/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.trident.windowing;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.storm.trident.windowing.WindowKryoSerializer;
import org.apache.storm.trident.windowing.WindowsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseWindowsStore
implements WindowsStore {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseWindowsStore.class);
    public static final String UTF_8 = "utf-8";
    private final ThreadLocal<HTable> threadLocalHtable;
    private final ThreadLocal<WindowKryoSerializer> threadLocalWindowKryoSerializer;
    private final Queue<HTable> htables = new ConcurrentLinkedQueue<HTable>();
    private final byte[] family;
    private final byte[] qualifier;

    public HBaseWindowsStore(final Map stormConf, final Configuration config, final String tableName, byte[] family, byte[] qualifier) {
        this.family = family;
        this.qualifier = qualifier;
        this.threadLocalHtable = new ThreadLocal<HTable>(){

            @Override
            protected HTable initialValue() {
                try {
                    HTable hTable = new HTable(config, tableName);
                    HBaseWindowsStore.this.htables.add(hTable);
                    return hTable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.threadLocalWindowKryoSerializer = new ThreadLocal<WindowKryoSerializer>(){

            @Override
            protected WindowKryoSerializer initialValue() {
                return new WindowKryoSerializer(stormConf);
            }
        };
    }

    private HTable htable() {
        return this.threadLocalHtable.get();
    }

    private WindowKryoSerializer windowKryoSerializer() {
        return this.threadLocalWindowKryoSerializer.get();
    }

    private byte[] effectiveKey(String key) {
        try {
            return key.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Object get(String key) {
        WindowsStore.Entry.nonNullCheckForKey((Object)key);
        byte[] effectiveKey = this.effectiveKey(key);
        Get get = new Get(effectiveKey);
        Result result = null;
        try {
            result = this.htable().get(get);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (result.isEmpty()) {
            return null;
        }
        return this.windowKryoSerializer().deserialize(result.getValue(this.family, this.qualifier));
    }

    public Iterable<Object> get(List<String> keys) {
        ArrayList<Get> gets = new ArrayList<Get>();
        for (String key : keys) {
            WindowsStore.Entry.nonNullCheckForKey((Object)key);
            byte[] effectiveKey = this.effectiveKey(key);
            gets.add(new Get(effectiveKey));
        }
        Result[] results = null;
        try {
            results = this.htable().get(gets);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < results.length; ++i) {
            Result result = results[i];
            if (result.isEmpty()) {
                LOG.error("Got empty result for key [{}]", (Object)keys.get(i));
                throw new RuntimeException("Received empty result for key: " + keys.get(i));
            }
            Object resultObject = this.windowKryoSerializer().deserialize(result.getValue(this.family, this.qualifier));
            values.add(resultObject);
        }
        return values;
    }

    public Iterable<String> getAllKeys() {
        Iterator resultIterator;
        Scan scan = new Scan();
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        try {
            resultIterator = this.htable().getScanner(scan).iterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final Iterator<String> iterator = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return resultIterator.hasNext();
            }

            @Override
            public String next() {
                Result result = (Result)resultIterator.next();
                String key = null;
                try {
                    key = new String(result.getRow(), HBaseWindowsStore.UTF_8);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                return key;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove operation is not supported");
            }
        };
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return iterator;
            }
        };
    }

    public void put(String key, Object value) {
        WindowsStore.Entry.nonNullCheckForKey((Object)key);
        WindowsStore.Entry.nonNullCheckForValue((Object)value);
        if (value == null) {
            throw new IllegalArgumentException("Invalid value of null with key: " + key);
        }
        Put put = new Put(this.effectiveKey(key));
        put.addColumn(this.family, ByteBuffer.wrap(this.qualifier), System.currentTimeMillis(), this.windowKryoSerializer().serializeToByteBuffer(value));
        try {
            this.htable().put(put);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void putAll(Collection<WindowsStore.Entry> entries) {
        ArrayList<Put> list = new ArrayList<Put>();
        for (WindowsStore.Entry entry : entries) {
            Put put = new Put(this.effectiveKey(entry.key));
            put.addColumn(this.family, ByteBuffer.wrap(this.qualifier), System.currentTimeMillis(), this.windowKryoSerializer().serializeToByteBuffer(entry.value));
            list.add(put);
        }
        try {
            this.htable().put(list);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(String key) {
        WindowsStore.Entry.nonNullCheckForKey((Object)key);
        Delete delete = new Delete(this.effectiveKey(key), System.currentTimeMillis());
        try {
            this.htable().delete(delete);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAll(Collection<String> keys) {
        ArrayList<Delete> deleteBatch = new ArrayList<Delete>();
        for (String key : keys) {
            WindowsStore.Entry.nonNullCheckForKey((Object)key);
            Delete delete = new Delete(this.effectiveKey(key), System.currentTimeMillis());
            deleteBatch.add(delete);
        }
        try {
            this.htable().delete(deleteBatch);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        for (HTable htable : this.htables) {
            try {
                htable.close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

