/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.bolt;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.storm.hbase.bolt.AbstractHBaseBolt;
import org.apache.storm.hbase.bolt.mapper.HBaseMapper;
import org.apache.storm.hbase.bolt.mapper.HBaseProjectionCriteria;
import org.apache.storm.hbase.bolt.mapper.HBaseValueMapper;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.TupleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseLookupBolt
extends AbstractHBaseBolt {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseLookupBolt.class);
    private HBaseValueMapper rowToTupleMapper;
    private HBaseProjectionCriteria projectionCriteria;

    public HBaseLookupBolt(String tableName, HBaseMapper mapper, HBaseValueMapper rowToTupleMapper) {
        super(tableName, mapper);
        Validate.notNull((Object)rowToTupleMapper, (String)"rowToTupleMapper can not be null");
        this.rowToTupleMapper = rowToTupleMapper;
    }

    public HBaseLookupBolt withConfigKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public HBaseLookupBolt withProjectionCriteria(HBaseProjectionCriteria projectionCriteria) {
        this.projectionCriteria = projectionCriteria;
        return this;
    }

    public void execute(Tuple tuple) {
        if (TupleUtils.isTick((Tuple)tuple)) {
            this.collector.ack(tuple);
            return;
        }
        byte[] rowKey = this.mapper.rowKey(tuple);
        Get get = this.hBaseClient.constructGetRequests(rowKey, this.projectionCriteria);
        try {
            Result result = this.hBaseClient.batchGet(Lists.newArrayList((Object[])new Get[]{get}))[0];
            for (Values values : this.rowToTupleMapper.toValues((ITuple)tuple, result)) {
                this.collector.emit(tuple, (List)values);
            }
            this.collector.ack(tuple);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(tuple);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        this.rowToTupleMapper.declareOutputFields(outputFieldsDeclarer);
    }
}

