/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.bolt;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.storm.hbase.bolt.AbstractHBaseBolt;
import org.apache.storm.hbase.bolt.mapper.HBaseMapper;
import org.apache.storm.hbase.common.ColumnList;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.BatchHelper;
import org.apache.storm.utils.TupleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseBolt
extends AbstractHBaseBolt {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseBolt.class);
    private static final int DEFAULT_FLUSH_INTERVAL_SECS = 1;
    boolean writeToWAL = true;
    List<Mutation> batchMutations = new LinkedList<Mutation>();
    int flushIntervalSecs = 1;
    int batchSize;
    BatchHelper batchHelper;

    public HBaseBolt(String tableName, HBaseMapper mapper) {
        super(tableName, mapper);
    }

    public HBaseBolt writeToWAL(boolean writeToWAL) {
        this.writeToWAL = writeToWAL;
        return this;
    }

    public HBaseBolt withConfigKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public HBaseBolt withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public HBaseBolt withFlushIntervalSecs(int flushIntervalSecs) {
        this.flushIntervalSecs = flushIntervalSecs;
        return this;
    }

    public Map<String, Object> getComponentConfiguration() {
        return TupleUtils.putTickFrequencyIntoComponentConfig((Map)super.getComponentConfiguration(), (int)this.flushIntervalSecs);
    }

    public void execute(Tuple tuple) {
        try {
            if (this.batchHelper.shouldHandle(tuple)) {
                byte[] rowKey = this.mapper.rowKey(tuple);
                ColumnList cols = this.mapper.columns(tuple);
                List<Mutation> mutations = this.hBaseClient.constructMutationReq(rowKey, cols, this.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
                this.batchMutations.addAll(mutations);
                this.batchHelper.addBatch(tuple);
            }
            if (this.batchHelper.shouldFlush()) {
                this.hBaseClient.batchMutate(this.batchMutations);
                LOG.debug("acknowledging tuples after batchMutate");
                this.batchHelper.ack();
                this.batchMutations.clear();
            }
        }
        catch (Exception e) {
            this.batchHelper.fail(e);
            this.batchMutations.clear();
        }
    }

    @Override
    public void prepare(Map map, TopologyContext topologyContext, OutputCollector collector) {
        super.prepare(map, topologyContext, collector);
        this.batchHelper = new BatchHelper(this.batchSize, collector);
    }

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
    }
}

