/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.ILocalCluster;
import org.apache.storm.LocalCluster;
import org.apache.storm.sql.runtime.ChannelContext;
import org.apache.storm.sql.runtime.ChannelHandler;
import org.apache.storm.sql.runtime.DataSource;
import org.apache.storm.sql.runtime.ISqlTridentDataSource;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.BaseFunction;
import org.apache.storm.trident.operation.Function;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.IBatchSpout;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class TestUtils {
    public static long monotonicNow() {
        long NANOSECONDS_PER_MILLISECOND = 1000000L;
        return System.nanoTime() / 1000000L;
    }

    public static ILocalCluster newLocalCluster() {
        return new LocalCluster();
    }

    public static class CollectDataChannelHandler
    implements ChannelHandler {
        private final List<Values> values;

        public CollectDataChannelHandler(List<Values> values) {
            this.values = values;
        }

        public void dataReceived(ChannelContext ctx, Values data) {
            this.values.add(data);
        }

        public void channelInactive(ChannelContext ctx) {
        }

        public void exceptionCaught(Throwable cause) {
            throw new RuntimeException(cause);
        }
    }

    public static class MockSqlTridentDataSource
    implements ISqlTridentDataSource {
        public IBatchSpout getProducer() {
            return new MockSpout();
        }

        public Function getConsumer() {
            return new CollectDataFunction();
        }

        private static class MockSpout
        implements IBatchSpout {
            private final ArrayList<Values> RECORDS = new ArrayList();
            private final Fields OUTPUT_FIELDS = new Fields(new String[]{"ID", "NAME", "ADDR"});
            private boolean emitted = false;

            public MockSpout() {
                for (int i = 0; i < 5; ++i) {
                    this.RECORDS.add(new Values(new Object[]{i, "x", "y"}));
                }
            }

            public void open(Map conf, TopologyContext context) {
            }

            public void emitBatch(long batchId, TridentCollector collector) {
                if (this.emitted) {
                    return;
                }
                for (Values r : this.RECORDS) {
                    collector.emit((List)r);
                }
                this.emitted = true;
            }

            public void ack(long batchId) {
            }

            public void close() {
            }

            public Map<String, Object> getComponentConfiguration() {
                return null;
            }

            public Fields getOutputFields() {
                return this.OUTPUT_FIELDS;
            }
        }

        public static class CollectDataFunction
        extends BaseFunction {
            private static final transient List<List<Object>> VALUES = new ArrayList<List<Object>>();

            public static List<List<Object>> getCollectedValues() {
                return VALUES;
            }

            public void execute(TridentTuple tuple, TridentCollector collector) {
                VALUES.add(tuple.getValues());
            }
        }
    }

    public static class MockNestedDataSource
    implements DataSource {
        private final ArrayList<Values> RECORDS = new ArrayList();

        public MockNestedDataSource() {
            List<Integer> ints = Arrays.asList(100, 200, 300);
            for (int i = 0; i < 5; ++i) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("b", i);
                map.put("c", i * i);
                HashMap<String, HashMap<String, Integer>> mm = new HashMap<String, HashMap<String, Integer>>();
                mm.put("a", map);
                this.RECORDS.add(new Values(new Object[]{i, map, mm, ints}));
            }
        }

        public void open(ChannelContext ctx) {
            for (Values v : this.RECORDS) {
                ctx.emit(v);
            }
            ctx.fireChannelInactive();
        }
    }

    public static class MockDataSource
    implements DataSource {
        private final ArrayList<Values> RECORDS = new ArrayList();

        public MockDataSource() {
            for (int i = 0; i < 5; ++i) {
                this.RECORDS.add(new Values(new Object[]{i, "x", null}));
            }
        }

        public void open(ChannelContext ctx) {
            for (Values v : this.RECORDS) {
                ctx.emit(v);
            }
            ctx.fireChannelInactive();
        }
    }

    public static class MyPlus {
        public static Integer evaluate(Integer x, Integer y) {
            return x + y;
        }
    }
}

