/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.storm.sql.runtime.DataSource;
import org.apache.storm.sql.runtime.DataSourcesProvider;
import org.apache.storm.sql.runtime.FieldInfo;
import org.apache.storm.sql.runtime.ISqlTridentDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourcesRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourcesRegistry.class);
    private static final Map<String, DataSourcesProvider> providers = new HashMap<String, DataSourcesProvider>();

    private DataSourcesRegistry() {
    }

    public static DataSource construct(URI uri, String inputFormatClass, String outputFormatClass, List<FieldInfo> fields) {
        DataSourcesProvider provider = providers.get(uri.getScheme());
        if (provider == null) {
            return null;
        }
        return provider.construct(uri, inputFormatClass, outputFormatClass, fields);
    }

    public static ISqlTridentDataSource constructTridentDataSource(URI uri, String inputFormatClass, String outputFormatClass, String properties, List<FieldInfo> fields) {
        DataSourcesProvider provider = providers.get(uri.getScheme());
        if (provider == null) {
            return null;
        }
        return provider.constructTrident(uri, inputFormatClass, outputFormatClass, properties, fields);
    }

    public static Map<String, DataSourcesProvider> providerMap() {
        return providers;
    }

    static {
        ServiceLoader<DataSourcesProvider> loader = ServiceLoader.load(DataSourcesProvider.class);
        for (DataSourcesProvider p : loader) {
            LOG.info("Registering scheme {} with {}", (Object)p.scheme(), (Object)p);
            providers.put(p.scheme(), p);
        }
    }
}

