/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime;

import org.apache.storm.sql.runtime.ChannelContext;
import org.apache.storm.sql.runtime.ChannelHandler;
import org.apache.storm.tuple.Values;

public class Channels {
    private static final ChannelContext VOID_CTX = new ChannelContext(){

        @Override
        public void emit(Values data) {
        }

        @Override
        public void fireChannelInactive() {
        }
    };

    public static ChannelContext chain(ChannelContext next, ChannelHandler handler) {
        return new ChannelContextAdapter(next, handler);
    }

    public static ChannelContext voidContext() {
        return VOID_CTX;
    }

    private static class ForwardingChannelContext
    implements ChannelContext {
        private final ChannelContext next;

        public ForwardingChannelContext(ChannelContext next) {
            this.next = next;
        }

        @Override
        public void emit(Values data) {
            this.next.emit(data);
        }

        @Override
        public void fireChannelInactive() {
            this.next.fireChannelInactive();
        }
    }

    private static class ChannelContextAdapter
    implements ChannelContext {
        private final ChannelHandler handler;
        private final ChannelContext next;

        public ChannelContextAdapter(ChannelContext next, ChannelHandler handler) {
            this.handler = handler;
            this.next = next;
        }

        @Override
        public void emit(Values data) {
            this.handler.dataReceived(this.next, data);
        }

        @Override
        public void fireChannelInactive() {
            this.handler.channelInactive(this.next);
        }
    }
}

