/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mqtt.trident;

import java.util.Map;
import org.apache.storm.mqtt.MqttMessage;
import org.apache.storm.mqtt.MqttTupleMapper;
import org.apache.storm.mqtt.common.MqttOptions;
import org.apache.storm.mqtt.common.MqttPublisher;
import org.apache.storm.mqtt.common.SslUtils;
import org.apache.storm.mqtt.ssl.KeyStoreLoader;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.topology.FailedException;
import org.apache.storm.trident.operation.BaseFunction;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.ITuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttPublishFunction
extends BaseFunction {
    private static final Logger LOG = LoggerFactory.getLogger(MqttPublishFunction.class);
    private MqttTupleMapper mapper;
    private transient MqttPublisher publisher;
    private boolean retain = false;
    private transient OutputCollector collector;
    private MqttOptions options;
    private KeyStoreLoader keyStoreLoader;
    private transient String topologyName;

    public MqttPublishFunction(MqttOptions options, MqttTupleMapper mapper, KeyStoreLoader keyStoreLoader, boolean retain) {
        this.options = options;
        this.mapper = mapper;
        this.retain = retain;
        this.keyStoreLoader = keyStoreLoader;
        SslUtils.checkSslConfig(this.options.getUrl(), keyStoreLoader);
    }

    public void prepare(Map conf, TridentOperationContext context) {
        this.topologyName = (String)conf.get("topology.name");
        this.publisher = new MqttPublisher(this.options, this.keyStoreLoader, this.retain);
        try {
            this.publisher.connectMqtt(this.topologyName + "-" + context.getPartitionIndex());
        }
        catch (Exception e) {
            LOG.error("Unable to connect to MQTT Broker.", (Throwable)e);
            throw new RuntimeException("Unable to connect to MQTT Broker.", e);
        }
    }

    public void execute(TridentTuple tuple, TridentCollector collector) {
        MqttMessage message = this.mapper.toMessage((ITuple)tuple);
        try {
            this.publisher.publish(message);
        }
        catch (Exception e) {
            LOG.warn("Error publishing MQTT message. Failing tuple.", (Throwable)e);
            throw new FailedException();
        }
    }
}

