/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mqtt.spout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.storm.mqtt.MqttMessageMapper;
import org.apache.storm.mqtt.common.MqttOptions;
import org.apache.storm.mqtt.common.MqttUtils;
import org.apache.storm.mqtt.common.SslUtils;
import org.apache.storm.mqtt.spout.AckableMessage;
import org.apache.storm.mqtt.ssl.KeyStoreLoader;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.CallbackConnection;
import org.fusesource.mqtt.client.Listener;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSpout
implements IRichSpout,
Listener {
    private static final Logger LOG = LoggerFactory.getLogger(MqttSpout.class);
    private String topologyName;
    private CallbackConnection connection;
    protected transient SpoutOutputCollector collector;
    protected transient TopologyContext context;
    protected transient LinkedBlockingQueue<AckableMessage> incoming;
    protected transient HashMap<Long, AckableMessage> pending;
    private transient Map conf;
    protected MqttMessageMapper type;
    protected MqttOptions options;
    protected KeyStoreLoader keyStoreLoader;
    private boolean mqttConnected = false;
    private boolean mqttConnectFailed = false;
    private Long sequence = Long.MIN_VALUE;

    private Long nextId() {
        MqttSpout mqttSpout = this;
        Long l = mqttSpout.sequence;
        Long l2 = mqttSpout.sequence = Long.valueOf(mqttSpout.sequence + 1L);
        if (this.sequence == Long.MAX_VALUE) {
            this.sequence = Long.MIN_VALUE;
        }
        return this.sequence;
    }

    protected MqttSpout() {
    }

    public MqttSpout(MqttMessageMapper type, MqttOptions options) {
        this(type, options, null);
    }

    public MqttSpout(MqttMessageMapper type, MqttOptions options, KeyStoreLoader keyStoreLoader) {
        this.type = type;
        this.options = options;
        this.keyStoreLoader = keyStoreLoader;
        SslUtils.checkSslConfig(this.options.getUrl(), this.keyStoreLoader);
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(this.type.outputFields());
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        this.topologyName = (String)conf.get("topology.name");
        this.collector = collector;
        this.context = context;
        this.conf = conf;
        this.incoming = new LinkedBlockingQueue();
        this.pending = new HashMap();
        try {
            this.connectMqtt();
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            throw new RuntimeException("MQTT Connection failed.", e);
        }
    }

    private void connectMqtt() throws Exception {
        String clientId = this.topologyName + "-" + this.context.getThisComponentId() + "-" + this.context.getThisTaskId();
        MQTT client = MqttUtils.configureClient(this.options, clientId, this.keyStoreLoader);
        this.connection = client.callbackConnection();
        this.connection.listener((Listener)this);
        this.connection.connect((Callback)new ConnectCallback());
        while (!this.mqttConnected && !this.mqttConnectFailed) {
            LOG.info("Waiting for connection...");
            Thread.sleep(500L);
        }
        if (this.mqttConnected) {
            List<String> topicList = this.options.getTopics();
            Topic[] topics = new Topic[topicList.size()];
            QoS qos = MqttUtils.qosFromInt(this.options.getQos());
            for (int i = 0; i < topicList.size(); ++i) {
                topics[i] = new Topic(topicList.get(i), qos);
            }
            this.connection.subscribe(topics, (Callback)new SubscribeCallback());
        }
    }

    public void close() {
        this.connection.disconnect((Callback)new DisconnectCallback());
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public void nextTuple() {
        AckableMessage tm = this.incoming.poll();
        if (tm != null) {
            Long id = this.nextId();
            this.collector.emit((List)this.type.toValues(tm.getMessage()), (Object)id);
            this.pending.put(id, tm);
        } else {
            Thread.yield();
        }
    }

    public void ack(Object msgId) {
        AckableMessage msg = this.pending.remove(msgId);
        this.connection.getDispatchQueue().execute(msg.ack());
    }

    public void fail(Object msgId) {
        try {
            this.incoming.put(this.pending.remove(msgId));
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while re-queueing message.", (Throwable)e);
        }
    }

    public void onConnected() {
    }

    public void onDisconnected() {
    }

    public void onPublish(UTF8Buffer topic, Buffer payload, Runnable ack) {
        LOG.debug("Received message: topic={}, payload={}", (Object)topic.toString(), (Object)new String(payload.toByteArray()));
        try {
            this.incoming.put(new AckableMessage(topic.toString(), payload.toByteArray(), ack));
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while queueing an MQTT message.");
        }
    }

    public void onFailure(Throwable throwable) {
        LOG.error("MQTT Connection Failure.", throwable);
        this.connection.disconnect((Callback)new DisconnectCallback());
        throw new RuntimeException("MQTT Connection failure.", throwable);
    }

    private class DisconnectCallback
    implements Callback<Void> {
        private DisconnectCallback() {
        }

        public void onSuccess(Void aVoid) {
            LOG.info("MQTT Disconnect successful.");
        }

        public void onFailure(Throwable throwable) {
        }
    }

    private class SubscribeCallback
    implements Callback<byte[]> {
        private SubscribeCallback() {
        }

        public void onSuccess(byte[] qos) {
            LOG.info("Subscripton sucessful.");
        }

        public void onFailure(Throwable throwable) {
            LOG.error("MQTT Subscripton failed.", throwable);
            throw new RuntimeException("MQTT Subscribe failed.", throwable);
        }
    }

    private class ConnectCallback
    implements Callback<Void> {
        private ConnectCallback() {
        }

        public void onSuccess(Void v) {
            LOG.info("MQTT Connected. Subscribing to topic...");
            MqttSpout.this.mqttConnected = true;
        }

        public void onFailure(Throwable throwable) {
            LOG.info("MQTT Connection failed.");
            MqttSpout.this.mqttConnectFailed = true;
        }
    }
}

