/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mqtt.common;

import org.apache.storm.mqtt.MqttMessage;
import org.apache.storm.mqtt.common.MqttOptions;
import org.apache.storm.mqtt.common.MqttUtils;
import org.apache.storm.mqtt.common.SslUtils;
import org.apache.storm.mqtt.ssl.KeyStoreLoader;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(MqttPublisher.class);
    private MqttOptions options;
    private transient BlockingConnection connection;
    private KeyStoreLoader keyStoreLoader;
    private QoS qos;
    private boolean retain = false;

    public MqttPublisher(MqttOptions options) {
        this(options, null, false);
    }

    public MqttPublisher(MqttOptions options, boolean retain) {
        this(options, null, retain);
    }

    public MqttPublisher(MqttOptions options, KeyStoreLoader keyStoreLoader, boolean retain) {
        this.retain = retain;
        this.options = options;
        this.keyStoreLoader = keyStoreLoader;
        SslUtils.checkSslConfig(this.options.getUrl(), keyStoreLoader);
        this.qos = MqttUtils.qosFromInt(this.options.getQos());
    }

    public void publish(MqttMessage message) throws Exception {
        this.connection.publish(message.getTopic(), message.getMessage(), this.qos, this.retain);
    }

    public void connectMqtt(String clientId) throws Exception {
        MQTT client = MqttUtils.configureClient(this.options, clientId, this.keyStoreLoader);
        this.connection = client.blockingConnection();
        this.connection.connect();
    }
}

