/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.flux.parser;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.storm.flux.model.BoltDef;
import org.apache.storm.flux.model.IncludeDef;
import org.apache.storm.flux.model.SpoutDef;
import org.apache.storm.flux.model.TopologyDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class FluxParser {
    private static final Logger LOG = LoggerFactory.getLogger(FluxParser.class);

    private FluxParser() {
    }

    public static TopologyDef parseFile(String inputFile, boolean dumpYaml, boolean processIncludes, String propertiesFile, boolean envSub) throws IOException {
        FileInputStream in = new FileInputStream(inputFile);
        TopologyDef topology = FluxParser.parseInputStream(in, dumpYaml, processIncludes, propertiesFile, envSub);
        in.close();
        return topology;
    }

    public static TopologyDef parseResource(String resource, boolean dumpYaml, boolean processIncludes, String propertiesFile, boolean envSub) throws IOException {
        InputStream in = FluxParser.class.getResourceAsStream(resource);
        TopologyDef topology = FluxParser.parseInputStream(in, dumpYaml, processIncludes, propertiesFile, envSub);
        in.close();
        return topology;
    }

    public static TopologyDef parseInputStream(InputStream inputStream, boolean dumpYaml, boolean processIncludes, String propertiesFile, boolean envSub) throws IOException {
        Yaml yaml = FluxParser.yaml();
        if (inputStream == null) {
            LOG.error("Unable to load input stream");
            System.exit(1);
        }
        TopologyDef topology = FluxParser.loadYaml(yaml, inputStream, propertiesFile, envSub);
        if (dumpYaml) {
            FluxParser.dumpYaml(topology, yaml);
        }
        if (processIncludes) {
            return FluxParser.processIncludes(yaml, topology, propertiesFile, envSub);
        }
        return topology;
    }

    private static TopologyDef loadYaml(Yaml yaml, InputStream in, String propsFile, boolean envSubstitution) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        LOG.info("loading YAML from input stream...");
        int b = -1;
        while ((b = in.read()) != -1) {
            bos.write(b);
        }
        String str = bos.toString();
        if (propsFile != null) {
            LOG.info("Performing property substitution.");
            FileInputStream propsIn = new FileInputStream(propsFile);
            Properties props = new Properties();
            props.load(propsIn);
            for (Object key : props.keySet()) {
                str = str.replace("${" + key + "}", props.getProperty((String)key));
            }
        } else {
            LOG.info("Not performing property substitution.");
        }
        if (envSubstitution) {
            LOG.info("Performing environment variable substitution...");
            Map<String, String> envs = System.getenv();
            for (String key : envs.keySet()) {
                str = str.replace("${ENV-" + key + "}", envs.get(key));
            }
        } else {
            LOG.info("Not performing environment variable substitution.");
        }
        return (TopologyDef)yaml.load(str);
    }

    private static void dumpYaml(TopologyDef topology, Yaml yaml) {
        System.out.println("Configuration (interpreted): \n" + yaml.dump(topology));
    }

    private static Yaml yaml() {
        Constructor constructor = new Constructor(TopologyDef.class);
        TypeDescription topologyDescription = new TypeDescription(TopologyDef.class);
        topologyDescription.putListPropertyType("spouts", SpoutDef.class);
        topologyDescription.putListPropertyType("bolts", BoltDef.class);
        topologyDescription.putListPropertyType("includes", IncludeDef.class);
        constructor.addTypeDescription(topologyDescription);
        Yaml yaml = new Yaml(constructor);
        return yaml;
    }

    private static TopologyDef processIncludes(Yaml yaml, TopologyDef topologyDef, String propsFile, boolean envSub) throws IOException {
        if (topologyDef.getIncludes() != null) {
            for (IncludeDef include : topologyDef.getIncludes()) {
                TopologyDef includeTopologyDef = null;
                if (include.isResource()) {
                    LOG.info("Loading includes from resource: {}", (Object)include.getFile());
                    includeTopologyDef = FluxParser.parseResource(include.getFile(), true, false, propsFile, envSub);
                } else {
                    LOG.info("Loading includes from file: {}", (Object)include.getFile());
                    includeTopologyDef = FluxParser.parseFile(include.getFile(), true, false, propsFile, envSub);
                }
                boolean override = include.isOverride();
                if (includeTopologyDef.getName() != null) {
                    topologyDef.setName(includeTopologyDef.getName(), override);
                }
                if (includeTopologyDef.getConfig() != null) {
                    Map<String, Object> config = topologyDef.getConfig();
                    Map<String, Object> includeConfig = includeTopologyDef.getConfig();
                    if (override) {
                        config.putAll(includeTopologyDef.getConfig());
                    } else {
                        for (String key : includeConfig.keySet()) {
                            if (config.containsKey(key)) {
                                LOG.warn("Ignoring attempt to set topology config property '{}' with override == false", (Object)key);
                                continue;
                            }
                            config.put(key, includeConfig.get(key));
                        }
                    }
                }
                if (includeTopologyDef.getComponents() != null) {
                    topologyDef.addAllComponents(includeTopologyDef.getComponents(), override);
                }
                if (includeTopologyDef.getBolts() != null) {
                    topologyDef.addAllBolts(includeTopologyDef.getBolts(), override);
                }
                if (includeTopologyDef.getSpouts() != null) {
                    topologyDef.addAllSpouts(includeTopologyDef.getSpouts(), override);
                }
                if (includeTopologyDef.getStreams() == null) continue;
                topologyDef.addAllStreams(includeTopologyDef.getStreams(), override);
            }
        }
        return topologyDef;
    }
}

