/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.flux.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.flux.model.BeanDef;
import org.apache.storm.flux.model.BoltDef;
import org.apache.storm.flux.model.IncludeDef;
import org.apache.storm.flux.model.SpoutDef;
import org.apache.storm.flux.model.StreamDef;
import org.apache.storm.flux.model.TopologySourceDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyDef {
    private static Logger LOG = LoggerFactory.getLogger(TopologyDef.class);
    private String name;
    private Map<String, BeanDef> componentMap = new LinkedHashMap<String, BeanDef>();
    private List<IncludeDef> includes;
    private Map<String, Object> config = new HashMap<String, Object>();
    private TopologySourceDef topologySource;
    private Map<String, BoltDef> boltMap = new LinkedHashMap<String, BoltDef>();
    private Map<String, SpoutDef> spoutMap = new LinkedHashMap<String, SpoutDef>();
    private List<StreamDef> streams = new ArrayList<StreamDef>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(String name, boolean override) {
        if (this.name == null || override) {
            this.name = name;
        } else {
            LOG.warn("Ignoring attempt to set property 'name' with override == false.");
        }
    }

    public List<SpoutDef> getSpouts() {
        ArrayList<SpoutDef> retval = new ArrayList<SpoutDef>();
        retval.addAll(this.spoutMap.values());
        return retval;
    }

    public void setSpouts(List<SpoutDef> spouts) {
        this.spoutMap = new LinkedHashMap<String, SpoutDef>();
        for (SpoutDef spout : spouts) {
            this.spoutMap.put(spout.getId(), spout);
        }
    }

    public List<BoltDef> getBolts() {
        ArrayList<BoltDef> retval = new ArrayList<BoltDef>();
        retval.addAll(this.boltMap.values());
        return retval;
    }

    public void setBolts(List<BoltDef> bolts) {
        this.boltMap = new LinkedHashMap<String, BoltDef>();
        for (BoltDef bolt : bolts) {
            this.boltMap.put(bolt.getId(), bolt);
        }
    }

    public List<StreamDef> getStreams() {
        return this.streams;
    }

    public void setStreams(List<StreamDef> streams) {
        this.streams = streams;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public List<BeanDef> getComponents() {
        ArrayList<BeanDef> retval = new ArrayList<BeanDef>();
        retval.addAll(this.componentMap.values());
        return retval;
    }

    public void setComponents(List<BeanDef> components) {
        this.componentMap = new LinkedHashMap<String, BeanDef>();
        for (BeanDef component : components) {
            this.componentMap.put(component.getId(), component);
        }
    }

    public List<IncludeDef> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<IncludeDef> includes) {
        this.includes = includes;
    }

    public int parallelismForBolt(String boltId) {
        return this.boltMap.get(boltId).getParallelism();
    }

    public BoltDef getBoltDef(String id) {
        return this.boltMap.get(id);
    }

    public SpoutDef getSpoutDef(String id) {
        return this.spoutMap.get(id);
    }

    public BeanDef getComponent(String id) {
        return this.componentMap.get(id);
    }

    public void addAllBolts(List<BoltDef> bolts, boolean override) {
        for (BoltDef bolt : bolts) {
            String id = bolt.getId();
            if (this.boltMap.get(id) == null || override) {
                this.boltMap.put(bolt.getId(), bolt);
                continue;
            }
            LOG.warn("Ignoring attempt to create bolt '{}' with override == false.", (Object)id);
        }
    }

    public void addAllSpouts(List<SpoutDef> spouts, boolean override) {
        for (SpoutDef spout : spouts) {
            String id = spout.getId();
            if (this.spoutMap.get(id) == null || override) {
                this.spoutMap.put(spout.getId(), spout);
                continue;
            }
            LOG.warn("Ignoring attempt to create spout '{}' with override == false.", (Object)id);
        }
    }

    public void addAllComponents(List<BeanDef> components, boolean override) {
        for (BeanDef bean : components) {
            String id = bean.getId();
            if (this.componentMap.get(id) == null || override) {
                this.componentMap.put(bean.getId(), bean);
                continue;
            }
            LOG.warn("Ignoring attempt to create component '{}' with override == false.", (Object)id);
        }
    }

    public void addAllStreams(List<StreamDef> streams, boolean override) {
        this.streams.addAll(streams);
    }

    public TopologySourceDef getTopologySource() {
        return this.topologySource;
    }

    public void setTopologySource(TopologySourceDef topologySource) {
        this.topologySource = topologySource;
    }

    public boolean isDslTopology() {
        return this.topologySource == null;
    }

    public boolean validate() {
        boolean hasSpoutsBoltsStreams;
        boolean hasSpouts = this.spoutMap != null && this.spoutMap.size() > 0;
        boolean hasBolts = this.boltMap != null && this.boltMap.size() > 0;
        boolean hasStreams = this.streams != null && this.streams.size() > 0;
        boolean bl = hasSpoutsBoltsStreams = hasStreams && hasBolts && hasSpouts;
        if (!this.isDslTopology() && (hasSpouts || hasBolts || hasStreams)) {
            return false;
        }
        if (this.isDslTopology() && hasSpouts && hasBolts && hasStreams) {
            return true;
        }
        return true;
    }
}

