/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.flux;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.flux.model.BeanDef;
import org.apache.storm.flux.model.BeanReference;
import org.apache.storm.flux.model.BoltDef;
import org.apache.storm.flux.model.ConfigMethodDef;
import org.apache.storm.flux.model.ExecutionContext;
import org.apache.storm.flux.model.GroupingDef;
import org.apache.storm.flux.model.ObjectDef;
import org.apache.storm.flux.model.PropertyDef;
import org.apache.storm.flux.model.SpoutDef;
import org.apache.storm.flux.model.StreamDef;
import org.apache.storm.flux.model.TopologyDef;
import org.apache.storm.flux.model.TopologySourceDef;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.IStatefulBolt;
import org.apache.storm.topology.IWindowedBolt;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluxBuilder {
    private static Logger LOG = LoggerFactory.getLogger(FluxBuilder.class);

    public static Config buildConfig(TopologyDef topologyDef) {
        Config conf = new Config();
        conf.putAll(topologyDef.getConfig());
        return conf;
    }

    public static StormTopology buildTopology(ExecutionContext context) throws IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        StormTopology topology = null;
        TopologyDef topologyDef = context.getTopologyDef();
        if (!topologyDef.validate()) {
            throw new IllegalArgumentException("Invalid topology config. Spouts, bolts and streams cannot be defined in the same configuration as a topologySource.");
        }
        FluxBuilder.buildComponents(context);
        if (topologyDef.isDslTopology()) {
            LOG.info("Detected DSL topology...");
            TopologyBuilder builder = new TopologyBuilder();
            FluxBuilder.buildSpouts(context, builder);
            FluxBuilder.buildBolts(context);
            FluxBuilder.buildStreamDefinitions(context, builder);
            topology = builder.createTopology();
        } else {
            LOG.info("A topology source has been specified...");
            TopologySourceDef def = topologyDef.getTopologySource();
            topology = FluxBuilder.buildExternalTopology(def, context);
        }
        return topology;
    }

    private static Method findGetTopologyMethod(Object topologySource, String methodName) throws NoSuchMethodException {
        Class<?> clazz = topologySource.getClass();
        Method[] methods = clazz.getMethods();
        ArrayList<Method> candidates = new ArrayList<Method>();
        for (Method method : methods) {
            Class<?>[] paramTypes;
            if (!method.getName().equals(methodName) || !method.getReturnType().equals(StormTopology.class) || (paramTypes = method.getParameterTypes()).length != 1 || !paramTypes[0].isAssignableFrom(Map.class) && !paramTypes[0].isAssignableFrom(Config.class)) continue;
            candidates.add(method);
        }
        if (candidates.size() == 0) {
            throw new IllegalArgumentException("Unable to find method '" + methodName + "' method in class: " + clazz.getName());
        }
        if (candidates.size() > 1) {
            LOG.warn("Found multiple candidate methods in class '" + clazz.getName() + "'. Using the first one found");
        }
        return (Method)candidates.get(0);
    }

    private static void buildStreamDefinitions(ExecutionContext context, TopologyBuilder builder) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        TopologyDef topologyDef = context.getTopologyDef();
        HashMap<String, BoltDeclarer> declarers = new HashMap<String, BoltDeclarer>();
        block10: for (StreamDef stream : topologyDef.getStreams()) {
            GroupingDef grouping;
            Object boltObj = context.getBolt(stream.getTo());
            BoltDeclarer declarer = (BoltDeclarer)declarers.get(stream.getTo());
            if (boltObj instanceof IRichBolt) {
                if (declarer == null) {
                    declarer = builder.setBolt(stream.getTo(), (IRichBolt)boltObj, (Number)topologyDef.parallelismForBolt(stream.getTo()));
                    declarers.put(stream.getTo(), declarer);
                }
            } else if (boltObj instanceof IBasicBolt) {
                if (declarer == null) {
                    declarer = builder.setBolt(stream.getTo(), (IBasicBolt)boltObj, (Number)topologyDef.parallelismForBolt(stream.getTo()));
                    declarers.put(stream.getTo(), declarer);
                }
            } else if (boltObj instanceof IWindowedBolt) {
                if (declarer == null) {
                    declarer = builder.setBolt(stream.getTo(), (IWindowedBolt)boltObj, (Number)topologyDef.parallelismForBolt(stream.getTo()));
                    declarers.put(stream.getTo(), declarer);
                }
            } else if (boltObj instanceof IStatefulBolt) {
                if (declarer == null) {
                    declarer = builder.setBolt(stream.getTo(), (IStatefulBolt)boltObj, (Number)topologyDef.parallelismForBolt(stream.getTo()));
                    declarers.put(stream.getTo(), declarer);
                }
            } else {
                throw new IllegalArgumentException("Class does not appear to be a bolt: " + boltObj.getClass().getName());
            }
            String streamId = (grouping = stream.getGrouping()).getStreamId() == null ? "default" : grouping.getStreamId();
            switch (grouping.getType()) {
                case SHUFFLE: {
                    declarer.shuffleGrouping(stream.getFrom(), streamId);
                    continue block10;
                }
                case FIELDS: {
                    declarer.fieldsGrouping(stream.getFrom(), streamId, new Fields(grouping.getArgs()));
                    continue block10;
                }
                case ALL: {
                    declarer.allGrouping(stream.getFrom(), streamId);
                    continue block10;
                }
                case DIRECT: {
                    declarer.directGrouping(stream.getFrom(), streamId);
                    continue block10;
                }
                case GLOBAL: {
                    declarer.globalGrouping(stream.getFrom(), streamId);
                    continue block10;
                }
                case LOCAL_OR_SHUFFLE: {
                    declarer.localOrShuffleGrouping(stream.getFrom(), streamId);
                    continue block10;
                }
                case NONE: {
                    declarer.noneGrouping(stream.getFrom(), streamId);
                    continue block10;
                }
                case CUSTOM: {
                    declarer.customGrouping(stream.getFrom(), streamId, FluxBuilder.buildCustomStreamGrouping(stream.getGrouping().getCustomClass(), context));
                    continue block10;
                }
            }
            throw new UnsupportedOperationException("unsupported grouping type: " + grouping);
        }
    }

    private static void applyProperties(ObjectDef bean, Object instance, ExecutionContext context) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        List<PropertyDef> props = bean.getProperties();
        Class<?> clazz = instance.getClass();
        if (props != null) {
            for (PropertyDef prop : props) {
                Object value = prop.isReference() ? context.getComponent(prop.getRef()) : prop.getValue();
                Method setter = FluxBuilder.findSetter(clazz, prop.getName(), value);
                if (setter != null) {
                    LOG.debug("found setter, attempting to invoke");
                    setter.invoke(instance, value);
                    continue;
                }
                LOG.debug("no setter found. Looking for a public instance variable...");
                Field field = FluxBuilder.findPublicField(clazz, prop.getName(), value);
                if (field == null) continue;
                field.set(instance, value);
            }
        }
    }

    private static Field findPublicField(Class clazz, String property, Object arg) throws NoSuchFieldException {
        Field field = clazz.getField(property);
        return field;
    }

    private static Method findSetter(Class clazz, String property, Object arg) {
        Method[] methods;
        String setterName = FluxBuilder.toSetterName(property);
        Method retval = null;
        for (Method method : methods = clazz.getMethods()) {
            if (!setterName.equals(method.getName())) continue;
            LOG.debug("Found setter method: " + method.getName());
            retval = method;
        }
        return retval;
    }

    private static String toSetterName(String name) {
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    private static List<Object> resolveReferences(List<Object> args, ExecutionContext context) {
        LOG.debug("Checking arguments for references.");
        ArrayList<Object> cArgs = new ArrayList<Object>();
        for (Object arg : args) {
            if (arg instanceof BeanReference) {
                cArgs.add(context.getComponent(((BeanReference)arg).getId()));
                continue;
            }
            cArgs.add(arg);
        }
        return cArgs;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Object buildObject(ObjectDef def, ExecutionContext context) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        Class<?> clazz = Class.forName(def.getClassName());
        Object obj = null;
        if (def.hasConstructorArgs()) {
            Constructor con;
            LOG.debug("Found constructor arguments in definition: " + def.getConstructorArgs().getClass().getName());
            List<Object> cArgs = def.getConstructorArgs();
            if (def.hasReferences()) {
                cArgs = FluxBuilder.resolveReferences(cArgs, context);
            }
            if ((con = FluxBuilder.findCompatibleConstructor(cArgs, clazz)) == null) {
                String msg = String.format("Couldn't find a suitable constructor for class '%s' with arguments '%s'.", clazz.getName(), cArgs);
                throw new IllegalArgumentException(msg);
            }
            LOG.debug("Found something seemingly compatible, attempting invocation...");
            obj = con.newInstance(FluxBuilder.getArgsWithListCoercian(cArgs, con.getParameterTypes()));
        } else {
            obj = clazz.newInstance();
        }
        FluxBuilder.applyProperties(def, obj, context);
        FluxBuilder.invokeConfigMethods(def, obj, context);
        return obj;
    }

    private static StormTopology buildExternalTopology(ObjectDef def, ExecutionContext context) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        String methodName;
        Object topologySource = FluxBuilder.buildObject(def, context);
        Method getTopology = FluxBuilder.findGetTopologyMethod(topologySource, methodName = context.getTopologyDef().getTopologySource().getMethodName());
        if (getTopology.getParameterTypes()[0].equals(Config.class)) {
            Config config = new Config();
            config.putAll(context.getTopologyDef().getConfig());
            return (StormTopology)getTopology.invoke(topologySource, config);
        }
        return (StormTopology)getTopology.invoke(topologySource, context.getTopologyDef().getConfig());
    }

    private static CustomStreamGrouping buildCustomStreamGrouping(ObjectDef def, ExecutionContext context) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        Object grouping = FluxBuilder.buildObject(def, context);
        return (CustomStreamGrouping)grouping;
    }

    private static void buildComponents(ExecutionContext context) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        List<BeanDef> cDefs = context.getTopologyDef().getComponents();
        if (cDefs != null) {
            for (BeanDef bean : cDefs) {
                Object obj = FluxBuilder.buildObject(bean, context);
                context.addComponent(bean.getId(), obj);
            }
        }
    }

    private static void buildSpouts(ExecutionContext context, TopologyBuilder builder) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        for (SpoutDef sd : context.getTopologyDef().getSpouts()) {
            IRichSpout spout = FluxBuilder.buildSpout(sd, context);
            builder.setSpout(sd.getId(), spout, (Number)sd.getParallelism());
            context.addSpout(sd.getId(), spout);
        }
    }

    private static IRichSpout buildSpout(SpoutDef def, ExecutionContext context) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        return (IRichSpout)FluxBuilder.buildObject(def, context);
    }

    private static void buildBolts(ExecutionContext context) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        for (BoltDef def : context.getTopologyDef().getBolts()) {
            Class<?> clazz = Class.forName(def.getClassName());
            Object bolt = FluxBuilder.buildObject(def, context);
            context.addBolt(def.getId(), bolt);
        }
    }

    private static Constructor findCompatibleConstructor(List<Object> args, Class target) throws NoSuchMethodException {
        Constructor<?>[] cons;
        Constructor<?> retval = null;
        int eligibleCount = 0;
        LOG.debug("Target class: {}", (Object)target.getName());
        for (Constructor<?> con : cons = target.getDeclaredConstructors()) {
            Class<?>[] paramClasses = con.getParameterTypes();
            if (paramClasses.length == args.size()) {
                LOG.debug("found constructor with same number of args..");
                boolean invokable = FluxBuilder.canInvokeWithArgs(args, con.getParameterTypes());
                if (invokable) {
                    retval = con;
                    ++eligibleCount;
                }
                LOG.debug("** invokable --> {}", (Object)invokable);
                continue;
            }
            LOG.debug("Skipping constructor with wrong number of arguments.");
        }
        if (eligibleCount > 1) {
            LOG.warn("Found multiple invokable constructors for class {}, given arguments {}. Using the last one found.", (Object)target, args);
        }
        return retval;
    }

    public static void invokeConfigMethods(ObjectDef bean, Object instance, ExecutionContext context) throws InvocationTargetException, IllegalAccessException {
        List<ConfigMethodDef> methodDefs = bean.getConfigMethods();
        if (methodDefs == null || methodDefs.size() == 0) {
            return;
        }
        Class<?> clazz = instance.getClass();
        for (ConfigMethodDef methodDef : methodDefs) {
            String methodName;
            Method method;
            List<Object> args = methodDef.getArgs();
            if (args == null) {
                args = new ArrayList<Object>();
            }
            if (methodDef.hasReferences()) {
                args = FluxBuilder.resolveReferences(args, context);
            }
            if ((method = FluxBuilder.findCompatibleMethod(args, clazz, methodName = methodDef.getName())) != null) {
                Object[] methodArgs = FluxBuilder.getArgsWithListCoercian(args, method.getParameterTypes());
                method.invoke(instance, methodArgs);
                continue;
            }
            String msg = String.format("Unable to find configuration method '%s' in class '%s' with arguments %s.", methodName, clazz.getName(), args);
            throw new IllegalArgumentException(msg);
        }
    }

    private static Method findCompatibleMethod(List<Object> args, Class target, String methodName) {
        Method[] methods;
        Method retval = null;
        int eligibleCount = 0;
        LOG.debug("Target class: {}", (Object)target.getName());
        for (Method method : methods = target.getMethods()) {
            Class<?>[] paramClasses = method.getParameterTypes();
            if (paramClasses.length == args.size() && method.getName().equals(methodName)) {
                LOG.debug("found constructor with same number of args..");
                boolean invokable = false;
                invokable = args.size() == 0 ? true : FluxBuilder.canInvokeWithArgs(args, method.getParameterTypes());
                if (invokable) {
                    retval = method;
                    ++eligibleCount;
                }
                LOG.debug("** invokable --> {}", (Object)invokable);
                continue;
            }
            LOG.debug("Skipping method with wrong number of arguments.");
        }
        if (eligibleCount > 1) {
            LOG.warn("Found multiple invokable methods for class {}, method {}, given arguments {}. Using the last one found.", new Object[]{target, methodName, args});
        }
        return retval;
    }

    private static Object[] getArgsWithListCoercian(List<Object> args, Class[] parameterTypes) {
        if (parameterTypes.length != args.size()) {
            throw new IllegalArgumentException("Contructor parameter count does not egual argument size.");
        }
        Object[] constructorParams = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            Object obj = args.get(i);
            Class paramType = parameterTypes[i];
            Class<?> objectType = obj.getClass();
            LOG.debug("Comparing parameter class {} to object class {} to see if assignment is possible.", (Object)paramType, objectType);
            if (paramType.equals(objectType)) {
                LOG.debug("They are the same class.");
                constructorParams[i] = args.get(i);
                continue;
            }
            if (paramType.isAssignableFrom(objectType)) {
                LOG.debug("Assignment is possible.");
                constructorParams[i] = args.get(i);
                continue;
            }
            if (FluxBuilder.isPrimitiveBoolean(paramType) && Boolean.class.isAssignableFrom(objectType)) {
                LOG.debug("Its a primitive boolean.");
                Boolean bool = (Boolean)args.get(i);
                constructorParams[i] = (boolean)bool;
                continue;
            }
            if (FluxBuilder.isPrimitiveNumber(paramType) && Number.class.isAssignableFrom(objectType)) {
                LOG.debug("Its a primitive number.");
                Number num = (Number)args.get(i);
                if (paramType == Float.TYPE) {
                    constructorParams[i] = Float.valueOf(num.floatValue());
                    continue;
                }
                if (paramType == Double.TYPE) {
                    constructorParams[i] = num.doubleValue();
                    continue;
                }
                if (paramType == Long.TYPE) {
                    constructorParams[i] = num.longValue();
                    continue;
                }
                if (paramType == Integer.TYPE) {
                    constructorParams[i] = num.intValue();
                    continue;
                }
                if (paramType == Short.TYPE) {
                    constructorParams[i] = num.shortValue();
                    continue;
                }
                if (paramType == Byte.TYPE) {
                    constructorParams[i] = num.byteValue();
                    continue;
                }
                constructorParams[i] = args.get(i);
                continue;
            }
            if (paramType.isEnum() && objectType.equals(String.class)) {
                LOG.debug("Yes, will convert a String to enum");
                constructorParams[i] = Enum.valueOf(paramType, (String)args.get(i));
                continue;
            }
            if (!paramType.isArray() || !List.class.isAssignableFrom(objectType)) continue;
            LOG.debug("Conversion appears possible...");
            List list = (List)obj;
            LOG.debug("Array Type: {}, List type: {}", paramType.getComponentType(), list.get(0).getClass());
            Object newArrayObj = Array.newInstance(paramType.getComponentType(), list.size());
            for (int j = 0; j < list.size(); ++j) {
                Array.set(newArrayObj, j, list.get(j));
            }
            constructorParams[i] = newArrayObj;
            LOG.debug("After conversion: {}", constructorParams[i]);
        }
        return constructorParams;
    }

    private static boolean canInvokeWithArgs(List<Object> args, Class[] parameterTypes) {
        if (parameterTypes.length != args.size()) {
            LOG.warn("parameter types were the wrong size");
            return false;
        }
        for (int i = 0; i < args.size(); ++i) {
            Object obj = args.get(i);
            Class paramType = parameterTypes[i];
            Class<?> objectType = obj.getClass();
            LOG.debug("Comparing parameter class {} to object class {} to see if assignment is possible.", (Object)paramType, objectType);
            if (paramType.equals(objectType)) {
                LOG.debug("Yes, they are the same class.");
                continue;
            }
            if (paramType.isAssignableFrom(objectType)) {
                LOG.debug("Yes, assignment is possible.");
                continue;
            }
            if (FluxBuilder.isPrimitiveBoolean(paramType) && Boolean.class.isAssignableFrom(objectType)) {
                LOG.debug("Yes, assignment is possible.");
                continue;
            }
            if (FluxBuilder.isPrimitiveNumber(paramType) && Number.class.isAssignableFrom(objectType)) {
                LOG.debug("Yes, assignment is possible.");
                continue;
            }
            if (paramType.isEnum() && objectType.equals(String.class)) {
                LOG.debug("Yes, will convert a String to enum");
                continue;
            }
            if (paramType.isArray() && List.class.isAssignableFrom(objectType)) {
                LOG.debug("Assignment is possible if we convert a List to an array.");
                LOG.debug("Array Type: {}, List type: {}", paramType.getComponentType(), ((List)obj).get(0).getClass());
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean isPrimitiveNumber(Class clazz) {
        return clazz.isPrimitive() && !clazz.equals(Boolean.TYPE);
    }

    public static boolean isPrimitiveBoolean(Class clazz) {
        return clazz.isPrimitive() && clazz.equals(Boolean.TYPE);
    }
}

