/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident.state;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.storm.redis.common.config.JedisClusterConfig;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.trident.state.AbstractRedisMapState;
import org.apache.storm.redis.trident.state.KeyFactory;
import org.apache.storm.redis.trident.state.Options;
import org.apache.storm.task.IMetricsContext;
import org.apache.storm.trident.state.OpaqueValue;
import org.apache.storm.trident.state.Serializer;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateType;
import org.apache.storm.trident.state.TransactionalValue;
import org.apache.storm.trident.state.map.CachedMap;
import org.apache.storm.trident.state.map.IBackingMap;
import org.apache.storm.trident.state.map.MapState;
import org.apache.storm.trident.state.map.NonTransactionalMap;
import org.apache.storm.trident.state.map.OpaqueMap;
import org.apache.storm.trident.state.map.SnapshottableMap;
import org.apache.storm.trident.state.map.TransactionalMap;
import org.apache.storm.tuple.Values;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public class RedisClusterMapState<T>
extends AbstractRedisMapState<T> {
    private JedisCluster jedisCluster;
    private Options options;
    private Serializer serializer;
    private KeyFactory keyFactory;

    public static StateFactory opaque(JedisClusterConfig jedisClusterConfig) {
        return RedisClusterMapState.opaque(jedisClusterConfig, new Options<OpaqueValue>());
    }

    public static StateFactory opaque(JedisClusterConfig jedisClusterConfig, RedisDataTypeDescription dataTypeDescription) {
        Options<OpaqueValue> opts = new Options<OpaqueValue>();
        opts.dataTypeDescription = dataTypeDescription;
        return RedisClusterMapState.opaque(jedisClusterConfig, opts);
    }

    public static StateFactory opaque(JedisClusterConfig jedisClusterConfig, KeyFactory factory) {
        Options<OpaqueValue> opts = new Options<OpaqueValue>();
        opts.keyFactory = factory;
        return RedisClusterMapState.opaque(jedisClusterConfig, opts);
    }

    public static StateFactory opaque(JedisClusterConfig jedisClusterConfig, Options<OpaqueValue> opts) {
        return new Factory(jedisClusterConfig, StateType.OPAQUE, opts);
    }

    public static StateFactory transactional(JedisClusterConfig jedisClusterConfig) {
        return RedisClusterMapState.transactional(jedisClusterConfig, new Options<TransactionalValue>());
    }

    public static StateFactory transactional(JedisClusterConfig jedisClusterConfig, RedisDataTypeDescription dataTypeDescription) {
        Options<TransactionalValue> opts = new Options<TransactionalValue>();
        opts.dataTypeDescription = dataTypeDescription;
        return RedisClusterMapState.transactional(jedisClusterConfig, opts);
    }

    public static StateFactory transactional(JedisClusterConfig jedisClusterConfig, KeyFactory factory) {
        Options<TransactionalValue> opts = new Options<TransactionalValue>();
        opts.keyFactory = factory;
        return RedisClusterMapState.transactional(jedisClusterConfig, opts);
    }

    public static StateFactory transactional(JedisClusterConfig jedisClusterConfig, Options<TransactionalValue> opts) {
        return new Factory(jedisClusterConfig, StateType.TRANSACTIONAL, opts);
    }

    public static StateFactory nonTransactional(JedisClusterConfig jedisClusterConfig) {
        return RedisClusterMapState.nonTransactional(jedisClusterConfig, new Options<Object>());
    }

    public static StateFactory nonTransactional(JedisClusterConfig jedisClusterConfig, RedisDataTypeDescription dataTypeDescription) {
        Options<Object> opts = new Options<Object>();
        opts.dataTypeDescription = dataTypeDescription;
        return RedisClusterMapState.nonTransactional(jedisClusterConfig, opts);
    }

    public static StateFactory nonTransactional(JedisClusterConfig jedisClusterConfig, KeyFactory factory) {
        Options<Object> opts = new Options<Object>();
        opts.keyFactory = factory;
        return RedisClusterMapState.nonTransactional(jedisClusterConfig, opts);
    }

    public static StateFactory nonTransactional(JedisClusterConfig jedisClusterConfig, Options<Object> opts) {
        return new Factory(jedisClusterConfig, StateType.NON_TRANSACTIONAL, opts);
    }

    public RedisClusterMapState(JedisCluster jedisCluster, Options options, Serializer<T> serializer, KeyFactory keyFactory) {
        this.jedisCluster = jedisCluster;
        this.options = options;
        this.serializer = serializer;
        this.keyFactory = keyFactory;
    }

    @Override
    protected Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    protected KeyFactory getKeyFactory() {
        return this.keyFactory;
    }

    @Override
    protected List<String> retrieveValuesFromRedis(List<String> keys) {
        String[] stringKeys = keys.toArray(new String[keys.size()]);
        RedisDataTypeDescription description = this.options.dataTypeDescription;
        switch (description.getDataType()) {
            case STRING: {
                ArrayList values = Lists.newArrayList();
                for (String stringKey : keys) {
                    String value = this.jedisCluster.get(stringKey);
                    values.add(value);
                }
                return values;
            }
            case HASH: {
                return this.jedisCluster.hmget(description.getAdditionalKey(), stringKeys);
            }
        }
        throw new IllegalArgumentException("Cannot process such data type: " + (Object)((Object)description.getDataType()));
    }

    @Override
    protected void updateStatesToRedis(Map<String, String> keyValues) {
        RedisDataTypeDescription description = this.options.dataTypeDescription;
        switch (description.getDataType()) {
            case STRING: {
                for (Map.Entry<String, String> kvEntry : keyValues.entrySet()) {
                    if (this.options.expireIntervalSec > 0) {
                        this.jedisCluster.setex(kvEntry.getKey(), this.options.expireIntervalSec, kvEntry.getValue());
                        continue;
                    }
                    this.jedisCluster.set(kvEntry.getKey(), kvEntry.getValue());
                }
                break;
            }
            case HASH: {
                this.jedisCluster.hmset(description.getAdditionalKey(), keyValues);
                if (this.options.expireIntervalSec <= 0) break;
                this.jedisCluster.expire(description.getAdditionalKey(), this.options.expireIntervalSec);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot process such data type: " + (Object)((Object)description.getDataType()));
            }
        }
    }

    protected static class Factory
    implements StateFactory {
        public static final JedisPoolConfig DEFAULT_POOL_CONFIG = new JedisPoolConfig();
        JedisClusterConfig jedisClusterConfig;
        StateType type;
        Serializer serializer;
        KeyFactory keyFactory;
        Options options;

        public Factory(JedisClusterConfig jedisClusterConfig, StateType type, Options options) {
            this.jedisClusterConfig = jedisClusterConfig;
            this.type = type;
            this.options = options;
            this.keyFactory = options.keyFactory;
            if (this.keyFactory == null) {
                this.keyFactory = new KeyFactory.DefaultKeyFactory();
            }
            this.serializer = options.serializer;
            if (this.serializer == null) {
                this.serializer = AbstractRedisMapState.DEFAULT_SERIALIZERS.get(type);
                if (this.serializer == null) {
                    throw new RuntimeException("Couldn't find serializer for state type: " + type);
                }
            }
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            MapState ms;
            JedisCluster jedisCluster = new JedisCluster(this.jedisClusterConfig.getNodes(), this.jedisClusterConfig.getTimeout(), this.jedisClusterConfig.getMaxRedirections(), (GenericObjectPoolConfig)DEFAULT_POOL_CONFIG);
            RedisClusterMapState state = new RedisClusterMapState(jedisCluster, this.options, this.serializer, this.keyFactory);
            CachedMap c = new CachedMap(state, this.options.localCacheSize);
            if (this.type == StateType.NON_TRANSACTIONAL) {
                ms = NonTransactionalMap.build((IBackingMap)c);
            } else if (this.type == StateType.OPAQUE) {
                ms = OpaqueMap.build((IBackingMap)c);
            } else if (this.type == StateType.TRANSACTIONAL) {
                ms = TransactionalMap.build((IBackingMap)c);
            } else {
                throw new RuntimeException("Unknown state type: " + this.type);
            }
            return new SnapshottableMap(ms, (List)new Values(new Object[]{this.options.globalKey}));
        }
    }
}

