/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.bolt;

import java.util.List;
import org.apache.storm.redis.bolt.AbstractRedisBolt;
import org.apache.storm.redis.common.config.JedisClusterConfig;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisLookupMapper;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import redis.clients.jedis.JedisCommands;

public class RedisLookupBolt
extends AbstractRedisBolt {
    private final RedisLookupMapper lookupMapper;
    private final RedisDataTypeDescription.RedisDataType dataType;
    private final String additionalKey;

    public RedisLookupBolt(JedisPoolConfig config, RedisLookupMapper lookupMapper) {
        super(config);
        this.lookupMapper = lookupMapper;
        RedisDataTypeDescription dataTypeDescription = lookupMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
    }

    public RedisLookupBolt(JedisClusterConfig config, RedisLookupMapper lookupMapper) {
        super(config);
        this.lookupMapper = lookupMapper;
        RedisDataTypeDescription dataTypeDescription = lookupMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Tuple input) {
        String key = this.lookupMapper.getKeyFromTuple((ITuple)input);
        JedisCommands jedisCommand = null;
        try {
            Object lookupValue;
            jedisCommand = this.getInstance();
            switch (this.dataType) {
                case STRING: {
                    lookupValue = jedisCommand.get(key);
                    break;
                }
                case LIST: {
                    lookupValue = jedisCommand.lpop(key);
                    break;
                }
                case HASH: {
                    lookupValue = jedisCommand.hget(this.additionalKey, key);
                    break;
                }
                case SET: {
                    lookupValue = jedisCommand.scard(key);
                    break;
                }
                case SORTED_SET: {
                    lookupValue = jedisCommand.zscore(this.additionalKey, key);
                    break;
                }
                case HYPER_LOG_LOG: {
                    lookupValue = jedisCommand.pfcount(key);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot process such data type: " + (Object)((Object)this.dataType));
                }
            }
            List<Values> values = this.lookupMapper.toTuple((ITuple)input, lookupValue);
            for (Values value : values) {
                this.collector.emit(input, (List)value);
            }
            this.collector.ack(input);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(input);
        }
        finally {
            this.returnInstance(jedisCommand);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.lookupMapper.declareOutputFields(declarer);
    }
}

