/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.mapper;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.storm.jdbc.common.Column;
import org.apache.storm.jdbc.common.ConnectionProvider;
import org.apache.storm.jdbc.common.JdbcClient;
import org.apache.storm.jdbc.common.Util;
import org.apache.storm.jdbc.mapper.JdbcMapper;
import org.apache.storm.tuple.ITuple;

public class SimpleJdbcMapper
implements JdbcMapper {
    private List<Column> schemaColumns;

    public SimpleJdbcMapper(String tableName, ConnectionProvider connectionProvider) {
        Validate.notEmpty((String)tableName);
        Validate.notNull((Object)connectionProvider);
        int queryTimeoutSecs = 30;
        connectionProvider.prepare();
        JdbcClient client = new JdbcClient(connectionProvider, queryTimeoutSecs);
        this.schemaColumns = client.getColumnSchema(tableName);
    }

    public SimpleJdbcMapper(List<Column> schemaColumns) {
        Validate.notEmpty(schemaColumns);
        this.schemaColumns = schemaColumns;
    }

    @Override
    public List<Column> getColumns(ITuple tuple) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Column column : this.schemaColumns) {
            Object value;
            String columnName = column.getColumnName();
            Integer columnSqlType = column.getSqlType();
            if (Util.getJavaType(columnSqlType).equals(String.class)) {
                value = tuple.getStringByField(columnName);
                columns.add(new Column<String>(columnName, (String)value, columnSqlType));
                continue;
            }
            if (Util.getJavaType(columnSqlType).equals(Short.class)) {
                value = tuple.getShortByField(columnName);
                columns.add(new Column<Object>(columnName, value, columnSqlType));
                continue;
            }
            if (Util.getJavaType(columnSqlType).equals(Integer.class)) {
                value = tuple.getIntegerByField(columnName);
                columns.add(new Column<Object>(columnName, value, columnSqlType));
                continue;
            }
            if (Util.getJavaType(columnSqlType).equals(Long.class)) {
                value = tuple.getLongByField(columnName);
                columns.add(new Column<Object>(columnName, value, columnSqlType));
                continue;
            }
            if (Util.getJavaType(columnSqlType).equals(Double.class)) {
                value = tuple.getDoubleByField(columnName);
                columns.add(new Column<Object>(columnName, value, columnSqlType));
                continue;
            }
            if (Util.getJavaType(columnSqlType).equals(Float.class)) {
                value = tuple.getFloatByField(columnName);
                columns.add(new Column<Object>(columnName, value, columnSqlType));
                continue;
            }
            if (Util.getJavaType(columnSqlType).equals(Boolean.class)) {
                value = tuple.getBooleanByField(columnName);
                columns.add(new Column<Object>(columnName, value, columnSqlType));
                continue;
            }
            if (Util.getJavaType(columnSqlType).equals(byte[].class)) {
                value = tuple.getBinaryByField(columnName);
                columns.add(new Column<Object>(columnName, value, columnSqlType));
                continue;
            }
            if (Util.getJavaType(columnSqlType).equals(Date.class)) {
                value = tuple.getLongByField(columnName);
                columns.add(new Column<Date>(columnName, new Date((Long)value), columnSqlType));
                continue;
            }
            if (Util.getJavaType(columnSqlType).equals(Time.class)) {
                value = tuple.getLongByField(columnName);
                columns.add(new Column<Time>(columnName, new Time((Long)value), columnSqlType));
                continue;
            }
            if (Util.getJavaType(columnSqlType).equals(Timestamp.class)) {
                value = tuple.getLongByField(columnName);
                columns.add(new Column<Timestamp>(columnName, new Timestamp((Long)value), columnSqlType));
                continue;
            }
            throw new RuntimeException("Unsupported java type in tuple " + Util.getJavaType(columnSqlType));
        }
        return columns;
    }
}

