/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.common;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.storm.jdbc.common.ConnectionProvider;

public class HikariCPConnectionProvider
implements ConnectionProvider {
    private Map<String, Object> configMap;
    private transient HikariDataSource dataSource;

    public HikariCPConnectionProvider(Map<String, Object> hikariCPConfigMap) {
        this.configMap = hikariCPConfigMap;
    }

    @Override
    public synchronized void prepare() {
        if (this.dataSource == null) {
            Properties properties = new Properties();
            properties.putAll(this.configMap);
            HikariConfig config = new HikariConfig(properties);
            this.dataSource = new HikariDataSource(config);
            this.dataSource.setAutoCommit(false);
        }
    }

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cleanup() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }
}

