/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.bolt;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.storm.jdbc.bolt.AbstractJdbcBolt;
import org.apache.storm.jdbc.common.Column;
import org.apache.storm.jdbc.common.ConnectionProvider;
import org.apache.storm.jdbc.mapper.JdbcLookupMapper;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcLookupBolt
extends AbstractJdbcBolt {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcLookupBolt.class);
    private String selectQuery;
    private JdbcLookupMapper jdbcLookupMapper;

    public JdbcLookupBolt(ConnectionProvider connectionProvider, String selectQuery, JdbcLookupMapper jdbcLookupMapper) {
        super(connectionProvider);
        Validate.notNull((Object)selectQuery);
        Validate.notNull((Object)jdbcLookupMapper);
        this.selectQuery = selectQuery;
        this.jdbcLookupMapper = jdbcLookupMapper;
    }

    public JdbcLookupBolt withQueryTimeoutSecs(int queryTimeoutSecs) {
        this.queryTimeoutSecs = queryTimeoutSecs;
        return this;
    }

    protected void process(Tuple tuple) {
        try {
            List<Column> columns = this.jdbcLookupMapper.getColumns((ITuple)tuple);
            List<List<Column>> result = this.jdbcClient.select(this.selectQuery, columns);
            if (result != null && result.size() != 0) {
                for (List<Column> row : result) {
                    List<Values> values = this.jdbcLookupMapper.toTuple((ITuple)tuple, row);
                    for (Values value : values) {
                        this.collector.emit(tuple, (List)value);
                    }
                }
            }
            this.collector.ack(tuple);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(tuple);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        this.jdbcLookupMapper.declareOutputFields(outputFieldsDeclarer);
    }
}

