/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.bolt;

import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.storm.jdbc.common.ConnectionProvider;
import org.apache.storm.jdbc.common.JdbcClient;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.base.BaseTickTupleAwareRichBolt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcBolt
extends BaseTickTupleAwareRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJdbcBolt.class);
    protected OutputCollector collector;
    protected transient JdbcClient jdbcClient;
    protected String configKey;
    protected Integer queryTimeoutSecs;
    protected ConnectionProvider connectionProvider;

    public void prepare(Map map, TopologyContext topologyContext, OutputCollector collector) {
        this.collector = collector;
        this.connectionProvider.prepare();
        if (this.queryTimeoutSecs == null) {
            this.queryTimeoutSecs = Integer.parseInt(map.get("topology.message.timeout.secs").toString());
        }
        this.jdbcClient = new JdbcClient(this.connectionProvider, this.queryTimeoutSecs);
    }

    public AbstractJdbcBolt(ConnectionProvider connectionProvider) {
        Validate.notNull((Object)connectionProvider);
        this.connectionProvider = connectionProvider;
    }

    public void cleanup() {
        this.connectionProvider.cleanup();
    }
}

