/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.trident;

import java.util.List;
import org.apache.storm.elasticsearch.common.EsConfig;
import org.apache.storm.elasticsearch.common.EsTupleMapper;
import org.apache.storm.elasticsearch.common.StormElasticSearchClient;
import org.apache.storm.topology.FailedException;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.ITuple;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EsState
implements State {
    private static final Logger LOG = LoggerFactory.getLogger(EsState.class);
    private static Client client;
    private EsConfig esConfig;
    private EsTupleMapper tupleMapper;

    public EsState(EsConfig esConfig, EsTupleMapper tupleMapper) {
        this.esConfig = esConfig;
        this.tupleMapper = tupleMapper;
    }

    public void beginCommit(Long txid) {
    }

    public void commit(Long txid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() {
        try {
            Class<EsState> clazz = EsState.class;
            synchronized (EsState.class) {
                if (client == null) {
                    client = new StormElasticSearchClient(this.esConfig).construct();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            LOG.warn("unable to initialize EsState ", (Throwable)e);
        }
        {
            return;
        }
    }

    public void updateState(List<TridentTuple> tuples) {
        BulkRequestBuilder bulkRequest = client.prepareBulk();
        for (TridentTuple tuple : tuples) {
            String source = this.tupleMapper.getSource((ITuple)tuple);
            String index = this.tupleMapper.getIndex((ITuple)tuple);
            String type = this.tupleMapper.getType((ITuple)tuple);
            String id = this.tupleMapper.getId((ITuple)tuple);
            bulkRequest.add(client.prepareIndex(index, type, id).setSource(source));
        }
        BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
        if (bulkResponse.hasFailures()) {
            LOG.warn("failed processing bulk index requests " + bulkResponse.buildFailureMessage());
            throw new FailedException();
        }
    }
}

