/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.common;

import java.util.Iterator;
import java.util.LinkedList;
import org.elasticsearch.common.transport.InetSocketTransportAddress;

final class TransportAddresses
implements Iterable<InetSocketTransportAddress> {
    static final String DELIMETER = ":";
    private final String[] nodes;

    TransportAddresses(String[] nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("Elasticsearch hosts cannot be null");
        }
        if (nodes.length == 0) {
            throw new IllegalArgumentException("At least one Elasticsearch host must be specified");
        }
        this.nodes = nodes;
    }

    @Override
    public Iterator<InetSocketTransportAddress> iterator() {
        LinkedList<InetSocketTransportAddress> result = new LinkedList<InetSocketTransportAddress>();
        for (String node : this.nodes) {
            InetSocketTransportAddress transportAddress = this.transformToInetAddress(node);
            result.add(transportAddress);
        }
        return result.iterator();
    }

    private InetSocketTransportAddress transformToInetAddress(String node) {
        String[] hostAndPort = node.split(DELIMETER);
        if (hostAndPort.length != 2) {
            throw new IllegalArgumentException("Incorrect Elasticsearch node format, should follow {host}:{port} pattern");
        }
        String hostname = this.hostname(hostAndPort[0]);
        return new InetSocketTransportAddress(hostname, this.port(hostAndPort[1]));
    }

    private String hostname(String input) {
        return input.trim();
    }

    private int port(String input) {
        return Integer.parseInt(input.trim());
    }
}

