/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.elasticsearch.common.TransportAddresses;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class EsConfig
implements Serializable {
    private final String clusterName;
    private final String[] nodes;
    private final Map<String, String> additionalConfiguration;

    public EsConfig(String clusterName, String[] nodes) {
        this(clusterName, nodes, Collections.emptyMap());
    }

    public EsConfig(String clusterName, String[] nodes, Map<String, String> additionalConfiguration) {
        Preconditions.checkNotNull((Object)clusterName);
        Preconditions.checkNotNull((Object)nodes);
        Preconditions.checkNotNull(additionalConfiguration);
        Preconditions.checkArgument((nodes.length != 0 ? 1 : 0) != 0, (Object)"Nodes cannot be empty");
        this.clusterName = clusterName;
        this.nodes = nodes;
        this.additionalConfiguration = new HashMap<String, String>(additionalConfiguration);
    }

    TransportAddresses getTransportAddresses() {
        return new TransportAddresses(this.nodes);
    }

    Settings toBasicSettings() {
        return ImmutableSettings.settingsBuilder().put("cluster.name", this.clusterName).put(this.additionalConfiguration).build();
    }
}

