/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.bolt;

import java.util.Map;
import org.apache.storm.elasticsearch.bolt.AbstractEsBolt;
import org.apache.storm.elasticsearch.common.EsConfig;
import org.apache.storm.elasticsearch.common.EsTupleMapper;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.elasticsearch.common.base.Preconditions;

public class EsIndexBolt
extends AbstractEsBolt {
    private final EsTupleMapper tupleMapper;

    public EsIndexBolt(EsConfig esConfig, EsTupleMapper tupleMapper) {
        super(esConfig);
        this.tupleMapper = (EsTupleMapper)Preconditions.checkNotNull((Object)tupleMapper);
    }

    @Override
    public void prepare(Map map, TopologyContext topologyContext, OutputCollector outputCollector) {
        super.prepare(map, topologyContext, outputCollector);
    }

    public void process(Tuple tuple) {
        try {
            String source = this.tupleMapper.getSource((ITuple)tuple);
            String index = this.tupleMapper.getIndex((ITuple)tuple);
            String type = this.tupleMapper.getType((ITuple)tuple);
            String id = this.tupleMapper.getId((ITuple)tuple);
            client.prepareIndex(index, type, id).setSource(source).execute().actionGet();
            this.collector.ack(tuple);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(tuple);
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
    }
}

