/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.storm.generated;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)")
public class Nimbus {

  public interface Iface {

    public void submitTopology(String name, String uploadedJarLocation, String jsonConf, StormTopology topology) throws AlreadyAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException;

    public void submitTopologyWithOpts(String name, String uploadedJarLocation, String jsonConf, StormTopology topology, SubmitOptions options) throws AlreadyAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException;

    public void killTopology(String name) throws NotAliveException, AuthorizationException, org.apache.thrift.TException;

    public void killTopologyWithOpts(String name, KillOptions options) throws NotAliveException, AuthorizationException, org.apache.thrift.TException;

    public void activate(String name) throws NotAliveException, AuthorizationException, org.apache.thrift.TException;

    public void deactivate(String name) throws NotAliveException, AuthorizationException, org.apache.thrift.TException;

    public void rebalance(String name, RebalanceOptions options) throws NotAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException;

    public void setLogConfig(String name, LogConfig config) throws org.apache.thrift.TException;

    public LogConfig getLogConfig(String name) throws org.apache.thrift.TException;

    /**
     * Enable/disable logging the tuples generated in topology via an internal EventLogger bolt. The component name is optional
     * and if null or empty, the debug flag will apply to the entire topology.
     * 
     * The 'samplingPercentage' will limit loggging to a percentage of generated tuples.
     * 
     * 
     * @param name
     * @param component
     * @param enable
     * @param samplingPercentage
     */
    public void debug(String name, String component, boolean enable, double samplingPercentage) throws NotAliveException, AuthorizationException, org.apache.thrift.TException;

    public void setWorkerProfiler(String id, ProfileRequest profileRequest) throws org.apache.thrift.TException;

    public List<ProfileRequest> getComponentPendingProfileActions(String id, String component_id, ProfileAction action) throws org.apache.thrift.TException;

    public void uploadNewCredentials(String name, Credentials creds) throws NotAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException;

    public String beginCreateBlob(String key, SettableBlobMeta meta) throws AuthorizationException, KeyAlreadyExistsException, org.apache.thrift.TException;

    public String beginUpdateBlob(String key) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException;

    public void uploadBlobChunk(String session, ByteBuffer chunk) throws AuthorizationException, org.apache.thrift.TException;

    public void finishBlobUpload(String session) throws AuthorizationException, org.apache.thrift.TException;

    public void cancelBlobUpload(String session) throws AuthorizationException, org.apache.thrift.TException;

    public ReadableBlobMeta getBlobMeta(String key) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException;

    public void setBlobMeta(String key, SettableBlobMeta meta) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException;

    public BeginDownloadResult beginBlobDownload(String key) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException;

    public ByteBuffer downloadBlobChunk(String session) throws AuthorizationException, org.apache.thrift.TException;

    public void deleteBlob(String key) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException;

    public ListBlobsResult listBlobs(String session) throws org.apache.thrift.TException;

    public int getBlobReplication(String key) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException;

    public int updateBlobReplication(String key, int replication) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException;

    public void createStateInZookeeper(String key) throws org.apache.thrift.TException;

    public String beginFileUpload() throws AuthorizationException, org.apache.thrift.TException;

    public void uploadChunk(String location, ByteBuffer chunk) throws AuthorizationException, org.apache.thrift.TException;

    public void finishFileUpload(String location) throws AuthorizationException, org.apache.thrift.TException;

    public String beginFileDownload(String file) throws AuthorizationException, org.apache.thrift.TException;

    public ByteBuffer downloadChunk(String id) throws AuthorizationException, org.apache.thrift.TException;

    public String getNimbusConf() throws AuthorizationException, org.apache.thrift.TException;

    public ClusterSummary getClusterInfo() throws AuthorizationException, org.apache.thrift.TException;

    public TopologyInfo getTopologyInfo(String id) throws NotAliveException, AuthorizationException, org.apache.thrift.TException;

    public TopologyInfo getTopologyInfoWithOpts(String id, GetInfoOptions options) throws NotAliveException, AuthorizationException, org.apache.thrift.TException;

    public TopologyPageInfo getTopologyPageInfo(String id, String window, boolean is_include_sys) throws NotAliveException, AuthorizationException, org.apache.thrift.TException;

    public ComponentPageInfo getComponentPageInfo(String topology_id, String component_id, String window, boolean is_include_sys) throws NotAliveException, AuthorizationException, org.apache.thrift.TException;

    public String getTopologyConf(String id) throws NotAliveException, AuthorizationException, org.apache.thrift.TException;

    /**
     * Returns the compiled topology that contains ackers and metrics consumsers. Compare {@link #getUserTopology(String id)}.
     * 
     * @param id
     */
    public StormTopology getTopology(String id) throws NotAliveException, AuthorizationException, org.apache.thrift.TException;

    /**
     * Returns the user specified topology as submitted originally. Compare {@link #getTopology(String id)}.
     * 
     * @param id
     */
    public StormTopology getUserTopology(String id) throws NotAliveException, AuthorizationException, org.apache.thrift.TException;

    public TopologyHistoryInfo getTopologyHistory(String user) throws AuthorizationException, org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void submitTopology(String name, String uploadedJarLocation, String jsonConf, StormTopology topology, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void submitTopologyWithOpts(String name, String uploadedJarLocation, String jsonConf, StormTopology topology, SubmitOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void killTopology(String name, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void killTopologyWithOpts(String name, KillOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void activate(String name, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deactivate(String name, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void rebalance(String name, RebalanceOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void setLogConfig(String name, LogConfig config, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getLogConfig(String name, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void debug(String name, String component, boolean enable, double samplingPercentage, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void setWorkerProfiler(String id, ProfileRequest profileRequest, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getComponentPendingProfileActions(String id, String component_id, ProfileAction action, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void uploadNewCredentials(String name, Credentials creds, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void beginCreateBlob(String key, SettableBlobMeta meta, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void beginUpdateBlob(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void uploadBlobChunk(String session, ByteBuffer chunk, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void finishBlobUpload(String session, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void cancelBlobUpload(String session, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getBlobMeta(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void setBlobMeta(String key, SettableBlobMeta meta, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void beginBlobDownload(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void downloadBlobChunk(String session, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteBlob(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void listBlobs(String session, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getBlobReplication(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateBlobReplication(String key, int replication, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createStateInZookeeper(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void beginFileUpload(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void uploadChunk(String location, ByteBuffer chunk, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void finishFileUpload(String location, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void beginFileDownload(String file, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void downloadChunk(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getNimbusConf(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getClusterInfo(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getTopologyInfo(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getTopologyInfoWithOpts(String id, GetInfoOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getTopologyPageInfo(String id, String window, boolean is_include_sys, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getComponentPageInfo(String topology_id, String component_id, String window, boolean is_include_sys, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getTopologyConf(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getTopology(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserTopology(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getTopologyHistory(String user, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public void submitTopology(String name, String uploadedJarLocation, String jsonConf, StormTopology topology) throws AlreadyAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException
    {
      send_submitTopology(name, uploadedJarLocation, jsonConf, topology);
      recv_submitTopology();
    }

    public void send_submitTopology(String name, String uploadedJarLocation, String jsonConf, StormTopology topology) throws org.apache.thrift.TException
    {
      submitTopology_args args = new submitTopology_args();
      args.set_name(name);
      args.set_uploadedJarLocation(uploadedJarLocation);
      args.set_jsonConf(jsonConf);
      args.set_topology(topology);
      sendBase("submitTopology", args);
    }

    public void recv_submitTopology() throws AlreadyAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException
    {
      submitTopology_result result = new submitTopology_result();
      receiveBase(result, "submitTopology");
      if (result.e != null) {
        throw result.e;
      }
      if (result.ite != null) {
        throw result.ite;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public void submitTopologyWithOpts(String name, String uploadedJarLocation, String jsonConf, StormTopology topology, SubmitOptions options) throws AlreadyAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException
    {
      send_submitTopologyWithOpts(name, uploadedJarLocation, jsonConf, topology, options);
      recv_submitTopologyWithOpts();
    }

    public void send_submitTopologyWithOpts(String name, String uploadedJarLocation, String jsonConf, StormTopology topology, SubmitOptions options) throws org.apache.thrift.TException
    {
      submitTopologyWithOpts_args args = new submitTopologyWithOpts_args();
      args.set_name(name);
      args.set_uploadedJarLocation(uploadedJarLocation);
      args.set_jsonConf(jsonConf);
      args.set_topology(topology);
      args.set_options(options);
      sendBase("submitTopologyWithOpts", args);
    }

    public void recv_submitTopologyWithOpts() throws AlreadyAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException
    {
      submitTopologyWithOpts_result result = new submitTopologyWithOpts_result();
      receiveBase(result, "submitTopologyWithOpts");
      if (result.e != null) {
        throw result.e;
      }
      if (result.ite != null) {
        throw result.ite;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public void killTopology(String name) throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      send_killTopology(name);
      recv_killTopology();
    }

    public void send_killTopology(String name) throws org.apache.thrift.TException
    {
      killTopology_args args = new killTopology_args();
      args.set_name(name);
      sendBase("killTopology", args);
    }

    public void recv_killTopology() throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      killTopology_result result = new killTopology_result();
      receiveBase(result, "killTopology");
      if (result.e != null) {
        throw result.e;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public void killTopologyWithOpts(String name, KillOptions options) throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      send_killTopologyWithOpts(name, options);
      recv_killTopologyWithOpts();
    }

    public void send_killTopologyWithOpts(String name, KillOptions options) throws org.apache.thrift.TException
    {
      killTopologyWithOpts_args args = new killTopologyWithOpts_args();
      args.set_name(name);
      args.set_options(options);
      sendBase("killTopologyWithOpts", args);
    }

    public void recv_killTopologyWithOpts() throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      killTopologyWithOpts_result result = new killTopologyWithOpts_result();
      receiveBase(result, "killTopologyWithOpts");
      if (result.e != null) {
        throw result.e;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public void activate(String name) throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      send_activate(name);
      recv_activate();
    }

    public void send_activate(String name) throws org.apache.thrift.TException
    {
      activate_args args = new activate_args();
      args.set_name(name);
      sendBase("activate", args);
    }

    public void recv_activate() throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      activate_result result = new activate_result();
      receiveBase(result, "activate");
      if (result.e != null) {
        throw result.e;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public void deactivate(String name) throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      send_deactivate(name);
      recv_deactivate();
    }

    public void send_deactivate(String name) throws org.apache.thrift.TException
    {
      deactivate_args args = new deactivate_args();
      args.set_name(name);
      sendBase("deactivate", args);
    }

    public void recv_deactivate() throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      deactivate_result result = new deactivate_result();
      receiveBase(result, "deactivate");
      if (result.e != null) {
        throw result.e;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public void rebalance(String name, RebalanceOptions options) throws NotAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException
    {
      send_rebalance(name, options);
      recv_rebalance();
    }

    public void send_rebalance(String name, RebalanceOptions options) throws org.apache.thrift.TException
    {
      rebalance_args args = new rebalance_args();
      args.set_name(name);
      args.set_options(options);
      sendBase("rebalance", args);
    }

    public void recv_rebalance() throws NotAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException
    {
      rebalance_result result = new rebalance_result();
      receiveBase(result, "rebalance");
      if (result.e != null) {
        throw result.e;
      }
      if (result.ite != null) {
        throw result.ite;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public void setLogConfig(String name, LogConfig config) throws org.apache.thrift.TException
    {
      send_setLogConfig(name, config);
      recv_setLogConfig();
    }

    public void send_setLogConfig(String name, LogConfig config) throws org.apache.thrift.TException
    {
      setLogConfig_args args = new setLogConfig_args();
      args.set_name(name);
      args.set_config(config);
      sendBase("setLogConfig", args);
    }

    public void recv_setLogConfig() throws org.apache.thrift.TException
    {
      setLogConfig_result result = new setLogConfig_result();
      receiveBase(result, "setLogConfig");
      return;
    }

    public LogConfig getLogConfig(String name) throws org.apache.thrift.TException
    {
      send_getLogConfig(name);
      return recv_getLogConfig();
    }

    public void send_getLogConfig(String name) throws org.apache.thrift.TException
    {
      getLogConfig_args args = new getLogConfig_args();
      args.set_name(name);
      sendBase("getLogConfig", args);
    }

    public LogConfig recv_getLogConfig() throws org.apache.thrift.TException
    {
      getLogConfig_result result = new getLogConfig_result();
      receiveBase(result, "getLogConfig");
      if (result.is_set_success()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getLogConfig failed: unknown result");
    }

    public void debug(String name, String component, boolean enable, double samplingPercentage) throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      send_debug(name, component, enable, samplingPercentage);
      recv_debug();
    }

    public void send_debug(String name, String component, boolean enable, double samplingPercentage) throws org.apache.thrift.TException
    {
      debug_args args = new debug_args();
      args.set_name(name);
      args.set_component(component);
      args.set_enable(enable);
      args.set_samplingPercentage(samplingPercentage);
      sendBase("debug", args);
    }

    public void recv_debug() throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      debug_result result = new debug_result();
      receiveBase(result, "debug");
      if (result.e != null) {
        throw result.e;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public void setWorkerProfiler(String id, ProfileRequest profileRequest) throws org.apache.thrift.TException
    {
      send_setWorkerProfiler(id, profileRequest);
      recv_setWorkerProfiler();
    }

    public void send_setWorkerProfiler(String id, ProfileRequest profileRequest) throws org.apache.thrift.TException
    {
      setWorkerProfiler_args args = new setWorkerProfiler_args();
      args.set_id(id);
      args.set_profileRequest(profileRequest);
      sendBase("setWorkerProfiler", args);
    }

    public void recv_setWorkerProfiler() throws org.apache.thrift.TException
    {
      setWorkerProfiler_result result = new setWorkerProfiler_result();
      receiveBase(result, "setWorkerProfiler");
      return;
    }

    public List<ProfileRequest> getComponentPendingProfileActions(String id, String component_id, ProfileAction action) throws org.apache.thrift.TException
    {
      send_getComponentPendingProfileActions(id, component_id, action);
      return recv_getComponentPendingProfileActions();
    }

    public void send_getComponentPendingProfileActions(String id, String component_id, ProfileAction action) throws org.apache.thrift.TException
    {
      getComponentPendingProfileActions_args args = new getComponentPendingProfileActions_args();
      args.set_id(id);
      args.set_component_id(component_id);
      args.set_action(action);
      sendBase("getComponentPendingProfileActions", args);
    }

    public List<ProfileRequest> recv_getComponentPendingProfileActions() throws org.apache.thrift.TException
    {
      getComponentPendingProfileActions_result result = new getComponentPendingProfileActions_result();
      receiveBase(result, "getComponentPendingProfileActions");
      if (result.is_set_success()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getComponentPendingProfileActions failed: unknown result");
    }

    public void uploadNewCredentials(String name, Credentials creds) throws NotAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException
    {
      send_uploadNewCredentials(name, creds);
      recv_uploadNewCredentials();
    }

    public void send_uploadNewCredentials(String name, Credentials creds) throws org.apache.thrift.TException
    {
      uploadNewCredentials_args args = new uploadNewCredentials_args();
      args.set_name(name);
      args.set_creds(creds);
      sendBase("uploadNewCredentials", args);
    }

    public void recv_uploadNewCredentials() throws NotAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException
    {
      uploadNewCredentials_result result = new uploadNewCredentials_result();
      receiveBase(result, "uploadNewCredentials");
      if (result.e != null) {
        throw result.e;
      }
      if (result.ite != null) {
        throw result.ite;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public String beginCreateBlob(String key, SettableBlobMeta meta) throws AuthorizationException, KeyAlreadyExistsException, org.apache.thrift.TException
    {
      send_beginCreateBlob(key, meta);
      return recv_beginCreateBlob();
    }

    public void send_beginCreateBlob(String key, SettableBlobMeta meta) throws org.apache.thrift.TException
    {
      beginCreateBlob_args args = new beginCreateBlob_args();
      args.set_key(key);
      args.set_meta(meta);
      sendBase("beginCreateBlob", args);
    }

    public String recv_beginCreateBlob() throws AuthorizationException, KeyAlreadyExistsException, org.apache.thrift.TException
    {
      beginCreateBlob_result result = new beginCreateBlob_result();
      receiveBase(result, "beginCreateBlob");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      if (result.kae != null) {
        throw result.kae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "beginCreateBlob failed: unknown result");
    }

    public String beginUpdateBlob(String key) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      send_beginUpdateBlob(key);
      return recv_beginUpdateBlob();
    }

    public void send_beginUpdateBlob(String key) throws org.apache.thrift.TException
    {
      beginUpdateBlob_args args = new beginUpdateBlob_args();
      args.set_key(key);
      sendBase("beginUpdateBlob", args);
    }

    public String recv_beginUpdateBlob() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      beginUpdateBlob_result result = new beginUpdateBlob_result();
      receiveBase(result, "beginUpdateBlob");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      if (result.knf != null) {
        throw result.knf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "beginUpdateBlob failed: unknown result");
    }

    public void uploadBlobChunk(String session, ByteBuffer chunk) throws AuthorizationException, org.apache.thrift.TException
    {
      send_uploadBlobChunk(session, chunk);
      recv_uploadBlobChunk();
    }

    public void send_uploadBlobChunk(String session, ByteBuffer chunk) throws org.apache.thrift.TException
    {
      uploadBlobChunk_args args = new uploadBlobChunk_args();
      args.set_session(session);
      args.set_chunk(chunk);
      sendBase("uploadBlobChunk", args);
    }

    public void recv_uploadBlobChunk() throws AuthorizationException, org.apache.thrift.TException
    {
      uploadBlobChunk_result result = new uploadBlobChunk_result();
      receiveBase(result, "uploadBlobChunk");
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public void finishBlobUpload(String session) throws AuthorizationException, org.apache.thrift.TException
    {
      send_finishBlobUpload(session);
      recv_finishBlobUpload();
    }

    public void send_finishBlobUpload(String session) throws org.apache.thrift.TException
    {
      finishBlobUpload_args args = new finishBlobUpload_args();
      args.set_session(session);
      sendBase("finishBlobUpload", args);
    }

    public void recv_finishBlobUpload() throws AuthorizationException, org.apache.thrift.TException
    {
      finishBlobUpload_result result = new finishBlobUpload_result();
      receiveBase(result, "finishBlobUpload");
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public void cancelBlobUpload(String session) throws AuthorizationException, org.apache.thrift.TException
    {
      send_cancelBlobUpload(session);
      recv_cancelBlobUpload();
    }

    public void send_cancelBlobUpload(String session) throws org.apache.thrift.TException
    {
      cancelBlobUpload_args args = new cancelBlobUpload_args();
      args.set_session(session);
      sendBase("cancelBlobUpload", args);
    }

    public void recv_cancelBlobUpload() throws AuthorizationException, org.apache.thrift.TException
    {
      cancelBlobUpload_result result = new cancelBlobUpload_result();
      receiveBase(result, "cancelBlobUpload");
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public ReadableBlobMeta getBlobMeta(String key) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      send_getBlobMeta(key);
      return recv_getBlobMeta();
    }

    public void send_getBlobMeta(String key) throws org.apache.thrift.TException
    {
      getBlobMeta_args args = new getBlobMeta_args();
      args.set_key(key);
      sendBase("getBlobMeta", args);
    }

    public ReadableBlobMeta recv_getBlobMeta() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      getBlobMeta_result result = new getBlobMeta_result();
      receiveBase(result, "getBlobMeta");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      if (result.knf != null) {
        throw result.knf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getBlobMeta failed: unknown result");
    }

    public void setBlobMeta(String key, SettableBlobMeta meta) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      send_setBlobMeta(key, meta);
      recv_setBlobMeta();
    }

    public void send_setBlobMeta(String key, SettableBlobMeta meta) throws org.apache.thrift.TException
    {
      setBlobMeta_args args = new setBlobMeta_args();
      args.set_key(key);
      args.set_meta(meta);
      sendBase("setBlobMeta", args);
    }

    public void recv_setBlobMeta() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      setBlobMeta_result result = new setBlobMeta_result();
      receiveBase(result, "setBlobMeta");
      if (result.aze != null) {
        throw result.aze;
      }
      if (result.knf != null) {
        throw result.knf;
      }
      return;
    }

    public BeginDownloadResult beginBlobDownload(String key) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      send_beginBlobDownload(key);
      return recv_beginBlobDownload();
    }

    public void send_beginBlobDownload(String key) throws org.apache.thrift.TException
    {
      beginBlobDownload_args args = new beginBlobDownload_args();
      args.set_key(key);
      sendBase("beginBlobDownload", args);
    }

    public BeginDownloadResult recv_beginBlobDownload() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      beginBlobDownload_result result = new beginBlobDownload_result();
      receiveBase(result, "beginBlobDownload");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      if (result.knf != null) {
        throw result.knf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "beginBlobDownload failed: unknown result");
    }

    public ByteBuffer downloadBlobChunk(String session) throws AuthorizationException, org.apache.thrift.TException
    {
      send_downloadBlobChunk(session);
      return recv_downloadBlobChunk();
    }

    public void send_downloadBlobChunk(String session) throws org.apache.thrift.TException
    {
      downloadBlobChunk_args args = new downloadBlobChunk_args();
      args.set_session(session);
      sendBase("downloadBlobChunk", args);
    }

    public ByteBuffer recv_downloadBlobChunk() throws AuthorizationException, org.apache.thrift.TException
    {
      downloadBlobChunk_result result = new downloadBlobChunk_result();
      receiveBase(result, "downloadBlobChunk");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "downloadBlobChunk failed: unknown result");
    }

    public void deleteBlob(String key) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      send_deleteBlob(key);
      recv_deleteBlob();
    }

    public void send_deleteBlob(String key) throws org.apache.thrift.TException
    {
      deleteBlob_args args = new deleteBlob_args();
      args.set_key(key);
      sendBase("deleteBlob", args);
    }

    public void recv_deleteBlob() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      deleteBlob_result result = new deleteBlob_result();
      receiveBase(result, "deleteBlob");
      if (result.aze != null) {
        throw result.aze;
      }
      if (result.knf != null) {
        throw result.knf;
      }
      return;
    }

    public ListBlobsResult listBlobs(String session) throws org.apache.thrift.TException
    {
      send_listBlobs(session);
      return recv_listBlobs();
    }

    public void send_listBlobs(String session) throws org.apache.thrift.TException
    {
      listBlobs_args args = new listBlobs_args();
      args.set_session(session);
      sendBase("listBlobs", args);
    }

    public ListBlobsResult recv_listBlobs() throws org.apache.thrift.TException
    {
      listBlobs_result result = new listBlobs_result();
      receiveBase(result, "listBlobs");
      if (result.is_set_success()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "listBlobs failed: unknown result");
    }

    public int getBlobReplication(String key) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      send_getBlobReplication(key);
      return recv_getBlobReplication();
    }

    public void send_getBlobReplication(String key) throws org.apache.thrift.TException
    {
      getBlobReplication_args args = new getBlobReplication_args();
      args.set_key(key);
      sendBase("getBlobReplication", args);
    }

    public int recv_getBlobReplication() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      getBlobReplication_result result = new getBlobReplication_result();
      receiveBase(result, "getBlobReplication");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      if (result.knf != null) {
        throw result.knf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getBlobReplication failed: unknown result");
    }

    public int updateBlobReplication(String key, int replication) throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      send_updateBlobReplication(key, replication);
      return recv_updateBlobReplication();
    }

    public void send_updateBlobReplication(String key, int replication) throws org.apache.thrift.TException
    {
      updateBlobReplication_args args = new updateBlobReplication_args();
      args.set_key(key);
      args.set_replication(replication);
      sendBase("updateBlobReplication", args);
    }

    public int recv_updateBlobReplication() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException
    {
      updateBlobReplication_result result = new updateBlobReplication_result();
      receiveBase(result, "updateBlobReplication");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      if (result.knf != null) {
        throw result.knf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateBlobReplication failed: unknown result");
    }

    public void createStateInZookeeper(String key) throws org.apache.thrift.TException
    {
      send_createStateInZookeeper(key);
      recv_createStateInZookeeper();
    }

    public void send_createStateInZookeeper(String key) throws org.apache.thrift.TException
    {
      createStateInZookeeper_args args = new createStateInZookeeper_args();
      args.set_key(key);
      sendBase("createStateInZookeeper", args);
    }

    public void recv_createStateInZookeeper() throws org.apache.thrift.TException
    {
      createStateInZookeeper_result result = new createStateInZookeeper_result();
      receiveBase(result, "createStateInZookeeper");
      return;
    }

    public String beginFileUpload() throws AuthorizationException, org.apache.thrift.TException
    {
      send_beginFileUpload();
      return recv_beginFileUpload();
    }

    public void send_beginFileUpload() throws org.apache.thrift.TException
    {
      beginFileUpload_args args = new beginFileUpload_args();
      sendBase("beginFileUpload", args);
    }

    public String recv_beginFileUpload() throws AuthorizationException, org.apache.thrift.TException
    {
      beginFileUpload_result result = new beginFileUpload_result();
      receiveBase(result, "beginFileUpload");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "beginFileUpload failed: unknown result");
    }

    public void uploadChunk(String location, ByteBuffer chunk) throws AuthorizationException, org.apache.thrift.TException
    {
      send_uploadChunk(location, chunk);
      recv_uploadChunk();
    }

    public void send_uploadChunk(String location, ByteBuffer chunk) throws org.apache.thrift.TException
    {
      uploadChunk_args args = new uploadChunk_args();
      args.set_location(location);
      args.set_chunk(chunk);
      sendBase("uploadChunk", args);
    }

    public void recv_uploadChunk() throws AuthorizationException, org.apache.thrift.TException
    {
      uploadChunk_result result = new uploadChunk_result();
      receiveBase(result, "uploadChunk");
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public void finishFileUpload(String location) throws AuthorizationException, org.apache.thrift.TException
    {
      send_finishFileUpload(location);
      recv_finishFileUpload();
    }

    public void send_finishFileUpload(String location) throws org.apache.thrift.TException
    {
      finishFileUpload_args args = new finishFileUpload_args();
      args.set_location(location);
      sendBase("finishFileUpload", args);
    }

    public void recv_finishFileUpload() throws AuthorizationException, org.apache.thrift.TException
    {
      finishFileUpload_result result = new finishFileUpload_result();
      receiveBase(result, "finishFileUpload");
      if (result.aze != null) {
        throw result.aze;
      }
      return;
    }

    public String beginFileDownload(String file) throws AuthorizationException, org.apache.thrift.TException
    {
      send_beginFileDownload(file);
      return recv_beginFileDownload();
    }

    public void send_beginFileDownload(String file) throws org.apache.thrift.TException
    {
      beginFileDownload_args args = new beginFileDownload_args();
      args.set_file(file);
      sendBase("beginFileDownload", args);
    }

    public String recv_beginFileDownload() throws AuthorizationException, org.apache.thrift.TException
    {
      beginFileDownload_result result = new beginFileDownload_result();
      receiveBase(result, "beginFileDownload");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "beginFileDownload failed: unknown result");
    }

    public ByteBuffer downloadChunk(String id) throws AuthorizationException, org.apache.thrift.TException
    {
      send_downloadChunk(id);
      return recv_downloadChunk();
    }

    public void send_downloadChunk(String id) throws org.apache.thrift.TException
    {
      downloadChunk_args args = new downloadChunk_args();
      args.set_id(id);
      sendBase("downloadChunk", args);
    }

    public ByteBuffer recv_downloadChunk() throws AuthorizationException, org.apache.thrift.TException
    {
      downloadChunk_result result = new downloadChunk_result();
      receiveBase(result, "downloadChunk");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "downloadChunk failed: unknown result");
    }

    public String getNimbusConf() throws AuthorizationException, org.apache.thrift.TException
    {
      send_getNimbusConf();
      return recv_getNimbusConf();
    }

    public void send_getNimbusConf() throws org.apache.thrift.TException
    {
      getNimbusConf_args args = new getNimbusConf_args();
      sendBase("getNimbusConf", args);
    }

    public String recv_getNimbusConf() throws AuthorizationException, org.apache.thrift.TException
    {
      getNimbusConf_result result = new getNimbusConf_result();
      receiveBase(result, "getNimbusConf");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getNimbusConf failed: unknown result");
    }

    public ClusterSummary getClusterInfo() throws AuthorizationException, org.apache.thrift.TException
    {
      send_getClusterInfo();
      return recv_getClusterInfo();
    }

    public void send_getClusterInfo() throws org.apache.thrift.TException
    {
      getClusterInfo_args args = new getClusterInfo_args();
      sendBase("getClusterInfo", args);
    }

    public ClusterSummary recv_getClusterInfo() throws AuthorizationException, org.apache.thrift.TException
    {
      getClusterInfo_result result = new getClusterInfo_result();
      receiveBase(result, "getClusterInfo");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getClusterInfo failed: unknown result");
    }

    public TopologyInfo getTopologyInfo(String id) throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      send_getTopologyInfo(id);
      return recv_getTopologyInfo();
    }

    public void send_getTopologyInfo(String id) throws org.apache.thrift.TException
    {
      getTopologyInfo_args args = new getTopologyInfo_args();
      args.set_id(id);
      sendBase("getTopologyInfo", args);
    }

    public TopologyInfo recv_getTopologyInfo() throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      getTopologyInfo_result result = new getTopologyInfo_result();
      receiveBase(result, "getTopologyInfo");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTopologyInfo failed: unknown result");
    }

    public TopologyInfo getTopologyInfoWithOpts(String id, GetInfoOptions options) throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      send_getTopologyInfoWithOpts(id, options);
      return recv_getTopologyInfoWithOpts();
    }

    public void send_getTopologyInfoWithOpts(String id, GetInfoOptions options) throws org.apache.thrift.TException
    {
      getTopologyInfoWithOpts_args args = new getTopologyInfoWithOpts_args();
      args.set_id(id);
      args.set_options(options);
      sendBase("getTopologyInfoWithOpts", args);
    }

    public TopologyInfo recv_getTopologyInfoWithOpts() throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      getTopologyInfoWithOpts_result result = new getTopologyInfoWithOpts_result();
      receiveBase(result, "getTopologyInfoWithOpts");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTopologyInfoWithOpts failed: unknown result");
    }

    public TopologyPageInfo getTopologyPageInfo(String id, String window, boolean is_include_sys) throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      send_getTopologyPageInfo(id, window, is_include_sys);
      return recv_getTopologyPageInfo();
    }

    public void send_getTopologyPageInfo(String id, String window, boolean is_include_sys) throws org.apache.thrift.TException
    {
      getTopologyPageInfo_args args = new getTopologyPageInfo_args();
      args.set_id(id);
      args.set_window(window);
      args.set_is_include_sys(is_include_sys);
      sendBase("getTopologyPageInfo", args);
    }

    public TopologyPageInfo recv_getTopologyPageInfo() throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      getTopologyPageInfo_result result = new getTopologyPageInfo_result();
      receiveBase(result, "getTopologyPageInfo");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTopologyPageInfo failed: unknown result");
    }

    public ComponentPageInfo getComponentPageInfo(String topology_id, String component_id, String window, boolean is_include_sys) throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      send_getComponentPageInfo(topology_id, component_id, window, is_include_sys);
      return recv_getComponentPageInfo();
    }

    public void send_getComponentPageInfo(String topology_id, String component_id, String window, boolean is_include_sys) throws org.apache.thrift.TException
    {
      getComponentPageInfo_args args = new getComponentPageInfo_args();
      args.set_topology_id(topology_id);
      args.set_component_id(component_id);
      args.set_window(window);
      args.set_is_include_sys(is_include_sys);
      sendBase("getComponentPageInfo", args);
    }

    public ComponentPageInfo recv_getComponentPageInfo() throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      getComponentPageInfo_result result = new getComponentPageInfo_result();
      receiveBase(result, "getComponentPageInfo");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getComponentPageInfo failed: unknown result");
    }

    public String getTopologyConf(String id) throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      send_getTopologyConf(id);
      return recv_getTopologyConf();
    }

    public void send_getTopologyConf(String id) throws org.apache.thrift.TException
    {
      getTopologyConf_args args = new getTopologyConf_args();
      args.set_id(id);
      sendBase("getTopologyConf", args);
    }

    public String recv_getTopologyConf() throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      getTopologyConf_result result = new getTopologyConf_result();
      receiveBase(result, "getTopologyConf");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTopologyConf failed: unknown result");
    }

    public StormTopology getTopology(String id) throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      send_getTopology(id);
      return recv_getTopology();
    }

    public void send_getTopology(String id) throws org.apache.thrift.TException
    {
      getTopology_args args = new getTopology_args();
      args.set_id(id);
      sendBase("getTopology", args);
    }

    public StormTopology recv_getTopology() throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      getTopology_result result = new getTopology_result();
      receiveBase(result, "getTopology");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTopology failed: unknown result");
    }

    public StormTopology getUserTopology(String id) throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      send_getUserTopology(id);
      return recv_getUserTopology();
    }

    public void send_getUserTopology(String id) throws org.apache.thrift.TException
    {
      getUserTopology_args args = new getUserTopology_args();
      args.set_id(id);
      sendBase("getUserTopology", args);
    }

    public StormTopology recv_getUserTopology() throws NotAliveException, AuthorizationException, org.apache.thrift.TException
    {
      getUserTopology_result result = new getUserTopology_result();
      receiveBase(result, "getUserTopology");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserTopology failed: unknown result");
    }

    public TopologyHistoryInfo getTopologyHistory(String user) throws AuthorizationException, org.apache.thrift.TException
    {
      send_getTopologyHistory(user);
      return recv_getTopologyHistory();
    }

    public void send_getTopologyHistory(String user) throws org.apache.thrift.TException
    {
      getTopologyHistory_args args = new getTopologyHistory_args();
      args.set_user(user);
      sendBase("getTopologyHistory", args);
    }

    public TopologyHistoryInfo recv_getTopologyHistory() throws AuthorizationException, org.apache.thrift.TException
    {
      getTopologyHistory_result result = new getTopologyHistory_result();
      receiveBase(result, "getTopologyHistory");
      if (result.is_set_success()) {
        return result.success;
      }
      if (result.aze != null) {
        throw result.aze;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTopologyHistory failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void submitTopology(String name, String uploadedJarLocation, String jsonConf, StormTopology topology, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      submitTopology_call method_call = new submitTopology_call(name, uploadedJarLocation, jsonConf, topology, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class submitTopology_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      private String uploadedJarLocation;
      private String jsonConf;
      private StormTopology topology;
      public submitTopology_call(String name, String uploadedJarLocation, String jsonConf, StormTopology topology, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
        this.uploadedJarLocation = uploadedJarLocation;
        this.jsonConf = jsonConf;
        this.topology = topology;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("submitTopology", org.apache.thrift.protocol.TMessageType.CALL, 0));
        submitTopology_args args = new submitTopology_args();
        args.set_name(name);
        args.set_uploadedJarLocation(uploadedJarLocation);
        args.set_jsonConf(jsonConf);
        args.set_topology(topology);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AlreadyAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_submitTopology();
      }
    }

    public void submitTopologyWithOpts(String name, String uploadedJarLocation, String jsonConf, StormTopology topology, SubmitOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      submitTopologyWithOpts_call method_call = new submitTopologyWithOpts_call(name, uploadedJarLocation, jsonConf, topology, options, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class submitTopologyWithOpts_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      private String uploadedJarLocation;
      private String jsonConf;
      private StormTopology topology;
      private SubmitOptions options;
      public submitTopologyWithOpts_call(String name, String uploadedJarLocation, String jsonConf, StormTopology topology, SubmitOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
        this.uploadedJarLocation = uploadedJarLocation;
        this.jsonConf = jsonConf;
        this.topology = topology;
        this.options = options;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("submitTopologyWithOpts", org.apache.thrift.protocol.TMessageType.CALL, 0));
        submitTopologyWithOpts_args args = new submitTopologyWithOpts_args();
        args.set_name(name);
        args.set_uploadedJarLocation(uploadedJarLocation);
        args.set_jsonConf(jsonConf);
        args.set_topology(topology);
        args.set_options(options);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AlreadyAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_submitTopologyWithOpts();
      }
    }

    public void killTopology(String name, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      killTopology_call method_call = new killTopology_call(name, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class killTopology_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      public killTopology_call(String name, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("killTopology", org.apache.thrift.protocol.TMessageType.CALL, 0));
        killTopology_args args = new killTopology_args();
        args.set_name(name);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws NotAliveException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_killTopology();
      }
    }

    public void killTopologyWithOpts(String name, KillOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      killTopologyWithOpts_call method_call = new killTopologyWithOpts_call(name, options, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class killTopologyWithOpts_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      private KillOptions options;
      public killTopologyWithOpts_call(String name, KillOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
        this.options = options;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("killTopologyWithOpts", org.apache.thrift.protocol.TMessageType.CALL, 0));
        killTopologyWithOpts_args args = new killTopologyWithOpts_args();
        args.set_name(name);
        args.set_options(options);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws NotAliveException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_killTopologyWithOpts();
      }
    }

    public void activate(String name, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      activate_call method_call = new activate_call(name, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class activate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      public activate_call(String name, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("activate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        activate_args args = new activate_args();
        args.set_name(name);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws NotAliveException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_activate();
      }
    }

    public void deactivate(String name, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deactivate_call method_call = new deactivate_call(name, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deactivate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      public deactivate_call(String name, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deactivate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deactivate_args args = new deactivate_args();
        args.set_name(name);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws NotAliveException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_deactivate();
      }
    }

    public void rebalance(String name, RebalanceOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      rebalance_call method_call = new rebalance_call(name, options, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class rebalance_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      private RebalanceOptions options;
      public rebalance_call(String name, RebalanceOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
        this.options = options;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("rebalance", org.apache.thrift.protocol.TMessageType.CALL, 0));
        rebalance_args args = new rebalance_args();
        args.set_name(name);
        args.set_options(options);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws NotAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_rebalance();
      }
    }

    public void setLogConfig(String name, LogConfig config, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      setLogConfig_call method_call = new setLogConfig_call(name, config, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class setLogConfig_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      private LogConfig config;
      public setLogConfig_call(String name, LogConfig config, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
        this.config = config;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("setLogConfig", org.apache.thrift.protocol.TMessageType.CALL, 0));
        setLogConfig_args args = new setLogConfig_args();
        args.set_name(name);
        args.set_config(config);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_setLogConfig();
      }
    }

    public void getLogConfig(String name, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getLogConfig_call method_call = new getLogConfig_call(name, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getLogConfig_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      public getLogConfig_call(String name, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getLogConfig", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getLogConfig_args args = new getLogConfig_args();
        args.set_name(name);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public LogConfig getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getLogConfig();
      }
    }

    public void debug(String name, String component, boolean enable, double samplingPercentage, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      debug_call method_call = new debug_call(name, component, enable, samplingPercentage, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class debug_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      private String component;
      private boolean enable;
      private double samplingPercentage;
      public debug_call(String name, String component, boolean enable, double samplingPercentage, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
        this.component = component;
        this.enable = enable;
        this.samplingPercentage = samplingPercentage;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("debug", org.apache.thrift.protocol.TMessageType.CALL, 0));
        debug_args args = new debug_args();
        args.set_name(name);
        args.set_component(component);
        args.set_enable(enable);
        args.set_samplingPercentage(samplingPercentage);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws NotAliveException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_debug();
      }
    }

    public void setWorkerProfiler(String id, ProfileRequest profileRequest, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      setWorkerProfiler_call method_call = new setWorkerProfiler_call(id, profileRequest, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class setWorkerProfiler_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String id;
      private ProfileRequest profileRequest;
      public setWorkerProfiler_call(String id, ProfileRequest profileRequest, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
        this.profileRequest = profileRequest;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("setWorkerProfiler", org.apache.thrift.protocol.TMessageType.CALL, 0));
        setWorkerProfiler_args args = new setWorkerProfiler_args();
        args.set_id(id);
        args.set_profileRequest(profileRequest);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_setWorkerProfiler();
      }
    }

    public void getComponentPendingProfileActions(String id, String component_id, ProfileAction action, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getComponentPendingProfileActions_call method_call = new getComponentPendingProfileActions_call(id, component_id, action, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getComponentPendingProfileActions_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String id;
      private String component_id;
      private ProfileAction action;
      public getComponentPendingProfileActions_call(String id, String component_id, ProfileAction action, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
        this.component_id = component_id;
        this.action = action;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getComponentPendingProfileActions", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getComponentPendingProfileActions_args args = new getComponentPendingProfileActions_args();
        args.set_id(id);
        args.set_component_id(component_id);
        args.set_action(action);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ProfileRequest> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getComponentPendingProfileActions();
      }
    }

    public void uploadNewCredentials(String name, Credentials creds, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      uploadNewCredentials_call method_call = new uploadNewCredentials_call(name, creds, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class uploadNewCredentials_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      private Credentials creds;
      public uploadNewCredentials_call(String name, Credentials creds, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
        this.creds = creds;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("uploadNewCredentials", org.apache.thrift.protocol.TMessageType.CALL, 0));
        uploadNewCredentials_args args = new uploadNewCredentials_args();
        args.set_name(name);
        args.set_creds(creds);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws NotAliveException, InvalidTopologyException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_uploadNewCredentials();
      }
    }

    public void beginCreateBlob(String key, SettableBlobMeta meta, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      beginCreateBlob_call method_call = new beginCreateBlob_call(key, meta, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class beginCreateBlob_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String key;
      private SettableBlobMeta meta;
      public beginCreateBlob_call(String key, SettableBlobMeta meta, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.meta = meta;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("beginCreateBlob", org.apache.thrift.protocol.TMessageType.CALL, 0));
        beginCreateBlob_args args = new beginCreateBlob_args();
        args.set_key(key);
        args.set_meta(meta);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws AuthorizationException, KeyAlreadyExistsException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_beginCreateBlob();
      }
    }

    public void beginUpdateBlob(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      beginUpdateBlob_call method_call = new beginUpdateBlob_call(key, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class beginUpdateBlob_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String key;
      public beginUpdateBlob_call(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("beginUpdateBlob", org.apache.thrift.protocol.TMessageType.CALL, 0));
        beginUpdateBlob_args args = new beginUpdateBlob_args();
        args.set_key(key);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_beginUpdateBlob();
      }
    }

    public void uploadBlobChunk(String session, ByteBuffer chunk, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      uploadBlobChunk_call method_call = new uploadBlobChunk_call(session, chunk, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class uploadBlobChunk_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String session;
      private ByteBuffer chunk;
      public uploadBlobChunk_call(String session, ByteBuffer chunk, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.session = session;
        this.chunk = chunk;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("uploadBlobChunk", org.apache.thrift.protocol.TMessageType.CALL, 0));
        uploadBlobChunk_args args = new uploadBlobChunk_args();
        args.set_session(session);
        args.set_chunk(chunk);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_uploadBlobChunk();
      }
    }

    public void finishBlobUpload(String session, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      finishBlobUpload_call method_call = new finishBlobUpload_call(session, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class finishBlobUpload_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String session;
      public finishBlobUpload_call(String session, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.session = session;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("finishBlobUpload", org.apache.thrift.protocol.TMessageType.CALL, 0));
        finishBlobUpload_args args = new finishBlobUpload_args();
        args.set_session(session);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_finishBlobUpload();
      }
    }

    public void cancelBlobUpload(String session, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      cancelBlobUpload_call method_call = new cancelBlobUpload_call(session, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class cancelBlobUpload_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String session;
      public cancelBlobUpload_call(String session, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.session = session;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("cancelBlobUpload", org.apache.thrift.protocol.TMessageType.CALL, 0));
        cancelBlobUpload_args args = new cancelBlobUpload_args();
        args.set_session(session);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_cancelBlobUpload();
      }
    }

    public void getBlobMeta(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getBlobMeta_call method_call = new getBlobMeta_call(key, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getBlobMeta_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String key;
      public getBlobMeta_call(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getBlobMeta", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getBlobMeta_args args = new getBlobMeta_args();
        args.set_key(key);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ReadableBlobMeta getResult() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getBlobMeta();
      }
    }

    public void setBlobMeta(String key, SettableBlobMeta meta, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      setBlobMeta_call method_call = new setBlobMeta_call(key, meta, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class setBlobMeta_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String key;
      private SettableBlobMeta meta;
      public setBlobMeta_call(String key, SettableBlobMeta meta, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.meta = meta;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("setBlobMeta", org.apache.thrift.protocol.TMessageType.CALL, 0));
        setBlobMeta_args args = new setBlobMeta_args();
        args.set_key(key);
        args.set_meta(meta);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_setBlobMeta();
      }
    }

    public void beginBlobDownload(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      beginBlobDownload_call method_call = new beginBlobDownload_call(key, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class beginBlobDownload_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String key;
      public beginBlobDownload_call(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("beginBlobDownload", org.apache.thrift.protocol.TMessageType.CALL, 0));
        beginBlobDownload_args args = new beginBlobDownload_args();
        args.set_key(key);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public BeginDownloadResult getResult() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_beginBlobDownload();
      }
    }

    public void downloadBlobChunk(String session, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      downloadBlobChunk_call method_call = new downloadBlobChunk_call(session, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class downloadBlobChunk_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String session;
      public downloadBlobChunk_call(String session, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.session = session;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("downloadBlobChunk", org.apache.thrift.protocol.TMessageType.CALL, 0));
        downloadBlobChunk_args args = new downloadBlobChunk_args();
        args.set_session(session);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ByteBuffer getResult() throws AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_downloadBlobChunk();
      }
    }

    public void deleteBlob(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteBlob_call method_call = new deleteBlob_call(key, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteBlob_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String key;
      public deleteBlob_call(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteBlob", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteBlob_args args = new deleteBlob_args();
        args.set_key(key);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_deleteBlob();
      }
    }

    public void listBlobs(String session, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      listBlobs_call method_call = new listBlobs_call(session, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class listBlobs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String session;
      public listBlobs_call(String session, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.session = session;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("listBlobs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        listBlobs_args args = new listBlobs_args();
        args.set_session(session);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ListBlobsResult getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_listBlobs();
      }
    }

    public void getBlobReplication(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getBlobReplication_call method_call = new getBlobReplication_call(key, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getBlobReplication_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String key;
      public getBlobReplication_call(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getBlobReplication", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getBlobReplication_args args = new getBlobReplication_args();
        args.set_key(key);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getBlobReplication();
      }
    }

    public void updateBlobReplication(String key, int replication, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateBlobReplication_call method_call = new updateBlobReplication_call(key, replication, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateBlobReplication_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String key;
      private int replication;
      public updateBlobReplication_call(String key, int replication, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.replication = replication;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateBlobReplication", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateBlobReplication_args args = new updateBlobReplication_args();
        args.set_key(key);
        args.set_replication(replication);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws AuthorizationException, KeyNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateBlobReplication();
      }
    }

    public void createStateInZookeeper(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createStateInZookeeper_call method_call = new createStateInZookeeper_call(key, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createStateInZookeeper_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String key;
      public createStateInZookeeper_call(String key, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createStateInZookeeper", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createStateInZookeeper_args args = new createStateInZookeeper_args();
        args.set_key(key);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_createStateInZookeeper();
      }
    }

    public void beginFileUpload(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      beginFileUpload_call method_call = new beginFileUpload_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class beginFileUpload_call extends org.apache.thrift.async.TAsyncMethodCall {
      public beginFileUpload_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("beginFileUpload", org.apache.thrift.protocol.TMessageType.CALL, 0));
        beginFileUpload_args args = new beginFileUpload_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_beginFileUpload();
      }
    }

    public void uploadChunk(String location, ByteBuffer chunk, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      uploadChunk_call method_call = new uploadChunk_call(location, chunk, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class uploadChunk_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String location;
      private ByteBuffer chunk;
      public uploadChunk_call(String location, ByteBuffer chunk, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.location = location;
        this.chunk = chunk;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("uploadChunk", org.apache.thrift.protocol.TMessageType.CALL, 0));
        uploadChunk_args args = new uploadChunk_args();
        args.set_location(location);
        args.set_chunk(chunk);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_uploadChunk();
      }
    }

    public void finishFileUpload(String location, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      finishFileUpload_call method_call = new finishFileUpload_call(location, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class finishFileUpload_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String location;
      public finishFileUpload_call(String location, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.location = location;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("finishFileUpload", org.apache.thrift.protocol.TMessageType.CALL, 0));
        finishFileUpload_args args = new finishFileUpload_args();
        args.set_location(location);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_finishFileUpload();
      }
    }

    public void beginFileDownload(String file, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      beginFileDownload_call method_call = new beginFileDownload_call(file, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class beginFileDownload_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String file;
      public beginFileDownload_call(String file, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.file = file;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("beginFileDownload", org.apache.thrift.protocol.TMessageType.CALL, 0));
        beginFileDownload_args args = new beginFileDownload_args();
        args.set_file(file);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_beginFileDownload();
      }
    }

    public void downloadChunk(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      downloadChunk_call method_call = new downloadChunk_call(id, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class downloadChunk_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String id;
      public downloadChunk_call(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("downloadChunk", org.apache.thrift.protocol.TMessageType.CALL, 0));
        downloadChunk_args args = new downloadChunk_args();
        args.set_id(id);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ByteBuffer getResult() throws AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_downloadChunk();
      }
    }

    public void getNimbusConf(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getNimbusConf_call method_call = new getNimbusConf_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getNimbusConf_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getNimbusConf_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getNimbusConf", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getNimbusConf_args args = new getNimbusConf_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getNimbusConf();
      }
    }

    public void getClusterInfo(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getClusterInfo_call method_call = new getClusterInfo_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getClusterInfo_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getClusterInfo_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getClusterInfo", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getClusterInfo_args args = new getClusterInfo_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ClusterSummary getResult() throws AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getClusterInfo();
      }
    }

    public void getTopologyInfo(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTopologyInfo_call method_call = new getTopologyInfo_call(id, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTopologyInfo_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String id;
      public getTopologyInfo_call(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTopologyInfo", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTopologyInfo_args args = new getTopologyInfo_args();
        args.set_id(id);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TopologyInfo getResult() throws NotAliveException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTopologyInfo();
      }
    }

    public void getTopologyInfoWithOpts(String id, GetInfoOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTopologyInfoWithOpts_call method_call = new getTopologyInfoWithOpts_call(id, options, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTopologyInfoWithOpts_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String id;
      private GetInfoOptions options;
      public getTopologyInfoWithOpts_call(String id, GetInfoOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
        this.options = options;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTopologyInfoWithOpts", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTopologyInfoWithOpts_args args = new getTopologyInfoWithOpts_args();
        args.set_id(id);
        args.set_options(options);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TopologyInfo getResult() throws NotAliveException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTopologyInfoWithOpts();
      }
    }

    public void getTopologyPageInfo(String id, String window, boolean is_include_sys, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTopologyPageInfo_call method_call = new getTopologyPageInfo_call(id, window, is_include_sys, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTopologyPageInfo_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String id;
      private String window;
      private boolean is_include_sys;
      public getTopologyPageInfo_call(String id, String window, boolean is_include_sys, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
        this.window = window;
        this.is_include_sys = is_include_sys;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTopologyPageInfo", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTopologyPageInfo_args args = new getTopologyPageInfo_args();
        args.set_id(id);
        args.set_window(window);
        args.set_is_include_sys(is_include_sys);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TopologyPageInfo getResult() throws NotAliveException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTopologyPageInfo();
      }
    }

    public void getComponentPageInfo(String topology_id, String component_id, String window, boolean is_include_sys, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getComponentPageInfo_call method_call = new getComponentPageInfo_call(topology_id, component_id, window, is_include_sys, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getComponentPageInfo_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String topology_id;
      private String component_id;
      private String window;
      private boolean is_include_sys;
      public getComponentPageInfo_call(String topology_id, String component_id, String window, boolean is_include_sys, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.topology_id = topology_id;
        this.component_id = component_id;
        this.window = window;
        this.is_include_sys = is_include_sys;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getComponentPageInfo", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getComponentPageInfo_args args = new getComponentPageInfo_args();
        args.set_topology_id(topology_id);
        args.set_component_id(component_id);
        args.set_window(window);
        args.set_is_include_sys(is_include_sys);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ComponentPageInfo getResult() throws NotAliveException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getComponentPageInfo();
      }
    }

    public void getTopologyConf(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTopologyConf_call method_call = new getTopologyConf_call(id, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTopologyConf_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String id;
      public getTopologyConf_call(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTopologyConf", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTopologyConf_args args = new getTopologyConf_args();
        args.set_id(id);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws NotAliveException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTopologyConf();
      }
    }

    public void getTopology(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTopology_call method_call = new getTopology_call(id, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTopology_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String id;
      public getTopology_call(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTopology", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTopology_args args = new getTopology_args();
        args.set_id(id);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public StormTopology getResult() throws NotAliveException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTopology();
      }
    }

    public void getUserTopology(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserTopology_call method_call = new getUserTopology_call(id, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserTopology_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String id;
      public getUserTopology_call(String id, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserTopology", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserTopology_args args = new getUserTopology_args();
        args.set_id(id);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public StormTopology getResult() throws NotAliveException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserTopology();
      }
    }

    public void getTopologyHistory(String user, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTopologyHistory_call method_call = new getTopologyHistory_call(user, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTopologyHistory_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String user;
      public getTopologyHistory_call(String user, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.user = user;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTopologyHistory", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTopologyHistory_args args = new getTopologyHistory_args();
        args.set_user(user);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TopologyHistoryInfo getResult() throws AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTopologyHistory();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("submitTopology", new submitTopology());
      processMap.put("submitTopologyWithOpts", new submitTopologyWithOpts());
      processMap.put("killTopology", new killTopology());
      processMap.put("killTopologyWithOpts", new killTopologyWithOpts());
      processMap.put("activate", new activate());
      processMap.put("deactivate", new deactivate());
      processMap.put("rebalance", new rebalance());
      processMap.put("setLogConfig", new setLogConfig());
      processMap.put("getLogConfig", new getLogConfig());
      processMap.put("debug", new debug());
      processMap.put("setWorkerProfiler", new setWorkerProfiler());
      processMap.put("getComponentPendingProfileActions", new getComponentPendingProfileActions());
      processMap.put("uploadNewCredentials", new uploadNewCredentials());
      processMap.put("beginCreateBlob", new beginCreateBlob());
      processMap.put("beginUpdateBlob", new beginUpdateBlob());
      processMap.put("uploadBlobChunk", new uploadBlobChunk());
      processMap.put("finishBlobUpload", new finishBlobUpload());
      processMap.put("cancelBlobUpload", new cancelBlobUpload());
      processMap.put("getBlobMeta", new getBlobMeta());
      processMap.put("setBlobMeta", new setBlobMeta());
      processMap.put("beginBlobDownload", new beginBlobDownload());
      processMap.put("downloadBlobChunk", new downloadBlobChunk());
      processMap.put("deleteBlob", new deleteBlob());
      processMap.put("listBlobs", new listBlobs());
      processMap.put("getBlobReplication", new getBlobReplication());
      processMap.put("updateBlobReplication", new updateBlobReplication());
      processMap.put("createStateInZookeeper", new createStateInZookeeper());
      processMap.put("beginFileUpload", new beginFileUpload());
      processMap.put("uploadChunk", new uploadChunk());
      processMap.put("finishFileUpload", new finishFileUpload());
      processMap.put("beginFileDownload", new beginFileDownload());
      processMap.put("downloadChunk", new downloadChunk());
      processMap.put("getNimbusConf", new getNimbusConf());
      processMap.put("getClusterInfo", new getClusterInfo());
      processMap.put("getTopologyInfo", new getTopologyInfo());
      processMap.put("getTopologyInfoWithOpts", new getTopologyInfoWithOpts());
      processMap.put("getTopologyPageInfo", new getTopologyPageInfo());
      processMap.put("getComponentPageInfo", new getComponentPageInfo());
      processMap.put("getTopologyConf", new getTopologyConf());
      processMap.put("getTopology", new getTopology());
      processMap.put("getUserTopology", new getUserTopology());
      processMap.put("getTopologyHistory", new getTopologyHistory());
      return processMap;
    }

    public static class submitTopology<I extends Iface> extends org.apache.thrift.ProcessFunction<I, submitTopology_args> {
      public submitTopology() {
        super("submitTopology");
      }

      public submitTopology_args getEmptyArgsInstance() {
        return new submitTopology_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public submitTopology_result getResult(I iface, submitTopology_args args) throws org.apache.thrift.TException {
        submitTopology_result result = new submitTopology_result();
        try {
          iface.submitTopology(args.name, args.uploadedJarLocation, args.jsonConf, args.topology);
        } catch (AlreadyAliveException e) {
          result.e = e;
        } catch (InvalidTopologyException ite) {
          result.ite = ite;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class submitTopologyWithOpts<I extends Iface> extends org.apache.thrift.ProcessFunction<I, submitTopologyWithOpts_args> {
      public submitTopologyWithOpts() {
        super("submitTopologyWithOpts");
      }

      public submitTopologyWithOpts_args getEmptyArgsInstance() {
        return new submitTopologyWithOpts_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public submitTopologyWithOpts_result getResult(I iface, submitTopologyWithOpts_args args) throws org.apache.thrift.TException {
        submitTopologyWithOpts_result result = new submitTopologyWithOpts_result();
        try {
          iface.submitTopologyWithOpts(args.name, args.uploadedJarLocation, args.jsonConf, args.topology, args.options);
        } catch (AlreadyAliveException e) {
          result.e = e;
        } catch (InvalidTopologyException ite) {
          result.ite = ite;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class killTopology<I extends Iface> extends org.apache.thrift.ProcessFunction<I, killTopology_args> {
      public killTopology() {
        super("killTopology");
      }

      public killTopology_args getEmptyArgsInstance() {
        return new killTopology_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public killTopology_result getResult(I iface, killTopology_args args) throws org.apache.thrift.TException {
        killTopology_result result = new killTopology_result();
        try {
          iface.killTopology(args.name);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class killTopologyWithOpts<I extends Iface> extends org.apache.thrift.ProcessFunction<I, killTopologyWithOpts_args> {
      public killTopologyWithOpts() {
        super("killTopologyWithOpts");
      }

      public killTopologyWithOpts_args getEmptyArgsInstance() {
        return new killTopologyWithOpts_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public killTopologyWithOpts_result getResult(I iface, killTopologyWithOpts_args args) throws org.apache.thrift.TException {
        killTopologyWithOpts_result result = new killTopologyWithOpts_result();
        try {
          iface.killTopologyWithOpts(args.name, args.options);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class activate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, activate_args> {
      public activate() {
        super("activate");
      }

      public activate_args getEmptyArgsInstance() {
        return new activate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public activate_result getResult(I iface, activate_args args) throws org.apache.thrift.TException {
        activate_result result = new activate_result();
        try {
          iface.activate(args.name);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class deactivate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deactivate_args> {
      public deactivate() {
        super("deactivate");
      }

      public deactivate_args getEmptyArgsInstance() {
        return new deactivate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deactivate_result getResult(I iface, deactivate_args args) throws org.apache.thrift.TException {
        deactivate_result result = new deactivate_result();
        try {
          iface.deactivate(args.name);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class rebalance<I extends Iface> extends org.apache.thrift.ProcessFunction<I, rebalance_args> {
      public rebalance() {
        super("rebalance");
      }

      public rebalance_args getEmptyArgsInstance() {
        return new rebalance_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public rebalance_result getResult(I iface, rebalance_args args) throws org.apache.thrift.TException {
        rebalance_result result = new rebalance_result();
        try {
          iface.rebalance(args.name, args.options);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (InvalidTopologyException ite) {
          result.ite = ite;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class setLogConfig<I extends Iface> extends org.apache.thrift.ProcessFunction<I, setLogConfig_args> {
      public setLogConfig() {
        super("setLogConfig");
      }

      public setLogConfig_args getEmptyArgsInstance() {
        return new setLogConfig_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public setLogConfig_result getResult(I iface, setLogConfig_args args) throws org.apache.thrift.TException {
        setLogConfig_result result = new setLogConfig_result();
        iface.setLogConfig(args.name, args.config);
        return result;
      }
    }

    public static class getLogConfig<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getLogConfig_args> {
      public getLogConfig() {
        super("getLogConfig");
      }

      public getLogConfig_args getEmptyArgsInstance() {
        return new getLogConfig_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getLogConfig_result getResult(I iface, getLogConfig_args args) throws org.apache.thrift.TException {
        getLogConfig_result result = new getLogConfig_result();
        result.success = iface.getLogConfig(args.name);
        return result;
      }
    }

    public static class debug<I extends Iface> extends org.apache.thrift.ProcessFunction<I, debug_args> {
      public debug() {
        super("debug");
      }

      public debug_args getEmptyArgsInstance() {
        return new debug_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public debug_result getResult(I iface, debug_args args) throws org.apache.thrift.TException {
        debug_result result = new debug_result();
        try {
          iface.debug(args.name, args.component, args.enable, args.samplingPercentage);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class setWorkerProfiler<I extends Iface> extends org.apache.thrift.ProcessFunction<I, setWorkerProfiler_args> {
      public setWorkerProfiler() {
        super("setWorkerProfiler");
      }

      public setWorkerProfiler_args getEmptyArgsInstance() {
        return new setWorkerProfiler_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public setWorkerProfiler_result getResult(I iface, setWorkerProfiler_args args) throws org.apache.thrift.TException {
        setWorkerProfiler_result result = new setWorkerProfiler_result();
        iface.setWorkerProfiler(args.id, args.profileRequest);
        return result;
      }
    }

    public static class getComponentPendingProfileActions<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getComponentPendingProfileActions_args> {
      public getComponentPendingProfileActions() {
        super("getComponentPendingProfileActions");
      }

      public getComponentPendingProfileActions_args getEmptyArgsInstance() {
        return new getComponentPendingProfileActions_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getComponentPendingProfileActions_result getResult(I iface, getComponentPendingProfileActions_args args) throws org.apache.thrift.TException {
        getComponentPendingProfileActions_result result = new getComponentPendingProfileActions_result();
        result.success = iface.getComponentPendingProfileActions(args.id, args.component_id, args.action);
        return result;
      }
    }

    public static class uploadNewCredentials<I extends Iface> extends org.apache.thrift.ProcessFunction<I, uploadNewCredentials_args> {
      public uploadNewCredentials() {
        super("uploadNewCredentials");
      }

      public uploadNewCredentials_args getEmptyArgsInstance() {
        return new uploadNewCredentials_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public uploadNewCredentials_result getResult(I iface, uploadNewCredentials_args args) throws org.apache.thrift.TException {
        uploadNewCredentials_result result = new uploadNewCredentials_result();
        try {
          iface.uploadNewCredentials(args.name, args.creds);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (InvalidTopologyException ite) {
          result.ite = ite;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class beginCreateBlob<I extends Iface> extends org.apache.thrift.ProcessFunction<I, beginCreateBlob_args> {
      public beginCreateBlob() {
        super("beginCreateBlob");
      }

      public beginCreateBlob_args getEmptyArgsInstance() {
        return new beginCreateBlob_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public beginCreateBlob_result getResult(I iface, beginCreateBlob_args args) throws org.apache.thrift.TException {
        beginCreateBlob_result result = new beginCreateBlob_result();
        try {
          result.success = iface.beginCreateBlob(args.key, args.meta);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        } catch (KeyAlreadyExistsException kae) {
          result.kae = kae;
        }
        return result;
      }
    }

    public static class beginUpdateBlob<I extends Iface> extends org.apache.thrift.ProcessFunction<I, beginUpdateBlob_args> {
      public beginUpdateBlob() {
        super("beginUpdateBlob");
      }

      public beginUpdateBlob_args getEmptyArgsInstance() {
        return new beginUpdateBlob_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public beginUpdateBlob_result getResult(I iface, beginUpdateBlob_args args) throws org.apache.thrift.TException {
        beginUpdateBlob_result result = new beginUpdateBlob_result();
        try {
          result.success = iface.beginUpdateBlob(args.key);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        } catch (KeyNotFoundException knf) {
          result.knf = knf;
        }
        return result;
      }
    }

    public static class uploadBlobChunk<I extends Iface> extends org.apache.thrift.ProcessFunction<I, uploadBlobChunk_args> {
      public uploadBlobChunk() {
        super("uploadBlobChunk");
      }

      public uploadBlobChunk_args getEmptyArgsInstance() {
        return new uploadBlobChunk_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public uploadBlobChunk_result getResult(I iface, uploadBlobChunk_args args) throws org.apache.thrift.TException {
        uploadBlobChunk_result result = new uploadBlobChunk_result();
        try {
          iface.uploadBlobChunk(args.session, args.chunk);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class finishBlobUpload<I extends Iface> extends org.apache.thrift.ProcessFunction<I, finishBlobUpload_args> {
      public finishBlobUpload() {
        super("finishBlobUpload");
      }

      public finishBlobUpload_args getEmptyArgsInstance() {
        return new finishBlobUpload_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public finishBlobUpload_result getResult(I iface, finishBlobUpload_args args) throws org.apache.thrift.TException {
        finishBlobUpload_result result = new finishBlobUpload_result();
        try {
          iface.finishBlobUpload(args.session);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class cancelBlobUpload<I extends Iface> extends org.apache.thrift.ProcessFunction<I, cancelBlobUpload_args> {
      public cancelBlobUpload() {
        super("cancelBlobUpload");
      }

      public cancelBlobUpload_args getEmptyArgsInstance() {
        return new cancelBlobUpload_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public cancelBlobUpload_result getResult(I iface, cancelBlobUpload_args args) throws org.apache.thrift.TException {
        cancelBlobUpload_result result = new cancelBlobUpload_result();
        try {
          iface.cancelBlobUpload(args.session);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class getBlobMeta<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getBlobMeta_args> {
      public getBlobMeta() {
        super("getBlobMeta");
      }

      public getBlobMeta_args getEmptyArgsInstance() {
        return new getBlobMeta_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getBlobMeta_result getResult(I iface, getBlobMeta_args args) throws org.apache.thrift.TException {
        getBlobMeta_result result = new getBlobMeta_result();
        try {
          result.success = iface.getBlobMeta(args.key);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        } catch (KeyNotFoundException knf) {
          result.knf = knf;
        }
        return result;
      }
    }

    public static class setBlobMeta<I extends Iface> extends org.apache.thrift.ProcessFunction<I, setBlobMeta_args> {
      public setBlobMeta() {
        super("setBlobMeta");
      }

      public setBlobMeta_args getEmptyArgsInstance() {
        return new setBlobMeta_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public setBlobMeta_result getResult(I iface, setBlobMeta_args args) throws org.apache.thrift.TException {
        setBlobMeta_result result = new setBlobMeta_result();
        try {
          iface.setBlobMeta(args.key, args.meta);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        } catch (KeyNotFoundException knf) {
          result.knf = knf;
        }
        return result;
      }
    }

    public static class beginBlobDownload<I extends Iface> extends org.apache.thrift.ProcessFunction<I, beginBlobDownload_args> {
      public beginBlobDownload() {
        super("beginBlobDownload");
      }

      public beginBlobDownload_args getEmptyArgsInstance() {
        return new beginBlobDownload_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public beginBlobDownload_result getResult(I iface, beginBlobDownload_args args) throws org.apache.thrift.TException {
        beginBlobDownload_result result = new beginBlobDownload_result();
        try {
          result.success = iface.beginBlobDownload(args.key);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        } catch (KeyNotFoundException knf) {
          result.knf = knf;
        }
        return result;
      }
    }

    public static class downloadBlobChunk<I extends Iface> extends org.apache.thrift.ProcessFunction<I, downloadBlobChunk_args> {
      public downloadBlobChunk() {
        super("downloadBlobChunk");
      }

      public downloadBlobChunk_args getEmptyArgsInstance() {
        return new downloadBlobChunk_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public downloadBlobChunk_result getResult(I iface, downloadBlobChunk_args args) throws org.apache.thrift.TException {
        downloadBlobChunk_result result = new downloadBlobChunk_result();
        try {
          result.success = iface.downloadBlobChunk(args.session);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class deleteBlob<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteBlob_args> {
      public deleteBlob() {
        super("deleteBlob");
      }

      public deleteBlob_args getEmptyArgsInstance() {
        return new deleteBlob_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteBlob_result getResult(I iface, deleteBlob_args args) throws org.apache.thrift.TException {
        deleteBlob_result result = new deleteBlob_result();
        try {
          iface.deleteBlob(args.key);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        } catch (KeyNotFoundException knf) {
          result.knf = knf;
        }
        return result;
      }
    }

    public static class listBlobs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, listBlobs_args> {
      public listBlobs() {
        super("listBlobs");
      }

      public listBlobs_args getEmptyArgsInstance() {
        return new listBlobs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public listBlobs_result getResult(I iface, listBlobs_args args) throws org.apache.thrift.TException {
        listBlobs_result result = new listBlobs_result();
        result.success = iface.listBlobs(args.session);
        return result;
      }
    }

    public static class getBlobReplication<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getBlobReplication_args> {
      public getBlobReplication() {
        super("getBlobReplication");
      }

      public getBlobReplication_args getEmptyArgsInstance() {
        return new getBlobReplication_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getBlobReplication_result getResult(I iface, getBlobReplication_args args) throws org.apache.thrift.TException {
        getBlobReplication_result result = new getBlobReplication_result();
        try {
          result.success = iface.getBlobReplication(args.key);
          result.set_success_isSet(true);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        } catch (KeyNotFoundException knf) {
          result.knf = knf;
        }
        return result;
      }
    }

    public static class updateBlobReplication<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateBlobReplication_args> {
      public updateBlobReplication() {
        super("updateBlobReplication");
      }

      public updateBlobReplication_args getEmptyArgsInstance() {
        return new updateBlobReplication_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateBlobReplication_result getResult(I iface, updateBlobReplication_args args) throws org.apache.thrift.TException {
        updateBlobReplication_result result = new updateBlobReplication_result();
        try {
          result.success = iface.updateBlobReplication(args.key, args.replication);
          result.set_success_isSet(true);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        } catch (KeyNotFoundException knf) {
          result.knf = knf;
        }
        return result;
      }
    }

    public static class createStateInZookeeper<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createStateInZookeeper_args> {
      public createStateInZookeeper() {
        super("createStateInZookeeper");
      }

      public createStateInZookeeper_args getEmptyArgsInstance() {
        return new createStateInZookeeper_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createStateInZookeeper_result getResult(I iface, createStateInZookeeper_args args) throws org.apache.thrift.TException {
        createStateInZookeeper_result result = new createStateInZookeeper_result();
        iface.createStateInZookeeper(args.key);
        return result;
      }
    }

    public static class beginFileUpload<I extends Iface> extends org.apache.thrift.ProcessFunction<I, beginFileUpload_args> {
      public beginFileUpload() {
        super("beginFileUpload");
      }

      public beginFileUpload_args getEmptyArgsInstance() {
        return new beginFileUpload_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public beginFileUpload_result getResult(I iface, beginFileUpload_args args) throws org.apache.thrift.TException {
        beginFileUpload_result result = new beginFileUpload_result();
        try {
          result.success = iface.beginFileUpload();
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class uploadChunk<I extends Iface> extends org.apache.thrift.ProcessFunction<I, uploadChunk_args> {
      public uploadChunk() {
        super("uploadChunk");
      }

      public uploadChunk_args getEmptyArgsInstance() {
        return new uploadChunk_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public uploadChunk_result getResult(I iface, uploadChunk_args args) throws org.apache.thrift.TException {
        uploadChunk_result result = new uploadChunk_result();
        try {
          iface.uploadChunk(args.location, args.chunk);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class finishFileUpload<I extends Iface> extends org.apache.thrift.ProcessFunction<I, finishFileUpload_args> {
      public finishFileUpload() {
        super("finishFileUpload");
      }

      public finishFileUpload_args getEmptyArgsInstance() {
        return new finishFileUpload_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public finishFileUpload_result getResult(I iface, finishFileUpload_args args) throws org.apache.thrift.TException {
        finishFileUpload_result result = new finishFileUpload_result();
        try {
          iface.finishFileUpload(args.location);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class beginFileDownload<I extends Iface> extends org.apache.thrift.ProcessFunction<I, beginFileDownload_args> {
      public beginFileDownload() {
        super("beginFileDownload");
      }

      public beginFileDownload_args getEmptyArgsInstance() {
        return new beginFileDownload_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public beginFileDownload_result getResult(I iface, beginFileDownload_args args) throws org.apache.thrift.TException {
        beginFileDownload_result result = new beginFileDownload_result();
        try {
          result.success = iface.beginFileDownload(args.file);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class downloadChunk<I extends Iface> extends org.apache.thrift.ProcessFunction<I, downloadChunk_args> {
      public downloadChunk() {
        super("downloadChunk");
      }

      public downloadChunk_args getEmptyArgsInstance() {
        return new downloadChunk_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public downloadChunk_result getResult(I iface, downloadChunk_args args) throws org.apache.thrift.TException {
        downloadChunk_result result = new downloadChunk_result();
        try {
          result.success = iface.downloadChunk(args.id);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class getNimbusConf<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getNimbusConf_args> {
      public getNimbusConf() {
        super("getNimbusConf");
      }

      public getNimbusConf_args getEmptyArgsInstance() {
        return new getNimbusConf_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getNimbusConf_result getResult(I iface, getNimbusConf_args args) throws org.apache.thrift.TException {
        getNimbusConf_result result = new getNimbusConf_result();
        try {
          result.success = iface.getNimbusConf();
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class getClusterInfo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getClusterInfo_args> {
      public getClusterInfo() {
        super("getClusterInfo");
      }

      public getClusterInfo_args getEmptyArgsInstance() {
        return new getClusterInfo_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getClusterInfo_result getResult(I iface, getClusterInfo_args args) throws org.apache.thrift.TException {
        getClusterInfo_result result = new getClusterInfo_result();
        try {
          result.success = iface.getClusterInfo();
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class getTopologyInfo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTopologyInfo_args> {
      public getTopologyInfo() {
        super("getTopologyInfo");
      }

      public getTopologyInfo_args getEmptyArgsInstance() {
        return new getTopologyInfo_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTopologyInfo_result getResult(I iface, getTopologyInfo_args args) throws org.apache.thrift.TException {
        getTopologyInfo_result result = new getTopologyInfo_result();
        try {
          result.success = iface.getTopologyInfo(args.id);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class getTopologyInfoWithOpts<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTopologyInfoWithOpts_args> {
      public getTopologyInfoWithOpts() {
        super("getTopologyInfoWithOpts");
      }

      public getTopologyInfoWithOpts_args getEmptyArgsInstance() {
        return new getTopologyInfoWithOpts_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTopologyInfoWithOpts_result getResult(I iface, getTopologyInfoWithOpts_args args) throws org.apache.thrift.TException {
        getTopologyInfoWithOpts_result result = new getTopologyInfoWithOpts_result();
        try {
          result.success = iface.getTopologyInfoWithOpts(args.id, args.options);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class getTopologyPageInfo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTopologyPageInfo_args> {
      public getTopologyPageInfo() {
        super("getTopologyPageInfo");
      }

      public getTopologyPageInfo_args getEmptyArgsInstance() {
        return new getTopologyPageInfo_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTopologyPageInfo_result getResult(I iface, getTopologyPageInfo_args args) throws org.apache.thrift.TException {
        getTopologyPageInfo_result result = new getTopologyPageInfo_result();
        try {
          result.success = iface.getTopologyPageInfo(args.id, args.window, args.is_include_sys);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class getComponentPageInfo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getComponentPageInfo_args> {
      public getComponentPageInfo() {
        super("getComponentPageInfo");
      }

      public getComponentPageInfo_args getEmptyArgsInstance() {
        return new getComponentPageInfo_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getComponentPageInfo_result getResult(I iface, getComponentPageInfo_args args) throws org.apache.thrift.TException {
        getComponentPageInfo_result result = new getComponentPageInfo_result();
        try {
          result.success = iface.getComponentPageInfo(args.topology_id, args.component_id, args.window, args.is_include_sys);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class getTopologyConf<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTopologyConf_args> {
      public getTopologyConf() {
        super("getTopologyConf");
      }

      public getTopologyConf_args getEmptyArgsInstance() {
        return new getTopologyConf_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTopologyConf_result getResult(I iface, getTopologyConf_args args) throws org.apache.thrift.TException {
        getTopologyConf_result result = new getTopologyConf_result();
        try {
          result.success = iface.getTopologyConf(args.id);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class getTopology<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTopology_args> {
      public getTopology() {
        super("getTopology");
      }

      public getTopology_args getEmptyArgsInstance() {
        return new getTopology_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTopology_result getResult(I iface, getTopology_args args) throws org.apache.thrift.TException {
        getTopology_result result = new getTopology_result();
        try {
          result.success = iface.getTopology(args.id);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class getUserTopology<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUserTopology_args> {
      public getUserTopology() {
        super("getUserTopology");
      }

      public getUserTopology_args getEmptyArgsInstance() {
        return new getUserTopology_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUserTopology_result getResult(I iface, getUserTopology_args args) throws org.apache.thrift.TException {
        getUserTopology_result result = new getUserTopology_result();
        try {
          result.success = iface.getUserTopology(args.id);
        } catch (NotAliveException e) {
          result.e = e;
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

    public static class getTopologyHistory<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTopologyHistory_args> {
      public getTopologyHistory() {
        super("getTopologyHistory");
      }

      public getTopologyHistory_args getEmptyArgsInstance() {
        return new getTopologyHistory_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTopologyHistory_result getResult(I iface, getTopologyHistory_args args) throws org.apache.thrift.TException {
        getTopologyHistory_result result = new getTopologyHistory_result();
        try {
          result.success = iface.getTopologyHistory(args.user);
        } catch (AuthorizationException aze) {
          result.aze = aze;
        }
        return result;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("submitTopology", new submitTopology());
      processMap.put("submitTopologyWithOpts", new submitTopologyWithOpts());
      processMap.put("killTopology", new killTopology());
      processMap.put("killTopologyWithOpts", new killTopologyWithOpts());
      processMap.put("activate", new activate());
      processMap.put("deactivate", new deactivate());
      processMap.put("rebalance", new rebalance());
      processMap.put("setLogConfig", new setLogConfig());
      processMap.put("getLogConfig", new getLogConfig());
      processMap.put("debug", new debug());
      processMap.put("setWorkerProfiler", new setWorkerProfiler());
      processMap.put("getComponentPendingProfileActions", new getComponentPendingProfileActions());
      processMap.put("uploadNewCredentials", new uploadNewCredentials());
      processMap.put("beginCreateBlob", new beginCreateBlob());
      processMap.put("beginUpdateBlob", new beginUpdateBlob());
      processMap.put("uploadBlobChunk", new uploadBlobChunk());
      processMap.put("finishBlobUpload", new finishBlobUpload());
      processMap.put("cancelBlobUpload", new cancelBlobUpload());
      processMap.put("getBlobMeta", new getBlobMeta());
      processMap.put("setBlobMeta", new setBlobMeta());
      processMap.put("beginBlobDownload", new beginBlobDownload());
      processMap.put("downloadBlobChunk", new downloadBlobChunk());
      processMap.put("deleteBlob", new deleteBlob());
      processMap.put("listBlobs", new listBlobs());
      processMap.put("getBlobReplication", new getBlobReplication());
      processMap.put("updateBlobReplication", new updateBlobReplication());
      processMap.put("createStateInZookeeper", new createStateInZookeeper());
      processMap.put("beginFileUpload", new beginFileUpload());
      processMap.put("uploadChunk", new uploadChunk());
      processMap.put("finishFileUpload", new finishFileUpload());
      processMap.put("beginFileDownload", new beginFileDownload());
      processMap.put("downloadChunk", new downloadChunk());
      processMap.put("getNimbusConf", new getNimbusConf());
      processMap.put("getClusterInfo", new getClusterInfo());
      processMap.put("getTopologyInfo", new getTopologyInfo());
      processMap.put("getTopologyInfoWithOpts", new getTopologyInfoWithOpts());
      processMap.put("getTopologyPageInfo", new getTopologyPageInfo());
      processMap.put("getComponentPageInfo", new getComponentPageInfo());
      processMap.put("getTopologyConf", new getTopologyConf());
      processMap.put("getTopology", new getTopology());
      processMap.put("getUserTopology", new getUserTopology());
      processMap.put("getTopologyHistory", new getTopologyHistory());
      return processMap;
    }

    public static class submitTopology<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, submitTopology_args, Void> {
      public submitTopology() {
        super("submitTopology");
      }

      public submitTopology_args getEmptyArgsInstance() {
        return new submitTopology_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            submitTopology_result result = new submitTopology_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            submitTopology_result result = new submitTopology_result();
            if (e instanceof AlreadyAliveException) {
                        result.e = (AlreadyAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof InvalidTopologyException) {
                        result.ite = (InvalidTopologyException) e;
                        result.set_ite_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, submitTopology_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.submitTopology(args.name, args.uploadedJarLocation, args.jsonConf, args.topology,resultHandler);
      }
    }

    public static class submitTopologyWithOpts<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, submitTopologyWithOpts_args, Void> {
      public submitTopologyWithOpts() {
        super("submitTopologyWithOpts");
      }

      public submitTopologyWithOpts_args getEmptyArgsInstance() {
        return new submitTopologyWithOpts_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            submitTopologyWithOpts_result result = new submitTopologyWithOpts_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            submitTopologyWithOpts_result result = new submitTopologyWithOpts_result();
            if (e instanceof AlreadyAliveException) {
                        result.e = (AlreadyAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof InvalidTopologyException) {
                        result.ite = (InvalidTopologyException) e;
                        result.set_ite_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, submitTopologyWithOpts_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.submitTopologyWithOpts(args.name, args.uploadedJarLocation, args.jsonConf, args.topology, args.options,resultHandler);
      }
    }

    public static class killTopology<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, killTopology_args, Void> {
      public killTopology() {
        super("killTopology");
      }

      public killTopology_args getEmptyArgsInstance() {
        return new killTopology_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            killTopology_result result = new killTopology_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            killTopology_result result = new killTopology_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, killTopology_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.killTopology(args.name,resultHandler);
      }
    }

    public static class killTopologyWithOpts<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, killTopologyWithOpts_args, Void> {
      public killTopologyWithOpts() {
        super("killTopologyWithOpts");
      }

      public killTopologyWithOpts_args getEmptyArgsInstance() {
        return new killTopologyWithOpts_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            killTopologyWithOpts_result result = new killTopologyWithOpts_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            killTopologyWithOpts_result result = new killTopologyWithOpts_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, killTopologyWithOpts_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.killTopologyWithOpts(args.name, args.options,resultHandler);
      }
    }

    public static class activate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, activate_args, Void> {
      public activate() {
        super("activate");
      }

      public activate_args getEmptyArgsInstance() {
        return new activate_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            activate_result result = new activate_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            activate_result result = new activate_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, activate_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.activate(args.name,resultHandler);
      }
    }

    public static class deactivate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deactivate_args, Void> {
      public deactivate() {
        super("deactivate");
      }

      public deactivate_args getEmptyArgsInstance() {
        return new deactivate_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deactivate_result result = new deactivate_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deactivate_result result = new deactivate_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deactivate_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.deactivate(args.name,resultHandler);
      }
    }

    public static class rebalance<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, rebalance_args, Void> {
      public rebalance() {
        super("rebalance");
      }

      public rebalance_args getEmptyArgsInstance() {
        return new rebalance_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            rebalance_result result = new rebalance_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            rebalance_result result = new rebalance_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof InvalidTopologyException) {
                        result.ite = (InvalidTopologyException) e;
                        result.set_ite_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, rebalance_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.rebalance(args.name, args.options,resultHandler);
      }
    }

    public static class setLogConfig<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, setLogConfig_args, Void> {
      public setLogConfig() {
        super("setLogConfig");
      }

      public setLogConfig_args getEmptyArgsInstance() {
        return new setLogConfig_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            setLogConfig_result result = new setLogConfig_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            setLogConfig_result result = new setLogConfig_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, setLogConfig_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.setLogConfig(args.name, args.config,resultHandler);
      }
    }

    public static class getLogConfig<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getLogConfig_args, LogConfig> {
      public getLogConfig() {
        super("getLogConfig");
      }

      public getLogConfig_args getEmptyArgsInstance() {
        return new getLogConfig_args();
      }

      public AsyncMethodCallback<LogConfig> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<LogConfig>() { 
          public void onComplete(LogConfig o) {
            getLogConfig_result result = new getLogConfig_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getLogConfig_result result = new getLogConfig_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getLogConfig_args args, org.apache.thrift.async.AsyncMethodCallback<LogConfig> resultHandler) throws TException {
        iface.getLogConfig(args.name,resultHandler);
      }
    }

    public static class debug<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, debug_args, Void> {
      public debug() {
        super("debug");
      }

      public debug_args getEmptyArgsInstance() {
        return new debug_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            debug_result result = new debug_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            debug_result result = new debug_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, debug_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.debug(args.name, args.component, args.enable, args.samplingPercentage,resultHandler);
      }
    }

    public static class setWorkerProfiler<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, setWorkerProfiler_args, Void> {
      public setWorkerProfiler() {
        super("setWorkerProfiler");
      }

      public setWorkerProfiler_args getEmptyArgsInstance() {
        return new setWorkerProfiler_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            setWorkerProfiler_result result = new setWorkerProfiler_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            setWorkerProfiler_result result = new setWorkerProfiler_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, setWorkerProfiler_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.setWorkerProfiler(args.id, args.profileRequest,resultHandler);
      }
    }

    public static class getComponentPendingProfileActions<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getComponentPendingProfileActions_args, List<ProfileRequest>> {
      public getComponentPendingProfileActions() {
        super("getComponentPendingProfileActions");
      }

      public getComponentPendingProfileActions_args getEmptyArgsInstance() {
        return new getComponentPendingProfileActions_args();
      }

      public AsyncMethodCallback<List<ProfileRequest>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<ProfileRequest>>() { 
          public void onComplete(List<ProfileRequest> o) {
            getComponentPendingProfileActions_result result = new getComponentPendingProfileActions_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getComponentPendingProfileActions_result result = new getComponentPendingProfileActions_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getComponentPendingProfileActions_args args, org.apache.thrift.async.AsyncMethodCallback<List<ProfileRequest>> resultHandler) throws TException {
        iface.getComponentPendingProfileActions(args.id, args.component_id, args.action,resultHandler);
      }
    }

    public static class uploadNewCredentials<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, uploadNewCredentials_args, Void> {
      public uploadNewCredentials() {
        super("uploadNewCredentials");
      }

      public uploadNewCredentials_args getEmptyArgsInstance() {
        return new uploadNewCredentials_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            uploadNewCredentials_result result = new uploadNewCredentials_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            uploadNewCredentials_result result = new uploadNewCredentials_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof InvalidTopologyException) {
                        result.ite = (InvalidTopologyException) e;
                        result.set_ite_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, uploadNewCredentials_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.uploadNewCredentials(args.name, args.creds,resultHandler);
      }
    }

    public static class beginCreateBlob<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, beginCreateBlob_args, String> {
      public beginCreateBlob() {
        super("beginCreateBlob");
      }

      public beginCreateBlob_args getEmptyArgsInstance() {
        return new beginCreateBlob_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            beginCreateBlob_result result = new beginCreateBlob_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            beginCreateBlob_result result = new beginCreateBlob_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
            else             if (e instanceof KeyAlreadyExistsException) {
                        result.kae = (KeyAlreadyExistsException) e;
                        result.set_kae_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, beginCreateBlob_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.beginCreateBlob(args.key, args.meta,resultHandler);
      }
    }

    public static class beginUpdateBlob<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, beginUpdateBlob_args, String> {
      public beginUpdateBlob() {
        super("beginUpdateBlob");
      }

      public beginUpdateBlob_args getEmptyArgsInstance() {
        return new beginUpdateBlob_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            beginUpdateBlob_result result = new beginUpdateBlob_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            beginUpdateBlob_result result = new beginUpdateBlob_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
            else             if (e instanceof KeyNotFoundException) {
                        result.knf = (KeyNotFoundException) e;
                        result.set_knf_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, beginUpdateBlob_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.beginUpdateBlob(args.key,resultHandler);
      }
    }

    public static class uploadBlobChunk<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, uploadBlobChunk_args, Void> {
      public uploadBlobChunk() {
        super("uploadBlobChunk");
      }

      public uploadBlobChunk_args getEmptyArgsInstance() {
        return new uploadBlobChunk_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            uploadBlobChunk_result result = new uploadBlobChunk_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            uploadBlobChunk_result result = new uploadBlobChunk_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, uploadBlobChunk_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.uploadBlobChunk(args.session, args.chunk,resultHandler);
      }
    }

    public static class finishBlobUpload<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, finishBlobUpload_args, Void> {
      public finishBlobUpload() {
        super("finishBlobUpload");
      }

      public finishBlobUpload_args getEmptyArgsInstance() {
        return new finishBlobUpload_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            finishBlobUpload_result result = new finishBlobUpload_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            finishBlobUpload_result result = new finishBlobUpload_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, finishBlobUpload_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.finishBlobUpload(args.session,resultHandler);
      }
    }

    public static class cancelBlobUpload<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, cancelBlobUpload_args, Void> {
      public cancelBlobUpload() {
        super("cancelBlobUpload");
      }

      public cancelBlobUpload_args getEmptyArgsInstance() {
        return new cancelBlobUpload_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            cancelBlobUpload_result result = new cancelBlobUpload_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            cancelBlobUpload_result result = new cancelBlobUpload_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, cancelBlobUpload_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.cancelBlobUpload(args.session,resultHandler);
      }
    }

    public static class getBlobMeta<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getBlobMeta_args, ReadableBlobMeta> {
      public getBlobMeta() {
        super("getBlobMeta");
      }

      public getBlobMeta_args getEmptyArgsInstance() {
        return new getBlobMeta_args();
      }

      public AsyncMethodCallback<ReadableBlobMeta> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ReadableBlobMeta>() { 
          public void onComplete(ReadableBlobMeta o) {
            getBlobMeta_result result = new getBlobMeta_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getBlobMeta_result result = new getBlobMeta_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
            else             if (e instanceof KeyNotFoundException) {
                        result.knf = (KeyNotFoundException) e;
                        result.set_knf_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getBlobMeta_args args, org.apache.thrift.async.AsyncMethodCallback<ReadableBlobMeta> resultHandler) throws TException {
        iface.getBlobMeta(args.key,resultHandler);
      }
    }

    public static class setBlobMeta<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, setBlobMeta_args, Void> {
      public setBlobMeta() {
        super("setBlobMeta");
      }

      public setBlobMeta_args getEmptyArgsInstance() {
        return new setBlobMeta_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            setBlobMeta_result result = new setBlobMeta_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            setBlobMeta_result result = new setBlobMeta_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
            else             if (e instanceof KeyNotFoundException) {
                        result.knf = (KeyNotFoundException) e;
                        result.set_knf_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, setBlobMeta_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.setBlobMeta(args.key, args.meta,resultHandler);
      }
    }

    public static class beginBlobDownload<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, beginBlobDownload_args, BeginDownloadResult> {
      public beginBlobDownload() {
        super("beginBlobDownload");
      }

      public beginBlobDownload_args getEmptyArgsInstance() {
        return new beginBlobDownload_args();
      }

      public AsyncMethodCallback<BeginDownloadResult> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<BeginDownloadResult>() { 
          public void onComplete(BeginDownloadResult o) {
            beginBlobDownload_result result = new beginBlobDownload_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            beginBlobDownload_result result = new beginBlobDownload_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
            else             if (e instanceof KeyNotFoundException) {
                        result.knf = (KeyNotFoundException) e;
                        result.set_knf_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, beginBlobDownload_args args, org.apache.thrift.async.AsyncMethodCallback<BeginDownloadResult> resultHandler) throws TException {
        iface.beginBlobDownload(args.key,resultHandler);
      }
    }

    public static class downloadBlobChunk<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, downloadBlobChunk_args, ByteBuffer> {
      public downloadBlobChunk() {
        super("downloadBlobChunk");
      }

      public downloadBlobChunk_args getEmptyArgsInstance() {
        return new downloadBlobChunk_args();
      }

      public AsyncMethodCallback<ByteBuffer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ByteBuffer>() { 
          public void onComplete(ByteBuffer o) {
            downloadBlobChunk_result result = new downloadBlobChunk_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            downloadBlobChunk_result result = new downloadBlobChunk_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, downloadBlobChunk_args args, org.apache.thrift.async.AsyncMethodCallback<ByteBuffer> resultHandler) throws TException {
        iface.downloadBlobChunk(args.session,resultHandler);
      }
    }

    public static class deleteBlob<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteBlob_args, Void> {
      public deleteBlob() {
        super("deleteBlob");
      }

      public deleteBlob_args getEmptyArgsInstance() {
        return new deleteBlob_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteBlob_result result = new deleteBlob_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteBlob_result result = new deleteBlob_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
            else             if (e instanceof KeyNotFoundException) {
                        result.knf = (KeyNotFoundException) e;
                        result.set_knf_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteBlob_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.deleteBlob(args.key,resultHandler);
      }
    }

    public static class listBlobs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, listBlobs_args, ListBlobsResult> {
      public listBlobs() {
        super("listBlobs");
      }

      public listBlobs_args getEmptyArgsInstance() {
        return new listBlobs_args();
      }

      public AsyncMethodCallback<ListBlobsResult> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ListBlobsResult>() { 
          public void onComplete(ListBlobsResult o) {
            listBlobs_result result = new listBlobs_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            listBlobs_result result = new listBlobs_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, listBlobs_args args, org.apache.thrift.async.AsyncMethodCallback<ListBlobsResult> resultHandler) throws TException {
        iface.listBlobs(args.session,resultHandler);
      }
    }

    public static class getBlobReplication<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getBlobReplication_args, Integer> {
      public getBlobReplication() {
        super("getBlobReplication");
      }

      public getBlobReplication_args getEmptyArgsInstance() {
        return new getBlobReplication_args();
      }

      public AsyncMethodCallback<Integer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Integer>() { 
          public void onComplete(Integer o) {
            getBlobReplication_result result = new getBlobReplication_result();
            result.success = o;
            result.set_success_isSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getBlobReplication_result result = new getBlobReplication_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
            else             if (e instanceof KeyNotFoundException) {
                        result.knf = (KeyNotFoundException) e;
                        result.set_knf_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getBlobReplication_args args, org.apache.thrift.async.AsyncMethodCallback<Integer> resultHandler) throws TException {
        iface.getBlobReplication(args.key,resultHandler);
      }
    }

    public static class updateBlobReplication<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateBlobReplication_args, Integer> {
      public updateBlobReplication() {
        super("updateBlobReplication");
      }

      public updateBlobReplication_args getEmptyArgsInstance() {
        return new updateBlobReplication_args();
      }

      public AsyncMethodCallback<Integer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Integer>() { 
          public void onComplete(Integer o) {
            updateBlobReplication_result result = new updateBlobReplication_result();
            result.success = o;
            result.set_success_isSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateBlobReplication_result result = new updateBlobReplication_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
            else             if (e instanceof KeyNotFoundException) {
                        result.knf = (KeyNotFoundException) e;
                        result.set_knf_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateBlobReplication_args args, org.apache.thrift.async.AsyncMethodCallback<Integer> resultHandler) throws TException {
        iface.updateBlobReplication(args.key, args.replication,resultHandler);
      }
    }

    public static class createStateInZookeeper<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createStateInZookeeper_args, Void> {
      public createStateInZookeeper() {
        super("createStateInZookeeper");
      }

      public createStateInZookeeper_args getEmptyArgsInstance() {
        return new createStateInZookeeper_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            createStateInZookeeper_result result = new createStateInZookeeper_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createStateInZookeeper_result result = new createStateInZookeeper_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createStateInZookeeper_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.createStateInZookeeper(args.key,resultHandler);
      }
    }

    public static class beginFileUpload<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, beginFileUpload_args, String> {
      public beginFileUpload() {
        super("beginFileUpload");
      }

      public beginFileUpload_args getEmptyArgsInstance() {
        return new beginFileUpload_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            beginFileUpload_result result = new beginFileUpload_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            beginFileUpload_result result = new beginFileUpload_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, beginFileUpload_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.beginFileUpload(resultHandler);
      }
    }

    public static class uploadChunk<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, uploadChunk_args, Void> {
      public uploadChunk() {
        super("uploadChunk");
      }

      public uploadChunk_args getEmptyArgsInstance() {
        return new uploadChunk_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            uploadChunk_result result = new uploadChunk_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            uploadChunk_result result = new uploadChunk_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, uploadChunk_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.uploadChunk(args.location, args.chunk,resultHandler);
      }
    }

    public static class finishFileUpload<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, finishFileUpload_args, Void> {
      public finishFileUpload() {
        super("finishFileUpload");
      }

      public finishFileUpload_args getEmptyArgsInstance() {
        return new finishFileUpload_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            finishFileUpload_result result = new finishFileUpload_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            finishFileUpload_result result = new finishFileUpload_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, finishFileUpload_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.finishFileUpload(args.location,resultHandler);
      }
    }

    public static class beginFileDownload<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, beginFileDownload_args, String> {
      public beginFileDownload() {
        super("beginFileDownload");
      }

      public beginFileDownload_args getEmptyArgsInstance() {
        return new beginFileDownload_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            beginFileDownload_result result = new beginFileDownload_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            beginFileDownload_result result = new beginFileDownload_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, beginFileDownload_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.beginFileDownload(args.file,resultHandler);
      }
    }

    public static class downloadChunk<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, downloadChunk_args, ByteBuffer> {
      public downloadChunk() {
        super("downloadChunk");
      }

      public downloadChunk_args getEmptyArgsInstance() {
        return new downloadChunk_args();
      }

      public AsyncMethodCallback<ByteBuffer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ByteBuffer>() { 
          public void onComplete(ByteBuffer o) {
            downloadChunk_result result = new downloadChunk_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            downloadChunk_result result = new downloadChunk_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, downloadChunk_args args, org.apache.thrift.async.AsyncMethodCallback<ByteBuffer> resultHandler) throws TException {
        iface.downloadChunk(args.id,resultHandler);
      }
    }

    public static class getNimbusConf<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getNimbusConf_args, String> {
      public getNimbusConf() {
        super("getNimbusConf");
      }

      public getNimbusConf_args getEmptyArgsInstance() {
        return new getNimbusConf_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            getNimbusConf_result result = new getNimbusConf_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getNimbusConf_result result = new getNimbusConf_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getNimbusConf_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.getNimbusConf(resultHandler);
      }
    }

    public static class getClusterInfo<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getClusterInfo_args, ClusterSummary> {
      public getClusterInfo() {
        super("getClusterInfo");
      }

      public getClusterInfo_args getEmptyArgsInstance() {
        return new getClusterInfo_args();
      }

      public AsyncMethodCallback<ClusterSummary> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ClusterSummary>() { 
          public void onComplete(ClusterSummary o) {
            getClusterInfo_result result = new getClusterInfo_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getClusterInfo_result result = new getClusterInfo_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getClusterInfo_args args, org.apache.thrift.async.AsyncMethodCallback<ClusterSummary> resultHandler) throws TException {
        iface.getClusterInfo(resultHandler);
      }
    }

    public static class getTopologyInfo<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTopologyInfo_args, TopologyInfo> {
      public getTopologyInfo() {
        super("getTopologyInfo");
      }

      public getTopologyInfo_args getEmptyArgsInstance() {
        return new getTopologyInfo_args();
      }

      public AsyncMethodCallback<TopologyInfo> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<TopologyInfo>() { 
          public void onComplete(TopologyInfo o) {
            getTopologyInfo_result result = new getTopologyInfo_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getTopologyInfo_result result = new getTopologyInfo_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTopologyInfo_args args, org.apache.thrift.async.AsyncMethodCallback<TopologyInfo> resultHandler) throws TException {
        iface.getTopologyInfo(args.id,resultHandler);
      }
    }

    public static class getTopologyInfoWithOpts<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTopologyInfoWithOpts_args, TopologyInfo> {
      public getTopologyInfoWithOpts() {
        super("getTopologyInfoWithOpts");
      }

      public getTopologyInfoWithOpts_args getEmptyArgsInstance() {
        return new getTopologyInfoWithOpts_args();
      }

      public AsyncMethodCallback<TopologyInfo> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<TopologyInfo>() { 
          public void onComplete(TopologyInfo o) {
            getTopologyInfoWithOpts_result result = new getTopologyInfoWithOpts_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getTopologyInfoWithOpts_result result = new getTopologyInfoWithOpts_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTopologyInfoWithOpts_args args, org.apache.thrift.async.AsyncMethodCallback<TopologyInfo> resultHandler) throws TException {
        iface.getTopologyInfoWithOpts(args.id, args.options,resultHandler);
      }
    }

    public static class getTopologyPageInfo<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTopologyPageInfo_args, TopologyPageInfo> {
      public getTopologyPageInfo() {
        super("getTopologyPageInfo");
      }

      public getTopologyPageInfo_args getEmptyArgsInstance() {
        return new getTopologyPageInfo_args();
      }

      public AsyncMethodCallback<TopologyPageInfo> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<TopologyPageInfo>() { 
          public void onComplete(TopologyPageInfo o) {
            getTopologyPageInfo_result result = new getTopologyPageInfo_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getTopologyPageInfo_result result = new getTopologyPageInfo_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTopologyPageInfo_args args, org.apache.thrift.async.AsyncMethodCallback<TopologyPageInfo> resultHandler) throws TException {
        iface.getTopologyPageInfo(args.id, args.window, args.is_include_sys,resultHandler);
      }
    }

    public static class getComponentPageInfo<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getComponentPageInfo_args, ComponentPageInfo> {
      public getComponentPageInfo() {
        super("getComponentPageInfo");
      }

      public getComponentPageInfo_args getEmptyArgsInstance() {
        return new getComponentPageInfo_args();
      }

      public AsyncMethodCallback<ComponentPageInfo> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ComponentPageInfo>() { 
          public void onComplete(ComponentPageInfo o) {
            getComponentPageInfo_result result = new getComponentPageInfo_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getComponentPageInfo_result result = new getComponentPageInfo_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getComponentPageInfo_args args, org.apache.thrift.async.AsyncMethodCallback<ComponentPageInfo> resultHandler) throws TException {
        iface.getComponentPageInfo(args.topology_id, args.component_id, args.window, args.is_include_sys,resultHandler);
      }
    }

    public static class getTopologyConf<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTopologyConf_args, String> {
      public getTopologyConf() {
        super("getTopologyConf");
      }

      public getTopologyConf_args getEmptyArgsInstance() {
        return new getTopologyConf_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            getTopologyConf_result result = new getTopologyConf_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getTopologyConf_result result = new getTopologyConf_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTopologyConf_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.getTopologyConf(args.id,resultHandler);
      }
    }

    public static class getTopology<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTopology_args, StormTopology> {
      public getTopology() {
        super("getTopology");
      }

      public getTopology_args getEmptyArgsInstance() {
        return new getTopology_args();
      }

      public AsyncMethodCallback<StormTopology> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<StormTopology>() { 
          public void onComplete(StormTopology o) {
            getTopology_result result = new getTopology_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getTopology_result result = new getTopology_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTopology_args args, org.apache.thrift.async.AsyncMethodCallback<StormTopology> resultHandler) throws TException {
        iface.getTopology(args.id,resultHandler);
      }
    }

    public static class getUserTopology<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getUserTopology_args, StormTopology> {
      public getUserTopology() {
        super("getUserTopology");
      }

      public getUserTopology_args getEmptyArgsInstance() {
        return new getUserTopology_args();
      }

      public AsyncMethodCallback<StormTopology> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<StormTopology>() { 
          public void onComplete(StormTopology o) {
            getUserTopology_result result = new getUserTopology_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getUserTopology_result result = new getUserTopology_result();
            if (e instanceof NotAliveException) {
                        result.e = (NotAliveException) e;
                        result.set_e_isSet(true);
                        msg = result;
            }
            else             if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getUserTopology_args args, org.apache.thrift.async.AsyncMethodCallback<StormTopology> resultHandler) throws TException {
        iface.getUserTopology(args.id,resultHandler);
      }
    }

    public static class getTopologyHistory<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTopologyHistory_args, TopologyHistoryInfo> {
      public getTopologyHistory() {
        super("getTopologyHistory");
      }

      public getTopologyHistory_args getEmptyArgsInstance() {
        return new getTopologyHistory_args();
      }

      public AsyncMethodCallback<TopologyHistoryInfo> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<TopologyHistoryInfo>() { 
          public void onComplete(TopologyHistoryInfo o) {
            getTopologyHistory_result result = new getTopologyHistory_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getTopologyHistory_result result = new getTopologyHistory_result();
            if (e instanceof AuthorizationException) {
                        result.aze = (AuthorizationException) e;
                        result.set_aze_isSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTopologyHistory_args args, org.apache.thrift.async.AsyncMethodCallback<TopologyHistoryInfo> resultHandler) throws TException {
        iface.getTopologyHistory(args.user,resultHandler);
      }
    }

  }

  public static class submitTopology_args implements org.apache.thrift.TBase<submitTopology_args, submitTopology_args._Fields>, java.io.Serializable, Cloneable, Comparable<submitTopology_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("submitTopology_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField UPLOADED_JAR_LOCATION_FIELD_DESC = new org.apache.thrift.protocol.TField("uploadedJarLocation", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField JSON_CONF_FIELD_DESC = new org.apache.thrift.protocol.TField("jsonConf", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField TOPOLOGY_FIELD_DESC = new org.apache.thrift.protocol.TField("topology", org.apache.thrift.protocol.TType.STRUCT, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new submitTopology_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new submitTopology_argsTupleSchemeFactory());
    }

    private String name; // required
    private String uploadedJarLocation; // required
    private String jsonConf; // required
    private StormTopology topology; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name"),
      UPLOADED_JAR_LOCATION((short)2, "uploadedJarLocation"),
      JSON_CONF((short)3, "jsonConf"),
      TOPOLOGY((short)4, "topology");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          case 2: // UPLOADED_JAR_LOCATION
            return UPLOADED_JAR_LOCATION;
          case 3: // JSON_CONF
            return JSON_CONF;
          case 4: // TOPOLOGY
            return TOPOLOGY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.UPLOADED_JAR_LOCATION, new org.apache.thrift.meta_data.FieldMetaData("uploadedJarLocation", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.JSON_CONF, new org.apache.thrift.meta_data.FieldMetaData("jsonConf", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.TOPOLOGY, new org.apache.thrift.meta_data.FieldMetaData("topology", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, StormTopology.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(submitTopology_args.class, metaDataMap);
    }

    public submitTopology_args() {
    }

    public submitTopology_args(
      String name,
      String uploadedJarLocation,
      String jsonConf,
      StormTopology topology)
    {
      this();
      this.name = name;
      this.uploadedJarLocation = uploadedJarLocation;
      this.jsonConf = jsonConf;
      this.topology = topology;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public submitTopology_args(submitTopology_args other) {
      if (other.is_set_name()) {
        this.name = other.name;
      }
      if (other.is_set_uploadedJarLocation()) {
        this.uploadedJarLocation = other.uploadedJarLocation;
      }
      if (other.is_set_jsonConf()) {
        this.jsonConf = other.jsonConf;
      }
      if (other.is_set_topology()) {
        this.topology = new StormTopology(other.topology);
      }
    }

    public submitTopology_args deepCopy() {
      return new submitTopology_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
      this.uploadedJarLocation = null;
      this.jsonConf = null;
      this.topology = null;
    }

    public String get_name() {
      return this.name;
    }

    public void set_name(String name) {
      this.name = name;
    }

    public void unset_name() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean is_set_name() {
      return this.name != null;
    }

    public void set_name_isSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public String get_uploadedJarLocation() {
      return this.uploadedJarLocation;
    }

    public void set_uploadedJarLocation(String uploadedJarLocation) {
      this.uploadedJarLocation = uploadedJarLocation;
    }

    public void unset_uploadedJarLocation() {
      this.uploadedJarLocation = null;
    }

    /** Returns true if field uploadedJarLocation is set (has been assigned a value) and false otherwise */
    public boolean is_set_uploadedJarLocation() {
      return this.uploadedJarLocation != null;
    }

    public void set_uploadedJarLocation_isSet(boolean value) {
      if (!value) {
        this.uploadedJarLocation = null;
      }
    }

    public String get_jsonConf() {
      return this.jsonConf;
    }

    public void set_jsonConf(String jsonConf) {
      this.jsonConf = jsonConf;
    }

    public void unset_jsonConf() {
      this.jsonConf = null;
    }

    /** Returns true if field jsonConf is set (has been assigned a value) and false otherwise */
    public boolean is_set_jsonConf() {
      return this.jsonConf != null;
    }

    public void set_jsonConf_isSet(boolean value) {
      if (!value) {
        this.jsonConf = null;
      }
    }

    public StormTopology get_topology() {
      return this.topology;
    }

    public void set_topology(StormTopology topology) {
      this.topology = topology;
    }

    public void unset_topology() {
      this.topology = null;
    }

    /** Returns true if field topology is set (has been assigned a value) and false otherwise */
    public boolean is_set_topology() {
      return this.topology != null;
    }

    public void set_topology_isSet(boolean value) {
      if (!value) {
        this.topology = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unset_name();
        } else {
          set_name((String)value);
        }
        break;

      case UPLOADED_JAR_LOCATION:
        if (value == null) {
          unset_uploadedJarLocation();
        } else {
          set_uploadedJarLocation((String)value);
        }
        break;

      case JSON_CONF:
        if (value == null) {
          unset_jsonConf();
        } else {
          set_jsonConf((String)value);
        }
        break;

      case TOPOLOGY:
        if (value == null) {
          unset_topology();
        } else {
          set_topology((StormTopology)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return get_name();

      case UPLOADED_JAR_LOCATION:
        return get_uploadedJarLocation();

      case JSON_CONF:
        return get_jsonConf();

      case TOPOLOGY:
        return get_topology();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return is_set_name();
      case UPLOADED_JAR_LOCATION:
        return is_set_uploadedJarLocation();
      case JSON_CONF:
        return is_set_jsonConf();
      case TOPOLOGY:
        return is_set_topology();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof submitTopology_args)
        return this.equals((submitTopology_args)that);
      return false;
    }

    public boolean equals(submitTopology_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.is_set_name();
      boolean that_present_name = true && that.is_set_name();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      boolean this_present_uploadedJarLocation = true && this.is_set_uploadedJarLocation();
      boolean that_present_uploadedJarLocation = true && that.is_set_uploadedJarLocation();
      if (this_present_uploadedJarLocation || that_present_uploadedJarLocation) {
        if (!(this_present_uploadedJarLocation && that_present_uploadedJarLocation))
          return false;
        if (!this.uploadedJarLocation.equals(that.uploadedJarLocation))
          return false;
      }

      boolean this_present_jsonConf = true && this.is_set_jsonConf();
      boolean that_present_jsonConf = true && that.is_set_jsonConf();
      if (this_present_jsonConf || that_present_jsonConf) {
        if (!(this_present_jsonConf && that_present_jsonConf))
          return false;
        if (!this.jsonConf.equals(that.jsonConf))
          return false;
      }

      boolean this_present_topology = true && this.is_set_topology();
      boolean that_present_topology = true && that.is_set_topology();
      if (this_present_topology || that_present_topology) {
        if (!(this_present_topology && that_present_topology))
          return false;
        if (!this.topology.equals(that.topology))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (is_set_name());
      list.add(present_name);
      if (present_name)
        list.add(name);

      boolean present_uploadedJarLocation = true && (is_set_uploadedJarLocation());
      list.add(present_uploadedJarLocation);
      if (present_uploadedJarLocation)
        list.add(uploadedJarLocation);

      boolean present_jsonConf = true && (is_set_jsonConf());
      list.add(present_jsonConf);
      if (present_jsonConf)
        list.add(jsonConf);

      boolean present_topology = true && (is_set_topology());
      list.add(present_topology);
      if (present_topology)
        list.add(topology);

      return list.hashCode();
    }

    @Override
    public int compareTo(submitTopology_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_name()).compareTo(other.is_set_name());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_name()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_uploadedJarLocation()).compareTo(other.is_set_uploadedJarLocation());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_uploadedJarLocation()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.uploadedJarLocation, other.uploadedJarLocation);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_jsonConf()).compareTo(other.is_set_jsonConf());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_jsonConf()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jsonConf, other.jsonConf);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_topology()).compareTo(other.is_set_topology());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_topology()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.topology, other.topology);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("submitTopology_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("uploadedJarLocation:");
      if (this.uploadedJarLocation == null) {
        sb.append("null");
      } else {
        sb.append(this.uploadedJarLocation);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jsonConf:");
      if (this.jsonConf == null) {
        sb.append("null");
      } else {
        sb.append(this.jsonConf);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("topology:");
      if (this.topology == null) {
        sb.append("null");
      } else {
        sb.append(this.topology);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (topology != null) {
        topology.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class submitTopology_argsStandardSchemeFactory implements SchemeFactory {
      public submitTopology_argsStandardScheme getScheme() {
        return new submitTopology_argsStandardScheme();
      }
    }

    private static class submitTopology_argsStandardScheme extends StandardScheme<submitTopology_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, submitTopology_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.set_name_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // UPLOADED_JAR_LOCATION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.uploadedJarLocation = iprot.readString();
                struct.set_uploadedJarLocation_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // JSON_CONF
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.jsonConf = iprot.readString();
                struct.set_jsonConf_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TOPOLOGY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.topology = new StormTopology();
                struct.topology.read(iprot);
                struct.set_topology_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, submitTopology_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.uploadedJarLocation != null) {
          oprot.writeFieldBegin(UPLOADED_JAR_LOCATION_FIELD_DESC);
          oprot.writeString(struct.uploadedJarLocation);
          oprot.writeFieldEnd();
        }
        if (struct.jsonConf != null) {
          oprot.writeFieldBegin(JSON_CONF_FIELD_DESC);
          oprot.writeString(struct.jsonConf);
          oprot.writeFieldEnd();
        }
        if (struct.topology != null) {
          oprot.writeFieldBegin(TOPOLOGY_FIELD_DESC);
          struct.topology.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class submitTopology_argsTupleSchemeFactory implements SchemeFactory {
      public submitTopology_argsTupleScheme getScheme() {
        return new submitTopology_argsTupleScheme();
      }
    }

    private static class submitTopology_argsTupleScheme extends TupleScheme<submitTopology_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, submitTopology_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_name()) {
          optionals.set(0);
        }
        if (struct.is_set_uploadedJarLocation()) {
          optionals.set(1);
        }
        if (struct.is_set_jsonConf()) {
          optionals.set(2);
        }
        if (struct.is_set_topology()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.is_set_name()) {
          oprot.writeString(struct.name);
        }
        if (struct.is_set_uploadedJarLocation()) {
          oprot.writeString(struct.uploadedJarLocation);
        }
        if (struct.is_set_jsonConf()) {
          oprot.writeString(struct.jsonConf);
        }
        if (struct.is_set_topology()) {
          struct.topology.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, submitTopology_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.set_name_isSet(true);
        }
        if (incoming.get(1)) {
          struct.uploadedJarLocation = iprot.readString();
          struct.set_uploadedJarLocation_isSet(true);
        }
        if (incoming.get(2)) {
          struct.jsonConf = iprot.readString();
          struct.set_jsonConf_isSet(true);
        }
        if (incoming.get(3)) {
          struct.topology = new StormTopology();
          struct.topology.read(iprot);
          struct.set_topology_isSet(true);
        }
      }
    }

  }

  public static class submitTopology_result implements org.apache.thrift.TBase<submitTopology_result, submitTopology_result._Fields>, java.io.Serializable, Cloneable, Comparable<submitTopology_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("submitTopology_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField ITE_FIELD_DESC = new org.apache.thrift.protocol.TField("ite", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new submitTopology_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new submitTopology_resultTupleSchemeFactory());
    }

    private AlreadyAliveException e; // required
    private InvalidTopologyException ite; // required
    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e"),
      ITE((short)2, "ite"),
      AZE((short)3, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          case 2: // ITE
            return ITE;
          case 3: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.ITE, new org.apache.thrift.meta_data.FieldMetaData("ite", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(submitTopology_result.class, metaDataMap);
    }

    public submitTopology_result() {
    }

    public submitTopology_result(
      AlreadyAliveException e,
      InvalidTopologyException ite,
      AuthorizationException aze)
    {
      this();
      this.e = e;
      this.ite = ite;
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public submitTopology_result(submitTopology_result other) {
      if (other.is_set_e()) {
        this.e = new AlreadyAliveException(other.e);
      }
      if (other.is_set_ite()) {
        this.ite = new InvalidTopologyException(other.ite);
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public submitTopology_result deepCopy() {
      return new submitTopology_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
      this.ite = null;
      this.aze = null;
    }

    public AlreadyAliveException get_e() {
      return this.e;
    }

    public void set_e(AlreadyAliveException e) {
      this.e = e;
    }

    public void unset_e() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean is_set_e() {
      return this.e != null;
    }

    public void set_e_isSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public InvalidTopologyException get_ite() {
      return this.ite;
    }

    public void set_ite(InvalidTopologyException ite) {
      this.ite = ite;
    }

    public void unset_ite() {
      this.ite = null;
    }

    /** Returns true if field ite is set (has been assigned a value) and false otherwise */
    public boolean is_set_ite() {
      return this.ite != null;
    }

    public void set_ite_isSet(boolean value) {
      if (!value) {
        this.ite = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unset_e();
        } else {
          set_e((AlreadyAliveException)value);
        }
        break;

      case ITE:
        if (value == null) {
          unset_ite();
        } else {
          set_ite((InvalidTopologyException)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return get_e();

      case ITE:
        return get_ite();

      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return is_set_e();
      case ITE:
        return is_set_ite();
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof submitTopology_result)
        return this.equals((submitTopology_result)that);
      return false;
    }

    public boolean equals(submitTopology_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.is_set_e();
      boolean that_present_e = true && that.is_set_e();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      boolean this_present_ite = true && this.is_set_ite();
      boolean that_present_ite = true && that.is_set_ite();
      if (this_present_ite || that_present_ite) {
        if (!(this_present_ite && that_present_ite))
          return false;
        if (!this.ite.equals(that.ite))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_e = true && (is_set_e());
      list.add(present_e);
      if (present_e)
        list.add(e);

      boolean present_ite = true && (is_set_ite());
      list.add(present_ite);
      if (present_ite)
        list.add(ite);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(submitTopology_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_e()).compareTo(other.is_set_e());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_e()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_ite()).compareTo(other.is_set_ite());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_ite()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ite, other.ite);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("submitTopology_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ite:");
      if (this.ite == null) {
        sb.append("null");
      } else {
        sb.append(this.ite);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class submitTopology_resultStandardSchemeFactory implements SchemeFactory {
      public submitTopology_resultStandardScheme getScheme() {
        return new submitTopology_resultStandardScheme();
      }
    }

    private static class submitTopology_resultStandardScheme extends StandardScheme<submitTopology_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, submitTopology_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new AlreadyAliveException();
                struct.e.read(iprot);
                struct.set_e_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ITE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ite = new InvalidTopologyException();
                struct.ite.read(iprot);
                struct.set_ite_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, submitTopology_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ite != null) {
          oprot.writeFieldBegin(ITE_FIELD_DESC);
          struct.ite.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class submitTopology_resultTupleSchemeFactory implements SchemeFactory {
      public submitTopology_resultTupleScheme getScheme() {
        return new submitTopology_resultTupleScheme();
      }
    }

    private static class submitTopology_resultTupleScheme extends TupleScheme<submitTopology_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, submitTopology_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_e()) {
          optionals.set(0);
        }
        if (struct.is_set_ite()) {
          optionals.set(1);
        }
        if (struct.is_set_aze()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.is_set_e()) {
          struct.e.write(oprot);
        }
        if (struct.is_set_ite()) {
          struct.ite.write(oprot);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, submitTopology_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.e = new AlreadyAliveException();
          struct.e.read(iprot);
          struct.set_e_isSet(true);
        }
        if (incoming.get(1)) {
          struct.ite = new InvalidTopologyException();
          struct.ite.read(iprot);
          struct.set_ite_isSet(true);
        }
        if (incoming.get(2)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class submitTopologyWithOpts_args implements org.apache.thrift.TBase<submitTopologyWithOpts_args, submitTopologyWithOpts_args._Fields>, java.io.Serializable, Cloneable, Comparable<submitTopologyWithOpts_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("submitTopologyWithOpts_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField UPLOADED_JAR_LOCATION_FIELD_DESC = new org.apache.thrift.protocol.TField("uploadedJarLocation", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField JSON_CONF_FIELD_DESC = new org.apache.thrift.protocol.TField("jsonConf", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField TOPOLOGY_FIELD_DESC = new org.apache.thrift.protocol.TField("topology", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField OPTIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("options", org.apache.thrift.protocol.TType.STRUCT, (short)5);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new submitTopologyWithOpts_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new submitTopologyWithOpts_argsTupleSchemeFactory());
    }

    private String name; // required
    private String uploadedJarLocation; // required
    private String jsonConf; // required
    private StormTopology topology; // required
    private SubmitOptions options; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name"),
      UPLOADED_JAR_LOCATION((short)2, "uploadedJarLocation"),
      JSON_CONF((short)3, "jsonConf"),
      TOPOLOGY((short)4, "topology"),
      OPTIONS((short)5, "options");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          case 2: // UPLOADED_JAR_LOCATION
            return UPLOADED_JAR_LOCATION;
          case 3: // JSON_CONF
            return JSON_CONF;
          case 4: // TOPOLOGY
            return TOPOLOGY;
          case 5: // OPTIONS
            return OPTIONS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.UPLOADED_JAR_LOCATION, new org.apache.thrift.meta_data.FieldMetaData("uploadedJarLocation", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.JSON_CONF, new org.apache.thrift.meta_data.FieldMetaData("jsonConf", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.TOPOLOGY, new org.apache.thrift.meta_data.FieldMetaData("topology", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, StormTopology.class)));
      tmpMap.put(_Fields.OPTIONS, new org.apache.thrift.meta_data.FieldMetaData("options", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, SubmitOptions.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(submitTopologyWithOpts_args.class, metaDataMap);
    }

    public submitTopologyWithOpts_args() {
    }

    public submitTopologyWithOpts_args(
      String name,
      String uploadedJarLocation,
      String jsonConf,
      StormTopology topology,
      SubmitOptions options)
    {
      this();
      this.name = name;
      this.uploadedJarLocation = uploadedJarLocation;
      this.jsonConf = jsonConf;
      this.topology = topology;
      this.options = options;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public submitTopologyWithOpts_args(submitTopologyWithOpts_args other) {
      if (other.is_set_name()) {
        this.name = other.name;
      }
      if (other.is_set_uploadedJarLocation()) {
        this.uploadedJarLocation = other.uploadedJarLocation;
      }
      if (other.is_set_jsonConf()) {
        this.jsonConf = other.jsonConf;
      }
      if (other.is_set_topology()) {
        this.topology = new StormTopology(other.topology);
      }
      if (other.is_set_options()) {
        this.options = new SubmitOptions(other.options);
      }
    }

    public submitTopologyWithOpts_args deepCopy() {
      return new submitTopologyWithOpts_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
      this.uploadedJarLocation = null;
      this.jsonConf = null;
      this.topology = null;
      this.options = null;
    }

    public String get_name() {
      return this.name;
    }

    public void set_name(String name) {
      this.name = name;
    }

    public void unset_name() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean is_set_name() {
      return this.name != null;
    }

    public void set_name_isSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public String get_uploadedJarLocation() {
      return this.uploadedJarLocation;
    }

    public void set_uploadedJarLocation(String uploadedJarLocation) {
      this.uploadedJarLocation = uploadedJarLocation;
    }

    public void unset_uploadedJarLocation() {
      this.uploadedJarLocation = null;
    }

    /** Returns true if field uploadedJarLocation is set (has been assigned a value) and false otherwise */
    public boolean is_set_uploadedJarLocation() {
      return this.uploadedJarLocation != null;
    }

    public void set_uploadedJarLocation_isSet(boolean value) {
      if (!value) {
        this.uploadedJarLocation = null;
      }
    }

    public String get_jsonConf() {
      return this.jsonConf;
    }

    public void set_jsonConf(String jsonConf) {
      this.jsonConf = jsonConf;
    }

    public void unset_jsonConf() {
      this.jsonConf = null;
    }

    /** Returns true if field jsonConf is set (has been assigned a value) and false otherwise */
    public boolean is_set_jsonConf() {
      return this.jsonConf != null;
    }

    public void set_jsonConf_isSet(boolean value) {
      if (!value) {
        this.jsonConf = null;
      }
    }

    public StormTopology get_topology() {
      return this.topology;
    }

    public void set_topology(StormTopology topology) {
      this.topology = topology;
    }

    public void unset_topology() {
      this.topology = null;
    }

    /** Returns true if field topology is set (has been assigned a value) and false otherwise */
    public boolean is_set_topology() {
      return this.topology != null;
    }

    public void set_topology_isSet(boolean value) {
      if (!value) {
        this.topology = null;
      }
    }

    public SubmitOptions get_options() {
      return this.options;
    }

    public void set_options(SubmitOptions options) {
      this.options = options;
    }

    public void unset_options() {
      this.options = null;
    }

    /** Returns true if field options is set (has been assigned a value) and false otherwise */
    public boolean is_set_options() {
      return this.options != null;
    }

    public void set_options_isSet(boolean value) {
      if (!value) {
        this.options = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unset_name();
        } else {
          set_name((String)value);
        }
        break;

      case UPLOADED_JAR_LOCATION:
        if (value == null) {
          unset_uploadedJarLocation();
        } else {
          set_uploadedJarLocation((String)value);
        }
        break;

      case JSON_CONF:
        if (value == null) {
          unset_jsonConf();
        } else {
          set_jsonConf((String)value);
        }
        break;

      case TOPOLOGY:
        if (value == null) {
          unset_topology();
        } else {
          set_topology((StormTopology)value);
        }
        break;

      case OPTIONS:
        if (value == null) {
          unset_options();
        } else {
          set_options((SubmitOptions)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return get_name();

      case UPLOADED_JAR_LOCATION:
        return get_uploadedJarLocation();

      case JSON_CONF:
        return get_jsonConf();

      case TOPOLOGY:
        return get_topology();

      case OPTIONS:
        return get_options();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return is_set_name();
      case UPLOADED_JAR_LOCATION:
        return is_set_uploadedJarLocation();
      case JSON_CONF:
        return is_set_jsonConf();
      case TOPOLOGY:
        return is_set_topology();
      case OPTIONS:
        return is_set_options();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof submitTopologyWithOpts_args)
        return this.equals((submitTopologyWithOpts_args)that);
      return false;
    }

    public boolean equals(submitTopologyWithOpts_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.is_set_name();
      boolean that_present_name = true && that.is_set_name();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      boolean this_present_uploadedJarLocation = true && this.is_set_uploadedJarLocation();
      boolean that_present_uploadedJarLocation = true && that.is_set_uploadedJarLocation();
      if (this_present_uploadedJarLocation || that_present_uploadedJarLocation) {
        if (!(this_present_uploadedJarLocation && that_present_uploadedJarLocation))
          return false;
        if (!this.uploadedJarLocation.equals(that.uploadedJarLocation))
          return false;
      }

      boolean this_present_jsonConf = true && this.is_set_jsonConf();
      boolean that_present_jsonConf = true && that.is_set_jsonConf();
      if (this_present_jsonConf || that_present_jsonConf) {
        if (!(this_present_jsonConf && that_present_jsonConf))
          return false;
        if (!this.jsonConf.equals(that.jsonConf))
          return false;
      }

      boolean this_present_topology = true && this.is_set_topology();
      boolean that_present_topology = true && that.is_set_topology();
      if (this_present_topology || that_present_topology) {
        if (!(this_present_topology && that_present_topology))
          return false;
        if (!this.topology.equals(that.topology))
          return false;
      }

      boolean this_present_options = true && this.is_set_options();
      boolean that_present_options = true && that.is_set_options();
      if (this_present_options || that_present_options) {
        if (!(this_present_options && that_present_options))
          return false;
        if (!this.options.equals(that.options))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (is_set_name());
      list.add(present_name);
      if (present_name)
        list.add(name);

      boolean present_uploadedJarLocation = true && (is_set_uploadedJarLocation());
      list.add(present_uploadedJarLocation);
      if (present_uploadedJarLocation)
        list.add(uploadedJarLocation);

      boolean present_jsonConf = true && (is_set_jsonConf());
      list.add(present_jsonConf);
      if (present_jsonConf)
        list.add(jsonConf);

      boolean present_topology = true && (is_set_topology());
      list.add(present_topology);
      if (present_topology)
        list.add(topology);

      boolean present_options = true && (is_set_options());
      list.add(present_options);
      if (present_options)
        list.add(options);

      return list.hashCode();
    }

    @Override
    public int compareTo(submitTopologyWithOpts_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_name()).compareTo(other.is_set_name());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_name()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_uploadedJarLocation()).compareTo(other.is_set_uploadedJarLocation());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_uploadedJarLocation()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.uploadedJarLocation, other.uploadedJarLocation);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_jsonConf()).compareTo(other.is_set_jsonConf());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_jsonConf()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jsonConf, other.jsonConf);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_topology()).compareTo(other.is_set_topology());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_topology()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.topology, other.topology);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_options()).compareTo(other.is_set_options());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_options()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.options, other.options);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("submitTopologyWithOpts_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("uploadedJarLocation:");
      if (this.uploadedJarLocation == null) {
        sb.append("null");
      } else {
        sb.append(this.uploadedJarLocation);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jsonConf:");
      if (this.jsonConf == null) {
        sb.append("null");
      } else {
        sb.append(this.jsonConf);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("topology:");
      if (this.topology == null) {
        sb.append("null");
      } else {
        sb.append(this.topology);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("options:");
      if (this.options == null) {
        sb.append("null");
      } else {
        sb.append(this.options);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (topology != null) {
        topology.validate();
      }
      if (options != null) {
        options.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class submitTopologyWithOpts_argsStandardSchemeFactory implements SchemeFactory {
      public submitTopologyWithOpts_argsStandardScheme getScheme() {
        return new submitTopologyWithOpts_argsStandardScheme();
      }
    }

    private static class submitTopologyWithOpts_argsStandardScheme extends StandardScheme<submitTopologyWithOpts_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, submitTopologyWithOpts_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.set_name_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // UPLOADED_JAR_LOCATION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.uploadedJarLocation = iprot.readString();
                struct.set_uploadedJarLocation_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // JSON_CONF
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.jsonConf = iprot.readString();
                struct.set_jsonConf_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TOPOLOGY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.topology = new StormTopology();
                struct.topology.read(iprot);
                struct.set_topology_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // OPTIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.options = new SubmitOptions();
                struct.options.read(iprot);
                struct.set_options_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, submitTopologyWithOpts_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.uploadedJarLocation != null) {
          oprot.writeFieldBegin(UPLOADED_JAR_LOCATION_FIELD_DESC);
          oprot.writeString(struct.uploadedJarLocation);
          oprot.writeFieldEnd();
        }
        if (struct.jsonConf != null) {
          oprot.writeFieldBegin(JSON_CONF_FIELD_DESC);
          oprot.writeString(struct.jsonConf);
          oprot.writeFieldEnd();
        }
        if (struct.topology != null) {
          oprot.writeFieldBegin(TOPOLOGY_FIELD_DESC);
          struct.topology.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.options != null) {
          oprot.writeFieldBegin(OPTIONS_FIELD_DESC);
          struct.options.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class submitTopologyWithOpts_argsTupleSchemeFactory implements SchemeFactory {
      public submitTopologyWithOpts_argsTupleScheme getScheme() {
        return new submitTopologyWithOpts_argsTupleScheme();
      }
    }

    private static class submitTopologyWithOpts_argsTupleScheme extends TupleScheme<submitTopologyWithOpts_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, submitTopologyWithOpts_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_name()) {
          optionals.set(0);
        }
        if (struct.is_set_uploadedJarLocation()) {
          optionals.set(1);
        }
        if (struct.is_set_jsonConf()) {
          optionals.set(2);
        }
        if (struct.is_set_topology()) {
          optionals.set(3);
        }
        if (struct.is_set_options()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.is_set_name()) {
          oprot.writeString(struct.name);
        }
        if (struct.is_set_uploadedJarLocation()) {
          oprot.writeString(struct.uploadedJarLocation);
        }
        if (struct.is_set_jsonConf()) {
          oprot.writeString(struct.jsonConf);
        }
        if (struct.is_set_topology()) {
          struct.topology.write(oprot);
        }
        if (struct.is_set_options()) {
          struct.options.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, submitTopologyWithOpts_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.set_name_isSet(true);
        }
        if (incoming.get(1)) {
          struct.uploadedJarLocation = iprot.readString();
          struct.set_uploadedJarLocation_isSet(true);
        }
        if (incoming.get(2)) {
          struct.jsonConf = iprot.readString();
          struct.set_jsonConf_isSet(true);
        }
        if (incoming.get(3)) {
          struct.topology = new StormTopology();
          struct.topology.read(iprot);
          struct.set_topology_isSet(true);
        }
        if (incoming.get(4)) {
          struct.options = new SubmitOptions();
          struct.options.read(iprot);
          struct.set_options_isSet(true);
        }
      }
    }

  }

  public static class submitTopologyWithOpts_result implements org.apache.thrift.TBase<submitTopologyWithOpts_result, submitTopologyWithOpts_result._Fields>, java.io.Serializable, Cloneable, Comparable<submitTopologyWithOpts_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("submitTopologyWithOpts_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField ITE_FIELD_DESC = new org.apache.thrift.protocol.TField("ite", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new submitTopologyWithOpts_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new submitTopologyWithOpts_resultTupleSchemeFactory());
    }

    private AlreadyAliveException e; // required
    private InvalidTopologyException ite; // required
    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e"),
      ITE((short)2, "ite"),
      AZE((short)3, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          case 2: // ITE
            return ITE;
          case 3: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.ITE, new org.apache.thrift.meta_data.FieldMetaData("ite", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(submitTopologyWithOpts_result.class, metaDataMap);
    }

    public submitTopologyWithOpts_result() {
    }

    public submitTopologyWithOpts_result(
      AlreadyAliveException e,
      InvalidTopologyException ite,
      AuthorizationException aze)
    {
      this();
      this.e = e;
      this.ite = ite;
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public submitTopologyWithOpts_result(submitTopologyWithOpts_result other) {
      if (other.is_set_e()) {
        this.e = new AlreadyAliveException(other.e);
      }
      if (other.is_set_ite()) {
        this.ite = new InvalidTopologyException(other.ite);
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public submitTopologyWithOpts_result deepCopy() {
      return new submitTopologyWithOpts_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
      this.ite = null;
      this.aze = null;
    }

    public AlreadyAliveException get_e() {
      return this.e;
    }

    public void set_e(AlreadyAliveException e) {
      this.e = e;
    }

    public void unset_e() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean is_set_e() {
      return this.e != null;
    }

    public void set_e_isSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public InvalidTopologyException get_ite() {
      return this.ite;
    }

    public void set_ite(InvalidTopologyException ite) {
      this.ite = ite;
    }

    public void unset_ite() {
      this.ite = null;
    }

    /** Returns true if field ite is set (has been assigned a value) and false otherwise */
    public boolean is_set_ite() {
      return this.ite != null;
    }

    public void set_ite_isSet(boolean value) {
      if (!value) {
        this.ite = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unset_e();
        } else {
          set_e((AlreadyAliveException)value);
        }
        break;

      case ITE:
        if (value == null) {
          unset_ite();
        } else {
          set_ite((InvalidTopologyException)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return get_e();

      case ITE:
        return get_ite();

      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return is_set_e();
      case ITE:
        return is_set_ite();
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof submitTopologyWithOpts_result)
        return this.equals((submitTopologyWithOpts_result)that);
      return false;
    }

    public boolean equals(submitTopologyWithOpts_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.is_set_e();
      boolean that_present_e = true && that.is_set_e();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      boolean this_present_ite = true && this.is_set_ite();
      boolean that_present_ite = true && that.is_set_ite();
      if (this_present_ite || that_present_ite) {
        if (!(this_present_ite && that_present_ite))
          return false;
        if (!this.ite.equals(that.ite))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_e = true && (is_set_e());
      list.add(present_e);
      if (present_e)
        list.add(e);

      boolean present_ite = true && (is_set_ite());
      list.add(present_ite);
      if (present_ite)
        list.add(ite);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(submitTopologyWithOpts_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_e()).compareTo(other.is_set_e());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_e()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_ite()).compareTo(other.is_set_ite());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_ite()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ite, other.ite);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("submitTopologyWithOpts_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ite:");
      if (this.ite == null) {
        sb.append("null");
      } else {
        sb.append(this.ite);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class submitTopologyWithOpts_resultStandardSchemeFactory implements SchemeFactory {
      public submitTopologyWithOpts_resultStandardScheme getScheme() {
        return new submitTopologyWithOpts_resultStandardScheme();
      }
    }

    private static class submitTopologyWithOpts_resultStandardScheme extends StandardScheme<submitTopologyWithOpts_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, submitTopologyWithOpts_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new AlreadyAliveException();
                struct.e.read(iprot);
                struct.set_e_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ITE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ite = new InvalidTopologyException();
                struct.ite.read(iprot);
                struct.set_ite_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, submitTopologyWithOpts_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ite != null) {
          oprot.writeFieldBegin(ITE_FIELD_DESC);
          struct.ite.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class submitTopologyWithOpts_resultTupleSchemeFactory implements SchemeFactory {
      public submitTopologyWithOpts_resultTupleScheme getScheme() {
        return new submitTopologyWithOpts_resultTupleScheme();
      }
    }

    private static class submitTopologyWithOpts_resultTupleScheme extends TupleScheme<submitTopologyWithOpts_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, submitTopologyWithOpts_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_e()) {
          optionals.set(0);
        }
        if (struct.is_set_ite()) {
          optionals.set(1);
        }
        if (struct.is_set_aze()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.is_set_e()) {
          struct.e.write(oprot);
        }
        if (struct.is_set_ite()) {
          struct.ite.write(oprot);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, submitTopologyWithOpts_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.e = new AlreadyAliveException();
          struct.e.read(iprot);
          struct.set_e_isSet(true);
        }
        if (incoming.get(1)) {
          struct.ite = new InvalidTopologyException();
          struct.ite.read(iprot);
          struct.set_ite_isSet(true);
        }
        if (incoming.get(2)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class killTopology_args implements org.apache.thrift.TBase<killTopology_args, killTopology_args._Fields>, java.io.Serializable, Cloneable, Comparable<killTopology_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("killTopology_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new killTopology_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new killTopology_argsTupleSchemeFactory());
    }

    private String name; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(killTopology_args.class, metaDataMap);
    }

    public killTopology_args() {
    }

    public killTopology_args(
      String name)
    {
      this();
      this.name = name;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public killTopology_args(killTopology_args other) {
      if (other.is_set_name()) {
        this.name = other.name;
      }
    }

    public killTopology_args deepCopy() {
      return new killTopology_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
    }

    public String get_name() {
      return this.name;
    }

    public void set_name(String name) {
      this.name = name;
    }

    public void unset_name() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean is_set_name() {
      return this.name != null;
    }

    public void set_name_isSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unset_name();
        } else {
          set_name((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return get_name();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return is_set_name();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof killTopology_args)
        return this.equals((killTopology_args)that);
      return false;
    }

    public boolean equals(killTopology_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.is_set_name();
      boolean that_present_name = true && that.is_set_name();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (is_set_name());
      list.add(present_name);
      if (present_name)
        list.add(name);

      return list.hashCode();
    }

    @Override
    public int compareTo(killTopology_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_name()).compareTo(other.is_set_name());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_name()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("killTopology_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class killTopology_argsStandardSchemeFactory implements SchemeFactory {
      public killTopology_argsStandardScheme getScheme() {
        return new killTopology_argsStandardScheme();
      }
    }

    private static class killTopology_argsStandardScheme extends StandardScheme<killTopology_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, killTopology_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.set_name_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, killTopology_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class killTopology_argsTupleSchemeFactory implements SchemeFactory {
      public killTopology_argsTupleScheme getScheme() {
        return new killTopology_argsTupleScheme();
      }
    }

    private static class killTopology_argsTupleScheme extends TupleScheme<killTopology_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, killTopology_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_name()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_name()) {
          oprot.writeString(struct.name);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, killTopology_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.set_name_isSet(true);
        }
      }
    }

  }

  public static class killTopology_result implements org.apache.thrift.TBase<killTopology_result, killTopology_result._Fields>, java.io.Serializable, Cloneable, Comparable<killTopology_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("killTopology_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new killTopology_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new killTopology_resultTupleSchemeFactory());
    }

    private NotAliveException e; // required
    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e"),
      AZE((short)2, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          case 2: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(killTopology_result.class, metaDataMap);
    }

    public killTopology_result() {
    }

    public killTopology_result(
      NotAliveException e,
      AuthorizationException aze)
    {
      this();
      this.e = e;
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public killTopology_result(killTopology_result other) {
      if (other.is_set_e()) {
        this.e = new NotAliveException(other.e);
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public killTopology_result deepCopy() {
      return new killTopology_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
      this.aze = null;
    }

    public NotAliveException get_e() {
      return this.e;
    }

    public void set_e(NotAliveException e) {
      this.e = e;
    }

    public void unset_e() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean is_set_e() {
      return this.e != null;
    }

    public void set_e_isSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unset_e();
        } else {
          set_e((NotAliveException)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return get_e();

      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return is_set_e();
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof killTopology_result)
        return this.equals((killTopology_result)that);
      return false;
    }

    public boolean equals(killTopology_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.is_set_e();
      boolean that_present_e = true && that.is_set_e();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_e = true && (is_set_e());
      list.add(present_e);
      if (present_e)
        list.add(e);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(killTopology_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_e()).compareTo(other.is_set_e());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_e()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("killTopology_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class killTopology_resultStandardSchemeFactory implements SchemeFactory {
      public killTopology_resultStandardScheme getScheme() {
        return new killTopology_resultStandardScheme();
      }
    }

    private static class killTopology_resultStandardScheme extends StandardScheme<killTopology_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, killTopology_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new NotAliveException();
                struct.e.read(iprot);
                struct.set_e_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, killTopology_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class killTopology_resultTupleSchemeFactory implements SchemeFactory {
      public killTopology_resultTupleScheme getScheme() {
        return new killTopology_resultTupleScheme();
      }
    }

    private static class killTopology_resultTupleScheme extends TupleScheme<killTopology_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, killTopology_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_e()) {
          optionals.set(0);
        }
        if (struct.is_set_aze()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_e()) {
          struct.e.write(oprot);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, killTopology_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.e = new NotAliveException();
          struct.e.read(iprot);
          struct.set_e_isSet(true);
        }
        if (incoming.get(1)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class killTopologyWithOpts_args implements org.apache.thrift.TBase<killTopologyWithOpts_args, killTopologyWithOpts_args._Fields>, java.io.Serializable, Cloneable, Comparable<killTopologyWithOpts_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("killTopologyWithOpts_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField OPTIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("options", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new killTopologyWithOpts_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new killTopologyWithOpts_argsTupleSchemeFactory());
    }

    private String name; // required
    private KillOptions options; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name"),
      OPTIONS((short)2, "options");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          case 2: // OPTIONS
            return OPTIONS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.OPTIONS, new org.apache.thrift.meta_data.FieldMetaData("options", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, KillOptions.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(killTopologyWithOpts_args.class, metaDataMap);
    }

    public killTopologyWithOpts_args() {
    }

    public killTopologyWithOpts_args(
      String name,
      KillOptions options)
    {
      this();
      this.name = name;
      this.options = options;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public killTopologyWithOpts_args(killTopologyWithOpts_args other) {
      if (other.is_set_name()) {
        this.name = other.name;
      }
      if (other.is_set_options()) {
        this.options = new KillOptions(other.options);
      }
    }

    public killTopologyWithOpts_args deepCopy() {
      return new killTopologyWithOpts_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
      this.options = null;
    }

    public String get_name() {
      return this.name;
    }

    public void set_name(String name) {
      this.name = name;
    }

    public void unset_name() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean is_set_name() {
      return this.name != null;
    }

    public void set_name_isSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public KillOptions get_options() {
      return this.options;
    }

    public void set_options(KillOptions options) {
      this.options = options;
    }

    public void unset_options() {
      this.options = null;
    }

    /** Returns true if field options is set (has been assigned a value) and false otherwise */
    public boolean is_set_options() {
      return this.options != null;
    }

    public void set_options_isSet(boolean value) {
      if (!value) {
        this.options = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unset_name();
        } else {
          set_name((String)value);
        }
        break;

      case OPTIONS:
        if (value == null) {
          unset_options();
        } else {
          set_options((KillOptions)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return get_name();

      case OPTIONS:
        return get_options();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return is_set_name();
      case OPTIONS:
        return is_set_options();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof killTopologyWithOpts_args)
        return this.equals((killTopologyWithOpts_args)that);
      return false;
    }

    public boolean equals(killTopologyWithOpts_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.is_set_name();
      boolean that_present_name = true && that.is_set_name();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      boolean this_present_options = true && this.is_set_options();
      boolean that_present_options = true && that.is_set_options();
      if (this_present_options || that_present_options) {
        if (!(this_present_options && that_present_options))
          return false;
        if (!this.options.equals(that.options))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (is_set_name());
      list.add(present_name);
      if (present_name)
        list.add(name);

      boolean present_options = true && (is_set_options());
      list.add(present_options);
      if (present_options)
        list.add(options);

      return list.hashCode();
    }

    @Override
    public int compareTo(killTopologyWithOpts_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_name()).compareTo(other.is_set_name());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_name()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_options()).compareTo(other.is_set_options());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_options()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.options, other.options);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("killTopologyWithOpts_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("options:");
      if (this.options == null) {
        sb.append("null");
      } else {
        sb.append(this.options);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (options != null) {
        options.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class killTopologyWithOpts_argsStandardSchemeFactory implements SchemeFactory {
      public killTopologyWithOpts_argsStandardScheme getScheme() {
        return new killTopologyWithOpts_argsStandardScheme();
      }
    }

    private static class killTopologyWithOpts_argsStandardScheme extends StandardScheme<killTopologyWithOpts_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, killTopologyWithOpts_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.set_name_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // OPTIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.options = new KillOptions();
                struct.options.read(iprot);
                struct.set_options_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, killTopologyWithOpts_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.options != null) {
          oprot.writeFieldBegin(OPTIONS_FIELD_DESC);
          struct.options.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class killTopologyWithOpts_argsTupleSchemeFactory implements SchemeFactory {
      public killTopologyWithOpts_argsTupleScheme getScheme() {
        return new killTopologyWithOpts_argsTupleScheme();
      }
    }

    private static class killTopologyWithOpts_argsTupleScheme extends TupleScheme<killTopologyWithOpts_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, killTopologyWithOpts_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_name()) {
          optionals.set(0);
        }
        if (struct.is_set_options()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_name()) {
          oprot.writeString(struct.name);
        }
        if (struct.is_set_options()) {
          struct.options.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, killTopologyWithOpts_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.set_name_isSet(true);
        }
        if (incoming.get(1)) {
          struct.options = new KillOptions();
          struct.options.read(iprot);
          struct.set_options_isSet(true);
        }
      }
    }

  }

  public static class killTopologyWithOpts_result implements org.apache.thrift.TBase<killTopologyWithOpts_result, killTopologyWithOpts_result._Fields>, java.io.Serializable, Cloneable, Comparable<killTopologyWithOpts_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("killTopologyWithOpts_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new killTopologyWithOpts_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new killTopologyWithOpts_resultTupleSchemeFactory());
    }

    private NotAliveException e; // required
    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e"),
      AZE((short)2, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          case 2: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(killTopologyWithOpts_result.class, metaDataMap);
    }

    public killTopologyWithOpts_result() {
    }

    public killTopologyWithOpts_result(
      NotAliveException e,
      AuthorizationException aze)
    {
      this();
      this.e = e;
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public killTopologyWithOpts_result(killTopologyWithOpts_result other) {
      if (other.is_set_e()) {
        this.e = new NotAliveException(other.e);
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public killTopologyWithOpts_result deepCopy() {
      return new killTopologyWithOpts_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
      this.aze = null;
    }

    public NotAliveException get_e() {
      return this.e;
    }

    public void set_e(NotAliveException e) {
      this.e = e;
    }

    public void unset_e() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean is_set_e() {
      return this.e != null;
    }

    public void set_e_isSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unset_e();
        } else {
          set_e((NotAliveException)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return get_e();

      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return is_set_e();
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof killTopologyWithOpts_result)
        return this.equals((killTopologyWithOpts_result)that);
      return false;
    }

    public boolean equals(killTopologyWithOpts_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.is_set_e();
      boolean that_present_e = true && that.is_set_e();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_e = true && (is_set_e());
      list.add(present_e);
      if (present_e)
        list.add(e);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(killTopologyWithOpts_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_e()).compareTo(other.is_set_e());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_e()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("killTopologyWithOpts_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class killTopologyWithOpts_resultStandardSchemeFactory implements SchemeFactory {
      public killTopologyWithOpts_resultStandardScheme getScheme() {
        return new killTopologyWithOpts_resultStandardScheme();
      }
    }

    private static class killTopologyWithOpts_resultStandardScheme extends StandardScheme<killTopologyWithOpts_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, killTopologyWithOpts_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new NotAliveException();
                struct.e.read(iprot);
                struct.set_e_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, killTopologyWithOpts_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class killTopologyWithOpts_resultTupleSchemeFactory implements SchemeFactory {
      public killTopologyWithOpts_resultTupleScheme getScheme() {
        return new killTopologyWithOpts_resultTupleScheme();
      }
    }

    private static class killTopologyWithOpts_resultTupleScheme extends TupleScheme<killTopologyWithOpts_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, killTopologyWithOpts_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_e()) {
          optionals.set(0);
        }
        if (struct.is_set_aze()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_e()) {
          struct.e.write(oprot);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, killTopologyWithOpts_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.e = new NotAliveException();
          struct.e.read(iprot);
          struct.set_e_isSet(true);
        }
        if (incoming.get(1)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class activate_args implements org.apache.thrift.TBase<activate_args, activate_args._Fields>, java.io.Serializable, Cloneable, Comparable<activate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("activate_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new activate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new activate_argsTupleSchemeFactory());
    }

    private String name; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(activate_args.class, metaDataMap);
    }

    public activate_args() {
    }

    public activate_args(
      String name)
    {
      this();
      this.name = name;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public activate_args(activate_args other) {
      if (other.is_set_name()) {
        this.name = other.name;
      }
    }

    public activate_args deepCopy() {
      return new activate_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
    }

    public String get_name() {
      return this.name;
    }

    public void set_name(String name) {
      this.name = name;
    }

    public void unset_name() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean is_set_name() {
      return this.name != null;
    }

    public void set_name_isSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unset_name();
        } else {
          set_name((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return get_name();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return is_set_name();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof activate_args)
        return this.equals((activate_args)that);
      return false;
    }

    public boolean equals(activate_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.is_set_name();
      boolean that_present_name = true && that.is_set_name();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (is_set_name());
      list.add(present_name);
      if (present_name)
        list.add(name);

      return list.hashCode();
    }

    @Override
    public int compareTo(activate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_name()).compareTo(other.is_set_name());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_name()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("activate_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class activate_argsStandardSchemeFactory implements SchemeFactory {
      public activate_argsStandardScheme getScheme() {
        return new activate_argsStandardScheme();
      }
    }

    private static class activate_argsStandardScheme extends StandardScheme<activate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, activate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.set_name_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, activate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class activate_argsTupleSchemeFactory implements SchemeFactory {
      public activate_argsTupleScheme getScheme() {
        return new activate_argsTupleScheme();
      }
    }

    private static class activate_argsTupleScheme extends TupleScheme<activate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, activate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_name()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_name()) {
          oprot.writeString(struct.name);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, activate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.set_name_isSet(true);
        }
      }
    }

  }

  public static class activate_result implements org.apache.thrift.TBase<activate_result, activate_result._Fields>, java.io.Serializable, Cloneable, Comparable<activate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("activate_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new activate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new activate_resultTupleSchemeFactory());
    }

    private NotAliveException e; // required
    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e"),
      AZE((short)2, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          case 2: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(activate_result.class, metaDataMap);
    }

    public activate_result() {
    }

    public activate_result(
      NotAliveException e,
      AuthorizationException aze)
    {
      this();
      this.e = e;
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public activate_result(activate_result other) {
      if (other.is_set_e()) {
        this.e = new NotAliveException(other.e);
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public activate_result deepCopy() {
      return new activate_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
      this.aze = null;
    }

    public NotAliveException get_e() {
      return this.e;
    }

    public void set_e(NotAliveException e) {
      this.e = e;
    }

    public void unset_e() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean is_set_e() {
      return this.e != null;
    }

    public void set_e_isSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unset_e();
        } else {
          set_e((NotAliveException)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return get_e();

      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return is_set_e();
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof activate_result)
        return this.equals((activate_result)that);
      return false;
    }

    public boolean equals(activate_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.is_set_e();
      boolean that_present_e = true && that.is_set_e();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_e = true && (is_set_e());
      list.add(present_e);
      if (present_e)
        list.add(e);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(activate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_e()).compareTo(other.is_set_e());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_e()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("activate_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class activate_resultStandardSchemeFactory implements SchemeFactory {
      public activate_resultStandardScheme getScheme() {
        return new activate_resultStandardScheme();
      }
    }

    private static class activate_resultStandardScheme extends StandardScheme<activate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, activate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new NotAliveException();
                struct.e.read(iprot);
                struct.set_e_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, activate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class activate_resultTupleSchemeFactory implements SchemeFactory {
      public activate_resultTupleScheme getScheme() {
        return new activate_resultTupleScheme();
      }
    }

    private static class activate_resultTupleScheme extends TupleScheme<activate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, activate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_e()) {
          optionals.set(0);
        }
        if (struct.is_set_aze()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_e()) {
          struct.e.write(oprot);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, activate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.e = new NotAliveException();
          struct.e.read(iprot);
          struct.set_e_isSet(true);
        }
        if (incoming.get(1)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class deactivate_args implements org.apache.thrift.TBase<deactivate_args, deactivate_args._Fields>, java.io.Serializable, Cloneable, Comparable<deactivate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deactivate_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new deactivate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new deactivate_argsTupleSchemeFactory());
    }

    private String name; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deactivate_args.class, metaDataMap);
    }

    public deactivate_args() {
    }

    public deactivate_args(
      String name)
    {
      this();
      this.name = name;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deactivate_args(deactivate_args other) {
      if (other.is_set_name()) {
        this.name = other.name;
      }
    }

    public deactivate_args deepCopy() {
      return new deactivate_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
    }

    public String get_name() {
      return this.name;
    }

    public void set_name(String name) {
      this.name = name;
    }

    public void unset_name() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean is_set_name() {
      return this.name != null;
    }

    public void set_name_isSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unset_name();
        } else {
          set_name((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return get_name();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return is_set_name();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deactivate_args)
        return this.equals((deactivate_args)that);
      return false;
    }

    public boolean equals(deactivate_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.is_set_name();
      boolean that_present_name = true && that.is_set_name();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (is_set_name());
      list.add(present_name);
      if (present_name)
        list.add(name);

      return list.hashCode();
    }

    @Override
    public int compareTo(deactivate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_name()).compareTo(other.is_set_name());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_name()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("deactivate_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deactivate_argsStandardSchemeFactory implements SchemeFactory {
      public deactivate_argsStandardScheme getScheme() {
        return new deactivate_argsStandardScheme();
      }
    }

    private static class deactivate_argsStandardScheme extends StandardScheme<deactivate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deactivate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.set_name_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deactivate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deactivate_argsTupleSchemeFactory implements SchemeFactory {
      public deactivate_argsTupleScheme getScheme() {
        return new deactivate_argsTupleScheme();
      }
    }

    private static class deactivate_argsTupleScheme extends TupleScheme<deactivate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deactivate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_name()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_name()) {
          oprot.writeString(struct.name);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deactivate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.set_name_isSet(true);
        }
      }
    }

  }

  public static class deactivate_result implements org.apache.thrift.TBase<deactivate_result, deactivate_result._Fields>, java.io.Serializable, Cloneable, Comparable<deactivate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deactivate_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new deactivate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new deactivate_resultTupleSchemeFactory());
    }

    private NotAliveException e; // required
    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e"),
      AZE((short)2, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          case 2: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deactivate_result.class, metaDataMap);
    }

    public deactivate_result() {
    }

    public deactivate_result(
      NotAliveException e,
      AuthorizationException aze)
    {
      this();
      this.e = e;
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deactivate_result(deactivate_result other) {
      if (other.is_set_e()) {
        this.e = new NotAliveException(other.e);
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public deactivate_result deepCopy() {
      return new deactivate_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
      this.aze = null;
    }

    public NotAliveException get_e() {
      return this.e;
    }

    public void set_e(NotAliveException e) {
      this.e = e;
    }

    public void unset_e() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean is_set_e() {
      return this.e != null;
    }

    public void set_e_isSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unset_e();
        } else {
          set_e((NotAliveException)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return get_e();

      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return is_set_e();
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deactivate_result)
        return this.equals((deactivate_result)that);
      return false;
    }

    public boolean equals(deactivate_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.is_set_e();
      boolean that_present_e = true && that.is_set_e();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_e = true && (is_set_e());
      list.add(present_e);
      if (present_e)
        list.add(e);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(deactivate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_e()).compareTo(other.is_set_e());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_e()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("deactivate_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deactivate_resultStandardSchemeFactory implements SchemeFactory {
      public deactivate_resultStandardScheme getScheme() {
        return new deactivate_resultStandardScheme();
      }
    }

    private static class deactivate_resultStandardScheme extends StandardScheme<deactivate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deactivate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new NotAliveException();
                struct.e.read(iprot);
                struct.set_e_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deactivate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deactivate_resultTupleSchemeFactory implements SchemeFactory {
      public deactivate_resultTupleScheme getScheme() {
        return new deactivate_resultTupleScheme();
      }
    }

    private static class deactivate_resultTupleScheme extends TupleScheme<deactivate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deactivate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_e()) {
          optionals.set(0);
        }
        if (struct.is_set_aze()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_e()) {
          struct.e.write(oprot);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deactivate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.e = new NotAliveException();
          struct.e.read(iprot);
          struct.set_e_isSet(true);
        }
        if (incoming.get(1)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class rebalance_args implements org.apache.thrift.TBase<rebalance_args, rebalance_args._Fields>, java.io.Serializable, Cloneable, Comparable<rebalance_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("rebalance_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField OPTIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("options", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new rebalance_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new rebalance_argsTupleSchemeFactory());
    }

    private String name; // required
    private RebalanceOptions options; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name"),
      OPTIONS((short)2, "options");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          case 2: // OPTIONS
            return OPTIONS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.OPTIONS, new org.apache.thrift.meta_data.FieldMetaData("options", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, RebalanceOptions.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(rebalance_args.class, metaDataMap);
    }

    public rebalance_args() {
    }

    public rebalance_args(
      String name,
      RebalanceOptions options)
    {
      this();
      this.name = name;
      this.options = options;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public rebalance_args(rebalance_args other) {
      if (other.is_set_name()) {
        this.name = other.name;
      }
      if (other.is_set_options()) {
        this.options = new RebalanceOptions(other.options);
      }
    }

    public rebalance_args deepCopy() {
      return new rebalance_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
      this.options = null;
    }

    public String get_name() {
      return this.name;
    }

    public void set_name(String name) {
      this.name = name;
    }

    public void unset_name() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean is_set_name() {
      return this.name != null;
    }

    public void set_name_isSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public RebalanceOptions get_options() {
      return this.options;
    }

    public void set_options(RebalanceOptions options) {
      this.options = options;
    }

    public void unset_options() {
      this.options = null;
    }

    /** Returns true if field options is set (has been assigned a value) and false otherwise */
    public boolean is_set_options() {
      return this.options != null;
    }

    public void set_options_isSet(boolean value) {
      if (!value) {
        this.options = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unset_name();
        } else {
          set_name((String)value);
        }
        break;

      case OPTIONS:
        if (value == null) {
          unset_options();
        } else {
          set_options((RebalanceOptions)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return get_name();

      case OPTIONS:
        return get_options();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return is_set_name();
      case OPTIONS:
        return is_set_options();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof rebalance_args)
        return this.equals((rebalance_args)that);
      return false;
    }

    public boolean equals(rebalance_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.is_set_name();
      boolean that_present_name = true && that.is_set_name();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      boolean this_present_options = true && this.is_set_options();
      boolean that_present_options = true && that.is_set_options();
      if (this_present_options || that_present_options) {
        if (!(this_present_options && that_present_options))
          return false;
        if (!this.options.equals(that.options))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (is_set_name());
      list.add(present_name);
      if (present_name)
        list.add(name);

      boolean present_options = true && (is_set_options());
      list.add(present_options);
      if (present_options)
        list.add(options);

      return list.hashCode();
    }

    @Override
    public int compareTo(rebalance_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_name()).compareTo(other.is_set_name());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_name()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_options()).compareTo(other.is_set_options());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_options()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.options, other.options);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("rebalance_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("options:");
      if (this.options == null) {
        sb.append("null");
      } else {
        sb.append(this.options);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (options != null) {
        options.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class rebalance_argsStandardSchemeFactory implements SchemeFactory {
      public rebalance_argsStandardScheme getScheme() {
        return new rebalance_argsStandardScheme();
      }
    }

    private static class rebalance_argsStandardScheme extends StandardScheme<rebalance_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, rebalance_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.set_name_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // OPTIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.options = new RebalanceOptions();
                struct.options.read(iprot);
                struct.set_options_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, rebalance_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.options != null) {
          oprot.writeFieldBegin(OPTIONS_FIELD_DESC);
          struct.options.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class rebalance_argsTupleSchemeFactory implements SchemeFactory {
      public rebalance_argsTupleScheme getScheme() {
        return new rebalance_argsTupleScheme();
      }
    }

    private static class rebalance_argsTupleScheme extends TupleScheme<rebalance_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, rebalance_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_name()) {
          optionals.set(0);
        }
        if (struct.is_set_options()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_name()) {
          oprot.writeString(struct.name);
        }
        if (struct.is_set_options()) {
          struct.options.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, rebalance_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.set_name_isSet(true);
        }
        if (incoming.get(1)) {
          struct.options = new RebalanceOptions();
          struct.options.read(iprot);
          struct.set_options_isSet(true);
        }
      }
    }

  }

  public static class rebalance_result implements org.apache.thrift.TBase<rebalance_result, rebalance_result._Fields>, java.io.Serializable, Cloneable, Comparable<rebalance_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("rebalance_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField ITE_FIELD_DESC = new org.apache.thrift.protocol.TField("ite", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new rebalance_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new rebalance_resultTupleSchemeFactory());
    }

    private NotAliveException e; // required
    private InvalidTopologyException ite; // required
    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e"),
      ITE((short)2, "ite"),
      AZE((short)3, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          case 2: // ITE
            return ITE;
          case 3: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.ITE, new org.apache.thrift.meta_data.FieldMetaData("ite", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(rebalance_result.class, metaDataMap);
    }

    public rebalance_result() {
    }

    public rebalance_result(
      NotAliveException e,
      InvalidTopologyException ite,
      AuthorizationException aze)
    {
      this();
      this.e = e;
      this.ite = ite;
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public rebalance_result(rebalance_result other) {
      if (other.is_set_e()) {
        this.e = new NotAliveException(other.e);
      }
      if (other.is_set_ite()) {
        this.ite = new InvalidTopologyException(other.ite);
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public rebalance_result deepCopy() {
      return new rebalance_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
      this.ite = null;
      this.aze = null;
    }

    public NotAliveException get_e() {
      return this.e;
    }

    public void set_e(NotAliveException e) {
      this.e = e;
    }

    public void unset_e() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean is_set_e() {
      return this.e != null;
    }

    public void set_e_isSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public InvalidTopologyException get_ite() {
      return this.ite;
    }

    public void set_ite(InvalidTopologyException ite) {
      this.ite = ite;
    }

    public void unset_ite() {
      this.ite = null;
    }

    /** Returns true if field ite is set (has been assigned a value) and false otherwise */
    public boolean is_set_ite() {
      return this.ite != null;
    }

    public void set_ite_isSet(boolean value) {
      if (!value) {
        this.ite = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unset_e();
        } else {
          set_e((NotAliveException)value);
        }
        break;

      case ITE:
        if (value == null) {
          unset_ite();
        } else {
          set_ite((InvalidTopologyException)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return get_e();

      case ITE:
        return get_ite();

      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return is_set_e();
      case ITE:
        return is_set_ite();
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof rebalance_result)
        return this.equals((rebalance_result)that);
      return false;
    }

    public boolean equals(rebalance_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.is_set_e();
      boolean that_present_e = true && that.is_set_e();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      boolean this_present_ite = true && this.is_set_ite();
      boolean that_present_ite = true && that.is_set_ite();
      if (this_present_ite || that_present_ite) {
        if (!(this_present_ite && that_present_ite))
          return false;
        if (!this.ite.equals(that.ite))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_e = true && (is_set_e());
      list.add(present_e);
      if (present_e)
        list.add(e);

      boolean present_ite = true && (is_set_ite());
      list.add(present_ite);
      if (present_ite)
        list.add(ite);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(rebalance_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_e()).compareTo(other.is_set_e());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_e()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_ite()).compareTo(other.is_set_ite());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_ite()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ite, other.ite);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("rebalance_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ite:");
      if (this.ite == null) {
        sb.append("null");
      } else {
        sb.append(this.ite);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class rebalance_resultStandardSchemeFactory implements SchemeFactory {
      public rebalance_resultStandardScheme getScheme() {
        return new rebalance_resultStandardScheme();
      }
    }

    private static class rebalance_resultStandardScheme extends StandardScheme<rebalance_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, rebalance_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new NotAliveException();
                struct.e.read(iprot);
                struct.set_e_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ITE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ite = new InvalidTopologyException();
                struct.ite.read(iprot);
                struct.set_ite_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, rebalance_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ite != null) {
          oprot.writeFieldBegin(ITE_FIELD_DESC);
          struct.ite.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class rebalance_resultTupleSchemeFactory implements SchemeFactory {
      public rebalance_resultTupleScheme getScheme() {
        return new rebalance_resultTupleScheme();
      }
    }

    private static class rebalance_resultTupleScheme extends TupleScheme<rebalance_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, rebalance_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_e()) {
          optionals.set(0);
        }
        if (struct.is_set_ite()) {
          optionals.set(1);
        }
        if (struct.is_set_aze()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.is_set_e()) {
          struct.e.write(oprot);
        }
        if (struct.is_set_ite()) {
          struct.ite.write(oprot);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, rebalance_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.e = new NotAliveException();
          struct.e.read(iprot);
          struct.set_e_isSet(true);
        }
        if (incoming.get(1)) {
          struct.ite = new InvalidTopologyException();
          struct.ite.read(iprot);
          struct.set_ite_isSet(true);
        }
        if (incoming.get(2)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class setLogConfig_args implements org.apache.thrift.TBase<setLogConfig_args, setLogConfig_args._Fields>, java.io.Serializable, Cloneable, Comparable<setLogConfig_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("setLogConfig_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField CONFIG_FIELD_DESC = new org.apache.thrift.protocol.TField("config", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new setLogConfig_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new setLogConfig_argsTupleSchemeFactory());
    }

    private String name; // required
    private LogConfig config; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name"),
      CONFIG((short)2, "config");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          case 2: // CONFIG
            return CONFIG;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CONFIG, new org.apache.thrift.meta_data.FieldMetaData("config", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, LogConfig.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(setLogConfig_args.class, metaDataMap);
    }

    public setLogConfig_args() {
    }

    public setLogConfig_args(
      String name,
      LogConfig config)
    {
      this();
      this.name = name;
      this.config = config;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public setLogConfig_args(setLogConfig_args other) {
      if (other.is_set_name()) {
        this.name = other.name;
      }
      if (other.is_set_config()) {
        this.config = new LogConfig(other.config);
      }
    }

    public setLogConfig_args deepCopy() {
      return new setLogConfig_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
      this.config = null;
    }

    public String get_name() {
      return this.name;
    }

    public void set_name(String name) {
      this.name = name;
    }

    public void unset_name() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean is_set_name() {
      return this.name != null;
    }

    public void set_name_isSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public LogConfig get_config() {
      return this.config;
    }

    public void set_config(LogConfig config) {
      this.config = config;
    }

    public void unset_config() {
      this.config = null;
    }

    /** Returns true if field config is set (has been assigned a value) and false otherwise */
    public boolean is_set_config() {
      return this.config != null;
    }

    public void set_config_isSet(boolean value) {
      if (!value) {
        this.config = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unset_name();
        } else {
          set_name((String)value);
        }
        break;

      case CONFIG:
        if (value == null) {
          unset_config();
        } else {
          set_config((LogConfig)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return get_name();

      case CONFIG:
        return get_config();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return is_set_name();
      case CONFIG:
        return is_set_config();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setLogConfig_args)
        return this.equals((setLogConfig_args)that);
      return false;
    }

    public boolean equals(setLogConfig_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.is_set_name();
      boolean that_present_name = true && that.is_set_name();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      boolean this_present_config = true && this.is_set_config();
      boolean that_present_config = true && that.is_set_config();
      if (this_present_config || that_present_config) {
        if (!(this_present_config && that_present_config))
          return false;
        if (!this.config.equals(that.config))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (is_set_name());
      list.add(present_name);
      if (present_name)
        list.add(name);

      boolean present_config = true && (is_set_config());
      list.add(present_config);
      if (present_config)
        list.add(config);

      return list.hashCode();
    }

    @Override
    public int compareTo(setLogConfig_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_name()).compareTo(other.is_set_name());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_name()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_config()).compareTo(other.is_set_config());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_config()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.config, other.config);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("setLogConfig_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("config:");
      if (this.config == null) {
        sb.append("null");
      } else {
        sb.append(this.config);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (config != null) {
        config.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class setLogConfig_argsStandardSchemeFactory implements SchemeFactory {
      public setLogConfig_argsStandardScheme getScheme() {
        return new setLogConfig_argsStandardScheme();
      }
    }

    private static class setLogConfig_argsStandardScheme extends StandardScheme<setLogConfig_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, setLogConfig_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.set_name_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CONFIG
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.config = new LogConfig();
                struct.config.read(iprot);
                struct.set_config_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, setLogConfig_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.config != null) {
          oprot.writeFieldBegin(CONFIG_FIELD_DESC);
          struct.config.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class setLogConfig_argsTupleSchemeFactory implements SchemeFactory {
      public setLogConfig_argsTupleScheme getScheme() {
        return new setLogConfig_argsTupleScheme();
      }
    }

    private static class setLogConfig_argsTupleScheme extends TupleScheme<setLogConfig_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, setLogConfig_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_name()) {
          optionals.set(0);
        }
        if (struct.is_set_config()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_name()) {
          oprot.writeString(struct.name);
        }
        if (struct.is_set_config()) {
          struct.config.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, setLogConfig_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.set_name_isSet(true);
        }
        if (incoming.get(1)) {
          struct.config = new LogConfig();
          struct.config.read(iprot);
          struct.set_config_isSet(true);
        }
      }
    }

  }

  public static class setLogConfig_result implements org.apache.thrift.TBase<setLogConfig_result, setLogConfig_result._Fields>, java.io.Serializable, Cloneable, Comparable<setLogConfig_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("setLogConfig_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new setLogConfig_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new setLogConfig_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(setLogConfig_result.class, metaDataMap);
    }

    public setLogConfig_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public setLogConfig_result(setLogConfig_result other) {
    }

    public setLogConfig_result deepCopy() {
      return new setLogConfig_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setLogConfig_result)
        return this.equals((setLogConfig_result)that);
      return false;
    }

    public boolean equals(setLogConfig_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(setLogConfig_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("setLogConfig_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class setLogConfig_resultStandardSchemeFactory implements SchemeFactory {
      public setLogConfig_resultStandardScheme getScheme() {
        return new setLogConfig_resultStandardScheme();
      }
    }

    private static class setLogConfig_resultStandardScheme extends StandardScheme<setLogConfig_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, setLogConfig_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, setLogConfig_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class setLogConfig_resultTupleSchemeFactory implements SchemeFactory {
      public setLogConfig_resultTupleScheme getScheme() {
        return new setLogConfig_resultTupleScheme();
      }
    }

    private static class setLogConfig_resultTupleScheme extends TupleScheme<setLogConfig_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, setLogConfig_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, setLogConfig_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getLogConfig_args implements org.apache.thrift.TBase<getLogConfig_args, getLogConfig_args._Fields>, java.io.Serializable, Cloneable, Comparable<getLogConfig_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getLogConfig_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getLogConfig_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getLogConfig_argsTupleSchemeFactory());
    }

    private String name; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getLogConfig_args.class, metaDataMap);
    }

    public getLogConfig_args() {
    }

    public getLogConfig_args(
      String name)
    {
      this();
      this.name = name;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getLogConfig_args(getLogConfig_args other) {
      if (other.is_set_name()) {
        this.name = other.name;
      }
    }

    public getLogConfig_args deepCopy() {
      return new getLogConfig_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
    }

    public String get_name() {
      return this.name;
    }

    public void set_name(String name) {
      this.name = name;
    }

    public void unset_name() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean is_set_name() {
      return this.name != null;
    }

    public void set_name_isSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unset_name();
        } else {
          set_name((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return get_name();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return is_set_name();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getLogConfig_args)
        return this.equals((getLogConfig_args)that);
      return false;
    }

    public boolean equals(getLogConfig_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.is_set_name();
      boolean that_present_name = true && that.is_set_name();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (is_set_name());
      list.add(present_name);
      if (present_name)
        list.add(name);

      return list.hashCode();
    }

    @Override
    public int compareTo(getLogConfig_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_name()).compareTo(other.is_set_name());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_name()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getLogConfig_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getLogConfig_argsStandardSchemeFactory implements SchemeFactory {
      public getLogConfig_argsStandardScheme getScheme() {
        return new getLogConfig_argsStandardScheme();
      }
    }

    private static class getLogConfig_argsStandardScheme extends StandardScheme<getLogConfig_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getLogConfig_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.set_name_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getLogConfig_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getLogConfig_argsTupleSchemeFactory implements SchemeFactory {
      public getLogConfig_argsTupleScheme getScheme() {
        return new getLogConfig_argsTupleScheme();
      }
    }

    private static class getLogConfig_argsTupleScheme extends TupleScheme<getLogConfig_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getLogConfig_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_name()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_name()) {
          oprot.writeString(struct.name);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getLogConfig_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.set_name_isSet(true);
        }
      }
    }

  }

  public static class getLogConfig_result implements org.apache.thrift.TBase<getLogConfig_result, getLogConfig_result._Fields>, java.io.Serializable, Cloneable, Comparable<getLogConfig_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getLogConfig_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getLogConfig_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getLogConfig_resultTupleSchemeFactory());
    }

    private LogConfig success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, LogConfig.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getLogConfig_result.class, metaDataMap);
    }

    public getLogConfig_result() {
    }

    public getLogConfig_result(
      LogConfig success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getLogConfig_result(getLogConfig_result other) {
      if (other.is_set_success()) {
        this.success = new LogConfig(other.success);
      }
    }

    public getLogConfig_result deepCopy() {
      return new getLogConfig_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public LogConfig get_success() {
      return this.success;
    }

    public void set_success(LogConfig success) {
      this.success = success;
    }

    public void unset_success() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean is_set_success() {
      return this.success != null;
    }

    public void set_success_isSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unset_success();
        } else {
          set_success((LogConfig)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return get_success();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return is_set_success();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getLogConfig_result)
        return this.equals((getLogConfig_result)that);
      return false;
    }

    public boolean equals(getLogConfig_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.is_set_success();
      boolean that_present_success = true && that.is_set_success();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (is_set_success());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(getLogConfig_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_success()).compareTo(other.is_set_success());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_success()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getLogConfig_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getLogConfig_resultStandardSchemeFactory implements SchemeFactory {
      public getLogConfig_resultStandardScheme getScheme() {
        return new getLogConfig_resultStandardScheme();
      }
    }

    private static class getLogConfig_resultStandardScheme extends StandardScheme<getLogConfig_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getLogConfig_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new LogConfig();
                struct.success.read(iprot);
                struct.set_success_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getLogConfig_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getLogConfig_resultTupleSchemeFactory implements SchemeFactory {
      public getLogConfig_resultTupleScheme getScheme() {
        return new getLogConfig_resultTupleScheme();
      }
    }

    private static class getLogConfig_resultTupleScheme extends TupleScheme<getLogConfig_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getLogConfig_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_success()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_success()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getLogConfig_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new LogConfig();
          struct.success.read(iprot);
          struct.set_success_isSet(true);
        }
      }
    }

  }

  public static class debug_args implements org.apache.thrift.TBase<debug_args, debug_args._Fields>, java.io.Serializable, Cloneable, Comparable<debug_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("debug_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField COMPONENT_FIELD_DESC = new org.apache.thrift.protocol.TField("component", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField ENABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("enable", org.apache.thrift.protocol.TType.BOOL, (short)3);
    private static final org.apache.thrift.protocol.TField SAMPLING_PERCENTAGE_FIELD_DESC = new org.apache.thrift.protocol.TField("samplingPercentage", org.apache.thrift.protocol.TType.DOUBLE, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new debug_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new debug_argsTupleSchemeFactory());
    }

    private String name; // required
    private String component; // required
    private boolean enable; // required
    private double samplingPercentage; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name"),
      COMPONENT((short)2, "component"),
      ENABLE((short)3, "enable"),
      SAMPLING_PERCENTAGE((short)4, "samplingPercentage");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          case 2: // COMPONENT
            return COMPONENT;
          case 3: // ENABLE
            return ENABLE;
          case 4: // SAMPLING_PERCENTAGE
            return SAMPLING_PERCENTAGE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __ENABLE_ISSET_ID = 0;
    private static final int __SAMPLINGPERCENTAGE_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.COMPONENT, new org.apache.thrift.meta_data.FieldMetaData("component", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.ENABLE, new org.apache.thrift.meta_data.FieldMetaData("enable", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SAMPLING_PERCENTAGE, new org.apache.thrift.meta_data.FieldMetaData("samplingPercentage", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.DOUBLE)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(debug_args.class, metaDataMap);
    }

    public debug_args() {
    }

    public debug_args(
      String name,
      String component,
      boolean enable,
      double samplingPercentage)
    {
      this();
      this.name = name;
      this.component = component;
      this.enable = enable;
      set_enable_isSet(true);
      this.samplingPercentage = samplingPercentage;
      set_samplingPercentage_isSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public debug_args(debug_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.is_set_name()) {
        this.name = other.name;
      }
      if (other.is_set_component()) {
        this.component = other.component;
      }
      this.enable = other.enable;
      this.samplingPercentage = other.samplingPercentage;
    }

    public debug_args deepCopy() {
      return new debug_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
      this.component = null;
      set_enable_isSet(false);
      this.enable = false;
      set_samplingPercentage_isSet(false);
      this.samplingPercentage = 0.0;
    }

    public String get_name() {
      return this.name;
    }

    public void set_name(String name) {
      this.name = name;
    }

    public void unset_name() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean is_set_name() {
      return this.name != null;
    }

    public void set_name_isSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public String get_component() {
      return this.component;
    }

    public void set_component(String component) {
      this.component = component;
    }

    public void unset_component() {
      this.component = null;
    }

    /** Returns true if field component is set (has been assigned a value) and false otherwise */
    public boolean is_set_component() {
      return this.component != null;
    }

    public void set_component_isSet(boolean value) {
      if (!value) {
        this.component = null;
      }
    }

    public boolean is_enable() {
      return this.enable;
    }

    public void set_enable(boolean enable) {
      this.enable = enable;
      set_enable_isSet(true);
    }

    public void unset_enable() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __ENABLE_ISSET_ID);
    }

    /** Returns true if field enable is set (has been assigned a value) and false otherwise */
    public boolean is_set_enable() {
      return EncodingUtils.testBit(__isset_bitfield, __ENABLE_ISSET_ID);
    }

    public void set_enable_isSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __ENABLE_ISSET_ID, value);
    }

    public double get_samplingPercentage() {
      return this.samplingPercentage;
    }

    public void set_samplingPercentage(double samplingPercentage) {
      this.samplingPercentage = samplingPercentage;
      set_samplingPercentage_isSet(true);
    }

    public void unset_samplingPercentage() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SAMPLINGPERCENTAGE_ISSET_ID);
    }

    /** Returns true if field samplingPercentage is set (has been assigned a value) and false otherwise */
    public boolean is_set_samplingPercentage() {
      return EncodingUtils.testBit(__isset_bitfield, __SAMPLINGPERCENTAGE_ISSET_ID);
    }

    public void set_samplingPercentage_isSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SAMPLINGPERCENTAGE_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unset_name();
        } else {
          set_name((String)value);
        }
        break;

      case COMPONENT:
        if (value == null) {
          unset_component();
        } else {
          set_component((String)value);
        }
        break;

      case ENABLE:
        if (value == null) {
          unset_enable();
        } else {
          set_enable((Boolean)value);
        }
        break;

      case SAMPLING_PERCENTAGE:
        if (value == null) {
          unset_samplingPercentage();
        } else {
          set_samplingPercentage((Double)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return get_name();

      case COMPONENT:
        return get_component();

      case ENABLE:
        return is_enable();

      case SAMPLING_PERCENTAGE:
        return get_samplingPercentage();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return is_set_name();
      case COMPONENT:
        return is_set_component();
      case ENABLE:
        return is_set_enable();
      case SAMPLING_PERCENTAGE:
        return is_set_samplingPercentage();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof debug_args)
        return this.equals((debug_args)that);
      return false;
    }

    public boolean equals(debug_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.is_set_name();
      boolean that_present_name = true && that.is_set_name();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      boolean this_present_component = true && this.is_set_component();
      boolean that_present_component = true && that.is_set_component();
      if (this_present_component || that_present_component) {
        if (!(this_present_component && that_present_component))
          return false;
        if (!this.component.equals(that.component))
          return false;
      }

      boolean this_present_enable = true;
      boolean that_present_enable = true;
      if (this_present_enable || that_present_enable) {
        if (!(this_present_enable && that_present_enable))
          return false;
        if (this.enable != that.enable)
          return false;
      }

      boolean this_present_samplingPercentage = true;
      boolean that_present_samplingPercentage = true;
      if (this_present_samplingPercentage || that_present_samplingPercentage) {
        if (!(this_present_samplingPercentage && that_present_samplingPercentage))
          return false;
        if (this.samplingPercentage != that.samplingPercentage)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (is_set_name());
      list.add(present_name);
      if (present_name)
        list.add(name);

      boolean present_component = true && (is_set_component());
      list.add(present_component);
      if (present_component)
        list.add(component);

      boolean present_enable = true;
      list.add(present_enable);
      if (present_enable)
        list.add(enable);

      boolean present_samplingPercentage = true;
      list.add(present_samplingPercentage);
      if (present_samplingPercentage)
        list.add(samplingPercentage);

      return list.hashCode();
    }

    @Override
    public int compareTo(debug_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_name()).compareTo(other.is_set_name());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_name()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_component()).compareTo(other.is_set_component());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_component()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.component, other.component);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_enable()).compareTo(other.is_set_enable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_enable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.enable, other.enable);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_samplingPercentage()).compareTo(other.is_set_samplingPercentage());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_samplingPercentage()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.samplingPercentage, other.samplingPercentage);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("debug_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("component:");
      if (this.component == null) {
        sb.append("null");
      } else {
        sb.append(this.component);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("enable:");
      sb.append(this.enable);
      first = false;
      if (!first) sb.append(", ");
      sb.append("samplingPercentage:");
      sb.append(this.samplingPercentage);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class debug_argsStandardSchemeFactory implements SchemeFactory {
      public debug_argsStandardScheme getScheme() {
        return new debug_argsStandardScheme();
      }
    }

    private static class debug_argsStandardScheme extends StandardScheme<debug_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, debug_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.set_name_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // COMPONENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.component = iprot.readString();
                struct.set_component_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // ENABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.enable = iprot.readBool();
                struct.set_enable_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // SAMPLING_PERCENTAGE
              if (schemeField.type == org.apache.thrift.protocol.TType.DOUBLE) {
                struct.samplingPercentage = iprot.readDouble();
                struct.set_samplingPercentage_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, debug_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.component != null) {
          oprot.writeFieldBegin(COMPONENT_FIELD_DESC);
          oprot.writeString(struct.component);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(ENABLE_FIELD_DESC);
        oprot.writeBool(struct.enable);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(SAMPLING_PERCENTAGE_FIELD_DESC);
        oprot.writeDouble(struct.samplingPercentage);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class debug_argsTupleSchemeFactory implements SchemeFactory {
      public debug_argsTupleScheme getScheme() {
        return new debug_argsTupleScheme();
      }
    }

    private static class debug_argsTupleScheme extends TupleScheme<debug_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, debug_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_name()) {
          optionals.set(0);
        }
        if (struct.is_set_component()) {
          optionals.set(1);
        }
        if (struct.is_set_enable()) {
          optionals.set(2);
        }
        if (struct.is_set_samplingPercentage()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.is_set_name()) {
          oprot.writeString(struct.name);
        }
        if (struct.is_set_component()) {
          oprot.writeString(struct.component);
        }
        if (struct.is_set_enable()) {
          oprot.writeBool(struct.enable);
        }
        if (struct.is_set_samplingPercentage()) {
          oprot.writeDouble(struct.samplingPercentage);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, debug_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.set_name_isSet(true);
        }
        if (incoming.get(1)) {
          struct.component = iprot.readString();
          struct.set_component_isSet(true);
        }
        if (incoming.get(2)) {
          struct.enable = iprot.readBool();
          struct.set_enable_isSet(true);
        }
        if (incoming.get(3)) {
          struct.samplingPercentage = iprot.readDouble();
          struct.set_samplingPercentage_isSet(true);
        }
      }
    }

  }

  public static class debug_result implements org.apache.thrift.TBase<debug_result, debug_result._Fields>, java.io.Serializable, Cloneable, Comparable<debug_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("debug_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new debug_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new debug_resultTupleSchemeFactory());
    }

    private NotAliveException e; // required
    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e"),
      AZE((short)2, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          case 2: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(debug_result.class, metaDataMap);
    }

    public debug_result() {
    }

    public debug_result(
      NotAliveException e,
      AuthorizationException aze)
    {
      this();
      this.e = e;
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public debug_result(debug_result other) {
      if (other.is_set_e()) {
        this.e = new NotAliveException(other.e);
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public debug_result deepCopy() {
      return new debug_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
      this.aze = null;
    }

    public NotAliveException get_e() {
      return this.e;
    }

    public void set_e(NotAliveException e) {
      this.e = e;
    }

    public void unset_e() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean is_set_e() {
      return this.e != null;
    }

    public void set_e_isSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unset_e();
        } else {
          set_e((NotAliveException)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return get_e();

      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return is_set_e();
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof debug_result)
        return this.equals((debug_result)that);
      return false;
    }

    public boolean equals(debug_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.is_set_e();
      boolean that_present_e = true && that.is_set_e();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_e = true && (is_set_e());
      list.add(present_e);
      if (present_e)
        list.add(e);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(debug_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_e()).compareTo(other.is_set_e());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_e()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("debug_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class debug_resultStandardSchemeFactory implements SchemeFactory {
      public debug_resultStandardScheme getScheme() {
        return new debug_resultStandardScheme();
      }
    }

    private static class debug_resultStandardScheme extends StandardScheme<debug_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, debug_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new NotAliveException();
                struct.e.read(iprot);
                struct.set_e_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, debug_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class debug_resultTupleSchemeFactory implements SchemeFactory {
      public debug_resultTupleScheme getScheme() {
        return new debug_resultTupleScheme();
      }
    }

    private static class debug_resultTupleScheme extends TupleScheme<debug_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, debug_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_e()) {
          optionals.set(0);
        }
        if (struct.is_set_aze()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_e()) {
          struct.e.write(oprot);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, debug_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.e = new NotAliveException();
          struct.e.read(iprot);
          struct.set_e_isSet(true);
        }
        if (incoming.get(1)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class setWorkerProfiler_args implements org.apache.thrift.TBase<setWorkerProfiler_args, setWorkerProfiler_args._Fields>, java.io.Serializable, Cloneable, Comparable<setWorkerProfiler_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("setWorkerProfiler_args");

    private static final org.apache.thrift.protocol.TField ID_FIELD_DESC = new org.apache.thrift.protocol.TField("id", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField PROFILE_REQUEST_FIELD_DESC = new org.apache.thrift.protocol.TField("profileRequest", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new setWorkerProfiler_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new setWorkerProfiler_argsTupleSchemeFactory());
    }

    private String id; // required
    private ProfileRequest profileRequest; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ID((short)1, "id"),
      PROFILE_REQUEST((short)2, "profileRequest");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ID
            return ID;
          case 2: // PROFILE_REQUEST
            return PROFILE_REQUEST;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ID, new org.apache.thrift.meta_data.FieldMetaData("id", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PROFILE_REQUEST, new org.apache.thrift.meta_data.FieldMetaData("profileRequest", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ProfileRequest.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(setWorkerProfiler_args.class, metaDataMap);
    }

    public setWorkerProfiler_args() {
    }

    public setWorkerProfiler_args(
      String id,
      ProfileRequest profileRequest)
    {
      this();
      this.id = id;
      this.profileRequest = profileRequest;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public setWorkerProfiler_args(setWorkerProfiler_args other) {
      if (other.is_set_id()) {
        this.id = other.id;
      }
      if (other.is_set_profileRequest()) {
        this.profileRequest = new ProfileRequest(other.profileRequest);
      }
    }

    public setWorkerProfiler_args deepCopy() {
      return new setWorkerProfiler_args(this);
    }

    @Override
    public void clear() {
      this.id = null;
      this.profileRequest = null;
    }

    public String get_id() {
      return this.id;
    }

    public void set_id(String id) {
      this.id = id;
    }

    public void unset_id() {
      this.id = null;
    }

    /** Returns true if field id is set (has been assigned a value) and false otherwise */
    public boolean is_set_id() {
      return this.id != null;
    }

    public void set_id_isSet(boolean value) {
      if (!value) {
        this.id = null;
      }
    }

    public ProfileRequest get_profileRequest() {
      return this.profileRequest;
    }

    public void set_profileRequest(ProfileRequest profileRequest) {
      this.profileRequest = profileRequest;
    }

    public void unset_profileRequest() {
      this.profileRequest = null;
    }

    /** Returns true if field profileRequest is set (has been assigned a value) and false otherwise */
    public boolean is_set_profileRequest() {
      return this.profileRequest != null;
    }

    public void set_profileRequest_isSet(boolean value) {
      if (!value) {
        this.profileRequest = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ID:
        if (value == null) {
          unset_id();
        } else {
          set_id((String)value);
        }
        break;

      case PROFILE_REQUEST:
        if (value == null) {
          unset_profileRequest();
        } else {
          set_profileRequest((ProfileRequest)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ID:
        return get_id();

      case PROFILE_REQUEST:
        return get_profileRequest();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ID:
        return is_set_id();
      case PROFILE_REQUEST:
        return is_set_profileRequest();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setWorkerProfiler_args)
        return this.equals((setWorkerProfiler_args)that);
      return false;
    }

    public boolean equals(setWorkerProfiler_args that) {
      if (that == null)
        return false;

      boolean this_present_id = true && this.is_set_id();
      boolean that_present_id = true && that.is_set_id();
      if (this_present_id || that_present_id) {
        if (!(this_present_id && that_present_id))
          return false;
        if (!this.id.equals(that.id))
          return false;
      }

      boolean this_present_profileRequest = true && this.is_set_profileRequest();
      boolean that_present_profileRequest = true && that.is_set_profileRequest();
      if (this_present_profileRequest || that_present_profileRequest) {
        if (!(this_present_profileRequest && that_present_profileRequest))
          return false;
        if (!this.profileRequest.equals(that.profileRequest))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_id = true && (is_set_id());
      list.add(present_id);
      if (present_id)
        list.add(id);

      boolean present_profileRequest = true && (is_set_profileRequest());
      list.add(present_profileRequest);
      if (present_profileRequest)
        list.add(profileRequest);

      return list.hashCode();
    }

    @Override
    public int compareTo(setWorkerProfiler_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_id()).compareTo(other.is_set_id());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_id()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.id, other.id);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_profileRequest()).compareTo(other.is_set_profileRequest());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_profileRequest()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.profileRequest, other.profileRequest);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("setWorkerProfiler_args(");
      boolean first = true;

      sb.append("id:");
      if (this.id == null) {
        sb.append("null");
      } else {
        sb.append(this.id);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("profileRequest:");
      if (this.profileRequest == null) {
        sb.append("null");
      } else {
        sb.append(this.profileRequest);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (profileRequest != null) {
        profileRequest.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class setWorkerProfiler_argsStandardSchemeFactory implements SchemeFactory {
      public setWorkerProfiler_argsStandardScheme getScheme() {
        return new setWorkerProfiler_argsStandardScheme();
      }
    }

    private static class setWorkerProfiler_argsStandardScheme extends StandardScheme<setWorkerProfiler_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, setWorkerProfiler_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.id = iprot.readString();
                struct.set_id_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PROFILE_REQUEST
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.profileRequest = new ProfileRequest();
                struct.profileRequest.read(iprot);
                struct.set_profileRequest_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, setWorkerProfiler_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.id != null) {
          oprot.writeFieldBegin(ID_FIELD_DESC);
          oprot.writeString(struct.id);
          oprot.writeFieldEnd();
        }
        if (struct.profileRequest != null) {
          oprot.writeFieldBegin(PROFILE_REQUEST_FIELD_DESC);
          struct.profileRequest.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class setWorkerProfiler_argsTupleSchemeFactory implements SchemeFactory {
      public setWorkerProfiler_argsTupleScheme getScheme() {
        return new setWorkerProfiler_argsTupleScheme();
      }
    }

    private static class setWorkerProfiler_argsTupleScheme extends TupleScheme<setWorkerProfiler_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, setWorkerProfiler_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_id()) {
          optionals.set(0);
        }
        if (struct.is_set_profileRequest()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_id()) {
          oprot.writeString(struct.id);
        }
        if (struct.is_set_profileRequest()) {
          struct.profileRequest.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, setWorkerProfiler_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.id = iprot.readString();
          struct.set_id_isSet(true);
        }
        if (incoming.get(1)) {
          struct.profileRequest = new ProfileRequest();
          struct.profileRequest.read(iprot);
          struct.set_profileRequest_isSet(true);
        }
      }
    }

  }

  public static class setWorkerProfiler_result implements org.apache.thrift.TBase<setWorkerProfiler_result, setWorkerProfiler_result._Fields>, java.io.Serializable, Cloneable, Comparable<setWorkerProfiler_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("setWorkerProfiler_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new setWorkerProfiler_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new setWorkerProfiler_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(setWorkerProfiler_result.class, metaDataMap);
    }

    public setWorkerProfiler_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public setWorkerProfiler_result(setWorkerProfiler_result other) {
    }

    public setWorkerProfiler_result deepCopy() {
      return new setWorkerProfiler_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setWorkerProfiler_result)
        return this.equals((setWorkerProfiler_result)that);
      return false;
    }

    public boolean equals(setWorkerProfiler_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(setWorkerProfiler_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("setWorkerProfiler_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class setWorkerProfiler_resultStandardSchemeFactory implements SchemeFactory {
      public setWorkerProfiler_resultStandardScheme getScheme() {
        return new setWorkerProfiler_resultStandardScheme();
      }
    }

    private static class setWorkerProfiler_resultStandardScheme extends StandardScheme<setWorkerProfiler_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, setWorkerProfiler_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, setWorkerProfiler_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class setWorkerProfiler_resultTupleSchemeFactory implements SchemeFactory {
      public setWorkerProfiler_resultTupleScheme getScheme() {
        return new setWorkerProfiler_resultTupleScheme();
      }
    }

    private static class setWorkerProfiler_resultTupleScheme extends TupleScheme<setWorkerProfiler_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, setWorkerProfiler_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, setWorkerProfiler_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getComponentPendingProfileActions_args implements org.apache.thrift.TBase<getComponentPendingProfileActions_args, getComponentPendingProfileActions_args._Fields>, java.io.Serializable, Cloneable, Comparable<getComponentPendingProfileActions_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getComponentPendingProfileActions_args");

    private static final org.apache.thrift.protocol.TField ID_FIELD_DESC = new org.apache.thrift.protocol.TField("id", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField COMPONENT_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("component_id", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField ACTION_FIELD_DESC = new org.apache.thrift.protocol.TField("action", org.apache.thrift.protocol.TType.I32, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getComponentPendingProfileActions_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getComponentPendingProfileActions_argsTupleSchemeFactory());
    }

    private String id; // required
    private String component_id; // required
    private ProfileAction action; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ID((short)1, "id"),
      COMPONENT_ID((short)2, "component_id"),
      /**
       * 
       * @see ProfileAction
       */
      ACTION((short)3, "action");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ID
            return ID;
          case 2: // COMPONENT_ID
            return COMPONENT_ID;
          case 3: // ACTION
            return ACTION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ID, new org.apache.thrift.meta_data.FieldMetaData("id", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.COMPONENT_ID, new org.apache.thrift.meta_data.FieldMetaData("component_id", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.ACTION, new org.apache.thrift.meta_data.FieldMetaData("action", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ProfileAction.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getComponentPendingProfileActions_args.class, metaDataMap);
    }

    public getComponentPendingProfileActions_args() {
    }

    public getComponentPendingProfileActions_args(
      String id,
      String component_id,
      ProfileAction action)
    {
      this();
      this.id = id;
      this.component_id = component_id;
      this.action = action;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getComponentPendingProfileActions_args(getComponentPendingProfileActions_args other) {
      if (other.is_set_id()) {
        this.id = other.id;
      }
      if (other.is_set_component_id()) {
        this.component_id = other.component_id;
      }
      if (other.is_set_action()) {
        this.action = other.action;
      }
    }

    public getComponentPendingProfileActions_args deepCopy() {
      return new getComponentPendingProfileActions_args(this);
    }

    @Override
    public void clear() {
      this.id = null;
      this.component_id = null;
      this.action = null;
    }

    public String get_id() {
      return this.id;
    }

    public void set_id(String id) {
      this.id = id;
    }

    public void unset_id() {
      this.id = null;
    }

    /** Returns true if field id is set (has been assigned a value) and false otherwise */
    public boolean is_set_id() {
      return this.id != null;
    }

    public void set_id_isSet(boolean value) {
      if (!value) {
        this.id = null;
      }
    }

    public String get_component_id() {
      return this.component_id;
    }

    public void set_component_id(String component_id) {
      this.component_id = component_id;
    }

    public void unset_component_id() {
      this.component_id = null;
    }

    /** Returns true if field component_id is set (has been assigned a value) and false otherwise */
    public boolean is_set_component_id() {
      return this.component_id != null;
    }

    public void set_component_id_isSet(boolean value) {
      if (!value) {
        this.component_id = null;
      }
    }

    /**
     * 
     * @see ProfileAction
     */
    public ProfileAction get_action() {
      return this.action;
    }

    /**
     * 
     * @see ProfileAction
     */
    public void set_action(ProfileAction action) {
      this.action = action;
    }

    public void unset_action() {
      this.action = null;
    }

    /** Returns true if field action is set (has been assigned a value) and false otherwise */
    public boolean is_set_action() {
      return this.action != null;
    }

    public void set_action_isSet(boolean value) {
      if (!value) {
        this.action = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ID:
        if (value == null) {
          unset_id();
        } else {
          set_id((String)value);
        }
        break;

      case COMPONENT_ID:
        if (value == null) {
          unset_component_id();
        } else {
          set_component_id((String)value);
        }
        break;

      case ACTION:
        if (value == null) {
          unset_action();
        } else {
          set_action((ProfileAction)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ID:
        return get_id();

      case COMPONENT_ID:
        return get_component_id();

      case ACTION:
        return get_action();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ID:
        return is_set_id();
      case COMPONENT_ID:
        return is_set_component_id();
      case ACTION:
        return is_set_action();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getComponentPendingProfileActions_args)
        return this.equals((getComponentPendingProfileActions_args)that);
      return false;
    }

    public boolean equals(getComponentPendingProfileActions_args that) {
      if (that == null)
        return false;

      boolean this_present_id = true && this.is_set_id();
      boolean that_present_id = true && that.is_set_id();
      if (this_present_id || that_present_id) {
        if (!(this_present_id && that_present_id))
          return false;
        if (!this.id.equals(that.id))
          return false;
      }

      boolean this_present_component_id = true && this.is_set_component_id();
      boolean that_present_component_id = true && that.is_set_component_id();
      if (this_present_component_id || that_present_component_id) {
        if (!(this_present_component_id && that_present_component_id))
          return false;
        if (!this.component_id.equals(that.component_id))
          return false;
      }

      boolean this_present_action = true && this.is_set_action();
      boolean that_present_action = true && that.is_set_action();
      if (this_present_action || that_present_action) {
        if (!(this_present_action && that_present_action))
          return false;
        if (!this.action.equals(that.action))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_id = true && (is_set_id());
      list.add(present_id);
      if (present_id)
        list.add(id);

      boolean present_component_id = true && (is_set_component_id());
      list.add(present_component_id);
      if (present_component_id)
        list.add(component_id);

      boolean present_action = true && (is_set_action());
      list.add(present_action);
      if (present_action)
        list.add(action.getValue());

      return list.hashCode();
    }

    @Override
    public int compareTo(getComponentPendingProfileActions_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_id()).compareTo(other.is_set_id());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_id()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.id, other.id);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_component_id()).compareTo(other.is_set_component_id());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_component_id()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.component_id, other.component_id);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_action()).compareTo(other.is_set_action());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_action()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.action, other.action);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getComponentPendingProfileActions_args(");
      boolean first = true;

      sb.append("id:");
      if (this.id == null) {
        sb.append("null");
      } else {
        sb.append(this.id);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("component_id:");
      if (this.component_id == null) {
        sb.append("null");
      } else {
        sb.append(this.component_id);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("action:");
      if (this.action == null) {
        sb.append("null");
      } else {
        sb.append(this.action);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getComponentPendingProfileActions_argsStandardSchemeFactory implements SchemeFactory {
      public getComponentPendingProfileActions_argsStandardScheme getScheme() {
        return new getComponentPendingProfileActions_argsStandardScheme();
      }
    }

    private static class getComponentPendingProfileActions_argsStandardScheme extends StandardScheme<getComponentPendingProfileActions_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getComponentPendingProfileActions_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.id = iprot.readString();
                struct.set_id_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // COMPONENT_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.component_id = iprot.readString();
                struct.set_component_id_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // ACTION
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.action = org.apache.storm.generated.ProfileAction.findByValue(iprot.readI32());
                struct.set_action_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getComponentPendingProfileActions_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.id != null) {
          oprot.writeFieldBegin(ID_FIELD_DESC);
          oprot.writeString(struct.id);
          oprot.writeFieldEnd();
        }
        if (struct.component_id != null) {
          oprot.writeFieldBegin(COMPONENT_ID_FIELD_DESC);
          oprot.writeString(struct.component_id);
          oprot.writeFieldEnd();
        }
        if (struct.action != null) {
          oprot.writeFieldBegin(ACTION_FIELD_DESC);
          oprot.writeI32(struct.action.getValue());
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getComponentPendingProfileActions_argsTupleSchemeFactory implements SchemeFactory {
      public getComponentPendingProfileActions_argsTupleScheme getScheme() {
        return new getComponentPendingProfileActions_argsTupleScheme();
      }
    }

    private static class getComponentPendingProfileActions_argsTupleScheme extends TupleScheme<getComponentPendingProfileActions_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getComponentPendingProfileActions_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_id()) {
          optionals.set(0);
        }
        if (struct.is_set_component_id()) {
          optionals.set(1);
        }
        if (struct.is_set_action()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.is_set_id()) {
          oprot.writeString(struct.id);
        }
        if (struct.is_set_component_id()) {
          oprot.writeString(struct.component_id);
        }
        if (struct.is_set_action()) {
          oprot.writeI32(struct.action.getValue());
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getComponentPendingProfileActions_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.id = iprot.readString();
          struct.set_id_isSet(true);
        }
        if (incoming.get(1)) {
          struct.component_id = iprot.readString();
          struct.set_component_id_isSet(true);
        }
        if (incoming.get(2)) {
          struct.action = org.apache.storm.generated.ProfileAction.findByValue(iprot.readI32());
          struct.set_action_isSet(true);
        }
      }
    }

  }

  public static class getComponentPendingProfileActions_result implements org.apache.thrift.TBase<getComponentPendingProfileActions_result, getComponentPendingProfileActions_result._Fields>, java.io.Serializable, Cloneable, Comparable<getComponentPendingProfileActions_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getComponentPendingProfileActions_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getComponentPendingProfileActions_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getComponentPendingProfileActions_resultTupleSchemeFactory());
    }

    private List<ProfileRequest> success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ProfileRequest.class))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getComponentPendingProfileActions_result.class, metaDataMap);
    }

    public getComponentPendingProfileActions_result() {
    }

    public getComponentPendingProfileActions_result(
      List<ProfileRequest> success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getComponentPendingProfileActions_result(getComponentPendingProfileActions_result other) {
      if (other.is_set_success()) {
        List<ProfileRequest> __this__success = new ArrayList<ProfileRequest>(other.success.size());
        for (ProfileRequest other_element : other.success) {
          __this__success.add(new ProfileRequest(other_element));
        }
        this.success = __this__success;
      }
    }

    public getComponentPendingProfileActions_result deepCopy() {
      return new getComponentPendingProfileActions_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public int get_success_size() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<ProfileRequest> get_success_iterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void add_to_success(ProfileRequest elem) {
      if (this.success == null) {
        this.success = new ArrayList<ProfileRequest>();
      }
      this.success.add(elem);
    }

    public List<ProfileRequest> get_success() {
      return this.success;
    }

    public void set_success(List<ProfileRequest> success) {
      this.success = success;
    }

    public void unset_success() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean is_set_success() {
      return this.success != null;
    }

    public void set_success_isSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unset_success();
        } else {
          set_success((List<ProfileRequest>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return get_success();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return is_set_success();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getComponentPendingProfileActions_result)
        return this.equals((getComponentPendingProfileActions_result)that);
      return false;
    }

    public boolean equals(getComponentPendingProfileActions_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.is_set_success();
      boolean that_present_success = true && that.is_set_success();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (is_set_success());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(getComponentPendingProfileActions_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_success()).compareTo(other.is_set_success());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_success()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getComponentPendingProfileActions_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getComponentPendingProfileActions_resultStandardSchemeFactory implements SchemeFactory {
      public getComponentPendingProfileActions_resultStandardScheme getScheme() {
        return new getComponentPendingProfileActions_resultStandardScheme();
      }
    }

    private static class getComponentPendingProfileActions_resultStandardScheme extends StandardScheme<getComponentPendingProfileActions_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getComponentPendingProfileActions_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list738 = iprot.readListBegin();
                  struct.success = new ArrayList<ProfileRequest>(_list738.size);
                  ProfileRequest _elem739;
                  for (int _i740 = 0; _i740 < _list738.size; ++_i740)
                  {
                    _elem739 = new ProfileRequest();
                    _elem739.read(iprot);
                    struct.success.add(_elem739);
                  }
                  iprot.readListEnd();
                }
                struct.set_success_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getComponentPendingProfileActions_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (ProfileRequest _iter741 : struct.success)
            {
              _iter741.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getComponentPendingProfileActions_resultTupleSchemeFactory implements SchemeFactory {
      public getComponentPendingProfileActions_resultTupleScheme getScheme() {
        return new getComponentPendingProfileActions_resultTupleScheme();
      }
    }

    private static class getComponentPendingProfileActions_resultTupleScheme extends TupleScheme<getComponentPendingProfileActions_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getComponentPendingProfileActions_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_success()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_success()) {
          {
            oprot.writeI32(struct.success.size());
            for (ProfileRequest _iter742 : struct.success)
            {
              _iter742.write(oprot);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getComponentPendingProfileActions_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list743 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<ProfileRequest>(_list743.size);
            ProfileRequest _elem744;
            for (int _i745 = 0; _i745 < _list743.size; ++_i745)
            {
              _elem744 = new ProfileRequest();
              _elem744.read(iprot);
              struct.success.add(_elem744);
            }
          }
          struct.set_success_isSet(true);
        }
      }
    }

  }

  public static class uploadNewCredentials_args implements org.apache.thrift.TBase<uploadNewCredentials_args, uploadNewCredentials_args._Fields>, java.io.Serializable, Cloneable, Comparable<uploadNewCredentials_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("uploadNewCredentials_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField CREDS_FIELD_DESC = new org.apache.thrift.protocol.TField("creds", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new uploadNewCredentials_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new uploadNewCredentials_argsTupleSchemeFactory());
    }

    private String name; // required
    private Credentials creds; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name"),
      CREDS((short)2, "creds");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          case 2: // CREDS
            return CREDS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CREDS, new org.apache.thrift.meta_data.FieldMetaData("creds", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Credentials.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(uploadNewCredentials_args.class, metaDataMap);
    }

    public uploadNewCredentials_args() {
    }

    public uploadNewCredentials_args(
      String name,
      Credentials creds)
    {
      this();
      this.name = name;
      this.creds = creds;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public uploadNewCredentials_args(uploadNewCredentials_args other) {
      if (other.is_set_name()) {
        this.name = other.name;
      }
      if (other.is_set_creds()) {
        this.creds = new Credentials(other.creds);
      }
    }

    public uploadNewCredentials_args deepCopy() {
      return new uploadNewCredentials_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
      this.creds = null;
    }

    public String get_name() {
      return this.name;
    }

    public void set_name(String name) {
      this.name = name;
    }

    public void unset_name() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean is_set_name() {
      return this.name != null;
    }

    public void set_name_isSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public Credentials get_creds() {
      return this.creds;
    }

    public void set_creds(Credentials creds) {
      this.creds = creds;
    }

    public void unset_creds() {
      this.creds = null;
    }

    /** Returns true if field creds is set (has been assigned a value) and false otherwise */
    public boolean is_set_creds() {
      return this.creds != null;
    }

    public void set_creds_isSet(boolean value) {
      if (!value) {
        this.creds = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unset_name();
        } else {
          set_name((String)value);
        }
        break;

      case CREDS:
        if (value == null) {
          unset_creds();
        } else {
          set_creds((Credentials)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return get_name();

      case CREDS:
        return get_creds();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return is_set_name();
      case CREDS:
        return is_set_creds();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof uploadNewCredentials_args)
        return this.equals((uploadNewCredentials_args)that);
      return false;
    }

    public boolean equals(uploadNewCredentials_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.is_set_name();
      boolean that_present_name = true && that.is_set_name();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      boolean this_present_creds = true && this.is_set_creds();
      boolean that_present_creds = true && that.is_set_creds();
      if (this_present_creds || that_present_creds) {
        if (!(this_present_creds && that_present_creds))
          return false;
        if (!this.creds.equals(that.creds))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (is_set_name());
      list.add(present_name);
      if (present_name)
        list.add(name);

      boolean present_creds = true && (is_set_creds());
      list.add(present_creds);
      if (present_creds)
        list.add(creds);

      return list.hashCode();
    }

    @Override
    public int compareTo(uploadNewCredentials_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_name()).compareTo(other.is_set_name());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_name()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_creds()).compareTo(other.is_set_creds());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_creds()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.creds, other.creds);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("uploadNewCredentials_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("creds:");
      if (this.creds == null) {
        sb.append("null");
      } else {
        sb.append(this.creds);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (creds != null) {
        creds.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class uploadNewCredentials_argsStandardSchemeFactory implements SchemeFactory {
      public uploadNewCredentials_argsStandardScheme getScheme() {
        return new uploadNewCredentials_argsStandardScheme();
      }
    }

    private static class uploadNewCredentials_argsStandardScheme extends StandardScheme<uploadNewCredentials_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, uploadNewCredentials_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.set_name_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CREDS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.creds = new Credentials();
                struct.creds.read(iprot);
                struct.set_creds_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, uploadNewCredentials_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.creds != null) {
          oprot.writeFieldBegin(CREDS_FIELD_DESC);
          struct.creds.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class uploadNewCredentials_argsTupleSchemeFactory implements SchemeFactory {
      public uploadNewCredentials_argsTupleScheme getScheme() {
        return new uploadNewCredentials_argsTupleScheme();
      }
    }

    private static class uploadNewCredentials_argsTupleScheme extends TupleScheme<uploadNewCredentials_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, uploadNewCredentials_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_name()) {
          optionals.set(0);
        }
        if (struct.is_set_creds()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_name()) {
          oprot.writeString(struct.name);
        }
        if (struct.is_set_creds()) {
          struct.creds.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, uploadNewCredentials_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.set_name_isSet(true);
        }
        if (incoming.get(1)) {
          struct.creds = new Credentials();
          struct.creds.read(iprot);
          struct.set_creds_isSet(true);
        }
      }
    }

  }

  public static class uploadNewCredentials_result implements org.apache.thrift.TBase<uploadNewCredentials_result, uploadNewCredentials_result._Fields>, java.io.Serializable, Cloneable, Comparable<uploadNewCredentials_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("uploadNewCredentials_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField ITE_FIELD_DESC = new org.apache.thrift.protocol.TField("ite", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new uploadNewCredentials_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new uploadNewCredentials_resultTupleSchemeFactory());
    }

    private NotAliveException e; // required
    private InvalidTopologyException ite; // required
    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e"),
      ITE((short)2, "ite"),
      AZE((short)3, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          case 2: // ITE
            return ITE;
          case 3: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.ITE, new org.apache.thrift.meta_data.FieldMetaData("ite", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(uploadNewCredentials_result.class, metaDataMap);
    }

    public uploadNewCredentials_result() {
    }

    public uploadNewCredentials_result(
      NotAliveException e,
      InvalidTopologyException ite,
      AuthorizationException aze)
    {
      this();
      this.e = e;
      this.ite = ite;
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public uploadNewCredentials_result(uploadNewCredentials_result other) {
      if (other.is_set_e()) {
        this.e = new NotAliveException(other.e);
      }
      if (other.is_set_ite()) {
        this.ite = new InvalidTopologyException(other.ite);
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public uploadNewCredentials_result deepCopy() {
      return new uploadNewCredentials_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
      this.ite = null;
      this.aze = null;
    }

    public NotAliveException get_e() {
      return this.e;
    }

    public void set_e(NotAliveException e) {
      this.e = e;
    }

    public void unset_e() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean is_set_e() {
      return this.e != null;
    }

    public void set_e_isSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public InvalidTopologyException get_ite() {
      return this.ite;
    }

    public void set_ite(InvalidTopologyException ite) {
      this.ite = ite;
    }

    public void unset_ite() {
      this.ite = null;
    }

    /** Returns true if field ite is set (has been assigned a value) and false otherwise */
    public boolean is_set_ite() {
      return this.ite != null;
    }

    public void set_ite_isSet(boolean value) {
      if (!value) {
        this.ite = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unset_e();
        } else {
          set_e((NotAliveException)value);
        }
        break;

      case ITE:
        if (value == null) {
          unset_ite();
        } else {
          set_ite((InvalidTopologyException)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return get_e();

      case ITE:
        return get_ite();

      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return is_set_e();
      case ITE:
        return is_set_ite();
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof uploadNewCredentials_result)
        return this.equals((uploadNewCredentials_result)that);
      return false;
    }

    public boolean equals(uploadNewCredentials_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.is_set_e();
      boolean that_present_e = true && that.is_set_e();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      boolean this_present_ite = true && this.is_set_ite();
      boolean that_present_ite = true && that.is_set_ite();
      if (this_present_ite || that_present_ite) {
        if (!(this_present_ite && that_present_ite))
          return false;
        if (!this.ite.equals(that.ite))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_e = true && (is_set_e());
      list.add(present_e);
      if (present_e)
        list.add(e);

      boolean present_ite = true && (is_set_ite());
      list.add(present_ite);
      if (present_ite)
        list.add(ite);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(uploadNewCredentials_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_e()).compareTo(other.is_set_e());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_e()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_ite()).compareTo(other.is_set_ite());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_ite()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ite, other.ite);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("uploadNewCredentials_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ite:");
      if (this.ite == null) {
        sb.append("null");
      } else {
        sb.append(this.ite);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class uploadNewCredentials_resultStandardSchemeFactory implements SchemeFactory {
      public uploadNewCredentials_resultStandardScheme getScheme() {
        return new uploadNewCredentials_resultStandardScheme();
      }
    }

    private static class uploadNewCredentials_resultStandardScheme extends StandardScheme<uploadNewCredentials_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, uploadNewCredentials_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new NotAliveException();
                struct.e.read(iprot);
                struct.set_e_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ITE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ite = new InvalidTopologyException();
                struct.ite.read(iprot);
                struct.set_ite_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, uploadNewCredentials_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ite != null) {
          oprot.writeFieldBegin(ITE_FIELD_DESC);
          struct.ite.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class uploadNewCredentials_resultTupleSchemeFactory implements SchemeFactory {
      public uploadNewCredentials_resultTupleScheme getScheme() {
        return new uploadNewCredentials_resultTupleScheme();
      }
    }

    private static class uploadNewCredentials_resultTupleScheme extends TupleScheme<uploadNewCredentials_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, uploadNewCredentials_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_e()) {
          optionals.set(0);
        }
        if (struct.is_set_ite()) {
          optionals.set(1);
        }
        if (struct.is_set_aze()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.is_set_e()) {
          struct.e.write(oprot);
        }
        if (struct.is_set_ite()) {
          struct.ite.write(oprot);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, uploadNewCredentials_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.e = new NotAliveException();
          struct.e.read(iprot);
          struct.set_e_isSet(true);
        }
        if (incoming.get(1)) {
          struct.ite = new InvalidTopologyException();
          struct.ite.read(iprot);
          struct.set_ite_isSet(true);
        }
        if (incoming.get(2)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class beginCreateBlob_args implements org.apache.thrift.TBase<beginCreateBlob_args, beginCreateBlob_args._Fields>, java.io.Serializable, Cloneable, Comparable<beginCreateBlob_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("beginCreateBlob_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField META_FIELD_DESC = new org.apache.thrift.protocol.TField("meta", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new beginCreateBlob_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new beginCreateBlob_argsTupleSchemeFactory());
    }

    private String key; // required
    private SettableBlobMeta meta; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key"),
      META((short)2, "meta");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 2: // META
            return META;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.META, new org.apache.thrift.meta_data.FieldMetaData("meta", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, SettableBlobMeta.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(beginCreateBlob_args.class, metaDataMap);
    }

    public beginCreateBlob_args() {
    }

    public beginCreateBlob_args(
      String key,
      SettableBlobMeta meta)
    {
      this();
      this.key = key;
      this.meta = meta;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public beginCreateBlob_args(beginCreateBlob_args other) {
      if (other.is_set_key()) {
        this.key = other.key;
      }
      if (other.is_set_meta()) {
        this.meta = new SettableBlobMeta(other.meta);
      }
    }

    public beginCreateBlob_args deepCopy() {
      return new beginCreateBlob_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.meta = null;
    }

    public String get_key() {
      return this.key;
    }

    public void set_key(String key) {
      this.key = key;
    }

    public void unset_key() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean is_set_key() {
      return this.key != null;
    }

    public void set_key_isSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public SettableBlobMeta get_meta() {
      return this.meta;
    }

    public void set_meta(SettableBlobMeta meta) {
      this.meta = meta;
    }

    public void unset_meta() {
      this.meta = null;
    }

    /** Returns true if field meta is set (has been assigned a value) and false otherwise */
    public boolean is_set_meta() {
      return this.meta != null;
    }

    public void set_meta_isSet(boolean value) {
      if (!value) {
        this.meta = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unset_key();
        } else {
          set_key((String)value);
        }
        break;

      case META:
        if (value == null) {
          unset_meta();
        } else {
          set_meta((SettableBlobMeta)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return get_key();

      case META:
        return get_meta();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return is_set_key();
      case META:
        return is_set_meta();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof beginCreateBlob_args)
        return this.equals((beginCreateBlob_args)that);
      return false;
    }

    public boolean equals(beginCreateBlob_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.is_set_key();
      boolean that_present_key = true && that.is_set_key();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_meta = true && this.is_set_meta();
      boolean that_present_meta = true && that.is_set_meta();
      if (this_present_meta || that_present_meta) {
        if (!(this_present_meta && that_present_meta))
          return false;
        if (!this.meta.equals(that.meta))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (is_set_key());
      list.add(present_key);
      if (present_key)
        list.add(key);

      boolean present_meta = true && (is_set_meta());
      list.add(present_meta);
      if (present_meta)
        list.add(meta);

      return list.hashCode();
    }

    @Override
    public int compareTo(beginCreateBlob_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_key()).compareTo(other.is_set_key());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_key()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_meta()).compareTo(other.is_set_meta());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_meta()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.meta, other.meta);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("beginCreateBlob_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("meta:");
      if (this.meta == null) {
        sb.append("null");
      } else {
        sb.append(this.meta);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (meta != null) {
        meta.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class beginCreateBlob_argsStandardSchemeFactory implements SchemeFactory {
      public beginCreateBlob_argsStandardScheme getScheme() {
        return new beginCreateBlob_argsStandardScheme();
      }
    }

    private static class beginCreateBlob_argsStandardScheme extends StandardScheme<beginCreateBlob_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, beginCreateBlob_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.key = iprot.readString();
                struct.set_key_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // META
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.meta = new SettableBlobMeta();
                struct.meta.read(iprot);
                struct.set_meta_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, beginCreateBlob_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          oprot.writeString(struct.key);
          oprot.writeFieldEnd();
        }
        if (struct.meta != null) {
          oprot.writeFieldBegin(META_FIELD_DESC);
          struct.meta.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class beginCreateBlob_argsTupleSchemeFactory implements SchemeFactory {
      public beginCreateBlob_argsTupleScheme getScheme() {
        return new beginCreateBlob_argsTupleScheme();
      }
    }

    private static class beginCreateBlob_argsTupleScheme extends TupleScheme<beginCreateBlob_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, beginCreateBlob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_key()) {
          optionals.set(0);
        }
        if (struct.is_set_meta()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_key()) {
          oprot.writeString(struct.key);
        }
        if (struct.is_set_meta()) {
          struct.meta.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, beginCreateBlob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.key = iprot.readString();
          struct.set_key_isSet(true);
        }
        if (incoming.get(1)) {
          struct.meta = new SettableBlobMeta();
          struct.meta.read(iprot);
          struct.set_meta_isSet(true);
        }
      }
    }

  }

  public static class beginCreateBlob_result implements org.apache.thrift.TBase<beginCreateBlob_result, beginCreateBlob_result._Fields>, java.io.Serializable, Cloneable, Comparable<beginCreateBlob_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("beginCreateBlob_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField KAE_FIELD_DESC = new org.apache.thrift.protocol.TField("kae", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new beginCreateBlob_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new beginCreateBlob_resultTupleSchemeFactory());
    }

    private String success; // required
    private AuthorizationException aze; // required
    private KeyAlreadyExistsException kae; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      AZE((short)1, "aze"),
      KAE((short)2, "kae");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // AZE
            return AZE;
          case 2: // KAE
            return KAE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.KAE, new org.apache.thrift.meta_data.FieldMetaData("kae", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(beginCreateBlob_result.class, metaDataMap);
    }

    public beginCreateBlob_result() {
    }

    public beginCreateBlob_result(
      String success,
      AuthorizationException aze,
      KeyAlreadyExistsException kae)
    {
      this();
      this.success = success;
      this.aze = aze;
      this.kae = kae;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public beginCreateBlob_result(beginCreateBlob_result other) {
      if (other.is_set_success()) {
        this.success = other.success;
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
      if (other.is_set_kae()) {
        this.kae = new KeyAlreadyExistsException(other.kae);
      }
    }

    public beginCreateBlob_result deepCopy() {
      return new beginCreateBlob_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.aze = null;
      this.kae = null;
    }

    public String get_success() {
      return this.success;
    }

    public void set_success(String success) {
      this.success = success;
    }

    public void unset_success() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean is_set_success() {
      return this.success != null;
    }

    public void set_success_isSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public KeyAlreadyExistsException get_kae() {
      return this.kae;
    }

    public void set_kae(KeyAlreadyExistsException kae) {
      this.kae = kae;
    }

    public void unset_kae() {
      this.kae = null;
    }

    /** Returns true if field kae is set (has been assigned a value) and false otherwise */
    public boolean is_set_kae() {
      return this.kae != null;
    }

    public void set_kae_isSet(boolean value) {
      if (!value) {
        this.kae = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unset_success();
        } else {
          set_success((String)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      case KAE:
        if (value == null) {
          unset_kae();
        } else {
          set_kae((KeyAlreadyExistsException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return get_success();

      case AZE:
        return get_aze();

      case KAE:
        return get_kae();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return is_set_success();
      case AZE:
        return is_set_aze();
      case KAE:
        return is_set_kae();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof beginCreateBlob_result)
        return this.equals((beginCreateBlob_result)that);
      return false;
    }

    public boolean equals(beginCreateBlob_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.is_set_success();
      boolean that_present_success = true && that.is_set_success();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      boolean this_present_kae = true && this.is_set_kae();
      boolean that_present_kae = true && that.is_set_kae();
      if (this_present_kae || that_present_kae) {
        if (!(this_present_kae && that_present_kae))
          return false;
        if (!this.kae.equals(that.kae))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (is_set_success());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      boolean present_kae = true && (is_set_kae());
      list.add(present_kae);
      if (present_kae)
        list.add(kae);

      return list.hashCode();
    }

    @Override
    public int compareTo(beginCreateBlob_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_success()).compareTo(other.is_set_success());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_success()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_kae()).compareTo(other.is_set_kae());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_kae()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.kae, other.kae);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("beginCreateBlob_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("kae:");
      if (this.kae == null) {
        sb.append("null");
      } else {
        sb.append(this.kae);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class beginCreateBlob_resultStandardSchemeFactory implements SchemeFactory {
      public beginCreateBlob_resultStandardScheme getScheme() {
        return new beginCreateBlob_resultStandardScheme();
      }
    }

    private static class beginCreateBlob_resultStandardScheme extends StandardScheme<beginCreateBlob_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, beginCreateBlob_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.set_success_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // KAE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.kae = new KeyAlreadyExistsException();
                struct.kae.read(iprot);
                struct.set_kae_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, beginCreateBlob_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.kae != null) {
          oprot.writeFieldBegin(KAE_FIELD_DESC);
          struct.kae.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class beginCreateBlob_resultTupleSchemeFactory implements SchemeFactory {
      public beginCreateBlob_resultTupleScheme getScheme() {
        return new beginCreateBlob_resultTupleScheme();
      }
    }

    private static class beginCreateBlob_resultTupleScheme extends TupleScheme<beginCreateBlob_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, beginCreateBlob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_success()) {
          optionals.set(0);
        }
        if (struct.is_set_aze()) {
          optionals.set(1);
        }
        if (struct.is_set_kae()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.is_set_success()) {
          oprot.writeString(struct.success);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
        if (struct.is_set_kae()) {
          struct.kae.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, beginCreateBlob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.set_success_isSet(true);
        }
        if (incoming.get(1)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
        if (incoming.get(2)) {
          struct.kae = new KeyAlreadyExistsException();
          struct.kae.read(iprot);
          struct.set_kae_isSet(true);
        }
      }
    }

  }

  public static class beginUpdateBlob_args implements org.apache.thrift.TBase<beginUpdateBlob_args, beginUpdateBlob_args._Fields>, java.io.Serializable, Cloneable, Comparable<beginUpdateBlob_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("beginUpdateBlob_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new beginUpdateBlob_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new beginUpdateBlob_argsTupleSchemeFactory());
    }

    private String key; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(beginUpdateBlob_args.class, metaDataMap);
    }

    public beginUpdateBlob_args() {
    }

    public beginUpdateBlob_args(
      String key)
    {
      this();
      this.key = key;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public beginUpdateBlob_args(beginUpdateBlob_args other) {
      if (other.is_set_key()) {
        this.key = other.key;
      }
    }

    public beginUpdateBlob_args deepCopy() {
      return new beginUpdateBlob_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
    }

    public String get_key() {
      return this.key;
    }

    public void set_key(String key) {
      this.key = key;
    }

    public void unset_key() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean is_set_key() {
      return this.key != null;
    }

    public void set_key_isSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unset_key();
        } else {
          set_key((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return get_key();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return is_set_key();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof beginUpdateBlob_args)
        return this.equals((beginUpdateBlob_args)that);
      return false;
    }

    public boolean equals(beginUpdateBlob_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.is_set_key();
      boolean that_present_key = true && that.is_set_key();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (is_set_key());
      list.add(present_key);
      if (present_key)
        list.add(key);

      return list.hashCode();
    }

    @Override
    public int compareTo(beginUpdateBlob_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_key()).compareTo(other.is_set_key());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_key()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("beginUpdateBlob_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class beginUpdateBlob_argsStandardSchemeFactory implements SchemeFactory {
      public beginUpdateBlob_argsStandardScheme getScheme() {
        return new beginUpdateBlob_argsStandardScheme();
      }
    }

    private static class beginUpdateBlob_argsStandardScheme extends StandardScheme<beginUpdateBlob_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, beginUpdateBlob_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.key = iprot.readString();
                struct.set_key_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, beginUpdateBlob_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          oprot.writeString(struct.key);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class beginUpdateBlob_argsTupleSchemeFactory implements SchemeFactory {
      public beginUpdateBlob_argsTupleScheme getScheme() {
        return new beginUpdateBlob_argsTupleScheme();
      }
    }

    private static class beginUpdateBlob_argsTupleScheme extends TupleScheme<beginUpdateBlob_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, beginUpdateBlob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_key()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_key()) {
          oprot.writeString(struct.key);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, beginUpdateBlob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.key = iprot.readString();
          struct.set_key_isSet(true);
        }
      }
    }

  }

  public static class beginUpdateBlob_result implements org.apache.thrift.TBase<beginUpdateBlob_result, beginUpdateBlob_result._Fields>, java.io.Serializable, Cloneable, Comparable<beginUpdateBlob_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("beginUpdateBlob_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField KNF_FIELD_DESC = new org.apache.thrift.protocol.TField("knf", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new beginUpdateBlob_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new beginUpdateBlob_resultTupleSchemeFactory());
    }

    private String success; // required
    private AuthorizationException aze; // required
    private KeyNotFoundException knf; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      AZE((short)1, "aze"),
      KNF((short)2, "knf");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // AZE
            return AZE;
          case 2: // KNF
            return KNF;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.KNF, new org.apache.thrift.meta_data.FieldMetaData("knf", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(beginUpdateBlob_result.class, metaDataMap);
    }

    public beginUpdateBlob_result() {
    }

    public beginUpdateBlob_result(
      String success,
      AuthorizationException aze,
      KeyNotFoundException knf)
    {
      this();
      this.success = success;
      this.aze = aze;
      this.knf = knf;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public beginUpdateBlob_result(beginUpdateBlob_result other) {
      if (other.is_set_success()) {
        this.success = other.success;
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
      if (other.is_set_knf()) {
        this.knf = new KeyNotFoundException(other.knf);
      }
    }

    public beginUpdateBlob_result deepCopy() {
      return new beginUpdateBlob_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.aze = null;
      this.knf = null;
    }

    public String get_success() {
      return this.success;
    }

    public void set_success(String success) {
      this.success = success;
    }

    public void unset_success() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean is_set_success() {
      return this.success != null;
    }

    public void set_success_isSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public KeyNotFoundException get_knf() {
      return this.knf;
    }

    public void set_knf(KeyNotFoundException knf) {
      this.knf = knf;
    }

    public void unset_knf() {
      this.knf = null;
    }

    /** Returns true if field knf is set (has been assigned a value) and false otherwise */
    public boolean is_set_knf() {
      return this.knf != null;
    }

    public void set_knf_isSet(boolean value) {
      if (!value) {
        this.knf = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unset_success();
        } else {
          set_success((String)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      case KNF:
        if (value == null) {
          unset_knf();
        } else {
          set_knf((KeyNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return get_success();

      case AZE:
        return get_aze();

      case KNF:
        return get_knf();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return is_set_success();
      case AZE:
        return is_set_aze();
      case KNF:
        return is_set_knf();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof beginUpdateBlob_result)
        return this.equals((beginUpdateBlob_result)that);
      return false;
    }

    public boolean equals(beginUpdateBlob_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.is_set_success();
      boolean that_present_success = true && that.is_set_success();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      boolean this_present_knf = true && this.is_set_knf();
      boolean that_present_knf = true && that.is_set_knf();
      if (this_present_knf || that_present_knf) {
        if (!(this_present_knf && that_present_knf))
          return false;
        if (!this.knf.equals(that.knf))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (is_set_success());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      boolean present_knf = true && (is_set_knf());
      list.add(present_knf);
      if (present_knf)
        list.add(knf);

      return list.hashCode();
    }

    @Override
    public int compareTo(beginUpdateBlob_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_success()).compareTo(other.is_set_success());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_success()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_knf()).compareTo(other.is_set_knf());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_knf()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.knf, other.knf);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("beginUpdateBlob_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("knf:");
      if (this.knf == null) {
        sb.append("null");
      } else {
        sb.append(this.knf);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class beginUpdateBlob_resultStandardSchemeFactory implements SchemeFactory {
      public beginUpdateBlob_resultStandardScheme getScheme() {
        return new beginUpdateBlob_resultStandardScheme();
      }
    }

    private static class beginUpdateBlob_resultStandardScheme extends StandardScheme<beginUpdateBlob_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, beginUpdateBlob_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.set_success_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // KNF
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.knf = new KeyNotFoundException();
                struct.knf.read(iprot);
                struct.set_knf_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, beginUpdateBlob_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.knf != null) {
          oprot.writeFieldBegin(KNF_FIELD_DESC);
          struct.knf.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class beginUpdateBlob_resultTupleSchemeFactory implements SchemeFactory {
      public beginUpdateBlob_resultTupleScheme getScheme() {
        return new beginUpdateBlob_resultTupleScheme();
      }
    }

    private static class beginUpdateBlob_resultTupleScheme extends TupleScheme<beginUpdateBlob_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, beginUpdateBlob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_success()) {
          optionals.set(0);
        }
        if (struct.is_set_aze()) {
          optionals.set(1);
        }
        if (struct.is_set_knf()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.is_set_success()) {
          oprot.writeString(struct.success);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
        if (struct.is_set_knf()) {
          struct.knf.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, beginUpdateBlob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.set_success_isSet(true);
        }
        if (incoming.get(1)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
        if (incoming.get(2)) {
          struct.knf = new KeyNotFoundException();
          struct.knf.read(iprot);
          struct.set_knf_isSet(true);
        }
      }
    }

  }

  public static class uploadBlobChunk_args implements org.apache.thrift.TBase<uploadBlobChunk_args, uploadBlobChunk_args._Fields>, java.io.Serializable, Cloneable, Comparable<uploadBlobChunk_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("uploadBlobChunk_args");

    private static final org.apache.thrift.protocol.TField SESSION_FIELD_DESC = new org.apache.thrift.protocol.TField("session", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField CHUNK_FIELD_DESC = new org.apache.thrift.protocol.TField("chunk", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new uploadBlobChunk_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new uploadBlobChunk_argsTupleSchemeFactory());
    }

    private String session; // required
    private ByteBuffer chunk; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SESSION((short)1, "session"),
      CHUNK((short)2, "chunk");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SESSION
            return SESSION;
          case 2: // CHUNK
            return CHUNK;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SESSION, new org.apache.thrift.meta_data.FieldMetaData("session", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CHUNK, new org.apache.thrift.meta_data.FieldMetaData("chunk", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(uploadBlobChunk_args.class, metaDataMap);
    }

    public uploadBlobChunk_args() {
    }

    public uploadBlobChunk_args(
      String session,
      ByteBuffer chunk)
    {
      this();
      this.session = session;
      this.chunk = org.apache.thrift.TBaseHelper.copyBinary(chunk);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public uploadBlobChunk_args(uploadBlobChunk_args other) {
      if (other.is_set_session()) {
        this.session = other.session;
      }
      if (other.is_set_chunk()) {
        this.chunk = org.apache.thrift.TBaseHelper.copyBinary(other.chunk);
      }
    }

    public uploadBlobChunk_args deepCopy() {
      return new uploadBlobChunk_args(this);
    }

    @Override
    public void clear() {
      this.session = null;
      this.chunk = null;
    }

    public String get_session() {
      return this.session;
    }

    public void set_session(String session) {
      this.session = session;
    }

    public void unset_session() {
      this.session = null;
    }

    /** Returns true if field session is set (has been assigned a value) and false otherwise */
    public boolean is_set_session() {
      return this.session != null;
    }

    public void set_session_isSet(boolean value) {
      if (!value) {
        this.session = null;
      }
    }

    public byte[] get_chunk() {
      set_chunk(org.apache.thrift.TBaseHelper.rightSize(chunk));
      return chunk == null ? null : chunk.array();
    }

    public ByteBuffer buffer_for_chunk() {
      return org.apache.thrift.TBaseHelper.copyBinary(chunk);
    }

    public void set_chunk(byte[] chunk) {
      this.chunk = chunk == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(chunk, chunk.length));
    }

    public void set_chunk(ByteBuffer chunk) {
      this.chunk = org.apache.thrift.TBaseHelper.copyBinary(chunk);
    }

    public void unset_chunk() {
      this.chunk = null;
    }

    /** Returns true if field chunk is set (has been assigned a value) and false otherwise */
    public boolean is_set_chunk() {
      return this.chunk != null;
    }

    public void set_chunk_isSet(boolean value) {
      if (!value) {
        this.chunk = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SESSION:
        if (value == null) {
          unset_session();
        } else {
          set_session((String)value);
        }
        break;

      case CHUNK:
        if (value == null) {
          unset_chunk();
        } else {
          set_chunk((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SESSION:
        return get_session();

      case CHUNK:
        return get_chunk();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SESSION:
        return is_set_session();
      case CHUNK:
        return is_set_chunk();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof uploadBlobChunk_args)
        return this.equals((uploadBlobChunk_args)that);
      return false;
    }

    public boolean equals(uploadBlobChunk_args that) {
      if (that == null)
        return false;

      boolean this_present_session = true && this.is_set_session();
      boolean that_present_session = true && that.is_set_session();
      if (this_present_session || that_present_session) {
        if (!(this_present_session && that_present_session))
          return false;
        if (!this.session.equals(that.session))
          return false;
      }

      boolean this_present_chunk = true && this.is_set_chunk();
      boolean that_present_chunk = true && that.is_set_chunk();
      if (this_present_chunk || that_present_chunk) {
        if (!(this_present_chunk && that_present_chunk))
          return false;
        if (!this.chunk.equals(that.chunk))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_session = true && (is_set_session());
      list.add(present_session);
      if (present_session)
        list.add(session);

      boolean present_chunk = true && (is_set_chunk());
      list.add(present_chunk);
      if (present_chunk)
        list.add(chunk);

      return list.hashCode();
    }

    @Override
    public int compareTo(uploadBlobChunk_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_session()).compareTo(other.is_set_session());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_session()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.session, other.session);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_chunk()).compareTo(other.is_set_chunk());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_chunk()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.chunk, other.chunk);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("uploadBlobChunk_args(");
      boolean first = true;

      sb.append("session:");
      if (this.session == null) {
        sb.append("null");
      } else {
        sb.append(this.session);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("chunk:");
      if (this.chunk == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.chunk, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class uploadBlobChunk_argsStandardSchemeFactory implements SchemeFactory {
      public uploadBlobChunk_argsStandardScheme getScheme() {
        return new uploadBlobChunk_argsStandardScheme();
      }
    }

    private static class uploadBlobChunk_argsStandardScheme extends StandardScheme<uploadBlobChunk_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, uploadBlobChunk_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SESSION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.session = iprot.readString();
                struct.set_session_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CHUNK
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.chunk = iprot.readBinary();
                struct.set_chunk_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, uploadBlobChunk_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.session != null) {
          oprot.writeFieldBegin(SESSION_FIELD_DESC);
          oprot.writeString(struct.session);
          oprot.writeFieldEnd();
        }
        if (struct.chunk != null) {
          oprot.writeFieldBegin(CHUNK_FIELD_DESC);
          oprot.writeBinary(struct.chunk);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class uploadBlobChunk_argsTupleSchemeFactory implements SchemeFactory {
      public uploadBlobChunk_argsTupleScheme getScheme() {
        return new uploadBlobChunk_argsTupleScheme();
      }
    }

    private static class uploadBlobChunk_argsTupleScheme extends TupleScheme<uploadBlobChunk_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, uploadBlobChunk_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_session()) {
          optionals.set(0);
        }
        if (struct.is_set_chunk()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_session()) {
          oprot.writeString(struct.session);
        }
        if (struct.is_set_chunk()) {
          oprot.writeBinary(struct.chunk);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, uploadBlobChunk_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.session = iprot.readString();
          struct.set_session_isSet(true);
        }
        if (incoming.get(1)) {
          struct.chunk = iprot.readBinary();
          struct.set_chunk_isSet(true);
        }
      }
    }

  }

  public static class uploadBlobChunk_result implements org.apache.thrift.TBase<uploadBlobChunk_result, uploadBlobChunk_result._Fields>, java.io.Serializable, Cloneable, Comparable<uploadBlobChunk_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("uploadBlobChunk_result");

    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new uploadBlobChunk_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new uploadBlobChunk_resultTupleSchemeFactory());
    }

    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      AZE((short)1, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(uploadBlobChunk_result.class, metaDataMap);
    }

    public uploadBlobChunk_result() {
    }

    public uploadBlobChunk_result(
      AuthorizationException aze)
    {
      this();
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public uploadBlobChunk_result(uploadBlobChunk_result other) {
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public uploadBlobChunk_result deepCopy() {
      return new uploadBlobChunk_result(this);
    }

    @Override
    public void clear() {
      this.aze = null;
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof uploadBlobChunk_result)
        return this.equals((uploadBlobChunk_result)that);
      return false;
    }

    public boolean equals(uploadBlobChunk_result that) {
      if (that == null)
        return false;

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(uploadBlobChunk_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("uploadBlobChunk_result(");
      boolean first = true;

      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class uploadBlobChunk_resultStandardSchemeFactory implements SchemeFactory {
      public uploadBlobChunk_resultStandardScheme getScheme() {
        return new uploadBlobChunk_resultStandardScheme();
      }
    }

    private static class uploadBlobChunk_resultStandardScheme extends StandardScheme<uploadBlobChunk_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, uploadBlobChunk_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, uploadBlobChunk_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class uploadBlobChunk_resultTupleSchemeFactory implements SchemeFactory {
      public uploadBlobChunk_resultTupleScheme getScheme() {
        return new uploadBlobChunk_resultTupleScheme();
      }
    }

    private static class uploadBlobChunk_resultTupleScheme extends TupleScheme<uploadBlobChunk_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, uploadBlobChunk_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_aze()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, uploadBlobChunk_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class finishBlobUpload_args implements org.apache.thrift.TBase<finishBlobUpload_args, finishBlobUpload_args._Fields>, java.io.Serializable, Cloneable, Comparable<finishBlobUpload_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("finishBlobUpload_args");

    private static final org.apache.thrift.protocol.TField SESSION_FIELD_DESC = new org.apache.thrift.protocol.TField("session", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new finishBlobUpload_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new finishBlobUpload_argsTupleSchemeFactory());
    }

    private String session; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SESSION((short)1, "session");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SESSION
            return SESSION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SESSION, new org.apache.thrift.meta_data.FieldMetaData("session", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(finishBlobUpload_args.class, metaDataMap);
    }

    public finishBlobUpload_args() {
    }

    public finishBlobUpload_args(
      String session)
    {
      this();
      this.session = session;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public finishBlobUpload_args(finishBlobUpload_args other) {
      if (other.is_set_session()) {
        this.session = other.session;
      }
    }

    public finishBlobUpload_args deepCopy() {
      return new finishBlobUpload_args(this);
    }

    @Override
    public void clear() {
      this.session = null;
    }

    public String get_session() {
      return this.session;
    }

    public void set_session(String session) {
      this.session = session;
    }

    public void unset_session() {
      this.session = null;
    }

    /** Returns true if field session is set (has been assigned a value) and false otherwise */
    public boolean is_set_session() {
      return this.session != null;
    }

    public void set_session_isSet(boolean value) {
      if (!value) {
        this.session = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SESSION:
        if (value == null) {
          unset_session();
        } else {
          set_session((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SESSION:
        return get_session();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SESSION:
        return is_set_session();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof finishBlobUpload_args)
        return this.equals((finishBlobUpload_args)that);
      return false;
    }

    public boolean equals(finishBlobUpload_args that) {
      if (that == null)
        return false;

      boolean this_present_session = true && this.is_set_session();
      boolean that_present_session = true && that.is_set_session();
      if (this_present_session || that_present_session) {
        if (!(this_present_session && that_present_session))
          return false;
        if (!this.session.equals(that.session))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_session = true && (is_set_session());
      list.add(present_session);
      if (present_session)
        list.add(session);

      return list.hashCode();
    }

    @Override
    public int compareTo(finishBlobUpload_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_session()).compareTo(other.is_set_session());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_session()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.session, other.session);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("finishBlobUpload_args(");
      boolean first = true;

      sb.append("session:");
      if (this.session == null) {
        sb.append("null");
      } else {
        sb.append(this.session);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class finishBlobUpload_argsStandardSchemeFactory implements SchemeFactory {
      public finishBlobUpload_argsStandardScheme getScheme() {
        return new finishBlobUpload_argsStandardScheme();
      }
    }

    private static class finishBlobUpload_argsStandardScheme extends StandardScheme<finishBlobUpload_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, finishBlobUpload_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SESSION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.session = iprot.readString();
                struct.set_session_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, finishBlobUpload_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.session != null) {
          oprot.writeFieldBegin(SESSION_FIELD_DESC);
          oprot.writeString(struct.session);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class finishBlobUpload_argsTupleSchemeFactory implements SchemeFactory {
      public finishBlobUpload_argsTupleScheme getScheme() {
        return new finishBlobUpload_argsTupleScheme();
      }
    }

    private static class finishBlobUpload_argsTupleScheme extends TupleScheme<finishBlobUpload_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, finishBlobUpload_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_session()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_session()) {
          oprot.writeString(struct.session);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, finishBlobUpload_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.session = iprot.readString();
          struct.set_session_isSet(true);
        }
      }
    }

  }

  public static class finishBlobUpload_result implements org.apache.thrift.TBase<finishBlobUpload_result, finishBlobUpload_result._Fields>, java.io.Serializable, Cloneable, Comparable<finishBlobUpload_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("finishBlobUpload_result");

    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new finishBlobUpload_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new finishBlobUpload_resultTupleSchemeFactory());
    }

    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      AZE((short)1, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(finishBlobUpload_result.class, metaDataMap);
    }

    public finishBlobUpload_result() {
    }

    public finishBlobUpload_result(
      AuthorizationException aze)
    {
      this();
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public finishBlobUpload_result(finishBlobUpload_result other) {
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public finishBlobUpload_result deepCopy() {
      return new finishBlobUpload_result(this);
    }

    @Override
    public void clear() {
      this.aze = null;
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof finishBlobUpload_result)
        return this.equals((finishBlobUpload_result)that);
      return false;
    }

    public boolean equals(finishBlobUpload_result that) {
      if (that == null)
        return false;

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(finishBlobUpload_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("finishBlobUpload_result(");
      boolean first = true;

      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class finishBlobUpload_resultStandardSchemeFactory implements SchemeFactory {
      public finishBlobUpload_resultStandardScheme getScheme() {
        return new finishBlobUpload_resultStandardScheme();
      }
    }

    private static class finishBlobUpload_resultStandardScheme extends StandardScheme<finishBlobUpload_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, finishBlobUpload_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, finishBlobUpload_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class finishBlobUpload_resultTupleSchemeFactory implements SchemeFactory {
      public finishBlobUpload_resultTupleScheme getScheme() {
        return new finishBlobUpload_resultTupleScheme();
      }
    }

    private static class finishBlobUpload_resultTupleScheme extends TupleScheme<finishBlobUpload_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, finishBlobUpload_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_aze()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, finishBlobUpload_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class cancelBlobUpload_args implements org.apache.thrift.TBase<cancelBlobUpload_args, cancelBlobUpload_args._Fields>, java.io.Serializable, Cloneable, Comparable<cancelBlobUpload_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cancelBlobUpload_args");

    private static final org.apache.thrift.protocol.TField SESSION_FIELD_DESC = new org.apache.thrift.protocol.TField("session", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new cancelBlobUpload_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new cancelBlobUpload_argsTupleSchemeFactory());
    }

    private String session; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SESSION((short)1, "session");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SESSION
            return SESSION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SESSION, new org.apache.thrift.meta_data.FieldMetaData("session", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cancelBlobUpload_args.class, metaDataMap);
    }

    public cancelBlobUpload_args() {
    }

    public cancelBlobUpload_args(
      String session)
    {
      this();
      this.session = session;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cancelBlobUpload_args(cancelBlobUpload_args other) {
      if (other.is_set_session()) {
        this.session = other.session;
      }
    }

    public cancelBlobUpload_args deepCopy() {
      return new cancelBlobUpload_args(this);
    }

    @Override
    public void clear() {
      this.session = null;
    }

    public String get_session() {
      return this.session;
    }

    public void set_session(String session) {
      this.session = session;
    }

    public void unset_session() {
      this.session = null;
    }

    /** Returns true if field session is set (has been assigned a value) and false otherwise */
    public boolean is_set_session() {
      return this.session != null;
    }

    public void set_session_isSet(boolean value) {
      if (!value) {
        this.session = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SESSION:
        if (value == null) {
          unset_session();
        } else {
          set_session((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SESSION:
        return get_session();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SESSION:
        return is_set_session();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof cancelBlobUpload_args)
        return this.equals((cancelBlobUpload_args)that);
      return false;
    }

    public boolean equals(cancelBlobUpload_args that) {
      if (that == null)
        return false;

      boolean this_present_session = true && this.is_set_session();
      boolean that_present_session = true && that.is_set_session();
      if (this_present_session || that_present_session) {
        if (!(this_present_session && that_present_session))
          return false;
        if (!this.session.equals(that.session))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_session = true && (is_set_session());
      list.add(present_session);
      if (present_session)
        list.add(session);

      return list.hashCode();
    }

    @Override
    public int compareTo(cancelBlobUpload_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_session()).compareTo(other.is_set_session());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_session()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.session, other.session);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("cancelBlobUpload_args(");
      boolean first = true;

      sb.append("session:");
      if (this.session == null) {
        sb.append("null");
      } else {
        sb.append(this.session);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class cancelBlobUpload_argsStandardSchemeFactory implements SchemeFactory {
      public cancelBlobUpload_argsStandardScheme getScheme() {
        return new cancelBlobUpload_argsStandardScheme();
      }
    }

    private static class cancelBlobUpload_argsStandardScheme extends StandardScheme<cancelBlobUpload_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, cancelBlobUpload_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SESSION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.session = iprot.readString();
                struct.set_session_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, cancelBlobUpload_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.session != null) {
          oprot.writeFieldBegin(SESSION_FIELD_DESC);
          oprot.writeString(struct.session);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class cancelBlobUpload_argsTupleSchemeFactory implements SchemeFactory {
      public cancelBlobUpload_argsTupleScheme getScheme() {
        return new cancelBlobUpload_argsTupleScheme();
      }
    }

    private static class cancelBlobUpload_argsTupleScheme extends TupleScheme<cancelBlobUpload_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, cancelBlobUpload_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_session()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_session()) {
          oprot.writeString(struct.session);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, cancelBlobUpload_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.session = iprot.readString();
          struct.set_session_isSet(true);
        }
      }
    }

  }

  public static class cancelBlobUpload_result implements org.apache.thrift.TBase<cancelBlobUpload_result, cancelBlobUpload_result._Fields>, java.io.Serializable, Cloneable, Comparable<cancelBlobUpload_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cancelBlobUpload_result");

    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new cancelBlobUpload_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new cancelBlobUpload_resultTupleSchemeFactory());
    }

    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      AZE((short)1, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cancelBlobUpload_result.class, metaDataMap);
    }

    public cancelBlobUpload_result() {
    }

    public cancelBlobUpload_result(
      AuthorizationException aze)
    {
      this();
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cancelBlobUpload_result(cancelBlobUpload_result other) {
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public cancelBlobUpload_result deepCopy() {
      return new cancelBlobUpload_result(this);
    }

    @Override
    public void clear() {
      this.aze = null;
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof cancelBlobUpload_result)
        return this.equals((cancelBlobUpload_result)that);
      return false;
    }

    public boolean equals(cancelBlobUpload_result that) {
      if (that == null)
        return false;

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(cancelBlobUpload_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("cancelBlobUpload_result(");
      boolean first = true;

      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class cancelBlobUpload_resultStandardSchemeFactory implements SchemeFactory {
      public cancelBlobUpload_resultStandardScheme getScheme() {
        return new cancelBlobUpload_resultStandardScheme();
      }
    }

    private static class cancelBlobUpload_resultStandardScheme extends StandardScheme<cancelBlobUpload_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, cancelBlobUpload_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, cancelBlobUpload_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class cancelBlobUpload_resultTupleSchemeFactory implements SchemeFactory {
      public cancelBlobUpload_resultTupleScheme getScheme() {
        return new cancelBlobUpload_resultTupleScheme();
      }
    }

    private static class cancelBlobUpload_resultTupleScheme extends TupleScheme<cancelBlobUpload_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, cancelBlobUpload_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_aze()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, cancelBlobUpload_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class getBlobMeta_args implements org.apache.thrift.TBase<getBlobMeta_args, getBlobMeta_args._Fields>, java.io.Serializable, Cloneable, Comparable<getBlobMeta_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getBlobMeta_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getBlobMeta_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getBlobMeta_argsTupleSchemeFactory());
    }

    private String key; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getBlobMeta_args.class, metaDataMap);
    }

    public getBlobMeta_args() {
    }

    public getBlobMeta_args(
      String key)
    {
      this();
      this.key = key;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getBlobMeta_args(getBlobMeta_args other) {
      if (other.is_set_key()) {
        this.key = other.key;
      }
    }

    public getBlobMeta_args deepCopy() {
      return new getBlobMeta_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
    }

    public String get_key() {
      return this.key;
    }

    public void set_key(String key) {
      this.key = key;
    }

    public void unset_key() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean is_set_key() {
      return this.key != null;
    }

    public void set_key_isSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unset_key();
        } else {
          set_key((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return get_key();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return is_set_key();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getBlobMeta_args)
        return this.equals((getBlobMeta_args)that);
      return false;
    }

    public boolean equals(getBlobMeta_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.is_set_key();
      boolean that_present_key = true && that.is_set_key();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (is_set_key());
      list.add(present_key);
      if (present_key)
        list.add(key);

      return list.hashCode();
    }

    @Override
    public int compareTo(getBlobMeta_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_key()).compareTo(other.is_set_key());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_key()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getBlobMeta_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getBlobMeta_argsStandardSchemeFactory implements SchemeFactory {
      public getBlobMeta_argsStandardScheme getScheme() {
        return new getBlobMeta_argsStandardScheme();
      }
    }

    private static class getBlobMeta_argsStandardScheme extends StandardScheme<getBlobMeta_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getBlobMeta_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.key = iprot.readString();
                struct.set_key_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getBlobMeta_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          oprot.writeString(struct.key);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getBlobMeta_argsTupleSchemeFactory implements SchemeFactory {
      public getBlobMeta_argsTupleScheme getScheme() {
        return new getBlobMeta_argsTupleScheme();
      }
    }

    private static class getBlobMeta_argsTupleScheme extends TupleScheme<getBlobMeta_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getBlobMeta_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_key()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_key()) {
          oprot.writeString(struct.key);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getBlobMeta_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.key = iprot.readString();
          struct.set_key_isSet(true);
        }
      }
    }

  }

  public static class getBlobMeta_result implements org.apache.thrift.TBase<getBlobMeta_result, getBlobMeta_result._Fields>, java.io.Serializable, Cloneable, Comparable<getBlobMeta_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getBlobMeta_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField KNF_FIELD_DESC = new org.apache.thrift.protocol.TField("knf", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getBlobMeta_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getBlobMeta_resultTupleSchemeFactory());
    }

    private ReadableBlobMeta success; // required
    private AuthorizationException aze; // required
    private KeyNotFoundException knf; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      AZE((short)1, "aze"),
      KNF((short)2, "knf");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // AZE
            return AZE;
          case 2: // KNF
            return KNF;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ReadableBlobMeta.class)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.KNF, new org.apache.thrift.meta_data.FieldMetaData("knf", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getBlobMeta_result.class, metaDataMap);
    }

    public getBlobMeta_result() {
    }

    public getBlobMeta_result(
      ReadableBlobMeta success,
      AuthorizationException aze,
      KeyNotFoundException knf)
    {
      this();
      this.success = success;
      this.aze = aze;
      this.knf = knf;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getBlobMeta_result(getBlobMeta_result other) {
      if (other.is_set_success()) {
        this.success = new ReadableBlobMeta(other.success);
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
      if (other.is_set_knf()) {
        this.knf = new KeyNotFoundException(other.knf);
      }
    }

    public getBlobMeta_result deepCopy() {
      return new getBlobMeta_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.aze = null;
      this.knf = null;
    }

    public ReadableBlobMeta get_success() {
      return this.success;
    }

    public void set_success(ReadableBlobMeta success) {
      this.success = success;
    }

    public void unset_success() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean is_set_success() {
      return this.success != null;
    }

    public void set_success_isSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public KeyNotFoundException get_knf() {
      return this.knf;
    }

    public void set_knf(KeyNotFoundException knf) {
      this.knf = knf;
    }

    public void unset_knf() {
      this.knf = null;
    }

    /** Returns true if field knf is set (has been assigned a value) and false otherwise */
    public boolean is_set_knf() {
      return this.knf != null;
    }

    public void set_knf_isSet(boolean value) {
      if (!value) {
        this.knf = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unset_success();
        } else {
          set_success((ReadableBlobMeta)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      case KNF:
        if (value == null) {
          unset_knf();
        } else {
          set_knf((KeyNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return get_success();

      case AZE:
        return get_aze();

      case KNF:
        return get_knf();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return is_set_success();
      case AZE:
        return is_set_aze();
      case KNF:
        return is_set_knf();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getBlobMeta_result)
        return this.equals((getBlobMeta_result)that);
      return false;
    }

    public boolean equals(getBlobMeta_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.is_set_success();
      boolean that_present_success = true && that.is_set_success();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      boolean this_present_knf = true && this.is_set_knf();
      boolean that_present_knf = true && that.is_set_knf();
      if (this_present_knf || that_present_knf) {
        if (!(this_present_knf && that_present_knf))
          return false;
        if (!this.knf.equals(that.knf))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (is_set_success());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      boolean present_knf = true && (is_set_knf());
      list.add(present_knf);
      if (present_knf)
        list.add(knf);

      return list.hashCode();
    }

    @Override
    public int compareTo(getBlobMeta_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_success()).compareTo(other.is_set_success());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_success()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_knf()).compareTo(other.is_set_knf());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_knf()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.knf, other.knf);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getBlobMeta_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("knf:");
      if (this.knf == null) {
        sb.append("null");
      } else {
        sb.append(this.knf);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getBlobMeta_resultStandardSchemeFactory implements SchemeFactory {
      public getBlobMeta_resultStandardScheme getScheme() {
        return new getBlobMeta_resultStandardScheme();
      }
    }

    private static class getBlobMeta_resultStandardScheme extends StandardScheme<getBlobMeta_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getBlobMeta_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ReadableBlobMeta();
                struct.success.read(iprot);
                struct.set_success_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // KNF
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.knf = new KeyNotFoundException();
                struct.knf.read(iprot);
                struct.set_knf_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getBlobMeta_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.knf != null) {
          oprot.writeFieldBegin(KNF_FIELD_DESC);
          struct.knf.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getBlobMeta_resultTupleSchemeFactory implements SchemeFactory {
      public getBlobMeta_resultTupleScheme getScheme() {
        return new getBlobMeta_resultTupleScheme();
      }
    }

    private static class getBlobMeta_resultTupleScheme extends TupleScheme<getBlobMeta_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getBlobMeta_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_success()) {
          optionals.set(0);
        }
        if (struct.is_set_aze()) {
          optionals.set(1);
        }
        if (struct.is_set_knf()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.is_set_success()) {
          struct.success.write(oprot);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
        if (struct.is_set_knf()) {
          struct.knf.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getBlobMeta_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = new ReadableBlobMeta();
          struct.success.read(iprot);
          struct.set_success_isSet(true);
        }
        if (incoming.get(1)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
        if (incoming.get(2)) {
          struct.knf = new KeyNotFoundException();
          struct.knf.read(iprot);
          struct.set_knf_isSet(true);
        }
      }
    }

  }

  public static class setBlobMeta_args implements org.apache.thrift.TBase<setBlobMeta_args, setBlobMeta_args._Fields>, java.io.Serializable, Cloneable, Comparable<setBlobMeta_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("setBlobMeta_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField META_FIELD_DESC = new org.apache.thrift.protocol.TField("meta", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new setBlobMeta_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new setBlobMeta_argsTupleSchemeFactory());
    }

    private String key; // required
    private SettableBlobMeta meta; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key"),
      META((short)2, "meta");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 2: // META
            return META;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.META, new org.apache.thrift.meta_data.FieldMetaData("meta", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, SettableBlobMeta.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(setBlobMeta_args.class, metaDataMap);
    }

    public setBlobMeta_args() {
    }

    public setBlobMeta_args(
      String key,
      SettableBlobMeta meta)
    {
      this();
      this.key = key;
      this.meta = meta;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public setBlobMeta_args(setBlobMeta_args other) {
      if (other.is_set_key()) {
        this.key = other.key;
      }
      if (other.is_set_meta()) {
        this.meta = new SettableBlobMeta(other.meta);
      }
    }

    public setBlobMeta_args deepCopy() {
      return new setBlobMeta_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.meta = null;
    }

    public String get_key() {
      return this.key;
    }

    public void set_key(String key) {
      this.key = key;
    }

    public void unset_key() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean is_set_key() {
      return this.key != null;
    }

    public void set_key_isSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public SettableBlobMeta get_meta() {
      return this.meta;
    }

    public void set_meta(SettableBlobMeta meta) {
      this.meta = meta;
    }

    public void unset_meta() {
      this.meta = null;
    }

    /** Returns true if field meta is set (has been assigned a value) and false otherwise */
    public boolean is_set_meta() {
      return this.meta != null;
    }

    public void set_meta_isSet(boolean value) {
      if (!value) {
        this.meta = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unset_key();
        } else {
          set_key((String)value);
        }
        break;

      case META:
        if (value == null) {
          unset_meta();
        } else {
          set_meta((SettableBlobMeta)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return get_key();

      case META:
        return get_meta();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return is_set_key();
      case META:
        return is_set_meta();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setBlobMeta_args)
        return this.equals((setBlobMeta_args)that);
      return false;
    }

    public boolean equals(setBlobMeta_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.is_set_key();
      boolean that_present_key = true && that.is_set_key();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_meta = true && this.is_set_meta();
      boolean that_present_meta = true && that.is_set_meta();
      if (this_present_meta || that_present_meta) {
        if (!(this_present_meta && that_present_meta))
          return false;
        if (!this.meta.equals(that.meta))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (is_set_key());
      list.add(present_key);
      if (present_key)
        list.add(key);

      boolean present_meta = true && (is_set_meta());
      list.add(present_meta);
      if (present_meta)
        list.add(meta);

      return list.hashCode();
    }

    @Override
    public int compareTo(setBlobMeta_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_key()).compareTo(other.is_set_key());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_key()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_meta()).compareTo(other.is_set_meta());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_meta()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.meta, other.meta);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("setBlobMeta_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("meta:");
      if (this.meta == null) {
        sb.append("null");
      } else {
        sb.append(this.meta);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (meta != null) {
        meta.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class setBlobMeta_argsStandardSchemeFactory implements SchemeFactory {
      public setBlobMeta_argsStandardScheme getScheme() {
        return new setBlobMeta_argsStandardScheme();
      }
    }

    private static class setBlobMeta_argsStandardScheme extends StandardScheme<setBlobMeta_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, setBlobMeta_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.key = iprot.readString();
                struct.set_key_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // META
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.meta = new SettableBlobMeta();
                struct.meta.read(iprot);
                struct.set_meta_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, setBlobMeta_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          oprot.writeString(struct.key);
          oprot.writeFieldEnd();
        }
        if (struct.meta != null) {
          oprot.writeFieldBegin(META_FIELD_DESC);
          struct.meta.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class setBlobMeta_argsTupleSchemeFactory implements SchemeFactory {
      public setBlobMeta_argsTupleScheme getScheme() {
        return new setBlobMeta_argsTupleScheme();
      }
    }

    private static class setBlobMeta_argsTupleScheme extends TupleScheme<setBlobMeta_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, setBlobMeta_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_key()) {
          optionals.set(0);
        }
        if (struct.is_set_meta()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_key()) {
          oprot.writeString(struct.key);
        }
        if (struct.is_set_meta()) {
          struct.meta.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, setBlobMeta_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.key = iprot.readString();
          struct.set_key_isSet(true);
        }
        if (incoming.get(1)) {
          struct.meta = new SettableBlobMeta();
          struct.meta.read(iprot);
          struct.set_meta_isSet(true);
        }
      }
    }

  }

  public static class setBlobMeta_result implements org.apache.thrift.TBase<setBlobMeta_result, setBlobMeta_result._Fields>, java.io.Serializable, Cloneable, Comparable<setBlobMeta_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("setBlobMeta_result");

    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField KNF_FIELD_DESC = new org.apache.thrift.protocol.TField("knf", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new setBlobMeta_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new setBlobMeta_resultTupleSchemeFactory());
    }

    private AuthorizationException aze; // required
    private KeyNotFoundException knf; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      AZE((short)1, "aze"),
      KNF((short)2, "knf");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // AZE
            return AZE;
          case 2: // KNF
            return KNF;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.KNF, new org.apache.thrift.meta_data.FieldMetaData("knf", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(setBlobMeta_result.class, metaDataMap);
    }

    public setBlobMeta_result() {
    }

    public setBlobMeta_result(
      AuthorizationException aze,
      KeyNotFoundException knf)
    {
      this();
      this.aze = aze;
      this.knf = knf;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public setBlobMeta_result(setBlobMeta_result other) {
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
      if (other.is_set_knf()) {
        this.knf = new KeyNotFoundException(other.knf);
      }
    }

    public setBlobMeta_result deepCopy() {
      return new setBlobMeta_result(this);
    }

    @Override
    public void clear() {
      this.aze = null;
      this.knf = null;
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public KeyNotFoundException get_knf() {
      return this.knf;
    }

    public void set_knf(KeyNotFoundException knf) {
      this.knf = knf;
    }

    public void unset_knf() {
      this.knf = null;
    }

    /** Returns true if field knf is set (has been assigned a value) and false otherwise */
    public boolean is_set_knf() {
      return this.knf != null;
    }

    public void set_knf_isSet(boolean value) {
      if (!value) {
        this.knf = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      case KNF:
        if (value == null) {
          unset_knf();
        } else {
          set_knf((KeyNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case AZE:
        return get_aze();

      case KNF:
        return get_knf();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case AZE:
        return is_set_aze();
      case KNF:
        return is_set_knf();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setBlobMeta_result)
        return this.equals((setBlobMeta_result)that);
      return false;
    }

    public boolean equals(setBlobMeta_result that) {
      if (that == null)
        return false;

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      boolean this_present_knf = true && this.is_set_knf();
      boolean that_present_knf = true && that.is_set_knf();
      if (this_present_knf || that_present_knf) {
        if (!(this_present_knf && that_present_knf))
          return false;
        if (!this.knf.equals(that.knf))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      boolean present_knf = true && (is_set_knf());
      list.add(present_knf);
      if (present_knf)
        list.add(knf);

      return list.hashCode();
    }

    @Override
    public int compareTo(setBlobMeta_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_knf()).compareTo(other.is_set_knf());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_knf()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.knf, other.knf);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("setBlobMeta_result(");
      boolean first = true;

      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("knf:");
      if (this.knf == null) {
        sb.append("null");
      } else {
        sb.append(this.knf);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class setBlobMeta_resultStandardSchemeFactory implements SchemeFactory {
      public setBlobMeta_resultStandardScheme getScheme() {
        return new setBlobMeta_resultStandardScheme();
      }
    }

    private static class setBlobMeta_resultStandardScheme extends StandardScheme<setBlobMeta_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, setBlobMeta_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // KNF
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.knf = new KeyNotFoundException();
                struct.knf.read(iprot);
                struct.set_knf_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, setBlobMeta_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.knf != null) {
          oprot.writeFieldBegin(KNF_FIELD_DESC);
          struct.knf.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class setBlobMeta_resultTupleSchemeFactory implements SchemeFactory {
      public setBlobMeta_resultTupleScheme getScheme() {
        return new setBlobMeta_resultTupleScheme();
      }
    }

    private static class setBlobMeta_resultTupleScheme extends TupleScheme<setBlobMeta_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, setBlobMeta_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_aze()) {
          optionals.set(0);
        }
        if (struct.is_set_knf()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
        if (struct.is_set_knf()) {
          struct.knf.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, setBlobMeta_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
        if (incoming.get(1)) {
          struct.knf = new KeyNotFoundException();
          struct.knf.read(iprot);
          struct.set_knf_isSet(true);
        }
      }
    }

  }

  public static class beginBlobDownload_args implements org.apache.thrift.TBase<beginBlobDownload_args, beginBlobDownload_args._Fields>, java.io.Serializable, Cloneable, Comparable<beginBlobDownload_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("beginBlobDownload_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new beginBlobDownload_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new beginBlobDownload_argsTupleSchemeFactory());
    }

    private String key; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(beginBlobDownload_args.class, metaDataMap);
    }

    public beginBlobDownload_args() {
    }

    public beginBlobDownload_args(
      String key)
    {
      this();
      this.key = key;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public beginBlobDownload_args(beginBlobDownload_args other) {
      if (other.is_set_key()) {
        this.key = other.key;
      }
    }

    public beginBlobDownload_args deepCopy() {
      return new beginBlobDownload_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
    }

    public String get_key() {
      return this.key;
    }

    public void set_key(String key) {
      this.key = key;
    }

    public void unset_key() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean is_set_key() {
      return this.key != null;
    }

    public void set_key_isSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unset_key();
        } else {
          set_key((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return get_key();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return is_set_key();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof beginBlobDownload_args)
        return this.equals((beginBlobDownload_args)that);
      return false;
    }

    public boolean equals(beginBlobDownload_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.is_set_key();
      boolean that_present_key = true && that.is_set_key();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (is_set_key());
      list.add(present_key);
      if (present_key)
        list.add(key);

      return list.hashCode();
    }

    @Override
    public int compareTo(beginBlobDownload_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_key()).compareTo(other.is_set_key());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_key()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("beginBlobDownload_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class beginBlobDownload_argsStandardSchemeFactory implements SchemeFactory {
      public beginBlobDownload_argsStandardScheme getScheme() {
        return new beginBlobDownload_argsStandardScheme();
      }
    }

    private static class beginBlobDownload_argsStandardScheme extends StandardScheme<beginBlobDownload_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, beginBlobDownload_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.key = iprot.readString();
                struct.set_key_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, beginBlobDownload_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          oprot.writeString(struct.key);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class beginBlobDownload_argsTupleSchemeFactory implements SchemeFactory {
      public beginBlobDownload_argsTupleScheme getScheme() {
        return new beginBlobDownload_argsTupleScheme();
      }
    }

    private static class beginBlobDownload_argsTupleScheme extends TupleScheme<beginBlobDownload_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, beginBlobDownload_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_key()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_key()) {
          oprot.writeString(struct.key);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, beginBlobDownload_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.key = iprot.readString();
          struct.set_key_isSet(true);
        }
      }
    }

  }

  public static class beginBlobDownload_result implements org.apache.thrift.TBase<beginBlobDownload_result, beginBlobDownload_result._Fields>, java.io.Serializable, Cloneable, Comparable<beginBlobDownload_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("beginBlobDownload_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField KNF_FIELD_DESC = new org.apache.thrift.protocol.TField("knf", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new beginBlobDownload_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new beginBlobDownload_resultTupleSchemeFactory());
    }

    private BeginDownloadResult success; // required
    private AuthorizationException aze; // required
    private KeyNotFoundException knf; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      AZE((short)1, "aze"),
      KNF((short)2, "knf");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // AZE
            return AZE;
          case 2: // KNF
            return KNF;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, BeginDownloadResult.class)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.KNF, new org.apache.thrift.meta_data.FieldMetaData("knf", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(beginBlobDownload_result.class, metaDataMap);
    }

    public beginBlobDownload_result() {
    }

    public beginBlobDownload_result(
      BeginDownloadResult success,
      AuthorizationException aze,
      KeyNotFoundException knf)
    {
      this();
      this.success = success;
      this.aze = aze;
      this.knf = knf;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public beginBlobDownload_result(beginBlobDownload_result other) {
      if (other.is_set_success()) {
        this.success = new BeginDownloadResult(other.success);
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
      if (other.is_set_knf()) {
        this.knf = new KeyNotFoundException(other.knf);
      }
    }

    public beginBlobDownload_result deepCopy() {
      return new beginBlobDownload_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.aze = null;
      this.knf = null;
    }

    public BeginDownloadResult get_success() {
      return this.success;
    }

    public void set_success(BeginDownloadResult success) {
      this.success = success;
    }

    public void unset_success() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean is_set_success() {
      return this.success != null;
    }

    public void set_success_isSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public KeyNotFoundException get_knf() {
      return this.knf;
    }

    public void set_knf(KeyNotFoundException knf) {
      this.knf = knf;
    }

    public void unset_knf() {
      this.knf = null;
    }

    /** Returns true if field knf is set (has been assigned a value) and false otherwise */
    public boolean is_set_knf() {
      return this.knf != null;
    }

    public void set_knf_isSet(boolean value) {
      if (!value) {
        this.knf = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unset_success();
        } else {
          set_success((BeginDownloadResult)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      case KNF:
        if (value == null) {
          unset_knf();
        } else {
          set_knf((KeyNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return get_success();

      case AZE:
        return get_aze();

      case KNF:
        return get_knf();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return is_set_success();
      case AZE:
        return is_set_aze();
      case KNF:
        return is_set_knf();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof beginBlobDownload_result)
        return this.equals((beginBlobDownload_result)that);
      return false;
    }

    public boolean equals(beginBlobDownload_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.is_set_success();
      boolean that_present_success = true && that.is_set_success();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      boolean this_present_knf = true && this.is_set_knf();
      boolean that_present_knf = true && that.is_set_knf();
      if (this_present_knf || that_present_knf) {
        if (!(this_present_knf && that_present_knf))
          return false;
        if (!this.knf.equals(that.knf))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (is_set_success());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      boolean present_knf = true && (is_set_knf());
      list.add(present_knf);
      if (present_knf)
        list.add(knf);

      return list.hashCode();
    }

    @Override
    public int compareTo(beginBlobDownload_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_success()).compareTo(other.is_set_success());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_success()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_knf()).compareTo(other.is_set_knf());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_knf()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.knf, other.knf);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("beginBlobDownload_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("knf:");
      if (this.knf == null) {
        sb.append("null");
      } else {
        sb.append(this.knf);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class beginBlobDownload_resultStandardSchemeFactory implements SchemeFactory {
      public beginBlobDownload_resultStandardScheme getScheme() {
        return new beginBlobDownload_resultStandardScheme();
      }
    }

    private static class beginBlobDownload_resultStandardScheme extends StandardScheme<beginBlobDownload_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, beginBlobDownload_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new BeginDownloadResult();
                struct.success.read(iprot);
                struct.set_success_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // KNF
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.knf = new KeyNotFoundException();
                struct.knf.read(iprot);
                struct.set_knf_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, beginBlobDownload_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.knf != null) {
          oprot.writeFieldBegin(KNF_FIELD_DESC);
          struct.knf.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class beginBlobDownload_resultTupleSchemeFactory implements SchemeFactory {
      public beginBlobDownload_resultTupleScheme getScheme() {
        return new beginBlobDownload_resultTupleScheme();
      }
    }

    private static class beginBlobDownload_resultTupleScheme extends TupleScheme<beginBlobDownload_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, beginBlobDownload_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_success()) {
          optionals.set(0);
        }
        if (struct.is_set_aze()) {
          optionals.set(1);
        }
        if (struct.is_set_knf()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.is_set_success()) {
          struct.success.write(oprot);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
        if (struct.is_set_knf()) {
          struct.knf.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, beginBlobDownload_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = new BeginDownloadResult();
          struct.success.read(iprot);
          struct.set_success_isSet(true);
        }
        if (incoming.get(1)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
        if (incoming.get(2)) {
          struct.knf = new KeyNotFoundException();
          struct.knf.read(iprot);
          struct.set_knf_isSet(true);
        }
      }
    }

  }

  public static class downloadBlobChunk_args implements org.apache.thrift.TBase<downloadBlobChunk_args, downloadBlobChunk_args._Fields>, java.io.Serializable, Cloneable, Comparable<downloadBlobChunk_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("downloadBlobChunk_args");

    private static final org.apache.thrift.protocol.TField SESSION_FIELD_DESC = new org.apache.thrift.protocol.TField("session", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new downloadBlobChunk_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new downloadBlobChunk_argsTupleSchemeFactory());
    }

    private String session; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SESSION((short)1, "session");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SESSION
            return SESSION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SESSION, new org.apache.thrift.meta_data.FieldMetaData("session", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(downloadBlobChunk_args.class, metaDataMap);
    }

    public downloadBlobChunk_args() {
    }

    public downloadBlobChunk_args(
      String session)
    {
      this();
      this.session = session;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public downloadBlobChunk_args(downloadBlobChunk_args other) {
      if (other.is_set_session()) {
        this.session = other.session;
      }
    }

    public downloadBlobChunk_args deepCopy() {
      return new downloadBlobChunk_args(this);
    }

    @Override
    public void clear() {
      this.session = null;
    }

    public String get_session() {
      return this.session;
    }

    public void set_session(String session) {
      this.session = session;
    }

    public void unset_session() {
      this.session = null;
    }

    /** Returns true if field session is set (has been assigned a value) and false otherwise */
    public boolean is_set_session() {
      return this.session != null;
    }

    public void set_session_isSet(boolean value) {
      if (!value) {
        this.session = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SESSION:
        if (value == null) {
          unset_session();
        } else {
          set_session((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SESSION:
        return get_session();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SESSION:
        return is_set_session();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof downloadBlobChunk_args)
        return this.equals((downloadBlobChunk_args)that);
      return false;
    }

    public boolean equals(downloadBlobChunk_args that) {
      if (that == null)
        return false;

      boolean this_present_session = true && this.is_set_session();
      boolean that_present_session = true && that.is_set_session();
      if (this_present_session || that_present_session) {
        if (!(this_present_session && that_present_session))
          return false;
        if (!this.session.equals(that.session))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_session = true && (is_set_session());
      list.add(present_session);
      if (present_session)
        list.add(session);

      return list.hashCode();
    }

    @Override
    public int compareTo(downloadBlobChunk_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_session()).compareTo(other.is_set_session());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_session()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.session, other.session);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("downloadBlobChunk_args(");
      boolean first = true;

      sb.append("session:");
      if (this.session == null) {
        sb.append("null");
      } else {
        sb.append(this.session);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class downloadBlobChunk_argsStandardSchemeFactory implements SchemeFactory {
      public downloadBlobChunk_argsStandardScheme getScheme() {
        return new downloadBlobChunk_argsStandardScheme();
      }
    }

    private static class downloadBlobChunk_argsStandardScheme extends StandardScheme<downloadBlobChunk_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, downloadBlobChunk_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SESSION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.session = iprot.readString();
                struct.set_session_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, downloadBlobChunk_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.session != null) {
          oprot.writeFieldBegin(SESSION_FIELD_DESC);
          oprot.writeString(struct.session);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class downloadBlobChunk_argsTupleSchemeFactory implements SchemeFactory {
      public downloadBlobChunk_argsTupleScheme getScheme() {
        return new downloadBlobChunk_argsTupleScheme();
      }
    }

    private static class downloadBlobChunk_argsTupleScheme extends TupleScheme<downloadBlobChunk_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, downloadBlobChunk_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_session()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_session()) {
          oprot.writeString(struct.session);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, downloadBlobChunk_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.session = iprot.readString();
          struct.set_session_isSet(true);
        }
      }
    }

  }

  public static class downloadBlobChunk_result implements org.apache.thrift.TBase<downloadBlobChunk_result, downloadBlobChunk_result._Fields>, java.io.Serializable, Cloneable, Comparable<downloadBlobChunk_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("downloadBlobChunk_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new downloadBlobChunk_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new downloadBlobChunk_resultTupleSchemeFactory());
    }

    private ByteBuffer success; // required
    private AuthorizationException aze; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      AZE((short)1, "aze");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // AZE
            return AZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(downloadBlobChunk_result.class, metaDataMap);
    }

    public downloadBlobChunk_result() {
    }

    public downloadBlobChunk_result(
      ByteBuffer success,
      AuthorizationException aze)
    {
      this();
      this.success = org.apache.thrift.TBaseHelper.copyBinary(success);
      this.aze = aze;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public downloadBlobChunk_result(downloadBlobChunk_result other) {
      if (other.is_set_success()) {
        this.success = org.apache.thrift.TBaseHelper.copyBinary(other.success);
      }
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
    }

    public downloadBlobChunk_result deepCopy() {
      return new downloadBlobChunk_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.aze = null;
    }

    public byte[] get_success() {
      set_success(org.apache.thrift.TBaseHelper.rightSize(success));
      return success == null ? null : success.array();
    }

    public ByteBuffer buffer_for_success() {
      return org.apache.thrift.TBaseHelper.copyBinary(success);
    }

    public void set_success(byte[] success) {
      this.success = success == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(success, success.length));
    }

    public void set_success(ByteBuffer success) {
      this.success = org.apache.thrift.TBaseHelper.copyBinary(success);
    }

    public void unset_success() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean is_set_success() {
      return this.success != null;
    }

    public void set_success_isSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unset_success();
        } else {
          set_success((ByteBuffer)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return get_success();

      case AZE:
        return get_aze();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return is_set_success();
      case AZE:
        return is_set_aze();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof downloadBlobChunk_result)
        return this.equals((downloadBlobChunk_result)that);
      return false;
    }

    public boolean equals(downloadBlobChunk_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.is_set_success();
      boolean that_present_success = true && that.is_set_success();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (is_set_success());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      return list.hashCode();
    }

    @Override
    public int compareTo(downloadBlobChunk_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_success()).compareTo(other.is_set_success());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_success()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("downloadBlobChunk_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.success, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class downloadBlobChunk_resultStandardSchemeFactory implements SchemeFactory {
      public downloadBlobChunk_resultStandardScheme getScheme() {
        return new downloadBlobChunk_resultStandardScheme();
      }
    }

    private static class downloadBlobChunk_resultStandardScheme extends StandardScheme<downloadBlobChunk_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, downloadBlobChunk_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readBinary();
                struct.set_success_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, downloadBlobChunk_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBinary(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class downloadBlobChunk_resultTupleSchemeFactory implements SchemeFactory {
      public downloadBlobChunk_resultTupleScheme getScheme() {
        return new downloadBlobChunk_resultTupleScheme();
      }
    }

    private static class downloadBlobChunk_resultTupleScheme extends TupleScheme<downloadBlobChunk_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, downloadBlobChunk_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_success()) {
          optionals.set(0);
        }
        if (struct.is_set_aze()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_success()) {
          oprot.writeBinary(struct.success);
        }
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, downloadBlobChunk_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBinary();
          struct.set_success_isSet(true);
        }
        if (incoming.get(1)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
      }
    }

  }

  public static class deleteBlob_args implements org.apache.thrift.TBase<deleteBlob_args, deleteBlob_args._Fields>, java.io.Serializable, Cloneable, Comparable<deleteBlob_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteBlob_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new deleteBlob_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new deleteBlob_argsTupleSchemeFactory());
    }

    private String key; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteBlob_args.class, metaDataMap);
    }

    public deleteBlob_args() {
    }

    public deleteBlob_args(
      String key)
    {
      this();
      this.key = key;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteBlob_args(deleteBlob_args other) {
      if (other.is_set_key()) {
        this.key = other.key;
      }
    }

    public deleteBlob_args deepCopy() {
      return new deleteBlob_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
    }

    public String get_key() {
      return this.key;
    }

    public void set_key(String key) {
      this.key = key;
    }

    public void unset_key() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean is_set_key() {
      return this.key != null;
    }

    public void set_key_isSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unset_key();
        } else {
          set_key((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return get_key();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return is_set_key();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteBlob_args)
        return this.equals((deleteBlob_args)that);
      return false;
    }

    public boolean equals(deleteBlob_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.is_set_key();
      boolean that_present_key = true && that.is_set_key();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (is_set_key());
      list.add(present_key);
      if (present_key)
        list.add(key);

      return list.hashCode();
    }

    @Override
    public int compareTo(deleteBlob_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_key()).compareTo(other.is_set_key());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_key()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("deleteBlob_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteBlob_argsStandardSchemeFactory implements SchemeFactory {
      public deleteBlob_argsStandardScheme getScheme() {
        return new deleteBlob_argsStandardScheme();
      }
    }

    private static class deleteBlob_argsStandardScheme extends StandardScheme<deleteBlob_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteBlob_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.key = iprot.readString();
                struct.set_key_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteBlob_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          oprot.writeString(struct.key);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteBlob_argsTupleSchemeFactory implements SchemeFactory {
      public deleteBlob_argsTupleScheme getScheme() {
        return new deleteBlob_argsTupleScheme();
      }
    }

    private static class deleteBlob_argsTupleScheme extends TupleScheme<deleteBlob_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteBlob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_key()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_key()) {
          oprot.writeString(struct.key);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteBlob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.key = iprot.readString();
          struct.set_key_isSet(true);
        }
      }
    }

  }

  public static class deleteBlob_result implements org.apache.thrift.TBase<deleteBlob_result, deleteBlob_result._Fields>, java.io.Serializable, Cloneable, Comparable<deleteBlob_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteBlob_result");

    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField KNF_FIELD_DESC = new org.apache.thrift.protocol.TField("knf", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new deleteBlob_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new deleteBlob_resultTupleSchemeFactory());
    }

    private AuthorizationException aze; // required
    private KeyNotFoundException knf; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      AZE((short)1, "aze"),
      KNF((short)2, "knf");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // AZE
            return AZE;
          case 2: // KNF
            return KNF;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.KNF, new org.apache.thrift.meta_data.FieldMetaData("knf", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteBlob_result.class, metaDataMap);
    }

    public deleteBlob_result() {
    }

    public deleteBlob_result(
      AuthorizationException aze,
      KeyNotFoundException knf)
    {
      this();
      this.aze = aze;
      this.knf = knf;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteBlob_result(deleteBlob_result other) {
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
      if (other.is_set_knf()) {
        this.knf = new KeyNotFoundException(other.knf);
      }
    }

    public deleteBlob_result deepCopy() {
      return new deleteBlob_result(this);
    }

    @Override
    public void clear() {
      this.aze = null;
      this.knf = null;
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public KeyNotFoundException get_knf() {
      return this.knf;
    }

    public void set_knf(KeyNotFoundException knf) {
      this.knf = knf;
    }

    public void unset_knf() {
      this.knf = null;
    }

    /** Returns true if field knf is set (has been assigned a value) and false otherwise */
    public boolean is_set_knf() {
      return this.knf != null;
    }

    public void set_knf_isSet(boolean value) {
      if (!value) {
        this.knf = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      case KNF:
        if (value == null) {
          unset_knf();
        } else {
          set_knf((KeyNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case AZE:
        return get_aze();

      case KNF:
        return get_knf();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case AZE:
        return is_set_aze();
      case KNF:
        return is_set_knf();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteBlob_result)
        return this.equals((deleteBlob_result)that);
      return false;
    }

    public boolean equals(deleteBlob_result that) {
      if (that == null)
        return false;

      boolean this_present_aze = true && this.is_set_aze();
      boolean that_present_aze = true && that.is_set_aze();
      if (this_present_aze || that_present_aze) {
        if (!(this_present_aze && that_present_aze))
          return false;
        if (!this.aze.equals(that.aze))
          return false;
      }

      boolean this_present_knf = true && this.is_set_knf();
      boolean that_present_knf = true && that.is_set_knf();
      if (this_present_knf || that_present_knf) {
        if (!(this_present_knf && that_present_knf))
          return false;
        if (!this.knf.equals(that.knf))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_aze = true && (is_set_aze());
      list.add(present_aze);
      if (present_aze)
        list.add(aze);

      boolean present_knf = true && (is_set_knf());
      list.add(present_knf);
      if (present_knf)
        list.add(knf);

      return list.hashCode();
    }

    @Override
    public int compareTo(deleteBlob_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_aze()).compareTo(other.is_set_aze());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_aze()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.aze, other.aze);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(is_set_knf()).compareTo(other.is_set_knf());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_knf()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.knf, other.knf);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("deleteBlob_result(");
      boolean first = true;

      sb.append("aze:");
      if (this.aze == null) {
        sb.append("null");
      } else {
        sb.append(this.aze);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("knf:");
      if (this.knf == null) {
        sb.append("null");
      } else {
        sb.append(this.knf);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteBlob_resultStandardSchemeFactory implements SchemeFactory {
      public deleteBlob_resultStandardScheme getScheme() {
        return new deleteBlob_resultStandardScheme();
      }
    }

    private static class deleteBlob_resultStandardScheme extends StandardScheme<deleteBlob_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteBlob_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // AZE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.aze = new AuthorizationException();
                struct.aze.read(iprot);
                struct.set_aze_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // KNF
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.knf = new KeyNotFoundException();
                struct.knf.read(iprot);
                struct.set_knf_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteBlob_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.aze != null) {
          oprot.writeFieldBegin(AZE_FIELD_DESC);
          struct.aze.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.knf != null) {
          oprot.writeFieldBegin(KNF_FIELD_DESC);
          struct.knf.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteBlob_resultTupleSchemeFactory implements SchemeFactory {
      public deleteBlob_resultTupleScheme getScheme() {
        return new deleteBlob_resultTupleScheme();
      }
    }

    private static class deleteBlob_resultTupleScheme extends TupleScheme<deleteBlob_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteBlob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_aze()) {
          optionals.set(0);
        }
        if (struct.is_set_knf()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.is_set_aze()) {
          struct.aze.write(oprot);
        }
        if (struct.is_set_knf()) {
          struct.knf.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteBlob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.aze = new AuthorizationException();
          struct.aze.read(iprot);
          struct.set_aze_isSet(true);
        }
        if (incoming.get(1)) {
          struct.knf = new KeyNotFoundException();
          struct.knf.read(iprot);
          struct.set_knf_isSet(true);
        }
      }
    }

  }

  public static class listBlobs_args implements org.apache.thrift.TBase<listBlobs_args, listBlobs_args._Fields>, java.io.Serializable, Cloneable, Comparable<listBlobs_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("listBlobs_args");

    private static final org.apache.thrift.protocol.TField SESSION_FIELD_DESC = new org.apache.thrift.protocol.TField("session", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new listBlobs_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new listBlobs_argsTupleSchemeFactory());
    }

    private String session; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SESSION((short)1, "session");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SESSION
            return SESSION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SESSION, new org.apache.thrift.meta_data.FieldMetaData("session", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(listBlobs_args.class, metaDataMap);
    }

    public listBlobs_args() {
    }

    public listBlobs_args(
      String session)
    {
      this();
      this.session = session;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public listBlobs_args(listBlobs_args other) {
      if (other.is_set_session()) {
        this.session = other.session;
      }
    }

    public listBlobs_args deepCopy() {
      return new listBlobs_args(this);
    }

    @Override
    public void clear() {
      this.session = null;
    }

    public String get_session() {
      return this.session;
    }

    public void set_session(String session) {
      this.session = session;
    }

    public void unset_session() {
      this.session = null;
    }

    /** Returns true if field session is set (has been assigned a value) and false otherwise */
    public boolean is_set_session() {
      return this.session != null;
    }

    public void set_session_isSet(boolean value) {
      if (!value) {
        this.session = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SESSION:
        if (value == null) {
          unset_session();
        } else {
          set_session((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SESSION:
        return get_session();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SESSION:
        return is_set_session();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof listBlobs_args)
        return this.equals((listBlobs_args)that);
      return false;
    }

    public boolean equals(listBlobs_args that) {
      if (that == null)
        return false;

      boolean this_present_session = true && this.is_set_session();
      boolean that_present_session = true && that.is_set_session();
      if (this_present_session || that_present_session) {
        if (!(this_present_session && that_present_session))
          return false;
        if (!this.session.equals(that.session))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_session = true && (is_set_session());
      list.add(present_session);
      if (present_session)
        list.add(session);

      return list.hashCode();
    }

    @Override
    public int compareTo(listBlobs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_session()).compareTo(other.is_set_session());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_session()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.session, other.session);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("listBlobs_args(");
      boolean first = true;

      sb.append("session:");
      if (this.session == null) {
        sb.append("null");
      } else {
        sb.append(this.session);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class listBlobs_argsStandardSchemeFactory implements SchemeFactory {
      public listBlobs_argsStandardScheme getScheme() {
        return new listBlobs_argsStandardScheme();
      }
    }

    private static class listBlobs_argsStandardScheme extends StandardScheme<listBlobs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, listBlobs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SESSION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.session = iprot.readString();
                struct.set_session_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, listBlobs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.session != null) {
          oprot.writeFieldBegin(SESSION_FIELD_DESC);
          oprot.writeString(struct.session);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class listBlobs_argsTupleSchemeFactory implements SchemeFactory {
      public listBlobs_argsTupleScheme getScheme() {
        return new listBlobs_argsTupleScheme();
      }
    }

    private static class listBlobs_argsTupleScheme extends TupleScheme<listBlobs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, listBlobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_session()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_session()) {
          oprot.writeString(struct.session);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, listBlobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.session = iprot.readString();
          struct.set_session_isSet(true);
        }
      }
    }

  }

  public static class listBlobs_result implements org.apache.thrift.TBase<listBlobs_result, listBlobs_result._Fields>, java.io.Serializable, Cloneable, Comparable<listBlobs_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("listBlobs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new listBlobs_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new listBlobs_resultTupleSchemeFactory());
    }

    private ListBlobsResult success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ListBlobsResult.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(listBlobs_result.class, metaDataMap);
    }

    public listBlobs_result() {
    }

    public listBlobs_result(
      ListBlobsResult success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public listBlobs_result(listBlobs_result other) {
      if (other.is_set_success()) {
        this.success = new ListBlobsResult(other.success);
      }
    }

    public listBlobs_result deepCopy() {
      return new listBlobs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public ListBlobsResult get_success() {
      return this.success;
    }

    public void set_success(ListBlobsResult success) {
      this.success = success;
    }

    public void unset_success() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean is_set_success() {
      return this.success != null;
    }

    public void set_success_isSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unset_success();
        } else {
          set_success((ListBlobsResult)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return get_success();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return is_set_success();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof listBlobs_result)
        return this.equals((listBlobs_result)that);
      return false;
    }

    public boolean equals(listBlobs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.is_set_success();
      boolean that_present_success = true && that.is_set_success();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (is_set_success());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(listBlobs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_success()).compareTo(other.is_set_success());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_success()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("listBlobs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class listBlobs_resultStandardSchemeFactory implements SchemeFactory {
      public listBlobs_resultStandardScheme getScheme() {
        return new listBlobs_resultStandardScheme();
      }
    }

    private static class listBlobs_resultStandardScheme extends StandardScheme<listBlobs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, listBlobs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ListBlobsResult();
                struct.success.read(iprot);
                struct.set_success_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, listBlobs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class listBlobs_resultTupleSchemeFactory implements SchemeFactory {
      public listBlobs_resultTupleScheme getScheme() {
        return new listBlobs_resultTupleScheme();
      }
    }

    private static class listBlobs_resultTupleScheme extends TupleScheme<listBlobs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, listBlobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_success()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_success()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, listBlobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new ListBlobsResult();
          struct.success.read(iprot);
          struct.set_success_isSet(true);
        }
      }
    }

  }

  public static class getBlobReplication_args implements org.apache.thrift.TBase<getBlobReplication_args, getBlobReplication_args._Fields>, java.io.Serializable, Cloneable, Comparable<getBlobReplication_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getBlobReplication_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getBlobReplication_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getBlobReplication_argsTupleSchemeFactory());
    }

    private String key; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getBlobReplication_args.class, metaDataMap);
    }

    public getBlobReplication_args() {
    }

    public getBlobReplication_args(
      String key)
    {
      this();
      this.key = key;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getBlobReplication_args(getBlobReplication_args other) {
      if (other.is_set_key()) {
        this.key = other.key;
      }
    }

    public getBlobReplication_args deepCopy() {
      return new getBlobReplication_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
    }

    public String get_key() {
      return this.key;
    }

    public void set_key(String key) {
      this.key = key;
    }

    public void unset_key() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean is_set_key() {
      return this.key != null;
    }

    public void set_key_isSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unset_key();
        } else {
          set_key((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return get_key();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return is_set_key();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getBlobReplication_args)
        return this.equals((getBlobReplication_args)that);
      return false;
    }

    public boolean equals(getBlobReplication_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.is_set_key();
      boolean that_present_key = true && that.is_set_key();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (is_set_key());
      list.add(present_key);
      if (present_key)
        list.add(key);

      return list.hashCode();
    }

    @Override
    public int compareTo(getBlobReplication_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(is_set_key()).compareTo(other.is_set_key());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (is_set_key()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getBlobReplication_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getBlobReplication_argsStandardSchemeFactory implements SchemeFactory {
      public getBlobReplication_argsStandardScheme getScheme() {
        return new getBlobReplication_argsStandardScheme();
      }
    }

    private static class getBlobReplication_argsStandardScheme extends StandardScheme<getBlobReplication_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getBlobReplication_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.key = iprot.readString();
                struct.set_key_isSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getBlobReplication_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          oprot.writeString(struct.key);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getBlobReplication_argsTupleSchemeFactory implements SchemeFactory {
      public getBlobReplication_argsTupleScheme getScheme() {
        return new getBlobReplication_argsTupleScheme();
      }
    }

    private static class getBlobReplication_argsTupleScheme extends TupleScheme<getBlobReplication_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getBlobReplication_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.is_set_key()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.is_set_key()) {
          oprot.writeString(struct.key);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getBlobReplication_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.key = iprot.readString();
          struct.set_key_isSet(true);
        }
      }
    }

  }

  public static class getBlobReplication_result implements org.apache.thrift.TBase<getBlobReplication_result, getBlobReplication_result._Fields>, java.io.Serializable, Cloneable, Comparable<getBlobReplication_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getBlobReplication_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I32, (short)0);
    private static final org.apache.thrift.protocol.TField AZE_FIELD_DESC = new org.apache.thrift.protocol.TField("aze", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField KNF_FIELD_DESC = new org.apache.thrift.protocol.TField("knf", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getBlobReplication_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getBlobReplication_resultTupleSchemeFactory());
    }

    private int success; // required
    private AuthorizationException aze; // required
    private KeyNotFoundException knf; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      AZE((short)1, "aze"),
      KNF((short)2, "knf");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // AZE
            return AZE;
          case 2: // KNF
            return KNF;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.AZE, new org.apache.thrift.meta_data.FieldMetaData("aze", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.KNF, new org.apache.thrift.meta_data.FieldMetaData("knf", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getBlobReplication_result.class, metaDataMap);
    }

    public getBlobReplication_result() {
    }

    public getBlobReplication_result(
      int success,
      AuthorizationException aze,
      KeyNotFoundException knf)
    {
      this();
      this.success = success;
      set_success_isSet(true);
      this.aze = aze;
      this.knf = knf;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getBlobReplication_result(getBlobReplication_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.is_set_aze()) {
        this.aze = new AuthorizationException(other.aze);
      }
      if (other.is_set_knf()) {
        this.knf = new KeyNotFoundException(other.knf);
      }
    }

    public getBlobReplication_result deepCopy() {
      return new getBlobReplication_result(this);
    }

    @Override
    public void clear() {
      set_success_isSet(false);
      this.success = 0;
      this.aze = null;
      this.knf = null;
    }

    public int get_success() {
      return this.success;
    }

    public void set_success(int success) {
      this.success = success;
      set_success_isSet(true);
    }

    public void unset_success() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean is_set_success() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void set_success_isSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public AuthorizationException get_aze() {
      return this.aze;
    }

    public void set_aze(AuthorizationException aze) {
      this.aze = aze;
    }

    public void unset_aze() {
      this.aze = null;
    }

    /** Returns true if field aze is set (has been assigned a value) and false otherwise */
    public boolean is_set_aze() {
      return this.aze != null;
    }

    public void set_aze_isSet(boolean value) {
      if (!value) {
        this.aze = null;
      }
    }

    public KeyNotFoundException get_knf() {
      return this.knf;
    }

    public void set_knf(KeyNotFoundException knf) {
      this.knf = knf;
    }

    public void unset_knf() {
      this.knf = null;
    }

    /** Returns true if field knf is set (has been assigned a value) and false otherwise */
    public boolean is_set_knf() {
      return this.knf != null;
    }

    public void set_knf_isSet(boolean value) {
      if (!value) {
        this.knf = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unset_success();
        } else {
          set_success((Integer)value);
        }
        break;

      case AZE:
        if (value == null) {
          unset_aze();
        } else {
          set_aze((AuthorizationException)value);
        }
        break;

      case KNF:
        if (value == null) {
          unset_knf();
        } else {
          set_knf((KeyNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return get_success();

      case AZE: