/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package org.apache.storm.eventhubs.spout;

import org.apache.storm.tuple.Fields;
import java.io.Serializable;
import java.util.List;
import org.apache.qpid.amqp_1_0.client.Message;

public interface IEventDataScheme extends Serializable {

  /**
   * Deserialize an AMQP Message into a Tuple.
   *
   * @see #getOutputFields() for the list of fields the tuple will contain.
   *
   * @param message The Message to Deserialize.
   * @return A tuple containing the deserialized fields of the message.
   */
  List<Object> deserialize(Message message);

  /**
   * Retrieve the Fields that are present on tuples created by this object.
   *
   * @return The Fields that are present on tuples created by this object.
   */
  Fields getOutputFields();
}
