<#--
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->
<@namespace platform="http://clerezza.org/2009/08/platform#" />
<@namespace permission="http://clerezza.org/2008/10/permission#" />
<@namespace sioc="http://rdfs.org/sioc/ns#" />
<table id="user-table" class="nicetable noauto">
    <thead><tr><th>Name</th><th>login</th><th>email</th><th>groups</th><th>&nbsp;</th></tr></thead>
    <tbody>
        <@ldpath path="fn:sort(^rdf:type)">
        <#assign userName>
            <@ldpath path="platform:userName :: xsd:string"/>
        </#assign>
        <tr>
            <td>get full name here</td>
            <td>${userName}</td>

            <#assign mbox>
            <@ldpath path="foaf:mbox" />
            </#assign>
            <#assign email>
            <#if mbox != "">${mbox?substring(7)}</#if>
            </#assign>
            <td>${email}</td>

            <td>
            <@ldpath path="fn:sort(sioc:has_function)">
               <@ldpath path="dc:title :: xsd:string"/>
            </@ldpath>
            </td>
            <td>
                <ul class="icons ui-widget">
                    <li class="dynhover ui-state-default ui-corner-all" title="Edit" onClick="javascript:editUser('${userName}')"><span class="ui-icon ui-icon-edit">&nbsp;</span></li>
                    <li class="dynhover ui-state-default ui-corner-all" title="delete" onClick="javascript:removeUser('${userName}')"><span class="ui-icon ui-icon-trash">&nbsp;</span></li>
                </ul>
            </td>
        </tr>
        </@ldpath>
    </tbody>
</table>