/* Generated By:JavaCC: Do not edit this line. RuleParserImpl.java */
package org.apache.stanbol.rules.manager.parse;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;

import org.apache.clerezza.commons.rdf.IRI;
import org.apache.stanbol.rules.base.api.Rule;
import org.apache.stanbol.rules.base.api.RuleAtom;
import org.apache.stanbol.rules.base.api.util.AtomList;
import org.apache.stanbol.rules.manager.KB;
import org.apache.stanbol.rules.manager.RuleImpl;
import org.apache.stanbol.rules.manager.atoms.ClassAtom;
import org.apache.stanbol.rules.manager.atoms.ComparisonAtom;
import org.apache.stanbol.rules.manager.atoms.ConcatAtom;
import org.apache.stanbol.rules.manager.atoms.CreateLabelAtom;
import org.apache.stanbol.rules.manager.atoms.DatavaluedPropertyAtom;
import org.apache.stanbol.rules.manager.atoms.DifferentAtom;
import org.apache.stanbol.rules.manager.atoms.DivisionAtom;
import org.apache.stanbol.rules.manager.atoms.EndsWithAtom;
import org.apache.stanbol.rules.manager.atoms.ExpressionAtom;
import org.apache.stanbol.rules.manager.atoms.GreaterEqualThanAtom;
import org.apache.stanbol.rules.manager.atoms.GreaterThanAtom;
import org.apache.stanbol.rules.manager.atoms.IObjectAtom;
import org.apache.stanbol.rules.manager.atoms.IndividualPropertyAtom;
import org.apache.stanbol.rules.manager.atoms.IsBlankAtom;
import org.apache.stanbol.rules.manager.atoms.LengthAtom;
import org.apache.stanbol.rules.manager.atoms.LessEqualThanAtom;
import org.apache.stanbol.rules.manager.atoms.LessThanAtom;
import org.apache.stanbol.rules.manager.atoms.LetAtom;
import org.apache.stanbol.rules.manager.atoms.LocalNameAtom;
import org.apache.stanbol.rules.manager.atoms.LowerCaseAtom;
import org.apache.stanbol.rules.manager.atoms.MultiplicationAtom;
import org.apache.stanbol.rules.manager.atoms.NamespaceAtom;
import org.apache.stanbol.rules.manager.atoms.NewIRIAtom;
import org.apache.stanbol.rules.manager.atoms.NewLiteralAtom;
import org.apache.stanbol.rules.manager.atoms.NotAtom;
import org.apache.stanbol.rules.manager.atoms.NumberAtom;
import org.apache.stanbol.rules.manager.atoms.NumericFunctionAtom;
import org.apache.stanbol.rules.manager.atoms.NumericVariableAtom;
import org.apache.stanbol.rules.manager.atoms.PropStringAtom;
import org.apache.stanbol.rules.manager.atoms.ResourceAtom;
import org.apache.stanbol.rules.manager.atoms.RuleBlankNode;
import org.apache.stanbol.rules.manager.atoms.SameAtom;
import org.apache.stanbol.rules.manager.atoms.StartsWithAtom;
import org.apache.stanbol.rules.manager.atoms.StrAtom;
import org.apache.stanbol.rules.manager.atoms.StringAtom;
import org.apache.stanbol.rules.manager.atoms.StringFunctionAtom;
import org.apache.stanbol.rules.manager.atoms.StringVariableAtom;
import org.apache.stanbol.rules.manager.atoms.SubstringAtom;
import org.apache.stanbol.rules.manager.atoms.SubtractionAtom;
import org.apache.stanbol.rules.manager.atoms.SumAtom;
import org.apache.stanbol.rules.manager.atoms.TypedLiteralAtom;
import org.apache.stanbol.rules.manager.atoms.UnionAtom;
import org.apache.stanbol.rules.manager.atoms.UpperCaseAtom;
import org.apache.stanbol.rules.manager.atoms.VariableAtom;

import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;

/**
*
* @author anuzzolese 
* 
*/

@SuppressWarnings("unused")

public class RuleParserImpl implements RuleParserImplConstants {

  static KB kb;

  public static KB parse( String namespace, String inString ) {
  {
        kb = new KB(namespace);
        Reader reader = new StringReader( inString ) ;
    RuleParserImpl parser = new RuleParserImpl(reader);
    StringBuffer buffer = new StringBuffer() ;
        try {
                parser.start( ) ;
        } catch( TokenMgrError e ) {
                throw new IllegalStateException(e) ;
        } catch( ParseException e ) {
                throw new IllegalStateException(e) ;
        }
        return kb ; }
  }

  public static KB parse( String namespace, InputStream inStream ) {

                kb = new KB(namespace);
                Reader reader = new InputStreamReader(inStream);
                RuleParserImpl parser = new RuleParserImpl(reader);
                try {
                        parser.start();
                } catch (TokenMgrError e) {
                        throw new IllegalStateException(e);
                } catch (ParseException e) {
                        throw new IllegalStateException(e);
                }
                return kb;
        }


        private static URI getSWRLArgument(String argument){
                Resource rdfNode = null;
                String[] argumentComposition = argument.split(":");
                if(argumentComposition.length == 2){
                        String prefix = argumentComposition[0];
                        String resourceName = argumentComposition[1];

                        String namespaceURI = kb.getPrefixURI(prefix);
                        rdfNode = ModelFactory.createDefaultModel().createResource(namespaceURI+resourceName);
                        try {
                                                        return new URI(rdfNode.getURI());
                                                } catch (URISyntaxException e) {
                                                        // TODO Auto-generated catch block
                                                        e.printStackTrace();
                                                }

                }

                return null;
        }

        private static URI getSWRLVariable(String argument){
                Resource variableResource = null;
                String variableString = argument.substring(1);


                variableResource = ModelFactory.createDefaultModel().createResource(kb.getPrefixURI("var")+variableString);



                try {
                                        return new URI(variableResource.getURI());
                                } catch (URISyntaxException e) {
                                        // TODO Auto-generated catch block
                                        e.printStackTrace();
                                        return null;
                                }
        }

  final public void start() throws ParseException {
    expression();
    expressionCont();
  }

  final public void expressionCont() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AND:
      jj_consume_token(AND);
      expression();
      break;
    default:
      jj_la1[0] = jj_gen;

    }
  }

  final public void expression() throws ParseException {
 Rule rule;
    prefix();
    expressionCont();
  }

  final public void prefix() throws ParseException {
 String nsPrefix; Object obj; Rule rule;
    nsPrefix = getVariable();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUAL:
      obj = equality();
                                           String prefixURI = (String)obj;
                                                                                   prefixURI = prefixURI.substring(1, prefixURI.length()-1);
                                                                                   kb.addPrefix(nsPrefix, prefixURI);
      break;
    case LQUAD:
      obj = rule();
                                                                         AtomList[] atoms = (AtomList[]) obj;
                                                                                         String ruleStorePrefix = kb.getPrefixURI("rmi2");
                                                                                         ruleStorePrefix = ruleStorePrefix.substring(0, ruleStorePrefix.length());

                                                                                         if(atoms.length == 1){
                                                            AtomList body = atoms[0];
                                                            if(body.size() == 1){
                                                                    // FIXME it previously managed SPARQL code injection.
                                                            }

                                                     }
                                                 else{
                                                         rule = new RuleImpl(new IRI(ruleStorePrefix+nsPrefix), nsPrefix, atoms[0], atoms[1]);
                                                         kb.addRule(rule);
                                                }
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public String equality() throws ParseException {
 String nsURI;
    jj_consume_token(EQUAL);
    nsURI = getURI();
          {if (true) return nsURI;}
    throw new Error("Missing return statement in function");
  }

  final public AtomList[] rule() throws ParseException {
 AtomList[] ruleAtoms;
    jj_consume_token(LQUAD);
    ruleAtoms = ruleDefinition();
    jj_consume_token(RQUAD);
     {if (true) return ruleAtoms;}
    throw new Error("Missing return statement in function");
  }

  final public AtomList[] ruleDefinition() throws ParseException {
 AtomList body; AtomList head; Token t;
    body = atomList();
    jj_consume_token(LARROW);
    head = atomList();
          {if (true) return new AtomList[]{body, head};}
    throw new Error("Missing return statement in function");
  }

  final public AtomList atomList() throws ParseException {
 AtomList atomList = new AtomList(); RuleAtom kReSAtom;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SAME:
    case DIFFERENT:
    case LESSTHAN:
    case GREATERTHAN:
    case IS:
    case NEW_IRI:
    case NEW_LITERAL:
    case STARTS_WITH:
    case ENDS_WITH:
    case LET:
    case HAS:
    case VALUES:
    case NOT:
    case UNION:
    case IS_BLANK:
      kReSAtom = atom();
      atomList = atomListRest();
          atomList.addToHead(kReSAtom); {if (true) return atomList;}
      break;
    default:
      jj_la1[2] = jj_gen;

         {if (true) return atomList;}
    }
    throw new Error("Missing return statement in function");
  }

  final public AtomList atomListRest() throws ParseException {
 AtomList atomList = new AtomList(); RuleAtom kReSAtom;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AND:
      jj_consume_token(AND);
      atomList = atomList();
          {if (true) return atomList;}
      break;
    default:
      jj_la1[3] = jj_gen;

         {if (true) return atomList;}
    }
    throw new Error("Missing return statement in function");
  }

  final public RuleAtom atom() throws ParseException {
 RuleAtom ruleAtom;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IS:
      ruleAtom = classAtom();
                         {if (true) return ruleAtom;}
      break;
    case HAS:
      ruleAtom = individualPropertyAtom();
                                      {if (true) return ruleAtom;}
      break;
    case VALUES:
      ruleAtom = datavaluedPropertyAtom();
                                      {if (true) return ruleAtom;}
      break;
    case LET:
      ruleAtom = letAtom();
                       {if (true) return ruleAtom;}
      break;
    case NEW_IRI:
      ruleAtom = newIRIAtom();
                          {if (true) return ruleAtom;}
      break;
    case NEW_LITERAL:
      ruleAtom = newLiteralAtom();
                              {if (true) return ruleAtom;}
      break;
    case SAME:
    case DIFFERENT:
    case LESSTHAN:
    case GREATERTHAN:
    case STARTS_WITH:
    case ENDS_WITH:
    case NOT:
    case IS_BLANK:
      ruleAtom = comparisonAtom();
                              {if (true) return ruleAtom;}
      break;
    case UNION:
      ruleAtom = unionAtom();
                         {if (true) return ruleAtom;}
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public RuleAtom unionAtom() throws ParseException {
 AtomList atomList1; AtomList atomList2;
    jj_consume_token(UNION);
    jj_consume_token(LPAR);
    atomList1 = atomList();
    jj_consume_token(COMMA);
    atomList2 = atomList();
    jj_consume_token(RPAR);
          {if (true) return new UnionAtom(atomList1, atomList2);}
    throw new Error("Missing return statement in function");
  }

  final public StringFunctionAtom createLabelAtom() throws ParseException {
 StringFunctionAtom stringFunctionAtom;
    jj_consume_token(CREATE_LABEL);
    jj_consume_token(LPAR);
    stringFunctionAtom = stringFunctionAtom();
    jj_consume_token(RPAR);
          {if (true) return new CreateLabelAtom(stringFunctionAtom);}
    throw new Error("Missing return statement in function");
  }

  final public StringFunctionAtom propStringAtom() throws ParseException {
 StringFunctionAtom stringFunctionAtom1; StringFunctionAtom stringFunctionAtom2;
    jj_consume_token(PROP);
    jj_consume_token(LPAR);
    stringFunctionAtom1 = stringFunctionAtom();
    jj_consume_token(COMMA);
    stringFunctionAtom2 = stringFunctionAtom();
    jj_consume_token(RPAR);
          {if (true) return new PropStringAtom(stringFunctionAtom1, stringFunctionAtom2);}
    throw new Error("Missing return statement in function");
  }

  final public ComparisonAtom endsWithAtom() throws ParseException {
 RuleAtom ruleAtom; StringFunctionAtom arg; StringFunctionAtom stringFunctionAtom;
    jj_consume_token(ENDS_WITH);
    jj_consume_token(LPAR);
    arg = stringFunctionAtom();
    jj_consume_token(COMMA);
    stringFunctionAtom = stringFunctionAtom();
    jj_consume_token(RPAR);
         {if (true) return new EndsWithAtom(arg, stringFunctionAtom);}
    throw new Error("Missing return statement in function");
  }

  final public ComparisonAtom startsWithAtom() throws ParseException {
 RuleAtom ruleAtom; StringFunctionAtom arg; StringFunctionAtom stringFunctionAtom;
    jj_consume_token(STARTS_WITH);
    jj_consume_token(LPAR);
    arg = stringFunctionAtom();
    jj_consume_token(COMMA);
    stringFunctionAtom = stringFunctionAtom();
    jj_consume_token(RPAR);
         {if (true) return new StartsWithAtom(arg, stringFunctionAtom);}
    throw new Error("Missing return statement in function");
  }

  final public StringFunctionAtom stringFunctionAtom() throws ParseException {
 Object obj; StringFunctionAtom stringFunctionAtom;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONCAT:
      stringFunctionAtom = concatAtom();
      break;
    case UPPERCASE:
      stringFunctionAtom = upperCaseAtom();
      break;
    case LOWERCASE:
      stringFunctionAtom = lowerCaseAtom();
      break;
    case SUBSTRING:
      stringFunctionAtom = substringAtom();
      break;
    case NAMESPACE:
      stringFunctionAtom = namespaceAtom();
      break;
    case LOCALNAME:
      stringFunctionAtom = localnameAtom();
      break;
    case STR:
      stringFunctionAtom = strAtom();
      break;
    case STRING:
      stringFunctionAtom = stringAtom();
      break;
    case PROP:
      stringFunctionAtom = propStringAtom();
      break;
    case CREATE_LABEL:
      stringFunctionAtom = createLabelAtom();
      break;
    case VARIABLE:
      stringFunctionAtom = stringVariable();
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
         {if (true) return stringFunctionAtom;}
    throw new Error("Missing return statement in function");
  }

  final public StrAtom strAtom() throws ParseException {
 IObjectAtom uri;
    jj_consume_token(STR);
    jj_consume_token(LPAR);
    uri = iObject();
    jj_consume_token(RPAR);
         {if (true) return new StrAtom(uri);}
    throw new Error("Missing return statement in function");
  }

  final public NamespaceAtom namespaceAtom() throws ParseException {
 IObjectAtom uri;
    jj_consume_token(NAMESPACE);
    jj_consume_token(LPAR);
    uri = iObject();
    jj_consume_token(RPAR);
         {if (true) return new NamespaceAtom(uri);}
    throw new Error("Missing return statement in function");
  }

  final public LocalNameAtom localnameAtom() throws ParseException {
 IObjectAtom uri;
    jj_consume_token(LOCALNAME);
    jj_consume_token(LPAR);
    uri = iObject();
    jj_consume_token(RPAR);
         {if (true) return new LocalNameAtom(uri);}
    throw new Error("Missing return statement in function");
  }

  final public StringAtom stringAtom() throws ParseException {
 String obj;
    obj = getStringValue();
                                 {if (true) return new StringAtom(obj);}
    throw new Error("Missing return statement in function");
  }

  final public ConcatAtom concatAtom() throws ParseException {
 StringFunctionAtom arg1; StringFunctionAtom arg2;
    jj_consume_token(CONCAT);
    jj_consume_token(LPAR);
    arg1 = stringFunctionAtom();
    jj_consume_token(COMMA);
    arg2 = stringFunctionAtom();
    jj_consume_token(RPAR);
          {if (true) return new ConcatAtom(arg1, arg2);}
    throw new Error("Missing return statement in function");
  }

  final public UpperCaseAtom upperCaseAtom() throws ParseException {
 StringFunctionAtom arg;
    jj_consume_token(UPPERCASE);
    jj_consume_token(LPAR);
    arg = stringFunctionAtom();
    jj_consume_token(RPAR);
          {if (true) return new UpperCaseAtom(arg);}
    throw new Error("Missing return statement in function");
  }

  final public LowerCaseAtom lowerCaseAtom() throws ParseException {
 StringFunctionAtom arg;
    jj_consume_token(LOWERCASE);
    jj_consume_token(LPAR);
    arg = stringFunctionAtom();
    jj_consume_token(RPAR);
          {if (true) return new LowerCaseAtom(arg);}
    throw new Error("Missing return statement in function");
  }

  final public SubstringAtom substringAtom() throws ParseException {
 StringFunctionAtom arg; NumericFunctionAtom start; NumericFunctionAtom length;
    jj_consume_token(SUBSTRING);
    jj_consume_token(LPAR);
    arg = stringFunctionAtom();
    jj_consume_token(COMMA);
    start = numericFunctionAtom();
    jj_consume_token(COMMA);
    length = numericFunctionAtom();
    jj_consume_token(RPAR);
          {if (true) return new SubstringAtom(arg, start, length);}
    throw new Error("Missing return statement in function");
  }

  final public ExpressionAtom expressionAtom() throws ParseException {
 ExpressionAtom expressionAtom;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUBSTRING:
    case UPPERCASE:
    case LOWERCASE:
    case CONCAT:
    case NAMESPACE:
    case LOCALNAME:
    case STR:
    case CREATE_LABEL:
    case PROP:
    case VARIABLE:
    case STRING:
      expressionAtom = stringFunctionAtom();
      break;
    case LENGTH:
    case PLUS:
    case MINUS:
    case NUM:
      expressionAtom = numericFunctionAtom();
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return expressionAtom;}
    throw new Error("Missing return statement in function");
  }

  final public NumericFunctionAtom numericFunctionAtom() throws ParseException {
 NumericFunctionAtom numericFunctionAtom;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      numericFunctionAtom = sumAtom();
      break;
    case MINUS:
      numericFunctionAtom = subtractionAtom();
      break;
    case LENGTH:
      numericFunctionAtom = lengthAtom();
      break;
    case NUM:
      numericFunctionAtom = numberAtom();
      break;
    case VARIABLE:
      numericFunctionAtom = numericVariable();
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
         {if (true) return numericFunctionAtom;}
    throw new Error("Missing return statement in function");
  }

  final public LengthAtom lengthAtom() throws ParseException {
 StringFunctionAtom stringFunctionAtom;
    jj_consume_token(LENGTH);
    jj_consume_token(LPAR);
    stringFunctionAtom = stringFunctionAtom();
    jj_consume_token(RPAR);
         {if (true) return new LengthAtom(stringFunctionAtom);}
    throw new Error("Missing return statement in function");
  }

  final public SumAtom sumAtom() throws ParseException {
 NumericFunctionAtom numericFunctionAtom1; NumericFunctionAtom numericFunctionAtom2;
    jj_consume_token(PLUS);
    jj_consume_token(LPAR);
    numericFunctionAtom1 = numericFunctionAtom();
    jj_consume_token(COMMA);
    numericFunctionAtom2 = numericFunctionAtom();
    jj_consume_token(RPAR);
         {if (true) return new SumAtom(numericFunctionAtom1, numericFunctionAtom2);}
    throw new Error("Missing return statement in function");
  }

  final public SubtractionAtom subtractionAtom() throws ParseException {
 NumericFunctionAtom numericFunctionAtom1; NumericFunctionAtom numericFunctionAtom2;
    jj_consume_token(MINUS);
    jj_consume_token(LPAR);
    numericFunctionAtom1 = numericFunctionAtom();
    jj_consume_token(COMMA);
    numericFunctionAtom2 = numericFunctionAtom();
    jj_consume_token(RPAR);
         {if (true) return new SubtractionAtom(numericFunctionAtom1, numericFunctionAtom2);}
    throw new Error("Missing return statement in function");
  }

  final public MultiplicationAtom multiplicationAtom() throws ParseException {
 NumericFunctionAtom numericFunctionAtom1; NumericFunctionAtom numericFunctionAtom2;
    jj_consume_token(MULTIPLIED);
    jj_consume_token(LPAR);
    numericFunctionAtom1 = numericFunctionAtom();
    jj_consume_token(COMMA);
    numericFunctionAtom2 = numericFunctionAtom();
    jj_consume_token(RPAR);
         {if (true) return new MultiplicationAtom(numericFunctionAtom1, numericFunctionAtom2);}
    throw new Error("Missing return statement in function");
  }

  final public DivisionAtom divisionAtom() throws ParseException {
 NumericFunctionAtom numericFunctionAtom1; NumericFunctionAtom numericFunctionAtom2;
    jj_consume_token(DIVIDED);
    jj_consume_token(LPAR);
    numericFunctionAtom1 = numericFunctionAtom();
    jj_consume_token(COMMA);
    numericFunctionAtom2 = numericFunctionAtom();
    jj_consume_token(RPAR);
         {if (true) return new DivisionAtom(numericFunctionAtom1, numericFunctionAtom2);}
    throw new Error("Missing return statement in function");
  }

  final public NumericFunctionAtom numberAtom() throws ParseException {
 Token t;
    t = jj_consume_token(NUM);
          {if (true) return new NumberAtom(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public ClassAtom classAtom() throws ParseException {
 IObjectAtom uri1; IObjectAtom uri2;
    jj_consume_token(IS);
    jj_consume_token(LPAR);
    uri1 = iObject();
    jj_consume_token(COMMA);
    uri2 = iObject();
    jj_consume_token(RPAR);
          {if (true) return new ClassAtom(uri1, uri2);}
    throw new Error("Missing return statement in function");
  }

  final public NewIRIAtom newIRIAtom() throws ParseException {
 IObjectAtom arg1; StringFunctionAtom arg2;
    jj_consume_token(NEW_IRI);
    jj_consume_token(LPAR);
    arg1 = iObject();
    jj_consume_token(COMMA);
    arg2 = stringFunctionAtom();
    jj_consume_token(RPAR);
          {if (true) return new NewIRIAtom(arg1, arg2);}
    throw new Error("Missing return statement in function");
  }

  final public NewLiteralAtom newLiteralAtom() throws ParseException {
 IObjectAtom arg1; StringFunctionAtom arg2;
    jj_consume_token(NEW_LITERAL);
    jj_consume_token(LPAR);
    arg1 = iObject();
    jj_consume_token(COMMA);
    arg2 = stringFunctionAtom();
    jj_consume_token(RPAR);
          {if (true) return new NewLiteralAtom(arg1, arg2);}
    throw new Error("Missing return statement in function");
  }

  final public LetAtom letAtom() throws ParseException {
 IObjectAtom uri1; StringFunctionAtom fun;
    jj_consume_token(LET);
    jj_consume_token(LPAR);
    uri1 = iObject();
    jj_consume_token(COMMA);
    fun = stringFunctionAtom();
    jj_consume_token(RPAR);
          {if (true) return new LetAtom(uri1, fun);}
    throw new Error("Missing return statement in function");
  }

  final public IndividualPropertyAtom individualPropertyAtom() throws ParseException {
 IObjectAtom uri1; IObjectAtom uri2; IObjectAtom uri3;
    jj_consume_token(HAS);
    jj_consume_token(LPAR);
    uri1 = iObject();
    jj_consume_token(COMMA);
    uri2 = iObject();
    jj_consume_token(COMMA);
    uri3 = iObject();
    jj_consume_token(RPAR);
          {if (true) return new IndividualPropertyAtom(uri1, uri2, uri3);}
    throw new Error("Missing return statement in function");
  }

  final public DatavaluedPropertyAtom datavaluedPropertyAtom() throws ParseException {
 IObjectAtom uri1; IObjectAtom uri2; RuleAtom obj;
    jj_consume_token(VALUES);
    jj_consume_token(LPAR);
    uri1 = iObject();
    jj_consume_token(COMMA);
    uri2 = iObject();
    jj_consume_token(COMMA);
    obj = dObject();
    jj_consume_token(RPAR);
           {if (true) return new DatavaluedPropertyAtom(uri1, uri2, obj);}
    throw new Error("Missing return statement in function");
  }

  final public SameAtom sameAsAtom() throws ParseException {
 ExpressionAtom expressionAtom1; ExpressionAtom expressionAtom2;
    jj_consume_token(SAME);
    jj_consume_token(LPAR);
    expressionAtom1 = expressionAtom();
    jj_consume_token(COMMA);
    expressionAtom2 = expressionAtom();
    jj_consume_token(RPAR);
          {if (true) return new SameAtom(expressionAtom1, expressionAtom2);}
    throw new Error("Missing return statement in function");
  }

  final public LessThanAtom lessThanAtom() throws ParseException {
 ExpressionAtom obj1; ExpressionAtom obj2;
    jj_consume_token(LESSTHAN);
    jj_consume_token(LPAR);
    obj1 = expressionAtom();
    jj_consume_token(COMMA);
    obj2 = expressionAtom();
    jj_consume_token(RPAR);
          {if (true) return new LessThanAtom(obj1, obj2);}
    throw new Error("Missing return statement in function");
  }

  final public LessEqualThanAtom lessEqualThanAtom() throws ParseException {
 ExpressionAtom obj1; ExpressionAtom obj2;
    jj_consume_token(LESSEQUALTHAN);
    jj_consume_token(LPAR);
    obj1 = expressionAtom();
    jj_consume_token(COMMA);
    obj2 = expressionAtom();
    jj_consume_token(RPAR);
          {if (true) return new LessEqualThanAtom(obj1, obj2);}
    throw new Error("Missing return statement in function");
  }

  final public GreaterThanAtom greaterThanAtom() throws ParseException {
 ExpressionAtom obj1; ExpressionAtom obj2;
    jj_consume_token(GREATERTHAN);
    jj_consume_token(LPAR);
    obj1 = expressionAtom();
    jj_consume_token(COMMA);
    obj2 = expressionAtom();
    jj_consume_token(RPAR);
          {if (true) return new GreaterThanAtom(obj1, obj2);}
    throw new Error("Missing return statement in function");
  }

  final public GreaterEqualThanAtom greaterEqualThanAtom() throws ParseException {
 ExpressionAtom obj1; ExpressionAtom obj2;
    jj_consume_token(GREATEREQUALTHAN);
    jj_consume_token(LPAR);
    obj1 = expressionAtom();
    jj_consume_token(COMMA);
    obj2 = expressionAtom();
    jj_consume_token(RPAR);
          {if (true) return new GreaterEqualThanAtom(obj1, obj2);}
    throw new Error("Missing return statement in function");
  }

  final public DifferentAtom differentFromAtom() throws ParseException {
 ExpressionAtom expressionAtom1; ExpressionAtom expressionAtom2;
    jj_consume_token(DIFFERENT);
    jj_consume_token(LPAR);
    expressionAtom1 = expressionAtom();
    jj_consume_token(COMMA);
    expressionAtom2 = expressionAtom();
    jj_consume_token(RPAR);
          {if (true) return new DifferentAtom(expressionAtom1, expressionAtom2);}
    throw new Error("Missing return statement in function");
  }

  final public IObjectAtom reference() throws ParseException {
  String uri1;
  Token colon;
  String uri3;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case URI:
      uri1 = getURI();
                         uri1 = uri1.substring(1, uri1.length()-1);
                                                try {
                                                  {if (true) return new ResourceAtom(new URI(uri1));}
                                                        } catch (URISyntaxException e) {
                                                                e.printStackTrace();
                                                        }
      break;
    case VAR:
      uri1 = getVariable();
      colon = jj_consume_token(COLON);
      uri3 = getVariable();
                                                                  {if (true) return new ResourceAtom(getSWRLArgument(uri1+colon.image+uri3));}
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public IObjectAtom varReference() throws ParseException {
  String uri1;
  Token colon;
  String uri3;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case URI:
      uri1 = getURI();
                         try {
                                                                                                                        {if (true) return new ResourceAtom(new URI(uri1));}
                                                                                                                } catch (URISyntaxException e) {
                                                                                                                        e.printStackTrace();
                                                                                                                }
      break;
    case VAR:
      uri1 = getVariable();
      colon = jj_consume_token(COLON);
      uri3 = getVariable();
                                                                  {if (true) return new ResourceAtom(getSWRLArgument(uri1+colon.image+uri3));}
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String getURI() throws ParseException {
        Token t;
    t = jj_consume_token(URI);
                      {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public String getVariable() throws ParseException {
        Token t;
    t = jj_consume_token(VAR);
                      {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public String getStringValue() throws ParseException {
        Token t;
    t = jj_consume_token(STRING);
                         {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public StringAtom getString() throws ParseException {
        Token t;
    t = jj_consume_token(STRING);
                         {if (true) return new StringAtom(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public NumberAtom getInt() throws ParseException {
        Token t;
    t = jj_consume_token(NUM);
                    {if (true) return new NumberAtom(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public Object uObject() throws ParseException {
  Object obj;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOTEX:
    case VARIABLE:
    case BNODE:
      obj = variable();
      break;
    case VAR:
    case URI:
      obj = reference();
      break;
    case STRING:
      obj = getString();
      break;
    case NUM:
      obj = getInt();
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
         {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public IObjectAtom iObject() throws ParseException {
  IObjectAtom uri;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOTEX:
    case VARIABLE:
    case BNODE:
      uri = variable();
                          {if (true) return uri;}
      break;
    case VAR:
    case URI:
      uri = reference();
                                                            {if (true) return uri;}
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public RuleAtom dObject() throws ParseException {
  RuleAtom variable;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUM:
    case STRING:
      variable = literal();
      break;
    case NOTEX:
    case VARIABLE:
    case BNODE:
      variable = variable();
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                                    {if (true) return variable;}
    throw new Error("Missing return statement in function");
  }

  final public ExpressionAtom literal() throws ParseException {
  ExpressionAtom literal; IObjectAtom typedLiteral;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      literal = getString();
      typedLiteral = typedLiteral();
      break;
    case NUM:
      literal = getInt();
      typedLiteral = typedLiteral();
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                if(typedLiteral != null){
                        {if (true) return new TypedLiteralAtom(literal, typedLiteral);}
                }
                else{
                        {if (true) return literal;}
                }
    throw new Error("Missing return statement in function");
  }

  final public IObjectAtom typedLiteral() throws ParseException {
  IObjectAtom type = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case APOX:
      jj_consume_token(APOX);
      jj_consume_token(APOX);
      type = reference();
      break;
    default:
      jj_la1[14] = jj_gen;

    }
         {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final public IObjectAtom variable() throws ParseException {
  Token t; String var;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOTEX:
      jj_consume_token(NOTEX);
      jj_consume_token(LPAR);
      t = jj_consume_token(VARIABLE);
      jj_consume_token(RPAR);
                                                      var=t.image; var=kb.getPrefixURI("var") + var.substring(1);
                                                                                                                try{
                                                                                                                        {if (true) return new VariableAtom(new URI(var), true);}
                                                                                                                } catch (URISyntaxException e) {
                                                                                                                        e.printStackTrace();
                                                                                                                        {if (true) return null;}
                                                                                                                }
      break;
    case VARIABLE:
      t = jj_consume_token(VARIABLE);
          var=t.image; var=kb.getPrefixURI("var") + var.substring(1);
                                                                                                                try{
                                                                                                                        {if (true) return new VariableAtom(new URI(var), false);}
                                                                                                                } catch (URISyntaxException e) {
                                                                                                                        e.printStackTrace();
                                                                                                                        {if (true) return null;}
                                                                                                                }
      break;
    case BNODE:
      t = jj_consume_token(BNODE);
          var=t.image;  {if (true) return new RuleBlankNode(var);}
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ComparisonAtom notAtom() throws ParseException {
  ComparisonAtom comparisonAtom;
    jj_consume_token(NOT);
    jj_consume_token(LPAR);
    comparisonAtom = comparisonAtom();
    jj_consume_token(RPAR);
         {if (true) return new NotAtom(comparisonAtom);}
    throw new Error("Missing return statement in function");
  }

  final public ComparisonAtom isBlankAtom() throws ParseException {
  IObjectAtom uriRes;
    jj_consume_token(IS_BLANK);
    jj_consume_token(LPAR);
    uriRes = iObject();
    jj_consume_token(RPAR);
         {if (true) return new IsBlankAtom(uriRes);}
    throw new Error("Missing return statement in function");
  }

  final public ComparisonAtom comparisonAtom() throws ParseException {
  ComparisonAtom comparisonAtom;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SAME:
      comparisonAtom = sameAsAtom();
      break;
    case LESSTHAN:
      comparisonAtom = lessThanAtom();
      break;
    case GREATERTHAN:
      comparisonAtom = greaterThanAtom();
      break;
    case DIFFERENT:
      comparisonAtom = differentFromAtom();
      break;
    case NOT:
      comparisonAtom = notAtom();
      break;
    case STARTS_WITH:
      comparisonAtom = startsWithAtom();
      break;
    case ENDS_WITH:
      comparisonAtom = endsWithAtom();
      break;
    case IS_BLANK:
      comparisonAtom = isBlankAtom();
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
         {if (true) return comparisonAtom;}
    throw new Error("Missing return statement in function");
  }

  final public NumericVariableAtom numericVariable() throws ParseException {
  Token t; String var;
    t = jj_consume_token(VARIABLE);
          var=t.image; var=kb.getPrefixURI("var") + var.substring(1);
                                                                                                                try{
                                                                                                                        {if (true) return new NumericVariableAtom(new URI(var), false);}
                                                                                                                } catch (URISyntaxException e) {
                                                                                                                        e.printStackTrace();
                                                                                                                        {if (true) return null;}
                                                                                                                }
    throw new Error("Missing return statement in function");
  }

  final public StringVariableAtom stringVariable() throws ParseException {
  Token t; String var;
    t = jj_consume_token(VARIABLE);
          var=t.image; var=kb.getPrefixURI("var") + var.substring(1);
                                                                                                                try{
                                                                                                                        {if (true) return new StringVariableAtom(new URI(var), false);}
                                                                                                                } catch (URISyntaxException e) {
                                                                                                                        e.printStackTrace();
                                                                                                                        {if (true) return null;}
                                                                                                                }
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public RuleParserImplTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[17];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x800,0x400,0xdc39e000,0x800,0xdc39e000,0x23800000,0x23c00000,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc01e000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x20000,0x2420,0x0,0x2420,0xa019c0,0xa819c6,0x280006,0x500000,0x500000,0x1f80001,0x1700001,0x1a80001,0x880000,0x200,0x1200001,0x2020,};
   }

  /** Constructor with InputStream. */
  public RuleParserImpl(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public RuleParserImpl(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new RuleParserImplTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 17; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 17; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public RuleParserImpl(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new RuleParserImplTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 17; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 17; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public RuleParserImpl(RuleParserImplTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 17; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(RuleParserImplTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 17; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[57];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 17; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 57; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
