/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.stanbol.enhancer.benchmark.impl;

import java.io.IOException;

import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.stanbol.enhancer.benchmark.TripleMatcher;

class TripleMatcherImpl implements TripleMatcher {

    private final String operator;
    private final IRI predicateUri;
    private final IRI objectUri;
    
    /** Build from a line supplied by the parser.
     *  Format is PREDICATE_URI OPERATOR ARGUMENTS, 
     */
    TripleMatcherImpl(String line) throws IOException {
        final String [] parts = line.split(" ");
        if(parts.length < 3) {
            throw new IOException("Invalid TripleMatcher format in line [" + line + "]");
        }
        
        predicateUri = new IRI(parts[0]);
        
        operator = parts[1];
        if("URI".equals(operator)) {
            objectUri = new IRI(parts[2]);
        } else {
            // TODO support other operators
            objectUri = null;
        }
    }
    
    @Override
    public String toString() {
        return getClass().getSimpleName() + " (" + getExpression() + ")";
    }
    
    /** Get the expression used to build this matcher */
    public String getExpression() {
        return predicateUri + " " + operator + " " + objectUri;
    }
    
    @Override
    public boolean matches(Triple t) {
        return 
            objectUri != null
            && t.getPredicate().equals(predicateUri)
            && t.getObject().equals(objectUri)
        ;
    }
}
