/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.stanbol.rules.manager.arqextention;

import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionBase2;

public class CreatePropertyURIStringFromLabel extends FunctionBase2 {

    @Override
    public NodeValue exec(NodeValue namespace, NodeValue label) {
        String argument1 = namespace.getString();
        String argument2 = label.getString();

        String[] argument2Splitted = argument2.split(" ");

        String localName = argument2Splitted[0].substring(0, 1).toLowerCase()
                           + argument2Splitted[0].substring(1, argument2Splitted[0].length());

        for (int i = 1; i < argument2Splitted.length; i++) {
            localName += argument2Splitted[i].substring(0, 1).toUpperCase()
                         + argument2Splitted[i].substring(1, argument2Splitted[i].length());
        }

        String newString = argument1 + localName;

        return NodeValue.makeString(newString);
    }

}
