/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.stanbol.ontologymanager.multiplexer.clerezza;

import static org.junit.Assert.*;

import java.util.HashMap;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.Test;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class StructureTest {

    private static IRI baseIri = IRI.create(Constants.PEANUTS_MAIN_BASE);

    private static OWLOntologyManager ontMgr = null;

    @BeforeClass
    public static void setUp() {
        try {
            // new Activator().start(null);
            ontMgr = OWLManager.createOWLOntologyManager();
        } catch (Exception e) {
            fail("Bundle activator could not be started");
        }
    }

    @Test
    public void testHashMapImplementation() {
        Map<String,int[]> map = new HashMap<String,int[]>();
        int[] prova1 = new int[] {0, 0};
        map.put("test", prova1);
        prova1[0]++;
        assertTrue(map.get("test")[0] > 0);
    }

    @Test
    public void testOntologyCreation() {
        try {
            assertNotNull(ontMgr.createOntology(baseIri));
        } catch (OWLOntologyCreationException e) {
            fail("An empty ontology manager failed to create ontology with base IRI " + baseIri + " !");
        }
    }

    @Test
    public void testOWLManagerCreation() {
        assertNotNull(ontMgr);
    }

}
