// Generated by CoffeeScript 1.6.2
/*   VIE entitypreview uses the VIE.load service method to show a preview for an entity.
#     Author: Szaby Gruenwald, Salzburg Research (2012-2013)
#     This file may be freely distributed under the MIT license
*/


(function() {
  var vie;

  vie = new VIE();

  vie.use(new vie.StanbolService({
    url: "http://dev.iks-project.eu:8080",
    proxyDisabled: true
  }));

  jQuery.widget("IKS.entitypreview", {
    options: {
      vie: vie,
      services: "stanbol",
      debug: false,
      depictionProperties: ["foaf:depiction", "schema:thumbnail"],
      labelProperties: ["rdfs:label", "skos:prefLabel", "schema:name", "foaf:name"],
      picSize: 150,
      width: 350,
      descriptionProperties: [
        "rdfs:comment", "skos:note", "schema:description", "rdfs:label", "skos:definition", {
          property: "skos:broader",
          makeLabel: function(propertyValueArr) {
            var labels;

            labels = _(propertyValueArr).map(function(termUri) {
              return termUri.replace(/<.*[\/#](.*)>/, "$1").replace(/_/g, "&nbsp;");
            });
            return "Subcategory of " + (labels.join(', ')) + ".";
          }
        }, {
          property: "dcterms:subject",
          makeLabel: function(propertyValueArr) {
            var labels;

            labels = _(propertyValueArr).map(function(termUri) {
              return termUri.replace(/<.*[\/#](.*)>/, "$1").replace(/_/g, "&nbsp;");
            });
            return "Subject(s): " + (labels.join(', ')) + ".";
          }
        }
      ],
      fallbackLanguage: "en",
      styleClass: "vie-autocomplete",
      getTypes: function() {
        return [
          {
            uri: "" + this.ns.dbpedia + "Place",
            label: 'Place'
          }, {
            uri: "" + this.ns.dbpedia + "Person",
            label: 'Person'
          }, {
            uri: "" + this.ns.dbpedia + "Organisation",
            label: 'Organisation'
          }, {
            uri: "" + this.ns.skos + "Concept",
            label: 'Concept'
          }
        ];
      },
      getSources: function() {
        return [
          {
            uri: "http://dbpedia.org/resource/",
            label: "dbpedia"
          }, {
            uri: "http://sws.geonames.org/",
            label: "geonames"
          }
        ];
      }
    },
    _create: function() {
      this._logger = this.options.debug ? console : {
        info: function() {},
        warn: function() {},
        error: function() {},
        log: function() {}
      };
      this.uri = this.options.uri || $(this.element).attr('about') || $(this.element).attr('resource');
      return this._instantiateTooltip();
    },
    _destroy: function() {
      var _base;

      return typeof (_base = this.element).tooltip === "function" ? _base.tooltip('destroy') : void 0;
    },
    _instantiateTooltip: function() {
      var widget;

      widget = this;
      if (this.element.tooltip) {
        return this.element.tooltip({
          items: "*",
          hide: {
            effect: "hide",
            delay: 50
          },
          show: {
            effect: "show",
            delay: 50
          },
          content: function(response) {
            var uri;

            uri = widget.uri;
            widget._createPreview(uri, response);
            return "loading...";
          }
        });
      }
    },
    getPreviewHtml: function(cb) {
      this._createPreview(this.uri, cb);
    },
    _createPreview: function(uri, response) {
      var entity, fail, success,
        _this = this;

      success = function(cacheEntity) {
        var depictionUrl, descr, html, picSize;

        html = "";
        picSize = _this.options.picSize;
        depictionUrl = _this._getDepiction(cacheEntity, picSize);
        if (depictionUrl) {
          html += "<img style='float:left;padding: 5px;width: " + picSize + "px' src='" + (depictionUrl.substring(1, depictionUrl.length - 1)) + "'/>";
        }
        descr = _this._getDescription(cacheEntity);
        if (!descr) {
          _this._logger.warn("No description found for", cacheEntity);
          descr = "No description found.";
        }
        html += "<small>" + descr + "</small>";
        html = "<div style='padding 5px;width:" + _this.options.width + "px;'>" + html + "</div>";
        _this._logger.info("tooltip for " + uri + ": cacheEntry loaded", cacheEntity);
        return response(html);
      };
      fail = function(e) {
        _this._logger.error("error loading " + uri, e);
        return response("error loading entity for " + uri);
      };
      jQuery(".ui-tooltip").remove();
      entity = this.options.vie.entities.get(uri);
      if (!entity) {
        return this.options.vie.load({
          entity: uri
        }).using(this.options.services).execute().success(function(res) {
          var loadedEntity;

          loadedEntity = _.detect(res, function(entity) {
            return entity.fromReference(entity.getSubject()) === uri;
          });
          return success(loadedEntity);
        }).fail(fail);
      } else {
        if (!entity.get('@type')) {
          fail('Entity has no type');
        }
        return success(entity);
      }
    },
    _getUserLang: function() {
      if (window.navigator.appName === 'Netscape') {
        return window.navigator.language.split("-")[0];
      } else {
        return window.navigator.browserLanguage.split("-")[0];
      }
    },
    _getDepiction: function(entity, picSize) {
      var depictionUrl, field, fieldValue, preferredFields;

      if (["gif", "jpg"].indexOf(entity.getSubjectUri().slice(-3)) !== -1) {
        return entity.getSubject();
      }
      preferredFields = this.options.depictionProperties;
      field = _(preferredFields).detect(function(field) {
        if (entity.get(field)) {
          return true;
        }
      });
      if (field && (fieldValue = _([entity.get(field)]).flatten())) {
        depictionUrl = _(fieldValue).detect(function(uri) {
          if (uri.indexOf("thumb") !== -1) {
            return true;
          }
        }).replace(/[0-9]{2..3}px/, "" + picSize + "px");
        return depictionUrl;
      }
    },
    _getLabel: function(entity) {
      var preferredFields, preferredLanguages;

      preferredFields = this.options.labelProperties;
      preferredLanguages = [this._getUserLang(), this.options.fallbackLanguage];
      return VIE.Util.getPreferredLangForPreferredProperty(entity, preferredFields, preferredLanguages);
    },
    _getDescription: function(entity) {
      var preferredFields, preferredLanguages;

      preferredFields = this.options.descriptionProperties;
      preferredLanguages = [this._getUserLang(), this.options.fallbackLanguage];
      return VIE.Util.getPreferredLangForPreferredProperty(entity, preferredFields, preferredLanguages);
    }
  });

}).call(this);
