// Generated by CoffeeScript 1.3.3

/*   Annotate - a text enhancement interaction jQuery UI widget
#     (c) 2011 Szaby Gruenwald, IKS Consortium
#     Annotate may be freely distributed under the MIT license
*/


(function() {
  var Backbone, EntityCache, Stanbol, VIE, delayThrottle, jQuery, ns, root, uriSuffix, vie, _, _base, _ref,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  ns = {
    rdf: 'http://www.w3.org/1999/02/22-rdf-syntax-ns#',
    enhancer: 'http://fise.iks-project.eu/ontology/',
    dcterms: 'http://purl.org/dc/terms/',
    rdfs: 'http://www.w3.org/2000/01/rdf-schema#',
    skos: 'http://www.w3.org/2004/02/skos/core#'
  };

  root = this;

  jQuery = root.jQuery;

  Backbone = root.Backbone;

  _ = root._;

  VIE = root.VIE;

  vie = new VIE();

  vie.use(new vie.StanbolService({
    url: "http://dev.iks-project.eu:8080"
  }));

  vie.namespaces.add("skos", ns.skos);

  if ((_ref = (_base = String.prototype).trim) == null) {
    _base.trim = function() {
      return this.replace(/^\s+|\s+$/g, '');
    };
  }

  EntityCache = (function() {

    function EntityCache(opts) {
      this.vie = opts.vie;
      this.logger = opts.logger;
    }

    EntityCache.prototype._entities = function() {
      var _ref1;
      return (_ref1 = window.entityCache) != null ? _ref1 : window.entityCache = {};
    };

    EntityCache.prototype.get = function(uri, scope, success, error) {
      var cache,
        _this = this;
      uri = uri.replace(/^<|>$/g, "");
      if (this._entities()[uri] && this._entities()[uri].status === "done") {
        if (typeof success === "function") {
          success.apply(scope, [this._entities()[uri].entity]);
        }
      } else if (this._entities()[uri] && this._entities()[uri].status === "error") {
        if (typeof error === "function") {
          error.apply(scope, ["error"]);
        }
      } else if (!this._entities()[uri]) {
        this._entities()[uri] = {
          status: "pending",
          uri: uri
        };
        cache = this;
        this.vie.load({
          entity: uri
        }).using('stanbol').execute().success(function(entityArr) {
          return _.defer(function() {
            var cacheEntry, entity;
            cacheEntry = _this._entities()[uri];
            entity = _.detect(entityArr, function(e) {
              if (e.getSubject() === ("<" + uri + ">")) {
                return true;
              }
            });
            if (entity) {
              cacheEntry.entity = entity;
              cacheEntry.status = "done";
              return $(cacheEntry).trigger("done", entity);
            } else {
              _this.logger.warn("couldn''t load " + uri, entityArr);
              return cacheEntry.status = "not found";
            }
          });
        }).fail(function(e) {
          return _.defer(function() {
            var cacheEntry;
            _this.logger.error("couldn't load " + uri);
            cacheEntry = _this._entities()[uri];
            cacheEntry.status = "error";
            return $(cacheEntry).trigger("fail", e);
          });
        });
      }
      if (this._entities()[uri] && this._entities()[uri].status === "pending") {
        return $(this._entities()[uri]).bind("done", function(event, entity) {
          if (typeof success === "function") {
            return success.apply(scope, [entity]);
          }
        }).bind("fail", function(event, error) {
          if (typeof error === "function") {
            return error.apply(scope, [error]);
          }
        });
      }
    };

    return EntityCache;

  })();

  uriSuffix = function(uri) {
    var res;
    res = uri.substring(uri.lastIndexOf("#") + 1);
    return res.substring(res.lastIndexOf("/") + 1);
  };

  jQuery.widget('IKS.annotate', {
    __widgetName: "IKS.annotate",
    options: {
      vie: vie,
      vieServices: ["stanbol"],
      autoAnalyze: false,
      continuousChecking: false,
      throttleDistance: 3000,
      showTooltip: true,
      debug: false,
      depictionProperties: ["foaf:depiction", "schema:thumbnail"],
      labelProperties: ["rdfs:label", "skos:prefLabel", "schema:name", "foaf:name"],
      descriptionProperties: [
        "rdfs:comment", "skos:note", "schema:description", "skos:definition", {
          property: "skos:broader",
          makeLabel: function(propertyValueArr) {
            var labels;
            labels = _(propertyValueArr).map(function(termUri) {
              return termUri.replace(/<.*[\/#](.*)>/, "$1").replace(/_/g, "&nbsp;");
            });
            return "Subcategory of " + (labels.join(', ')) + ".";
          }
        }, {
          property: "dcterms:subject",
          makeLabel: function(propertyValueArr) {
            var labels;
            labels = _(propertyValueArr).map(function(termUri) {
              return termUri.replace(/<.*[\/#](.*)>/, "$1").replace(/_/g, "&nbsp;");
            });
            return "Subject(s): " + (labels.join(', ')) + ".";
          }
        }
      ],
      fallbackLanguage: "en",
      ns: {
        dbpedia: "http://dbpedia.org/ontology/",
        skos: "http://www.w3.org/2004/02/skos/core#"
      },
      typeFilter: null,
      annotationInteractionWidget: "annotationInteraction",
      getTypes: function() {
        return [
          {
            uri: "" + this.ns.dbpedia + "Place",
            label: 'Place'
          }, {
            uri: "" + this.ns.dbpedia + "Person",
            label: 'Person'
          }, {
            uri: "" + this.ns.dbpedia + "Organisation",
            label: 'Organisation'
          }, {
            uri: "" + this.ns.skos + "Concept",
            label: 'Concept'
          }
        ];
      },
      getSources: function() {
        return [
          {
            uri: "http://dbpedia.org/resource/",
            label: "dbpedia"
          }, {
            uri: "http://sws.geonames.org/",
            label: "geonames"
          }
        ];
      }
    },
    _create: function() {
      var widget;
      widget = this;
      this.pendingrequests = 0;
      this.errorcollector = [];
      this._logger = this.options.debug ? console : {
        info: function() {},
        warn: function() {},
        error: function() {},
        log: function() {}
      };
      this.entityCache = new EntityCache({
        vie: this.options.vie,
        logger: this._logger
      });
      if (this.options.autoAnalyze) {
        this.enable();
      }
      if (!jQuery().tooltip) {
        this.options.showTooltip = false;
        this._logger.warn("the used jQuery UI doesn't support tooltips, disabling.");
      }
      return this._initExistingAnnotations();
    },
    _destroy: function() {
      this.disable();
      $(':iks-annotationselector', this.element).each(function() {
        if ($(this).data().annotationSelector || $(this).data().IKSAnnotationSelector) {
          return $(this).annotationSelector('destroy');
        }
      });
      return this._destroyExistingAnnotationInteractionWidgets();
    },
    enable: function() {
      var checkerFn,
        _this = this;
      if (this.options.continuousChecking) {
        checkerFn = delayThrottle(function() {
          return _this._checkForChanges();
        }, this.options.throttleDistance);
        $(this.element).bind('keyup click', function() {
          return checkerFn();
        });
      }
      return this._checkForChanges();
    },
    _checkForChanges: function() {
      var el, hash, _i, _len, _ref1, _results;
      _ref1 = this._findElementsToAnalyze();
      _results = [];
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        el = _ref1[_i];
        if (!$(el).has(window.getSelection().anchorNode).length) {
          hash = this._elementHash(el);
          if (!jQuery(el).data('hash')) {
            console.info(el, "wasn't analized yet.");
            this._analyze(el);
          }
          if (jQuery(el).data('hash') && jQuery(el).data('hash') !== hash) {
            console.info(el, 'changed, try to get annotations for it.');
            _results.push(this._analyze(el));
          } else {
            _results.push(void 0);
          }
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    },
    _elementHash: function(el) {
      return jQuery(el).text().hashCode();
    },
    _findElementsToAnalyze: function() {
      return this._listNonblockElements(this.element);
    },
    _analyze: function(el) {
      var hash, lastRequestDone,
        _this = this;
      hash = this._elementHash(el);
      lastRequestDone = function() {
        _this.errorcollector = _(_this.errorcollector).uniq();
        if (_this.errorcollector.length) {
          _this._trigger("error", _this.errorcollector, {
            message: _this.errorcollector.join('; ')
          });
          return _this.errorcollector = [];
        }
      };
      this.options.vie.analyze({
        element: jQuery(el)
      }).using(this.options.vieServices).execute().success(function(enhancements) {
        _this.pendingrequests--;
        if (!$(el).has(window.getSelection().anchorNode).length) {
          if (_this._elementHash(el) === hash) {
            console.info('applying suggestions to', el, enhancements);
            _this._applyEnhancements(el, enhancements);
            jQuery(el).data('hash', hash);
          } else {
            console.info(el, 'changed in the meantime.');
          }
          _this._trigger("success", true);
        }
        if (_this.pendingrequests === 0) {
          return lastRequestDone();
        }
      }).fail(function(msg) {
        _this._logger.error("analyze failed", msg);
        _this.errorcollector.push(msg);
        _this.pendingrequests--;
        if (_this.pendingrequests === 0) {
          return lastRequestDone();
        }
      });
      return this.pendingrequests++;
    },
    _applyEnhancements: function(el, enhancements) {
      var _this = this;
      return _.defer(function() {
        var entAnn, entityAnnotations, textAnn, textAnnotations, textAnns, _i, _j, _len, _len1, _ref1;
        entityAnnotations = Stanbol.getEntityAnnotations(enhancements);
        for (_i = 0, _len = entityAnnotations.length; _i < _len; _i++) {
          entAnn = entityAnnotations[_i];
          textAnns = entAnn.get("dcterms:relation");
          if (!textAnns) {
            _this._logger.error("For " + (entAnn.getSubject()) + " dcterms:relation is not set! This makes this EntityAnnotation unusable!", entAnn);
            continue;
          }
          _ref1 = _.flatten([textAnns]);
          for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
            textAnn = _ref1[_j];
            if (!(textAnn instanceof Backbone.Model)) {
              textAnn = entAnn.vie.entities.get(textAnn);
            }
            if (!textAnn) {
              continue;
            }
            _(_.flatten([textAnn])).each(function(ta) {
              return ta.setOrAdd({
                "entityAnnotation": entAnn.getSubject()
              });
            });
          }
        }
        textAnnotations = Stanbol.getTextAnnotations(enhancements);
        textAnnotations = _this._filterByType(textAnnotations);
        textAnnotations = _(textAnnotations).filter(function(textEnh) {
          if (textEnh.getSelectedText && textEnh.getSelectedText()) {
            return true;
          } else {
            return false;
          }
        });
        return _(textAnnotations).each(function(s) {
          _this._logger.info(s._enhancement, 'confidence', s.getConfidence(), 'selectedText', s.getSelectedText(), 'type', s.getType(), 'EntityEnhancements', s.getEntityEnhancements());
          return _this._processTextEnhancement(s, el);
        });
      });
    },
    disable: function() {
      var el, _i, _len, _ref1;
      _ref1 = this._findElementsToAnalyze();
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        el = _ref1[_i];
        jQuery.removeData(el, 'hash');
      }
      return $(':IKS-annotationSelector', this.element).each(function() {
        if ($(this).data().annotationSelector || $(this).data().IKSAnnotationSelector) {
          return $(this).annotationSelector('disable');
        }
      });
    },
    _initExistingAnnotations: function() {
      this.existingAnnotations = jQuery("a[resource]", this.element);
      this._logger.info(this.existingAnnotations);
      return this.existingAnnotations[this.options.annotationInteractionWidget](this.options);
    },
    _destroyExistingAnnotationInteractionWidgets: function() {
      this.existingAnnotations[this.options.annotationInteractionWidget]("destroy");
      return this.existingAnnotations = [];
    },
    acceptAll: function(reportCallback) {
      var report;
      report = {
        updated: [],
        accepted: 0
      };
      $(':IKS-annotationSelector', this.element).each(function() {
        var res;
        if ($(this).data().annotationSelector || $(this).data().IKSAnnotationSelector) {
          res = $(this).annotationSelector('acceptBestCandidate');
          if (res) {
            report.updated.push(this);
            return report.accepted++;
          }
        }
      });
      return reportCallback(report);
    },
    _listNonblockElements: function(el) {
      var isDevidable, res,
        _this = this;
      isDevidable = function(el) {
        var child, sum, _i, _len, _ref1;
        sum = "";
        _ref1 = jQuery(el).children();
        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
          child = _ref1[_i];
          sum += jQuery(child).text().replace(/\s\s*/g, "");
        }
        return jQuery(el).text().replace(/\s\s*/g, "") === sum;
      };
      res = jQuery([]);
      if (isDevidable(el)) {
        jQuery(el).children().each(function(i, ch) {
          return res = res.add(_this._listNonblockElements(ch));
        });
      } else {
        res = res.add(jQuery(el));
      }
      return res;
    },
    _processTextEnhancement: function(textEnh, parentEl) {
      var eEnh, eEnhUri, el, options, sType, type, widget, _i, _j, _len, _len1, _ref1,
        _this = this;
      if (!textEnh.getSelectedText()) {
        this._logger.warn("textEnh", textEnh, "doesn't have selected-text!");
        return;
      }
      el = $(this._getOrCreateDomElement(parentEl, textEnh.getSelectedText(), {
        createElement: 'span',
        createMode: 'existing',
        context: textEnh.getContext(),
        start: textEnh.getStart(),
        end: textEnh.getEnd()
      }));
      sType = textEnh.getType() || "Other";
      widget = this;
      el.addClass('entity');
      for (_i = 0, _len = sType.length; _i < _len; _i++) {
        type = sType[_i];
        el.addClass(uriSuffix(type).toLowerCase());
      }
      if (textEnh.getEntityEnhancements().length) {
        el.addClass("withSuggestions");
      }
      _ref1 = textEnh.getEntityEnhancements();
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        eEnh = _ref1[_j];
        eEnhUri = eEnh.getUri();
        this.entityCache.get(eEnhUri, eEnh, function(entity) {
          if (("<" + eEnhUri + ">") === entity.getSubject()) {
            return _this._logger.info("entity " + eEnhUri + " is loaded:", entity.as("JSON"));
          } else {
            return widget._logger.info("forwarded entity for " + eEnhUri + " loaded:", entity.getSubject());
          }
        });
      }
      options = this.options;
      options.cache = this.entityCache;
      options.annotateElement = this.element;
      return el.annotationSelector(options).annotationSelector('addTextEnhancement', textEnh);
    },
    _filterByType: function(textAnnotations) {
      var _this = this;
      if (!this.options.typeFilter) {
        return textAnnotations;
      }
      return _.filter(textAnnotations, function(ta) {
        var type, _i, _len, _ref1, _ref2;
        if (_ref1 = _this.options.typeFilter, __indexOf.call(ta.getType(), _ref1) >= 0) {
          return true;
        }
        _ref2 = _this.options.typeFilter;
        for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
          type = _ref2[_i];
          if (__indexOf.call(ta.getType(), type) >= 0) {
            return true;
          }
        }
      });
    },
    _getOrCreateDomElement: function(element, text, options) {
      var domEl, len, nearest, nearestPosition, newElement, occurrences, pos, start, textContentOf, textToCut;
      if (options == null) {
        options = {};
      }
      occurrences = function(str, s) {
        var last, next, res;
        res = [];
        last = 0;
        while (str.indexOf(s, last) !== -1) {
          next = str.indexOf(s, last);
          res.push(next);
          last = next + 1;
        }
        return res;
      };
      nearest = function(arr, nr) {
        return _(arr).sortedIndex(nr);
      };
      nearestPosition = function(str, s, ind) {
        var arr, d0, d1, i0, i1;
        arr = occurrences(str, s);
        i1 = nearest(arr, ind);
        if (arr.length === 1) {
          return arr[0];
        } else if (i1 === arr.length) {
          return arr[i1 - 1];
        } else {
          i0 = i1 - 1;
          d0 = ind - arr[i0];
          d1 = arr[i1] - ind;
          if (d1 > d0) {
            return arr[i0];
          } else {
            return arr[i1];
          }
        }
      };
      domEl = element;
      textContentOf = function(element) {
        return $(element).text().replace(/\n/g, " ");
      };
      if (textContentOf(element).indexOf(text) === -1) {
        this._logger.error("'" + text + "' doesn't appear in the text block.");
        return $();
      }
      start = options.start + textContentOf(element).indexOf(textContentOf(element).trim());
      start = nearestPosition(textContentOf(element), text, start);
      pos = 0;
      while (textContentOf(domEl).indexOf(text) !== -1 && domEl.nodeName !== '#text') {
        domEl = _(domEl.childNodes).detect(function(el) {
          var p;
          p = textContentOf(el).lastIndexOf(text);
          if (p >= start - pos) {
            return true;
          } else {
            pos += textContentOf(el).length;
            return false;
          }
        });
      }
      if (options.createMode === "existing" && textContentOf($(domEl).parent()) === text) {
        return $(domEl).parent()[0];
      } else {
        pos = start - pos;
        len = text.length;
        textToCut = textContentOf(domEl).substring(pos, pos + len);
        if (textToCut === text) {
          domEl.splitText(pos + len);
          newElement = document.createElement(options.createElement || 'span');
          newElement.innerHTML = text;
          $(domEl).parent()[0].replaceChild(newElement, domEl.splitText(pos));
          return $(newElement);
        } else {
          return this._logger.warn("dom element creation problem: " + textToCut + " isnt " + text);
        }
      }
    }
  });

  String.prototype.hashCode = function() {
    var char, hash, i;
    hash = 0;
    if (this.length === 0) {
      return hash;
    }
    i = 0;
    while (i < this.length) {
      char = this.charCodeAt(i);
      hash = ((hash << 5) - hash) + char;
      hash = hash & hash;
      i++;
    }
    return hash;
  };

  delayThrottle = function(cb, timeout) {
    var resFn, timeoutHandler;
    timeoutHandler = null;
    return resFn = function() {
      if (timeoutHandler) {
        clearTimeout(timeoutHandler);
      }
      return timeoutHandler = setTimeout(function() {
        timeoutHandler = null;
        return cb();
      }, timeout);
    };
  };

  jQuery.widget("IKS.annotationInteraction", {
    __widgetName: "IKS.annotationInteraction",
    options: {
      ns: {
        dbpedia: "http://dbpedia.org/ontology/",
        skos: "http://www.w3.org/2004/02/skos/core#"
      },
      getTypes: function() {
        return [
          {
            uri: "" + this.ns.dbpedia + "Place",
            label: 'Place'
          }, {
            uri: "" + this.ns.dbpedia + "Person",
            label: 'Person'
          }, {
            uri: "" + this.ns.dbpedia + "Organisation",
            label: 'Organisation'
          }, {
            uri: "" + this.ns.skos + "Concept",
            label: 'Concept'
          }
        ];
      },
      getSources: function() {
        return [
          {
            uri: "http://dbpedia.org/resource/",
            label: "dbpedia"
          }, {
            uri: "http://sws.geonames.org/",
            label: "geonames"
          }
        ];
      }
    },
    _create: function() {
      var _this = this;
      this._logger = this.options.debug ? console : {
        info: function() {},
        warn: function() {},
        error: function() {},
        log: function() {}
      };
      this.vie = this.options.vie;
      return this._loadEntity(function(entity) {
        _this.entity = entity;
        return _this._initTooltip();
      });
    },
    _destroy: function() {
      return this.element.tooltip('destroy');
    },
    _initTooltip: function() {
      var widget,
        _this = this;
      widget = this;
      this._logger.info("init tooltip for", this.element);
      if (this.options.showTooltip) {
        return jQuery(this.element).tooltip({
          items: "[resource]",
          hide: {
            effect: "hide",
            delay: 50
          },
          show: {
            effect: "show",
            delay: 50
          },
          content: function(response) {
            var uri;
            uri = _this.element.attr("resource");
            _this._logger.info("tooltip uri:", uri);
            return widget._createPreview(uri);
          }
        });
      }
    },
    _createPreview: function(uri) {
      var depictionUrl, descr, html, picSize;
      html = "";
      picSize = 100;
      depictionUrl = this._getDepiction(this.entity, picSize);
      if (depictionUrl) {
        html += "<img style='float:left;padding: 5px;width: " + picSize + "px' src='" + (depictionUrl.substring(1, depictionUrl.length - 1)) + "'/>";
      }
      descr = this._getDescription(this.entity);
      if (!descr) {
        this._logger.warn("No description found for", this.entity);
        descr = "No description found.";
      }
      html += "<div style='padding 5px;width:250px;float:left;'><small>" + descr + "</small></div>";
      this._logger.info("tooltip for " + uri + ": cacheEntry loaded", this.entity);
      return html;
    },
    _loadEntity: function(callback) {
      var uri,
        _this = this;
      uri = this.element.attr('resource');
      return this.vie.load({
        entity: uri
      }).using("stanbol").execute().success(function(res) {
        var loadedEntity;
        loadedEntity = _(res).detect(function(e) {
          return e.getSubject().replace(/^<|>$/g, '') === uri;
        });
        return callback(loadedEntity);
      }).fail(function(err) {
        return _this._logger.error("error getting entity from stanbol", err, entity.getSubject());
      });
    },
    _getUserLang: function() {
      var navigatorLanguage;
      navigatorLanguage = window.navigator.language || window.navigator.userLanguage;
      return navigatorLanguage.split("-")[0];
    },
    _getDepiction: function(entity, picSize) {
      var depictionUrl, field, fieldValue, preferredFields;
      preferredFields = this.options.depictionProperties;
      field = _(preferredFields).detect(function(field) {
        if (entity.get(field)) {
          return true;
        }
      });
      if (field && (fieldValue = _([entity.get(field)]).flatten())) {
        depictionUrl = _(fieldValue).detect(function(uri) {
          uri = (typeof uri.getSubject === "function" ? uri.getSubject() : void 0) || uri;
          if (uri.indexOf("thumb") !== -1) {
            return true;
          }
        });
        if (depictionUrl) {
          depictionUrl = depictionUrl.replace(/[0-9]{2..3}px/, "" + picSize + "px");
        }
        return depictionUrl;
      }
    },
    _getLabel: function(entity) {
      var preferredFields, preferredLanguages;
      preferredFields = this.options.labelProperties;
      preferredLanguages = [this._getUserLang(), this.options.fallbackLanguage];
      return VIE.Util.getPreferredLangForPreferredProperty(entity, preferredFields, preferredLanguages);
    },
    _getDescription: function(entity) {
      var preferredFields, preferredLanguages;
      preferredFields = this.options.descriptionProperties;
      preferredLanguages = [this._getUserLang(), this.options.fallbackLanguage];
      return VIE.Util.getPreferredLangForPreferredProperty(entity, preferredFields, preferredLanguages);
    }
  });

  jQuery.widget('IKS.annotationSelector', {
    __widgetName: "IKS.annotationSelector",
    options: {
      ns: {
        dbpedia: "http://dbpedia.org/ontology/",
        skos: "http://www.w3.org/2004/02/skos/core#"
      },
      getTypes: function() {
        return [
          {
            uri: "" + this.ns.dbpedia + "Place",
            label: 'Place'
          }, {
            uri: "" + this.ns.dbpedia + "Person",
            label: 'Person'
          }, {
            uri: "" + this.ns.dbpedia + "Organisation",
            label: 'Organisation'
          }, {
            uri: "" + this.ns.skos + "Concept",
            label: 'Concept'
          }
        ];
      },
      getSources: function() {
        return [
          {
            uri: "http://dbpedia.org/resource/",
            label: "dbpedia"
          }, {
            uri: "http://sws.geonames.org/",
            label: "geonames"
          }
        ];
      }
    },
    _create: function() {
      var _this = this;
      this.enableEditing();
      this._logger = this.options.debug ? console : {
        info: function() {},
        warn: function() {},
        error: function() {},
        log: function() {}
      };
      if (this.isAnnotated()) {
        this._initTooltip();
        this.linkedEntity = {
          uri: this.element.attr("resource")
        };
        return this.options.cache.get(this.linkedEntity.uri, this, function(cachedEntity) {
          var navigatorLanguage, userLang;
          navigatorLanguage = window.navigator.language || window.navigator.userLanguage;
          userLang = navigatorLanguage.split("-")[0];
          return _this.linkedEntity.label = VIE.Util.getPreferredLangForPreferredProperty(cachedEntity, ["skos:prefLabel", "rdfs:label"], [userLang, "en"]);
        });
      }
    },
    enableEditing: function() {
      var _this = this;
      return this.element.click(function(e) {
        _this._logger.log("click", e, e.isDefaultPrevented());
        if (_this.dialog || !_this.dialog) {
          _this._createDialog();
          setTimeout((function() {
            return _this.dialog.open();
          }), 220);
          _this.entityEnhancements = _this._getEntityEnhancements();
          _this._createSearchbox();
          if (_this.entityEnhancements.length > 0) {
            return _this._createMenu();
          }
        } else {
          return _this.searchEntryField.find('.search').focus(100);
        }
      });
    },
    disableEditing: function() {
      return jQuery(this.element).unbind('click');
    },
    _destroy: function() {
      this.disableEditing();
      if (this.menu) {
        this.menu.destroy();
        this.menu.element.remove();
        delete this.menu;
      }
      if (this.dialog) {
        this.dialog.destroy();
        this.dialog.element.remove();
        this.dialog.uiDialogTitlebar.remove();
        delete this.dialog;
      }
      this._logger.info("destroy tooltip");
      if (this.element.data().tooltip || this.element.data().uiTooltip) {
        return this.element.tooltip("destroy");
      }
    },
    remove: function(event) {
      var el;
      el = this.element.parent();
      this._logger.info("destroy tooltip");
      if (this.element.data().tooltip || this.element.data().uiTooltip) {
        this.element.tooltip("destroy");
      }
      if (!this.isAnnotated() && this.textEnhancements) {
        this._trigger('decline', event, {
          textEnhancements: this.textEnhancements
        });
      } else {
        this._trigger('remove', event, {
          textEnhancement: this._acceptedTextEnhancement,
          entityEnhancement: this._acceptedEntityEnhancement,
          linkedEntity: this.linkedEntity
        });
      }
      this.destroy();
      if (this.element.qname().name !== '#text') {
        return this.element.replaceWith(document.createTextNode(this.element.text()));
      }
    },
    disable: function() {
      if (!this.isAnnotated() && this.element.qname().name !== '#text') {
        return this.element.replaceWith(document.createTextNode(this.element.text()));
      } else {
        return this.disableEditing();
      }
    },
    isAnnotated: function() {
      if (this.element.attr('resource')) {
        return true;
      } else {
        return false;
      }
    },
    annotate: function(entityEnhancement, options) {
      var entityClass, entityHtml, entityType, entityUri, newElement, rel, sType, type, ui, _i, _len, _ref1, _ref2;
      entityUri = entityEnhancement.getUri();
      entityType = entityEnhancement.getTextEnhancement().getType() || "";
      entityHtml = this.element.html();
      sType = entityEnhancement.getTextEnhancement().getType();
      if (!sType.length) {
        sType = ["Other"];
      }
      this.element.attr('xmlns:skos', ns.skos);
      rel = options.rel || "skos:related";
      entityClass = 'entity ' + uriSuffix(sType[0]).toLowerCase();
      _ref1 = ['Person', 'Place', 'Organisation'];
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        type = _ref1[_i];
        _(sType).each(function(t) {
          if (t.indexOf(type) !== -1) {
            return entityClass += " " + type;
          }
        });
      }
      newElement = $("<a href='" + entityUri + "'            resource='" + entityUri + "'            rel='" + rel + "'            class='" + entityClass + "'>" + entityHtml + "</a>");
      this._cloneCopyEvent(this.element[0], newElement[0]);
      this.linkedEntity = {
        uri: entityUri,
        type: entityType,
        label: entityEnhancement.getLabel()
      };
      this.element.replaceWith(newElement);
      this.element = newElement.addClass(options.styleClass);
      this._logger.info("created annotation in", this.element);
      this._updateTitle();
      this._insertLink();
      this._acceptedTextEnhancement = entityEnhancement.getTextEnhancement();
      this._acceptedEntityEnhancement = entityEnhancement;
      ui = {
        linkedEntity: this.linkedEntity,
        textEnhancement: entityEnhancement.getTextEnhancement(),
        entityEnhancement: entityEnhancement
      };
      this.select(ui);
      this._initTooltip();
      jQuery(newElement).annotationSelector(this.options);
      return (_ref2 = this.dialog) != null ? _ref2.close() : void 0;
    },
    select: function(ui) {
      var e;
      e = new jQuery.Event("select");
      e.ui = ui;
      this._trigger('select', e, ui);
      return jQuery(this.options.annotateElement).trigger("annotateselect", ui);
    },
    acceptBestCandidate: function() {
      var eEnhancements;
      eEnhancements = this._getEntityEnhancements();
      if (!eEnhancements.length) {
        return;
      }
      if (this.isAnnotated()) {
        return;
      }
      this.annotate(eEnhancements[0], {
        styleClass: "acknowledged"
      });
      return eEnhancements[0];
    },
    addTextEnhancement: function(textEnh) {
      this.options.textEnhancements = this.options.textEnhancements || [];
      this.options.textEnhancements.push(textEnh);
      return this.textEnhancements = this.options.textEnhancements;
    },
    close: function() {
      var _ref1;
      if ((_ref1 = this.dialog) != null) {
        if (typeof _ref1.close === "function") {
          _ref1.close();
        }
      }
      return jQuery(".ui-tooltip").remove();
    },
    _initTooltip: function() {
      var widget,
        _this = this;
      widget = this;
      if (this.options.showTooltip) {
        this._logger.info("init tooltip for", this.element);
        return jQuery(this.element).tooltip({
          items: "[resource]",
          hide: {
            effect: "hide",
            delay: 50
          },
          show: {
            effect: "show",
            delay: 50
          },
          content: function(response) {
            var uri;
            uri = _this.element.attr("resource");
            _this._logger.info("tooltip uri:", uri);
            widget._createPreview(uri, response);
            return "loading...";
          }
        });
      }
    },
    _getEntityEnhancements: function() {
      var eEnhancements, enhancement, textEnh, _i, _j, _len, _len1, _ref1, _ref2, _tempUris;
      eEnhancements = [];
      _ref1 = this.textEnhancements;
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        textEnh = _ref1[_i];
        _ref2 = textEnh.getEntityEnhancements();
        for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
          enhancement = _ref2[_j];
          eEnhancements.push(enhancement);
        }
      }
      _tempUris = [];
      eEnhancements = _(eEnhancements).filter(function(eEnh) {
        var uri;
        uri = eEnh.getUri();
        if (_.indexOf(_tempUris, uri) === -1) {
          _tempUris.push(uri);
          return true;
        } else {
          return false;
        }
      });
      return _(eEnhancements).sortBy(function(e) {
        return -1 * e.getConfidence();
      });
    },
    _typeLabels: function(types) {
      var allKnownPrefixes, knownMapping, knownPrefixes,
        _this = this;
      knownMapping = this.options.getTypes();
      allKnownPrefixes = _(knownMapping).map(function(x) {
        return x.uri;
      });
      knownPrefixes = _.intersection(allKnownPrefixes, types);
      return _(knownPrefixes).map(function(key) {
        var foundPrefix;
        foundPrefix = _(knownMapping).detect(function(x) {
          return x.uri === key;
        });
        return foundPrefix.label;
      });
    },
    _sourceLabel: function(src) {
      var sourceObj, sources;
      if (!src) {
        this._logger.warn("No source");
      }
      if (!src) {
        return "";
      }
      sources = this.options.getSources();
      sourceObj = _(sources).detect(function(s) {
        return src.indexOf(s.uri) !== -1;
      });
      if (sourceObj) {
        return sourceObj.label;
      } else {
        return src.split("/")[2];
      }
    },
    _createDialog: function() {
      var dialogEl, label, widget,
        _this = this;
      label = this.element.text();
      jQuery(".annotateselector-dialog-content").dialog("destroy").remove();
      dialogEl = $("<div class='annotateselector-dialog-content'><span class='entity-link'></span></div>").attr("tabIndex", -1).addClass().keydown(function(event) {
        if (!event.isDefaultPrevented() && event.keyCode && event.keyCode === $.ui.keyCode.ESCAPE) {
          _this.close(event);
          return event.preventDefault();
        }
      }).bind('dialogblur', function(event) {
        _this._logger.info('dialog dialogblur');
        return _this.close(event);
      }).bind('blur', function(event) {
        _this._logger.info('dialog blur');
        return _this.close(event);
      }).appendTo($("body")[0]);
      widget = this;
      dialogEl.dialog({
        width: 400,
        dialogClass: 'annotation-selector-dialog',
        title: label,
        autoOpen: false,
        open: function(e, ui) {},
        position: {
          of: this.element,
          my: "left top",
          at: "left bottom",
          collision: "flip"
        }
      });
      this.dialog = dialogEl.data('dialog') || dialogEl.data('uiDialog');
      this.dialog.uiDialogTitlebar.hide();
      this._logger.info("dialog widget:", this.dialog);
      this.dialog.element.focus(100);
      window.d = this.dialog;
      this._insertLink();
      this._updateTitle();
      return this._setButtons();
    },
    _insertLink: function() {
      if (this.isAnnotated() && this.dialog) {
        return $("Annotated: <a href='" + this.linkedEntity.uri + "' target='_blank'>            " + this.linkedEntity.label + " @ " + (this._sourceLabel(this.linkedEntity.uri)) + "</a><br/>").appendTo($('.entity-link', this.dialog.element));
      }
    },
    _setButtons: function() {
      var _this = this;
      return this.dialog.element.dialog('option', 'buttons', {
        rem: {
          text: this.isAnnotated() ? 'Remove' : 'Decline',
          click: function(event) {
            _this.remove(event);
            return _this.close();
          }
        },
        Cancel: function() {
          return _this.close();
        }
      });
    },
    _updateTitle: function() {
      var title;
      if (this.dialog) {
        if (this.isAnnotated()) {
          title = "" + this.linkedEntity.label + " <small>@ " + (this._sourceLabel(this.linkedEntity.uri)) + "</small>";
        } else {
          title = this.element.text();
        }
        return this.dialog._setOption('title', title);
      }
    },
    _createMenu: function() {
      var selectHandler, ul, widget,
        _this = this;
      widget = this;
      ul = $('<ul class="suggestion-menu"></ul>').appendTo(this.dialog.element);
      this._renderMenu(ul, this.entityEnhancements);
      selectHandler = function(event, ui) {
        _this._logger.info("selected menu item", ui.item);
        _this.annotate(ui.item.data('enhancement'), {
          styleClass: 'acknowledged'
        });
        return _this.close(event);
      };
      this.menu = ul.menu({
        selected: selectHandler,
        select: selectHandler,
        blur: function(event, ui) {
          return _this._logger.info('menu.blur()', ui.item);
        },
        styleClass: 'suggestion-menu'
      }).focus(150);
      if (this.options.showTooltip) {
        this.menu.tooltip({
          items: ".ui-menu-item",
          hide: {
            effect: "hide",
            delay: 50
          },
          show: {
            effect: "show",
            delay: 50
          },
          content: function(response) {
            var uri;
            uri = jQuery(this).attr("entityuri");
            widget._createPreview(uri, response);
            return "loading...";
          }
        });
      }
      return this.menu = this.menu.data('menu') || this.menu.data('uiMenu');
    },
    _createPreview: function(uri, response) {
      var fail, success,
        _this = this;
      success = function(cacheEntity) {
        var depictionUrl, descr, html, picSize;
        html = "";
        picSize = 100;
        depictionUrl = _this._getDepiction(cacheEntity, picSize);
        if (depictionUrl) {
          html += "<img style='float:left;padding: 5px;width: " + picSize + "px' src='" + (depictionUrl.substring(1, depictionUrl.length - 1)) + "'/>";
        }
        descr = _this._getDescription(cacheEntity);
        if (!descr) {
          _this._logger.warn("No description found for", cacheEntity);
          descr = "No description found.";
        }
        html += "<div style='padding 5px;width:250px;float:left;'><small>" + descr + "</small></div>";
        _this._logger.info("tooltip for " + uri + ": cacheEntry loaded", cacheEntity);
        return setTimeout(function() {
          return response(html);
        }, 200);
      };
      fail = function(e) {
        _this._logger.error("error loading " + uri, e);
        return response("error loading entity for " + uri);
      };
      jQuery(".ui-tooltip").remove();
      return this.options.cache.get(uri, this, success, fail);
    },
    _getUserLang: function() {
      var navigatorLanguage;
      navigatorLanguage = window.navigator.language || window.navigator.userLanguage;
      return navigatorLanguage.split("-")[0];
    },
    _getDepiction: function(entity, picSize) {
      var depictionUrl, field, fieldValue, preferredFields;
      preferredFields = this.options.depictionProperties;
      field = _(preferredFields).detect(function(field) {
        if (entity.get(field)) {
          return true;
        }
      });
      if (field && (fieldValue = _([entity.get(field)]).flatten())) {
        depictionUrl = _(fieldValue).detect(function(uri) {
          uri = (typeof uri.getSubject === "function" ? uri.getSubject() : void 0) || uri;
          if (uri.indexOf("thumb") !== -1) {
            return true;
          }
        });
        if (depictionUrl) {
          depictionUrl = depictionUrl.replace(/[0-9]{2..3}px/, "" + picSize + "px");
        }
        return depictionUrl;
      }
    },
    _getLabel: function(entity) {
      var preferredFields, preferredLanguages;
      preferredFields = this.options.labelProperties;
      preferredLanguages = [this._getUserLang(), this.options.fallbackLanguage];
      return VIE.Util.getPreferredLangForPreferredProperty(entity, preferredFields, preferredLanguages);
    },
    _getDescription: function(entity) {
      var preferredFields, preferredLanguages;
      preferredFields = this.options.descriptionProperties;
      preferredLanguages = [this._getUserLang(), this.options.fallbackLanguage];
      return VIE.Util.getPreferredLangForPreferredProperty(entity, preferredFields, preferredLanguages);
    },
    _renderMenu: function(ul, entityEnhancements) {
      var enhancement, _i, _len;
      entityEnhancements = _(entityEnhancements).sortBy(function(ee) {
        return -1 * ee.getConfidence();
      });
      for (_i = 0, _len = entityEnhancements.length; _i < _len; _i++) {
        enhancement = entityEnhancements[_i];
        this._renderItem(ul, enhancement);
      }
      return this._logger.info('rendered menu for the elements', entityEnhancements);
    },
    _renderItem: function(ul, eEnhancement) {
      var active, item, label, source, type;
      label = eEnhancement.getLabel().replace(/^\"|\"$/g, "");
      type = this._typeLabels(eEnhancement.getTypes()).toString() || "Other";
      source = this._sourceLabel(eEnhancement.getUri());
      active = this.linkedEntity && eEnhancement.getUri() === this.linkedEntity.uri ? " class='ui-state-active'" : "";
      return item = $("<li" + active + " entityuri='" + (eEnhancement.getUri()) + "' resource='" + (eEnhancement.getUri()) + "'><a>" + label + " <small>(" + type + " from " + source + ")</small></a></li>").data('enhancement', eEnhancement).appendTo(ul);
    },
    _createSearchbox: function() {
      var sugg, widget,
        _this = this;
      this.searchEntryField = $('<span style="background: fff;"><label for="search">Search:</label> <input id="search" class="search"></span>').appendTo(this.dialog.element);
      sugg = this.textEnhancements[0];
      widget = this;
      this.searchbox = $('.search', this.searchEntryField).vieAutocomplete({
        vie: this.options.vie,
        urifield: jQuery("#urifield"),
        select: function(e, ui) {
          var item;
          item = ui.item;
          item.getUri = function() {
            return this.key;
          };
          item._tEnh = sugg;
          item.getTextEnhancement = function() {
            return this._tEnh;
          };
          item.getLabel = function() {
            return this.label;
          };
          _this.annotate(ui.item, {
            styleClass: "acknowledged"
          });
          return _this._logger.info("autocomplete.select", e.target, ui);
        }
      });
      this.searchEntryField.focus(200).blur(function(e, ui) {
        return _this._dialogCloseTimeout = setTimeout((function() {
          return _this.close();
        }), 200);
      });
      if (!this.entityEnhancements.length && !this.isAnnotated()) {
        setTimeout(function() {
          var label;
          label = _this.element.html();
          _this.searchbox.val(label);
          return _this.searchbox.autocomplete("search", label);
        }, 300);
      }
      return this._logger.info("show searchbox");
    },
    _cloneCopyEvent: function(src, dest) {
      if (jQuery().jquery.indexOf("1.6") === 0) {
        return this._cloneCopyEvent1_6(src, dest);
      } else {
        return this._cloneCopyEvent1_7(src, dest);
      }
    },
    _cloneCopyEvent1_6: function(src, dest) {
      var curData, events, i, internalKey, l, oldData, type;
      if (dest.nodeType !== 1 || !jQuery.hasData(src)) {
        return;
      }
      internalKey = $.expando;
      oldData = $.data(src);
      curData = $.data(dest, oldData);
      if (oldData = oldData[internalKey]) {
        events = oldData.events;
        curData = curData[internalKey] = jQuery.extend({}, oldData);
        if (events) {
          delete curData.handle;
          curData.events = {};
          for (type in events) {
            i = 0;
            l = events[type].length;
            while (i < l) {
              jQuery.event.add(dest, type + (events[type][i].namespace ? "." : "") + events[type][i].namespace, events[type][i], events[type][i].data);
              i++;
            }
          }
        }
        return null;
      }
    },
    _cloneCopyEvent1_7: function(src, dest) {
      var curData, events, i, l, oldData, type;
      if (dest.nodeType !== 1 || !jQuery.hasData(src)) {
        return;
      }
      type = void 0;
      i = void 0;
      l = void 0;
      oldData = jQuery._data(src);
      curData = jQuery._data(dest, oldData);
      events = oldData.events;
      if (events) {
        delete curData.handle;
        curData.events = {};
        for (type in events) {
          i = 0;
          l = events[type].length;
          while (i < l) {
            jQuery.event.add(dest, type + (events[type][i].namespace ? "." : "") + events[type][i].namespace, events[type][i], events[type][i].data);
            i++;
          }
        }
      }
      if (curData.data) {
        return curData.data = jQuery.extend({}, curData.data);
      }
    }
  });

  $(window).click(function(event) {
    if (($(event.target).closest(".ui-dialog.annotation-selector-dialog")).length > 0) {
      return false;
    } else {
      return $(".annotation-selector-dialog .ui-dialog-content:visible").dialog("close");
    }
  });

  Stanbol = Stanbol != null ? Stanbol : {};

  Stanbol.getTextAnnotations = function(enhList) {
    var res;
    res = _(enhList).filter(function(e) {
      return e.isof("<" + ns.enhancer + "TextAnnotation>");
    });
    res = _(res).sortBy(function(e) {
      var conf;
      if (e.get("enhancer:confidence")) {
        conf = Number(e.get("enhancer:confidence"));
      }
      return -1 * conf;
    });
    return _(res).map(function(enh) {
      return new Stanbol.TextEnhancement(enh, enhList);
    });
  };

  Stanbol.getEntityAnnotations = function(enhList) {
    return _(enhList).filter(function(e) {
      return e.isof("<" + ns.enhancer + "EntityAnnotation>");
    });
  };

  Stanbol.TextEnhancement = (function() {

    function TextEnhancement(enhancement, enhList) {
      this._enhancement = enhancement;
      this._enhList = enhList;
      this.id = this._enhancement.getSubject();
    }

    TextEnhancement.prototype.getSelectedText = function() {
      var res;
      res = this._vals("enhancer:selected-text");
      if (typeof res === "string") {
        return res;
      }
      if (typeof res === "object") {
        return res.toString();
      }
    };

    TextEnhancement.prototype.getConfidence = function() {
      return this._vals("enhancer:confidence");
    };

    TextEnhancement.prototype.getEntityEnhancements = function() {
      var rawList,
        _this = this;
      rawList = this._enhancement.get("entityAnnotation");
      if (!rawList) {
        return [];
      }
      rawList = _.flatten([rawList]);
      return _(rawList).map(function(ee) {
        return new Stanbol.EntityEnhancement(ee, _this);
      });
    };

    TextEnhancement.prototype.getType = function() {
      return this._uriTrim(this._vals("dcterms:type"));
    };

    TextEnhancement.prototype.getContext = function() {
      return this._vals("enhancer:selection-context");
    };

    TextEnhancement.prototype.getStart = function() {
      return Number(this._vals("enhancer:start"));
    };

    TextEnhancement.prototype.getEnd = function() {
      return Number(this._vals("enhancer:end"));
    };

    TextEnhancement.prototype.getOrigText = function() {
      var ciUri;
      ciUri = this._vals("enhancer:extracted-from");
      return this._enhList[ciUri]["http://www.semanticdesktop.org/ontologies/2007/01/19/nie#plainTextContent"][0].value;
    };

    TextEnhancement.prototype._vals = function(key) {
      return this._enhancement.get(key);
    };

    TextEnhancement.prototype._uriTrim = function(uriRef) {
      var bbColl, mod;
      if (!uriRef) {
        return [];
      }
      if (uriRef instanceof Backbone.Model || uriRef instanceof Backbone.Collection) {
        bbColl = uriRef;
        return (function() {
          var _i, _len, _ref1, _results;
          _ref1 = bbColl.models;
          _results = [];
          for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
            mod = _ref1[_i];
            _results.push(mod.get("@subject").replace(/^<|>$/g, ""));
          }
          return _results;
        })();
      } else {

      }
      return _(_.flatten([uriRef])).map(function(ur) {
        return ur.replace(/^<|>$/g, "");
      });
    };

    return TextEnhancement;

  })();

  Stanbol.EntityEnhancement = (function() {

    function EntityEnhancement(ee, textEnh) {
      this._enhancement = ee;
      this._textEnhancement = textEnh;
      this;

    }

    EntityEnhancement.prototype.getLabel = function() {
      return this._vals("enhancer:entity-label").toString().replace(/(^\"*|\"*@..$)/g, "");
    };

    EntityEnhancement.prototype.getUri = function() {
      return this._uriTrim(this._vals("enhancer:entity-reference"))[0];
    };

    EntityEnhancement.prototype.getTextEnhancement = function() {
      return this._textEnhancement;
    };

    EntityEnhancement.prototype.getTypes = function() {
      return this._uriTrim(this._vals("enhancer:entity-type"));
    };

    EntityEnhancement.prototype.getConfidence = function() {
      return Number(this._vals("enhancer:confidence"));
    };

    EntityEnhancement.prototype._vals = function(key) {
      var res;
      res = this._enhancement.get(key);
      if (!res) {
        return [];
      }
      if (res.pluck) {
        return res.pluck("@subject");
      } else {
        return res;
      }
    };

    EntityEnhancement.prototype._uriTrim = function(uriRef) {
      var bbColl, mod;
      if (!uriRef) {
        return [];
      }
      if (uriRef instanceof Backbone.Collection) {
        bbColl = uriRef;
        return (function() {
          var _i, _len, _ref1, _results;
          _ref1 = bbColl.models;
          _results = [];
          for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
            mod = _ref1[_i];
            _results.push(mod.getSubject().replace(/^<|>$/g, ""));
          }
          return _results;
        })();
      } else if (uriRef instanceof Backbone.Model) {
        uriRef = uriRef.getSubject();
      }
      return _(_.flatten([uriRef])).map(function(ur) {
        return ur.replace(/^<|>$/g, "");
      });
    };

    return EntityEnhancement;

  })();

  vie = new VIE();

  vie.use(new vie.StanbolService({
    url: "http://dev.iks-project.eu:8080",
    proxyDisabled: true
  }));

  jQuery.widget("IKS.vieAutocomplete", {
    options: {
      vie: vie,
      select: function(e, ui) {},
      urifield: null,
      field: "rdfs:label",
      services: "stanbol",
      debug: false,
      showTooltip: true,
      depictionProperties: ["foaf:depiction", "schema:thumbnail"],
      labelProperties: ["rdfs:label", "skos:prefLabel", "schema:name", "foaf:name"],
      descriptionProperties: [
        "rdfs:comment", "skos:note", "schema:description", "skos:definition", {
          property: "skos:broader",
          makeLabel: function(propertyValueArr) {
            var labels;
            labels = _(propertyValueArr).map(function(termUri) {
              return termUri.replace(/<.*[\/#](.*)>/, "$1").replace(/_/g, "&nbsp;");
            });
            return "Subcategory of " + (labels.join(', ')) + ".";
          }
        }, {
          property: "dcterms:subject",
          makeLabel: function(propertyValueArr) {
            var labels;
            labels = _(propertyValueArr).map(function(termUri) {
              return termUri.replace(/<.*[\/#](.*)>/, "$1").replace(/_/g, "&nbsp;");
            });
            return "Subject(s): " + (labels.join(', ')) + ".";
          }
        }
      ],
      stanbolIncludeLocalSite: false,
      fallbackLanguage: "en",
      styleClass: "vie-autocomplete",
      getTypes: function() {
        return [
          {
            uri: "" + this.ns.dbpedia + "Place",
            label: 'Place'
          }, {
            uri: "" + this.ns.dbpedia + "Person",
            label: 'Person'
          }, {
            uri: "" + this.ns.dbpedia + "Organisation",
            label: 'Organisation'
          }, {
            uri: "" + this.ns.skos + "Concept",
            label: 'Concept'
          }
        ];
      },
      getSources: function() {
        return [
          {
            uri: "http://dbpedia.org/resource/",
            label: "dbpedia"
          }, {
            uri: "http://sws.geonames.org/",
            label: "geonames"
          }
        ];
      },
      source: function(req, resp) {
        var getSuccessCallback, listOfResultLists, mergedEntityList, properties, term, waitingfor,
          _this = this;
        this._logger.info("req:", req);
        properties = _.flatten([this.options.labelProperties, this.options.descriptionProperties, this.options.depictionProperties]);
        properties = _(properties).map(function(prop) {
          if (typeof prop === "object") {
            return prop.property;
          } else {
            return prop;
          }
        });
        waitingfor = 0;
        mergedEntityList = [];
        listOfResultLists = [];
        getSuccessCallback = function(term, priority) {
          return function(entityList) {
            return _.defer(function() {
              var limit, res;
              waitingfor--;
              _this._logger.info(term, priority, "resp:", entityList);
              limit = 10;
              entityList = _(entityList).filter(function(ent) {
                if (ent.getSubject().replace(/^<|>$/g, "") === "http://www.iks-project.eu/ontology/rick/query/QueryResultSet") {
                  return false;
                }
                return true;
              });
              listOfResultLists[priority] = listOfResultLists[priority] || [];
              listOfResultLists[priority] = listOfResultLists[priority].concat(entityList);
              if (waitingfor === 0) {
                console.info("listOfResultLists", listOfResultLists);
                _.chain(listOfResultLists).compact().each(function(resultList) {
                  var sortedList;
                  sortedList = _(resultList).sortBy(function(e) {
                    var s;
                    s = e.get('<http://stanbol.apache.org/ontology/entityhub/query#score>');
                    if (typeof s === "object") {
                      s = _.max(s);
                    }
                    return 0 - s;
                  });
                  return mergedEntityList = mergedEntityList.concat(sortedList);
                });
                /*
                                  @_logger.info _(mergedEntityList).map (e) ->
                                    uri = e.getSubject()
                                    s = e.get '<http://stanbol.apache.org/ontology/entityhub/query#score>'
                                    return "#{uri}: #{s}"
                */

                _this._logger.info(mergedEntityList);
                res = _(mergedEntityList.slice(0, limit)).map(function(entity) {
                  return {
                    key: entity.getSubject().replace(/^<|>$/g, ""),
                    label: "" + (_this._getLabel(entity)) + " @ " + (_this._sourceLabel(entity.id)),
                    value: _this._getLabel(entity),
                    getUri: function() {
                      return this.key;
                    }
                  };
                });
                return resp(res);
              }
            });
          };
        };
        waitingfor++;
        term = "" + req.term + (req.term.length > 3 ? '*' : '');
        this.options.vie.find({
          term: term,
          field: this.options.field,
          properties: properties
        }).using(this.options.services).execute().fail(function(e) {
          return _this._logger.error("Something wrong happened at stanbol find:", e);
        }).success(getSuccessCallback(term, 3));
        if (req.term.length > 3) {
          waitingfor++;
          this.options.vie.find({
            term: req.term,
            field: this.options.field,
            properties: properties
          }).using(this.options.services).execute().fail(function(e) {
            return _this._logger.error("Something wrong happened at stanbol find:", e);
          }).success(getSuccessCallback(req.term, 2));
        }
        if (this.options.stanbolIncludeLocalSite) {
          this._logger.log("stanbolIncludeLocalSite");
          waitingfor++;
          term = "" + req.term + (req.term.length > 3 ? '*' : '');
          return this.options.vie.find({
            term: term,
            field: this.options.field,
            properties: properties,
            local: true
          }).using(this.options.services).execute().fail(function(e) {
            return _this._logger.error("Something wrong happened at stanbol find:", e);
          }).success(getSuccessCallback('local:' + term, 1));
        }
      }
    },
    _create: function() {
      this._logger = this.options.debug ? console : {
        info: function() {},
        warn: function() {},
        error: function() {},
        log: function() {}
      };
      this.menuContainer = jQuery("<span class='" + this.options.styleClass + "'/>");
      this.menuContainer.appendTo('body');
      return this._instantiateAutocomplete();
    },
    _destroy: function() {
      return this.menuContainer.remove();
    },
    _instantiateAutocomplete: function() {
      var widget,
        _this = this;
      widget = this;
      return this.element.autocomplete({
        source: function(req, resp) {
          return _this.options.source.apply(_this, [req, resp]);
        },
        open: function(e, ui) {
          var uiMenu, _ref1,
            _this = this;
          widget._logger.info("autocomplete.open", e, ui);
          if (widget.options.showTooltip) {
            uiMenu = ((_ref1 = $(this).data().autocomplete) != null ? _ref1.menu : void 0) || $(this).data().uiAutocomplete.menu;
            $('.ui-menu-item', uiMenu.activeMenu).each(function() {
              var item, uri;
              item = $(this).data()["item.autocomplete"] || $(this).data()["uiAutocompleteItem"] || $(this).data()["ui-autocomplete-item"];
              uri = item.getUri();
              return $(this).entitypreview({
                vie: widget.options.vie,
                uri: uri
              });
            });
            $('.ui-menu-item', uiMenu.activeMenu).first().parent().unbind('menufocus').bind('menufocus', function(e, ui) {
              console.info('fire focusin');
              return ui.item.trigger('focusin', ui);
            });
            return $('.ui-menu-item', uiMenu.activeMenu).first().parent().unbind('menublur').bind('menublur', function(e, ui) {
              return $(':IKS-Entitypreview').trigger('blur');
            });
          }
        },
        focus: function(e, ui) {
          return console.info("focus", ui);
        },
        blur: function(e, ui) {
          return console.info('autocomplete.blur event', e, ui);
        },
        select: function(e, ui) {
          var uiMenu, _ref1;
          uiMenu = ((_ref1 = $(e.target).data().autocomplete) != null ? _ref1.menu : void 0) || $(e.target).data().uiAutocomplete.menu;
          $('.ui-menu-item', uiMenu.activeMenu).each(function() {
            return $(this).entitypreview('destroy');
          });
          _.defer(function() {
            _this.options.select(e, ui);
            _this._logger.info("autocomplete.select", e.target, ui);
            if (widget.options.urifield) {
              return widget.options.urifield.val(ui.item.key);
            }
          });
          return true;
        },
        appendTo: this.menuContainer
      });
    },
    _getUserLang: function() {
      return window.navigator.language.split("-")[0];
    },
    _getLabel: function(entity) {
      var preferredFields, preferredLanguages;
      preferredFields = this.options.labelProperties;
      preferredLanguages = [this._getUserLang(), this.options.fallbackLanguage];
      return VIE.Util.getPreferredLangForPreferredProperty(entity, preferredFields, preferredLanguages);
    },
    _sourceLabel: function(src) {
      var sourceObj, sources;
      if (!src) {
        this._logger.warn("No source");
      }
      if (!src) {
        return "";
      }
      sources = this.options.getSources();
      sourceObj = _(sources).detect(function(s) {
        return src.indexOf(s.uri) !== -1;
      });
      if (sourceObj) {
        return sourceObj.label;
      } else {
        return src.split("/")[2];
      }
    }
  });

}).call(this);
