/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart.run;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.sling.maven.slingstart.launcher.Main;
import org.apache.sling.maven.slingstart.run.LaunchpadEnvironment;
import org.apache.sling.maven.slingstart.run.ProcessDescription;
import org.apache.sling.maven.slingstart.run.ProcessDescriptionProvider;
import org.apache.sling.maven.slingstart.run.ServerConfiguration;

public class LauncherCallable
implements Callable<ProcessDescription> {
    private final LaunchpadEnvironment environment;
    private final ServerConfiguration configuration;
    private final Log logger;

    public LauncherCallable(Log logger, ServerConfiguration configuration, LaunchpadEnvironment environment) {
        this.logger = logger;
        this.configuration = configuration;
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessDescription call() throws Exception {
        if (!ProcessDescriptionProvider.getInstance().isRunConfigurationAvailable(this.configuration.getId())) {
            throw new Exception("Launchpad with id " + this.configuration.getId() + " is not available");
        }
        File launchpad = this.environment.prepare(this.configuration.getFolder());
        String launchpadKey = ProcessDescriptionProvider.getInstance().getId(this.configuration.getId());
        ProcessDescription cfg = this.start(launchpad);
        if (this.environment.isShutdownOnExit()) {
            cfg.installShutdownHook();
        }
        ProcessDescriptionProvider.getInstance().addRunConfiguration(cfg, launchpadKey);
        boolean started = false;
        try {
            long endTime = System.currentTimeMillis() + (long)(this.environment.getReadyTimeOutSec() * 1000);
            boolean finished = false;
            while (!started && !finished && System.currentTimeMillis() < endTime) {
                Thread.sleep(5000L);
                started = cfg.getControlListener().isStarted();
                try {
                    cfg.getProcess().exitValue();
                    finished = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
            if (finished) {
                throw new Exception("Launchpad did exit unexpectedly.");
            }
            if (!started) {
                throw new Exception("Launchpad did not start successfully in " + this.environment.getReadyTimeOutSec() + " seconds.");
            }
            boolean httpAvailable = this.isLocalhostPortAvailable(Integer.valueOf(this.configuration.getPort()));
            while (!httpAvailable && System.currentTimeMillis() < endTime) {
                Thread.sleep(1000L);
                httpAvailable = this.isLocalhostPortAvailable(Integer.valueOf(this.configuration.getPort()));
            }
            if (!httpAvailable) {
                throw new Exception("Launchpad did not start http service on port " + this.configuration.getPort() + " successfully in " + this.environment.getReadyTimeOutSec() + " seconds.");
            }
            this.logger.info((CharSequence)("Started Launchpad '" + this.configuration.getId() + "' at port " + this.configuration.getPort() + " [run modes: " + this.configuration.getRunmode() + "]"));
        }
        finally {
            cfg.getControlListener().stop();
            if (!started) {
                LauncherCallable.stop(this.logger, cfg);
                ProcessDescriptionProvider.getInstance().removeRunConfiguration(cfg.getId());
                cfg = null;
            }
        }
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLocalhostPortAvailable(int port) throws IOException {
        try (Socket clientSocket = new Socket();){
            clientSocket.connect(new InetSocketAddress("127.0.0.1", port), 500);
            this.logger.debug((CharSequence)("Successfully connected to localhost, port " + port));
            clientSocket.close();
            boolean bl = true;
            return bl;
        }
    }

    public boolean isRunning() {
        return LauncherCallable.getControlPortFile(this.configuration.getFolder()).exists();
    }

    private void add(List<String> args, String value) {
        if (value != null) {
            String[] single;
            for (String v : single = value.trim().split(" ")) {
                if (v.trim().length() <= 0) continue;
                args.add(v.trim());
            }
        }
    }

    private ProcessDescription start(File jar) throws Exception {
        ProcessDescription cfg = new ProcessDescription(this.configuration.getId(), this.configuration.getFolder());
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ArrayList<String> args = new ArrayList<String>();
        String javaHome = System.getenv("JAVA_HOME");
        String javaCmd = javaHome != null ? Paths.get(javaHome, "bin", "java").toString() : "java";
        args.add(javaCmd);
        this.add(args, this.configuration.getVmOpts());
        this.add(args, this.configuration.getVmDebugOpts(this.environment.getDebug()));
        args.add("-cp");
        args.add("bin");
        args.add(Main.class.getName());
        args.add(jar.getPath());
        args.add(String.valueOf(cfg.getControlListener().getPort()));
        args.add("true");
        this.add(args, this.configuration.getOpts());
        String contextPath = this.configuration.getContextPath();
        if (contextPath != null && contextPath.length() > 0 && !contextPath.equals("/")) {
            args.add("-r");
            args.add(contextPath);
        }
        if (this.configuration.getPort() != null) {
            args.add("-p");
            args.add(this.configuration.getPort());
        }
        if (this.configuration.getControlPort() != null) {
            args.add("-j");
            args.add(this.configuration.getControlPort());
        }
        if (this.configuration.getRunmode() != null && this.configuration.getRunmode().length() > 0) {
            args.add("-Dsling.run.modes=" + this.configuration.getRunmode());
        }
        if (!this.environment.isShutdownOnExit()) {
            args.add("start");
        }
        builder.command(args.toArray(new String[args.size()]));
        builder.directory(this.configuration.getFolder());
        builder.redirectErrorStream(true);
        this.logger.info((CharSequence)("Starting Launchpad " + this.configuration.getId() + "..."));
        String stdOutFile = this.configuration.getStdOutFile();
        if (StringUtils.isNotBlank((String)stdOutFile)) {
            File absoluteStdOutFile = new File(builder.directory(), stdOutFile);
            absoluteStdOutFile.getParentFile().mkdirs();
            builder.redirectOutput(absoluteStdOutFile);
            this.logger.info((CharSequence)("Redirecting stdout and stderr to " + absoluteStdOutFile));
        } else {
            builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        }
        this.logger.debug((CharSequence)("Launchpad cmd: " + builder.command()));
        this.logger.debug((CharSequence)("Launchpad dir: " + builder.directory()));
        try {
            cfg.setProcess(builder.start());
        }
        catch (IOException e) {
            if (cfg.getProcess() != null) {
                cfg.getProcess().destroy();
                cfg.setProcess(null);
            }
            throw new Exception("Could not start the Launchpad", e);
        }
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void stop(Log LOG, ProcessDescription cfg) throws Exception {
        block23: {
            block20: {
                boolean destroy;
                block21: {
                    boolean isNew = false;
                    if (cfg.getProcess() == null && !isNew) break block20;
                    LOG.info((CharSequence)("Stopping Launchpad '" + cfg.getId() + "'"));
                    destroy = true;
                    int twoMinutes = 120000;
                    File controlPortFile = LauncherCallable.getControlPortFile(cfg.getDirectory());
                    LOG.debug((CharSequence)("Control port file " + controlPortFile + " exists: " + controlPortFile.exists()));
                    if (!controlPortFile.exists()) break block21;
                    int controlPort = -1;
                    String secretKey = null;
                    LineNumberReader lnr = null;
                    String serverName = null;
                    try {
                        lnr = new LineNumberReader(new FileReader(controlPortFile));
                        String portLine = lnr.readLine();
                        int pos = portLine.indexOf(58);
                        controlPort = Integer.parseInt(portLine.substring(pos + 1));
                        if (pos > 0) {
                            serverName = portLine.substring(0, pos);
                        }
                        secretKey = lnr.readLine();
                    }
                    catch (NumberFormatException ignore) {
                        LOG.debug((CharSequence)("Error reading control port file " + controlPortFile), (Throwable)ignore);
                        IOUtils.closeQuietly((Reader)lnr);
                    }
                    catch (IOException ignore2) {
                        LOG.debug((CharSequence)("Error reading control port file " + controlPortFile), (Throwable)ignore2);
                        {
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(lnr);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((Reader)lnr);
                    }
                    IOUtils.closeQuietly((Reader)lnr);
                    if (controlPort != -1) {
                        ArrayList<String> hosts = new ArrayList<String>();
                        if (serverName != null) {
                            hosts.add(serverName);
                        }
                        hosts.add("localhost");
                        hosts.add("127.0.0.1");
                        LOG.debug((CharSequence)("Found control port " + controlPort));
                        for (int index = 0; destroy && index < hosts.size(); ++index) {
                            String hostName = (String)hosts.get(index);
                            Socket clientSocket = null;
                            DataOutputStream out = null;
                            BufferedReader in = null;
                            try {
                                LOG.debug((CharSequence)("Trying to connect to " + hostName + ":" + controlPort));
                                clientSocket = new Socket();
                                clientSocket.connect(new InetSocketAddress(hostName, controlPort), 120000);
                                clientSocket.setSoTimeout(120000);
                                LOG.debug((CharSequence)(hostName + ":" + controlPort + " connection estabilished, sending the 'stop' command..."));
                                out = new DataOutputStream(clientSocket.getOutputStream());
                                in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                                if (secretKey != null) {
                                    out.writeBytes(secretKey);
                                    out.write(32);
                                }
                                out.writeBytes("stop\n");
                                in.readLine();
                                destroy = false;
                                LOG.debug((CharSequence)("'stop' command sent to " + hostName + ":" + controlPort));
                            }
                            catch (Throwable ignore) {
                                try {
                                    LOG.debug((CharSequence)("Error sending 'stop' command to " + hostName + ":" + controlPort + " due to: " + ignore.getMessage()));
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(in);
                                    IOUtils.closeQuietly(out);
                                    IOUtils.closeQuietly(clientSocket);
                                    throw throwable;
                                }
                                IOUtils.closeQuietly(in);
                                IOUtils.closeQuietly(out);
                                IOUtils.closeQuietly((Socket)clientSocket);
                                continue;
                            }
                            IOUtils.closeQuietly((Reader)in);
                            IOUtils.closeQuietly((OutputStream)out);
                            IOUtils.closeQuietly((Socket)clientSocket);
                            continue;
                        }
                    }
                }
                if (cfg.getProcess() != null) {
                    Process process = cfg.getProcess();
                    if (!destroy) {
                        LOG.debug((CharSequence)"Waiting for process to stop...");
                        process.waitFor(120000L, TimeUnit.MILLISECONDS);
                        if (process.isAlive()) {
                            LOG.debug((CharSequence)"Process timeout out after 2 minutes");
                            destroy = true;
                        } else {
                            LOG.debug((CharSequence)"Process stopped");
                        }
                    }
                    if (destroy) {
                        LOG.debug((CharSequence)"Destroying process...");
                        process.destroy();
                        process.waitFor(120000L, TimeUnit.MILLISECONDS);
                        LOG.debug((CharSequence)"Process destroyed");
                    }
                    cfg.setProcess(null);
                }
                break block23;
            }
            LOG.warn((CharSequence)"Launchpad already stopped");
        }
    }

    private static File getControlPortFile(File directory) {
        File launchpadDir = new File(directory, "sling");
        File confDir = new File(launchpadDir, "conf");
        File controlPortFile = new File(confDir, "controlport");
        return controlPortFile;
    }
}

