/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.slingstart.ModelUtils;
import org.apache.sling.maven.slingstart.PomArtifactVersionResolver;
import org.apache.sling.maven.slingstart.PomVariableResolver;
import org.apache.sling.maven.slingstart.ProjectHelper;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.MergeUtility;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelResolveUtility;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.io.ModelReader;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class ModelPreprocessor {
    private static final Pattern FUZZY_VERSION = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);

    public void addDependencies(Environment env) throws MavenExecutionException {
        for (ProjectInfo info : env.modelProjects.values()) {
            this.addDependencies(env, info);
        }
    }

    private Model addDependencies(Environment env, ProjectInfo info) throws MavenExecutionException {
        if (info.done) {
            env.logger.debug("Return prepared model for " + info.project);
            return info.model;
        }
        info.done = true;
        env.logger.debug("Processing project " + info.project);
        String pattern = ModelPreprocessor.nodeValue(info.plugin, "modelPattern", "((.*)\\.txt|(.*)\\.model)");
        String inlinedModel = ModelPreprocessor.nodeValue(info.plugin, "model", null);
        String scope = "provided";
        try {
            if (this.hasNodeValue(info.plugin, "modelDirectory")) {
                String directory = ModelPreprocessor.nodeValue(info.plugin, "modelDirectory", null);
                info.localModel = this.readLocalModel(info.project, inlinedModel, new File(directory), pattern, env.logger);
            } else {
                File defaultModelDirectory = new File(info.project.getBasedir(), "src/main/provisioning");
                File defaultConvertedModelDirectory = new File(info.project.getBuild().getDirectory() + "/" + "provisioning/converted");
                File defaultModelDirectoryInTest = new File(info.project.getBasedir(), "src/test/provisioning");
                if (defaultModelDirectory.exists()) {
                    if (defaultConvertedModelDirectory.exists()) {
                        for (File f : defaultModelDirectory.listFiles()) {
                            File targetFile = new File(defaultConvertedModelDirectory, f.getName());
                            if (targetFile.exists()) {
                                env.logger.debug("File already exists. Skipping: " + targetFile);
                                continue;
                            }
                            env.logger.debug("Copying " + f + " to " + targetFile);
                            Files.copy(f.toPath(), targetFile.toPath(), new CopyOption[0]);
                        }
                    } else {
                        env.logger.debug("Try to extract model from default provisioning directory " + defaultModelDirectory.getAbsolutePath());
                        info.localModel = this.readLocalModel(info.project, inlinedModel, defaultModelDirectory, pattern, env.logger);
                    }
                }
                if (defaultConvertedModelDirectory.exists()) {
                    env.logger.debug("Try to extract model from generated provisioning model directory " + defaultConvertedModelDirectory.getAbsolutePath());
                    info.localModel = this.readLocalModel(info.project, inlinedModel, defaultConvertedModelDirectory, pattern, env.logger);
                }
                if (defaultModelDirectoryInTest.exists()) {
                    env.logger.debug("Try to extract model from default test provisioning directory " + defaultModelDirectoryInTest.getAbsolutePath());
                    info.localModel = this.readLocalModel(info.project, inlinedModel, defaultModelDirectoryInTest, pattern, env.logger);
                    scope = "test";
                }
                if (info.localModel == null) {
                    info.localModel = new Model();
                }
            }
        }
        catch (IOException ioe) {
            throw new MavenExecutionException(ioe.getMessage(), (Throwable)ioe);
        }
        this.processAttachments(env, info);
        boolean bl = info.extendMavenClassPath = !this.nodeBooleanValue(info.plugin, "disableExtendingMavenClasspath", false);
        if (this.nodeBooleanValue(info.plugin, "setFeatureVersions", false)) {
            for (Feature f : info.localModel.getFeatures()) {
                if (f.getVersion() != null) continue;
                f.setVersion(this.cleanupVersion(info.project.getVersion()));
            }
        }
        ModelUtility.ResolverOptions resolverOptions = new ModelUtility.ResolverOptions();
        if (this.nodeBooleanValue(info.plugin, "usePomVariables", false)) {
            resolverOptions.variableResolver((ModelUtility.VariableResolver)new PomVariableResolver(info.project));
        }
        if (this.nodeBooleanValue(info.plugin, "usePomDependencies", false)) {
            resolverOptions.artifactVersionResolver((ModelUtility.ArtifactVersionResolver)new PomArtifactVersionResolver(info.project, this.nodeBooleanValue(info.plugin, "allowUnresolvedPomDependencies", false)));
        }
        Model copyModel = new Model();
        this.mergeModels(copyModel, info.localModel);
        Model effectiveModel = ModelUtility.getEffectiveModel((Model)copyModel, (ModelUtility.ResolverOptions)resolverOptions);
        List<Model> dependencies = this.searchSlingstartDependencies(env, info, copyModel, effectiveModel, resolverOptions);
        info.model = new Model();
        for (Model d : dependencies) {
            this.mergeModels(info.model, d);
        }
        this.mergeModels(info.model, copyModel);
        info.model = ModelUtility.getEffectiveModel((Model)info.model, (ModelUtility.ResolverOptions)resolverOptions);
        Map errors = ModelUtility.validate((Model)info.model);
        if (errors != null) {
            throw new MavenExecutionException("Unable to create model file for " + info.project + " : " + errors, (File)null);
        }
        if (info.extendMavenClassPath) {
            this.addDependenciesFromModel(env, info, scope);
            env.logger.info("Extended Maven classpath (scope '" + scope + "') by the dependencies extracted from the Sling model.");
        } else {
            env.logger.debug("Do not enrich Maven classpath with Sling model!");
        }
        try {
            ProjectHelper.storeProjectInfo(info);
        }
        catch (IOException ioe) {
            throw new MavenExecutionException(ioe.getMessage(), (Throwable)ioe);
        }
        return info.model;
    }

    private void addDependenciesFromModel(Environment env, ProjectInfo info, String scope) throws MavenExecutionException {
        if (info.project.getPackaging().equals("slingstart")) {
            Artifact baseArtifact = ModelUtils.findBaseArtifact(info.model);
            String[] classifiers = new String[]{null, "app", "webapp"};
            for (String c : classifiers) {
                Dependency dep = new Dependency();
                dep.setGroupId(baseArtifact.getGroupId());
                dep.setArtifactId(baseArtifact.getArtifactId());
                dep.setVersion(baseArtifact.getVersion());
                dep.setType(baseArtifact.getType());
                dep.setClassifier(c);
                if ("webapp".equals(c)) {
                    dep.setType("war");
                }
                dep.setScope(scope);
                info.project.getDependencies().add(dep);
                env.logger.debug("- adding base dependency " + ModelUtils.toString(dep));
            }
        }
        for (Feature feature : info.model.getFeatures()) {
            if (feature.getName().equals(":launchpad")) continue;
            for (RunMode runMode : feature.getRunModes()) {
                for (ArtifactGroup group : runMode.getArtifactGroups()) {
                    for (Artifact a : group) {
                        if (a.getGroupId().equals(info.project.getGroupId()) && a.getArtifactId().equals(info.project.getArtifactId()) && a.getVersion().equals(info.project.getVersion())) {
                            env.logger.debug("- skipping dependency " + a.toMvnUrl());
                            continue;
                        }
                        Dependency dep = new Dependency();
                        dep.setGroupId(a.getGroupId());
                        dep.setArtifactId(a.getArtifactId());
                        dep.setVersion(a.getVersion());
                        dep.setType(a.getType());
                        dep.setClassifier(a.getClassifier());
                        dep.setScope(scope);
                        env.logger.debug("- adding dependency " + ModelUtils.toString(dep));
                        info.project.getDependencies().add(dep);
                    }
                }
            }
        }
    }

    private List<Model> searchSlingstartDependencies(Environment env, ProjectInfo info, Model rawModel, Model effectiveModel, ModelUtility.ResolverOptions resolverOptions) throws MavenExecutionException {
        ArrayList<Model> dependencies = new ArrayList<Model>();
        for (Feature feature : effectiveModel.getFeatures()) {
            for (RunMode runMode : feature.getRunModes()) {
                for (ArtifactGroup group : runMode.getArtifactGroups()) {
                    ArrayList<Artifact> removeList = new ArrayList<Artifact>();
                    for (Artifact a : group) {
                        if (!a.getType().equals("slingstart") && !a.getType().equals("slingfeature")) continue;
                        Dependency dep = new Dependency();
                        dep.setGroupId(a.getGroupId());
                        dep.setArtifactId(a.getArtifactId());
                        dep.setVersion(a.getVersion());
                        dep.setType("slingfeature");
                        if (a.getType().equals("slingstart")) {
                            dep.setClassifier("slingfeature");
                        } else {
                            dep.setClassifier(a.getClassifier());
                        }
                        dep.setScope("provided");
                        env.logger.debug("- adding dependency " + ModelUtils.toString(dep));
                        info.project.getDependencies().add(dep);
                        String key = a.getGroupId() + ":" + a.getArtifactId();
                        ProjectInfo depInfo = env.modelProjects.get(key);
                        if (depInfo != null) {
                            env.logger.debug("Found reactor " + a.getType() + " dependency : " + a);
                            Model model = this.addDependencies(env, depInfo);
                            if (model == null) {
                                throw new MavenExecutionException("Recursive model dependency list including project " + info.project, (File)null);
                            }
                            dependencies.add(model);
                            info.includedModels.put(a, depInfo.localModel);
                        } else {
                            env.logger.debug("Found external " + a.getType() + " dependency: " + a);
                            File modelFile = this.resolveSlingstartArtifact(env, info.project, dep);
                            FileReader r = null;
                            try {
                                r = new FileReader(modelFile);
                                Model model = ModelReader.read((Reader)r, (String)modelFile.getAbsolutePath());
                                info.includedModels.put(a, model);
                                Map errors = ModelUtility.validate((Model)model);
                                if (errors != null) {
                                    throw new MavenExecutionException("Unable to read model file from " + modelFile + " : " + errors, modelFile);
                                }
                                Model fullModel = this.processSlingstartDependencies(env, info, dep, model, resolverOptions);
                                dependencies.add(fullModel);
                            }
                            catch (IOException ioe) {
                                throw new MavenExecutionException("Unable to read model file from " + modelFile, (Throwable)ioe);
                            }
                            finally {
                                try {
                                    if (r != null) {
                                        r.close();
                                    }
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        removeList.add(a);
                    }
                    for (Artifact r : removeList) {
                        ArtifactGroup localAG;
                        RunMode localRunMode;
                        group.remove((Object)r);
                        Feature localModelFeature = rawModel.getFeature(feature.getName());
                        if (localModelFeature == null || (localRunMode = localModelFeature.getRunMode(runMode.getNames())) == null || (localAG = localRunMode.getArtifactGroup(group.getStartLevel())) == null) continue;
                        ModelPreprocessor.removeArtifact(localModelFeature, localAG, r, resolverOptions);
                    }
                }
            }
        }
        return dependencies;
    }

    private static void removeArtifact(Feature feature, ArtifactGroup group, Artifact toRemove, ModelUtility.ResolverOptions resolverOptions) {
        Iterator it = group.iterator();
        while (it.hasNext()) {
            Artifact el = (Artifact)it.next();
            String version = ModelResolveUtility.replace((Feature)feature, (String)el.getVersion(), (ModelUtility.VariableResolver)resolverOptions.getVariableResolver());
            Artifact resolved = el.getVersion().equals(version) ? el : new Artifact(el.getGroupId(), el.getArtifactId(), version, el.getClassifier(), el.getType());
            if (!resolved.equals((Object)toRemove)) continue;
            it.remove();
        }
    }

    private Model processSlingstartDependencies(Environment env, ProjectInfo info, Dependency dep, Model rawModel, ModelUtility.ResolverOptions resolverOptions) throws MavenExecutionException {
        env.logger.debug("Processing dependency " + dep);
        Model effectiveModel = ModelUtility.getEffectiveModel((Model)rawModel, (ModelUtility.ResolverOptions)new ModelUtility.ResolverOptions());
        List<Model> dependencies = this.searchSlingstartDependencies(env, info, rawModel, effectiveModel, resolverOptions);
        Model mergingModel = new Model();
        for (Model d : dependencies) {
            this.mergeModels(mergingModel, d);
        }
        this.mergeModels(mergingModel, rawModel);
        Map errors = ModelUtility.validate((Model)ModelUtility.getEffectiveModel((Model)mergingModel, (ModelUtility.ResolverOptions)new ModelUtility.ResolverOptions()));
        if (errors != null) {
            throw new MavenExecutionException("Unable to create model file for " + dep + " : " + errors, (File)null);
        }
        return mergingModel;
    }

    public static String nodeValue(Plugin plugin, String name, String defaultValue) {
        Xpp3Dom config = plugin == null ? null : (Xpp3Dom)plugin.getConfiguration();
        return ModelPreprocessor.nodeValue(config, name, defaultValue);
    }

    private static String nodeValue(Xpp3Dom config, String name, String defaultValue) {
        Xpp3Dom node;
        Xpp3Dom xpp3Dom = node = config == null ? null : config.getChild(name);
        if (node != null) {
            return node.getValue();
        }
        return defaultValue;
    }

    private boolean hasNodeValue(Plugin plugin, String name) {
        Xpp3Dom config = plugin == null ? null : (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom node = config == null ? null : config.getChild(name);
        return node != null;
    }

    private void processAttachments(Environment env, ProjectInfo info) throws MavenExecutionException {
        Xpp3Dom[] nodes;
        Xpp3Dom config = info.plugin == null ? null : (Xpp3Dom)info.plugin.getConfiguration();
        Xpp3Dom[] xpp3DomArray = nodes = config == null ? null : config.getChildren("attach");
        if (nodes != null) {
            for (Xpp3Dom node : nodes) {
                Object f;
                String type = ModelPreprocessor.nodeValue(node, "type", null);
                if (type == null) {
                    throw new MavenExecutionException("Attachment for provisioning model has no type.", (File)null);
                }
                String classifier = ModelPreprocessor.nodeValue(node, "classifier", null);
                String featureName = ModelPreprocessor.nodeValue(node, "feature", null);
                int startLevel = 0;
                String level = ModelPreprocessor.nodeValue(node, "startLevel", null);
                if (level != null) {
                    startLevel = Integer.valueOf(level);
                }
                if ((f = featureName != null ? info.localModel.getFeature(featureName) : (info.localModel.getFeatures().isEmpty() ? null : (Feature)info.localModel.getFeatures().get(0))) == null) {
                    if (featureName == null) {
                        throw new MavenExecutionException("No feature found in provisioning model for attachment.", (File)null);
                    }
                    throw new MavenExecutionException("Feature with name '" + featureName + "' not found in provisioning model for attachment.", (File)null);
                }
                RunMode runMode = f.getOrCreateRunMode(null);
                ArtifactGroup group = runMode.getOrCreateArtifactGroup(startLevel);
                Artifact artifact = new Artifact(info.project.getGroupId(), info.project.getArtifactId(), info.project.getVersion(), classifier, type);
                env.logger.debug("Attaching " + artifact + " to feature " + f.getName());
                group.add(artifact);
            }
        }
    }

    private boolean nodeBooleanValue(Plugin plugin, String name, boolean defaultValue) {
        String booleanValue = ModelPreprocessor.nodeValue(plugin, name, Boolean.toString(defaultValue));
        return "true".equals(booleanValue.toLowerCase());
    }

    private File resolveSlingstartArtifact(Environment env, MavenProject project, Dependency d) throws MavenExecutionException {
        DefaultArtifact prjArtifact = new DefaultArtifact(d.getGroupId(), d.getArtifactId(), VersionRange.createFromVersion((String)d.getVersion()), "provided", d.getType(), d.getClassifier(), env.artifactHandlerManager.getArtifactHandler(d.getType()));
        try {
            env.resolver.resolve((org.apache.maven.artifact.Artifact)prjArtifact, project.getRemoteArtifactRepositories(), env.session.getLocalRepository());
        }
        catch (ArtifactResolutionException e) {
            throw new MavenExecutionException("Unable to get artifact for " + d, (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new MavenExecutionException("Unable to get artifact for " + d, (Throwable)e);
        }
        return prjArtifact.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Model readLocalModel(MavenProject project, String inlinedModel, File modelDirectory, String pattern, Logger logger) throws MavenExecutionException, IOException {
        Pattern p = Pattern.compile(pattern);
        ArrayList<String> candidates = new ArrayList<String>();
        if (modelDirectory != null && modelDirectory.exists()) {
            for (File f : modelDirectory.listFiles()) {
                if (!f.isFile() || f.getName().startsWith(".") || !p.matcher(f.getName()).matches()) continue;
                candidates.add(f.getName());
            }
            Collections.sort(candidates);
        }
        if (candidates.size() == 0 && (inlinedModel == null || inlinedModel.trim().length() == 0)) {
            throw new MavenExecutionException("No model files found in " + modelDirectory + ", and no model inlined in POM.", (File)null);
        }
        Model result = new Model();
        if (inlinedModel != null) {
            logger.debug("Reading inlined model from project " + project.getId());
            try {
                StringReader reader = new StringReader(inlinedModel);
                try {
                    Model current = ModelReader.read((Reader)reader, (String)"pom");
                    Map errors = ModelUtility.validate((Model)current);
                    if (errors != null) {
                        throw new MavenExecutionException("Invalid inlined model : " + errors, (File)null);
                    }
                    MergeUtility.merge((Model)result, (Model)current, (MergeUtility.MergeOptions)new MergeUtility.MergeOptions().setHandleRemoveRunMode(false));
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            catch (IOException io) {
                throw new MavenExecutionException("Unable to read inlined model", (Throwable)io);
            }
        }
        for (String name : candidates) {
            logger.debug("Reading model " + name + " in project " + project.getId());
            try {
                File f;
                f = new File(modelDirectory, name);
                FileReader reader = new FileReader(f);
                try {
                    Model current = ModelReader.read((Reader)reader, (String)f.getAbsolutePath());
                    Map errors = ModelUtility.validate((Model)current);
                    if (errors != null) {
                        throw new MavenExecutionException("Invalid model at " + name + " : " + errors, (File)null);
                    }
                    MergeUtility.merge((Model)result, (Model)current, (MergeUtility.MergeOptions)new MergeUtility.MergeOptions().setHandleRemoveRunMode(false));
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            catch (IOException io) {
                throw new MavenExecutionException("Unable to read model at " + name, (Throwable)io);
            }
        }
        Map errors = ModelUtility.validate((Model)result);
        if (errors != null) {
            throw new MavenExecutionException("Invalid assembled model : " + errors, (File)null);
        }
        return this.postProcessReadModel(result);
    }

    protected Model postProcessReadModel(Model result) throws MavenExecutionException {
        return result;
    }

    protected void mergeModels(Model base, Model additional) throws MavenExecutionException {
        MergeUtility.merge((Model)base, (Model)additional);
    }

    private String cleanupVersion(String version) {
        StringBuilder result = new StringBuilder();
        Matcher m = FUZZY_VERSION.matcher(version);
        if (m.matches()) {
            String major = m.group(1);
            String minor = m.group(3);
            String micro = m.group(5);
            String qualifier = m.group(7);
            if (major != null) {
                result.append(major);
                if (minor != null) {
                    result.append(".");
                    result.append(minor);
                    if (micro != null) {
                        result.append(".");
                        result.append(micro);
                        if (qualifier != null) {
                            result.append(".");
                            ModelPreprocessor.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        ModelPreprocessor.cleanupModifier(result, qualifier);
                    } else {
                        result.append(".0");
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    ModelPreprocessor.cleanupModifier(result, qualifier);
                } else {
                    result.append(".0.0");
                }
            }
        } else {
            result.append("0.0.0.");
            ModelPreprocessor.cleanupModifier(result, version);
        }
        return result.toString();
    }

    private static void cleanupModifier(StringBuilder result, String modifier) {
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                result.append(c);
                continue;
            }
            result.append('_');
        }
    }

    public static final class Environment {
        public ArtifactHandlerManager artifactHandlerManager;
        public ArtifactResolver resolver;
        public MavenSession session;
        public Logger logger;
        public final Map<String, ProjectInfo> modelProjects = new HashMap<String, ProjectInfo>();
    }

    public static final class ProjectInfo {
        public MavenProject project;
        public Plugin plugin;
        public Model localModel;
        public boolean done = false;
        public Model model;
        public boolean extendMavenClassPath = true;
        public final Map<Artifact, Model> includedModels = new HashMap<Artifact, Model>();
    }
}

