/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.util.List;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.maven.slingstart.AbstractSlingStartMojo;
import org.apache.sling.maven.slingstart.FeatureModelConverter;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

@Mojo(name="generate-resources", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class GenerateResourcesMojo
extends AbstractSlingStartMojo {
    @Parameter(defaultValue="src/main/features")
    private String featuresDirectory;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    protected MojoExecution mojoExecution;

    public void execute() throws MojoExecutionException {
        List<File> featureFiles = FeatureModelConverter.getFeatureFiles(this.project.getBasedir(), this.featuresDirectory);
        if (featureFiles == null) {
            return;
        }
        try {
            FeatureModelConverter.convert(featureFiles, this.project, id -> FeatureModelConverter.getFeature(id, this.mavenSession, this.project, this.artifactHandlerManager, this.resolver));
        }
        catch (MavenExecutionException e) {
            throw new MojoExecutionException("Cannot convert feature files to provisioning model.", (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Problem obtaining artifact manager.", (Exception)e);
        }
    }
}

