/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import aQute.bnd.version.MavenVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.modelconverter.FeatureToProvisioning;
import org.apache.sling.maven.slingstart.ModelPreprocessor;
import org.apache.sling.maven.slingstart.ModelUtils;

public class FeatureModelConverter {
    static final String BUILD_DIR = "provisioning/converted";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Feature getFeature(ArtifactId id, MavenSession session, MavenProject project, ArtifactHandlerManager manager, ArtifactResolver resolver) {
        try {
            File file = ModelUtils.getArtifact(project, session, manager, resolver, id.getGroupId(), id.getArtifactId(), id.getVersion(), id.getType(), id.getClassifier()).getFile();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
                Feature feature = FeatureJSONReader.read((Reader)reader, (String)file.toURI().toURL().toString());
                return feature;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void convert(MavenSession session, ModelPreprocessor.Environment env) throws MavenExecutionException {
        Map<String, ModelPreprocessor.ProjectInfo> projs = env.modelProjects;
        for (ModelPreprocessor.ProjectInfo pi : projs.values()) {
            FeatureModelConverter.convert(session, pi.project, env.artifactHandlerManager, env.resolver);
        }
    }

    private static void convert(MavenSession session, MavenProject project, ArtifactHandlerManager manager, ArtifactResolver resolver) throws MavenExecutionException {
        File featuresDir = new File(project.getBasedir(), "src/main/features");
        File[] files = featuresDir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        try {
            FeatureModelConverter.convert(files, project, id -> FeatureModelConverter.getFeature(id, session, project, manager, resolver));
        }
        catch (RuntimeException ex) {
            throw new MavenExecutionException(ex.getMessage(), (Throwable)ex);
        }
    }

    static void convert(File[] files, MavenProject project, FeatureProvider fp) throws MavenExecutionException {
        File processedFeaturesDir = new File(project.getBuild().getDirectory(), "features/processed");
        processedFeaturesDir.mkdirs();
        ArrayList<File> substedFiles = new ArrayList<File>();
        for (File f : files) {
            if (!f.getName().endsWith(".json")) continue;
            try {
                substedFiles.add(FeatureModelConverter.substituteVars(project, f, processedFeaturesDir));
            }
            catch (IOException e) {
                throw new MavenExecutionException("Problem processing feature file " + f.getAbsolutePath(), (Throwable)e);
            }
        }
        File targetDir = new File(project.getBuild().getDirectory(), BUILD_DIR);
        targetDir.mkdirs();
        try {
            for (File f : substedFiles) {
                if (!f.getName().endsWith(".json")) continue;
                File genFile = new File(targetDir, f.getName() + ".txt");
                FeatureToProvisioning.convert((File)f, (File)genFile, (FeatureProvider)fp, (File[])substedFiles.toArray(new File[0]));
            }
        }
        catch (Exception e) {
            throw new MavenExecutionException("Cannot convert feature files to provisioning model", (Throwable)e);
        }
    }

    private static File substituteVars(MavenProject project, File f, File processedFeaturesDir) throws IOException {
        File file = new File(processedFeaturesDir, f.getName());
        if (file.exists() && file.lastModified() > f.lastModified()) {
            return file;
        }
        try (FileWriter fw = new FileWriter(file);){
            for (String s : Files.readAllLines(f.toPath())) {
                fw.write(FeatureModelConverter.replaceVars(project, s));
                fw.write(System.getProperty("line.separator"));
            }
        }
        return file;
    }

    static String replaceVars(MavenProject project, String s) {
        s = FeatureModelConverter.replaceAll(s, "project.groupId", project.getGroupId());
        s = FeatureModelConverter.replaceAll(s, "project.artifactId", project.getArtifactId());
        s = FeatureModelConverter.replaceAll(s, "project.version", project.getVersion());
        s = FeatureModelConverter.replaceAll(s, "project.osgiVersion", FeatureModelConverter.getOSGiVersion(project.getVersion()));
        s = FeatureModelConverter.replaceProperties(System.getProperties(), s);
        s = FeatureModelConverter.replaceProperties(project.getProperties(), s);
        return s;
    }

    private static String replaceProperties(Properties props, String s) {
        if (props != null) {
            for (String key : props.stringPropertyNames()) {
                s = FeatureModelConverter.replaceAll(s, key, props.getProperty(key));
            }
        }
        return s;
    }

    private static String replaceAll(String s, String key, String value) {
        return s.replaceAll("\\Q${" + key + "}\\E", value);
    }

    private static String cleanVersionString(String version) {
        StringBuilder sb = new StringBuilder();
        boolean afterDot = false;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c == '.') {
                if (afterDot) {
                    sb.append('0');
                }
                afterDot = true;
                sb.append(c);
                continue;
            }
            if (afterDot && c == '0') continue;
            if (afterDot && c == '-') {
                sb.append('0');
                sb.append(c);
                afterDot = false;
                continue;
            }
            afterDot = false;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getOSGiVersion(String version) {
        DefaultArtifactVersion dav = new DefaultArtifactVersion(FeatureModelConverter.cleanVersionString(version));
        StringBuilder sb = new StringBuilder();
        sb.append(dav.getMajorVersion());
        sb.append('.');
        sb.append(dav.getMinorVersion());
        sb.append('.');
        sb.append(dav.getIncrementalVersion());
        if (dav.getQualifier() != null) {
            sb.append('.');
            sb.append(dav.getQualifier());
        }
        MavenVersion mavenVersion = new MavenVersion(sb.toString());
        return mavenVersion.getOSGiVersion().toString();
    }
}

