/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.io.ArtifactManager;
import org.apache.sling.feature.io.ArtifactManagerConfig;
import org.apache.sling.feature.modelconverter.FeatureToProvisioning;
import org.apache.sling.maven.slingstart.AbstractSlingStartMojo;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

@Mojo(name="generate-resources", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class GenerateResourcesMojo
extends AbstractSlingStartMojo {
    @Parameter(defaultValue="${basedir}/src/main/features")
    private File featuresDirectory;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    protected MojoExecution mojoExecution;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] featureFiles = this.featuresDirectory.listFiles();
        if (featureFiles == null) {
            return;
        }
        File targetDir = new File(this.project.getBuild().getDirectory(), "provisioning/converted");
        targetDir.mkdirs();
        try {
            ArtifactManager am = this.getArtifactManager();
            List<File> files = Arrays.asList(featureFiles);
            for (File f : files) {
                if (!f.getName().endsWith(".json")) continue;
                File genFile = new File(targetDir, f.getName() + ".txt");
                FeatureToProvisioning.convert((File)f, (File)genFile, (ArtifactManager)am);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot convert feature files to provisioning model", e);
        }
    }

    private ArtifactManager getArtifactManager() throws IOException {
        ArrayList<String> repos = new ArrayList<String>();
        repos.add(this.mavenSession.getLocalRepository().getUrl());
        for (ArtifactRepository ar : this.project.getRemoteArtifactRepositories()) {
            repos.add(ar.getUrl());
        }
        ArtifactManagerConfig amConfig = new ArtifactManagerConfig();
        amConfig.setRepositoryUrls(repos.toArray(new String[0]));
        return ArtifactManager.getArtifactManager((ArtifactManagerConfig)amConfig);
    }
}

