/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.sling.feature.io.ArtifactManager;
import org.apache.sling.feature.io.ArtifactManagerConfig;
import org.apache.sling.feature.modelconverter.FeatureToProvisioning;
import org.apache.sling.maven.slingstart.ModelPreprocessor;

public class FeatureModelConverter {
    static final String BUILD_DIR = "provisioning/converted";

    public void convert(MavenSession session, ModelPreprocessor.Environment env) throws MavenExecutionException {
        Map<String, ModelPreprocessor.ProjectInfo> projs = env.modelProjects;
        for (ModelPreprocessor.ProjectInfo pi : projs.values()) {
            this.convert(session, pi.project);
        }
    }

    private void convert(MavenSession session, MavenProject project) throws MavenExecutionException {
        File featuresDir = new File(project.getBasedir(), "src/main/features");
        File[] files = featuresDir.listFiles();
        List<Object> featureFiles = files != null ? Arrays.asList(files) : Collections.emptyList();
        if (featureFiles.size() == 0) {
            return;
        }
        File targetDir = new File(project.getBuild().getDirectory(), BUILD_DIR);
        targetDir.mkdirs();
        try {
            ArtifactManager am = this.getArtifactManager(project, session);
            for (File f : files) {
                if (!f.getName().endsWith(".json")) continue;
                File genFile = new File(targetDir, f.getName() + ".txt");
                FeatureToProvisioning.convert((File)f, (File)genFile, (ArtifactManager)am);
            }
        }
        catch (Exception e) {
            throw new MavenExecutionException("Cannot convert feature files to provisioning model", (Throwable)e);
        }
    }

    private ArtifactManager getArtifactManager(MavenProject project, MavenSession session) throws IOException {
        ArrayList<String> repos = new ArrayList<String>();
        repos.add(session.getLocalRepository().getUrl());
        for (ArtifactRepository ar : project.getRemoteArtifactRepositories()) {
            repos.add(ar.getUrl());
        }
        ArtifactManagerConfig amConfig = new ArtifactManagerConfig();
        amConfig.setRepositoryUrls(repos.toArray(new String[0]));
        return ArtifactManager.getArtifactManager((ArtifactManagerConfig)amConfig);
    }
}

