/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.extensions;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.sling.feature.maven.Environment;
import org.apache.sling.feature.maven.FeatureProjectInfo;
import org.apache.sling.feature.maven.Preprocessor;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystem;

@Named(value="featureparticipant")
@Singleton
public class DependencyLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String PLUGIN_ID = "org.apache.sling:slingfeature-maven-plugin";
    private final Logger logger;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final RepositorySystem repoSystem;

    @Inject
    public DependencyLifecycleParticipant(Logger logger, ArtifactHandlerManager artifactHandlerManager, RepositorySystem repoSystem) {
        this.logger = logger;
        this.artifactHandlerManager = artifactHandlerManager;
        this.repoSystem = repoSystem;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Environment env = new Environment();
        env.artifactHandlerManager = this.artifactHandlerManager;
        env.repoSystem = this.repoSystem;
        env.logger = this.logger;
        env.session = session;
        this.logger.debug("Searching for project using plugin 'org.apache.sling:slingfeature-maven-plugin'...");
        for (MavenProject project : session.getProjects()) {
            Plugin plugin = project.getPlugin(PLUGIN_ID);
            if (plugin == null) continue;
            this.logger.debug("Found project " + project.getId() + " using " + PLUGIN_ID);
            FeatureProjectInfo info = new FeatureProjectInfo();
            info.plugin = plugin;
            info.project = project;
            env.modelProjects.put(project.getGroupId() + ":" + project.getArtifactId(), info);
        }
        new Preprocessor().process(env);
    }
}

