/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.reports;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.maven.mojos.reports.ReportContext;
import org.apache.sling.feature.maven.mojos.reports.Reporter;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.FeatureDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;

public class ImportPackagesReporter
implements Reporter {
    @Override
    public String getName() {
        return "imported-packages";
    }

    @Override
    public void generateReport(ReportContext ctx) throws MojoExecutionException {
        for (Feature feature : ctx.getFeatures()) {
            FeatureDescriptor fd;
            try {
                fd = ctx.getScanner().scan(feature);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to scan feature " + e.getMessage(), (Exception)e);
            }
            List<String> importedPackages = this.getImportedPackages(fd);
            if (importedPackages.isEmpty()) continue;
            ctx.addReport(fd.getFeature().getId().changeType("imports.txt").toMvnName(), importedPackages);
        }
    }

    private List<String> getImportedPackages(FeatureDescriptor fd) {
        ArrayList<String> packages = new ArrayList<String>();
        for (BundleDescriptor bd : fd.getBundleDescriptors()) {
            for (PackageInfo p : bd.getImportedPackages()) {
                String version = p.getVersion();
                if (version == null) {
                    version = "any";
                }
                if (p.isOptional()) {
                    version = version.concat(";optional");
                }
                packages.add(p.getName().concat("    ").concat(version).concat("    ").concat(bd.getArtifact().getId().toMvnId()));
            }
        }
        Collections.sort(packages);
        return packages;
    }
}

