/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationApi;
import org.apache.sling.feature.extension.apiregions.api.config.validation.FeatureValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.FeatureValidator;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractFeatureMojo;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;

@Mojo(name="apply-default-config", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class ApplyDefaultConfigMojo
extends AbstractIncludingFeatureMojo {
    @Parameter(name="selection", required=true)
    FeatureSelectionConfig selection;
    @Parameter(defaultValue="true")
    boolean failOnValidationError;
    @Parameter
    Dependency configurationApiDependency;
    @Parameter
    String configurationApiClassifier;

    private ConfigurationApi getDefaultConfigurationApi() throws MojoExecutionException {
        if (this.configurationApiClassifier != null && this.configurationApiDependency != null) {
            throw new MojoExecutionException("Only one of configurationApiDependency or configurationApiClassifier can be specified, but not both.");
        }
        ConfigurationApi defaultApi = null;
        if (this.configurationApiClassifier != null) {
            Map<String, Feature> projectFeatures = ProjectHelper.getAssembledFeatures(this.project);
            for (Feature f : projectFeatures.values()) {
                if (!this.configurationApiClassifier.equals(f.getId().getClassifier())) continue;
                defaultApi = ConfigurationApi.getConfigurationApi((Feature)f);
                if (defaultApi != null) break;
                throw new MojoExecutionException("Specified feature with classifier " + this.configurationApiClassifier + " does not contain configuration api");
            }
            if (defaultApi == null) {
                throw new MojoExecutionException("Specified feature with classifier + " + this.configurationApiClassifier + " does not exist in project.");
            }
        } else if (this.configurationApiDependency != null) {
            ArtifactId depId = ProjectHelper.toArtifactId(this.configurationApiDependency);
            if (ProjectHelper.isLocalProjectArtifact(this.project, depId)) {
                throw new MojoExecutionException("configurationApiDependency configuration is used to select a local feature: " + depId.toMvnId());
            }
            Feature f = ProjectHelper.getOrResolveFeature(this.project, this.mavenSession, this.artifactHandlerManager, this.artifactResolver, depId);
            defaultApi = ConfigurationApi.getConfigurationApi((Feature)f);
            if (defaultApi == null) {
                throw new MojoExecutionException("Specified feature " + depId.toMvnId() + " does not contain configuration api");
            }
        }
        if (defaultApi != null) {
            this.getLog().info((CharSequence)("Using configured configuration-api from " + (this.configurationApiClassifier != null ? "classifier " + this.configurationApiClassifier : " dependency " + ProjectHelper.toString(this.configurationApiDependency))));
        }
        return defaultApi;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkPreconditions();
        this.getLog().info((CharSequence)("Feature Selection: " + this.selection));
        ConfigurationApi defaultApi = this.getDefaultConfigurationApi();
        Map<String, Feature> selFeat = this.getSelectedFeatures(this.selection);
        for (Map.Entry<String, Feature> entry : selFeat.entrySet()) {
            Feature f = entry.getValue();
            ConfigurationApi api = defaultApi != null ? defaultApi : ConfigurationApi.getConfigurationApi((Feature)f);
            if (api == null) continue;
            FeatureValidator validator = new FeatureValidator();
            validator.setFeatureProvider((FeatureProvider)new AbstractFeatureMojo.BaseFeatureProvider());
            FeatureValidationResult result = validator.validate(f, api);
            if (!result.isValid() && this.failOnValidationError) {
                throw new MojoExecutionException("Unable to apply default configuration to invalid feature ".concat(f.getId().toMvnId()));
            }
            if (!validator.applyDefaultValues(f, result)) continue;
            this.getLog().info((CharSequence)"Applied default configurations to feature ".concat(f.getId().toMvnId()));
            ProjectHelper.createTmpFeatureFile(this.project, f, true);
        }
    }
}

