/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.maven.FeatureProjectInfo;
import org.apache.sling.feature.maven.JSONFeatures;
import org.apache.sling.feature.maven.Preprocessor;
import org.apache.sling.feature.maven.Substitution;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class ProjectHelper {
    private static final String RAW_FEATURE_JSON = Feature.class.getName() + "/rawmain.json";
    private static final String RAW_TEST_FEATURE_JSON = Feature.class.getName() + "/rawtest.json";
    private static final String ASSEMBLED_FEATURE_JSON = Feature.class.getName() + "/assembledmain.json";
    private static final String ASSEMBLED_TEST_FEATURE_JSON = Feature.class.getName() + "/assembledtest.json";
    private static final String METADATA_KEY = Feature.class.getName() + "/metadata";
    private static final String ARTIFACT_CACHE = Artifact.class.getName() + "/cache";
    private static final String AGGREGATE_PREFIX = ":aggregate:";
    private static final String NULL_KEY = ":";

    private static void store(MavenProject project, String key, Map<String, Feature> features) {
        if (features != null && !features.isEmpty()) {
            project.setContextValue(key, (Object)features.size());
            int index = 0;
            for (Map.Entry<String, Feature> entry : features.entrySet()) {
                try (StringWriter w1 = new StringWriter();){
                    FeatureJSONWriter.write((Writer)w1, (Feature)entry.getValue());
                    project.setContextValue(key + "_" + String.valueOf(index), (Object)w1.toString());
                    project.setContextValue(key + "_" + String.valueOf(index) + "f", (Object)entry.getKey());
                    ++index;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe.getMessage(), ioe);
                }
            }
        }
    }

    private static Map<String, Feature> getFeatures(MavenProject project, String key) {
        String cacheKey = key + "-cache";
        TreeMap<String, Feature> result = null;
        try {
            result = (TreeMap<String, Feature>)project.getContextValue(cacheKey);
            if (result != null && !result.isEmpty()) {
                Feature f = (Feature)result.values().iterator().next();
                f.getId();
            }
        }
        catch (Exception e) {
            result = null;
        }
        if (result == null) {
            result = new TreeMap<String, Feature>();
            Integer size = (Integer)project.getContextValue(key);
            if (size != null) {
                for (int i = 0; i < size; ++i) {
                    String text = (String)project.getContextValue(key + "_" + String.valueOf(i));
                    if (text == null) {
                        throw new RuntimeException("Unable to get feature from internal store.");
                    }
                    String file = (String)project.getContextValue(key + "_" + String.valueOf(i) + "f");
                    if (file == null) {
                        throw new RuntimeException("Unable to get feature from internal store.");
                    }
                    try (StringReader r = new StringReader(text);){
                        Feature feature = FeatureJSONReader.read((Reader)r, (String)project.getId());
                        result.put(file, feature);
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe.getMessage(), ioe);
                    }
                }
            }
            project.setContextValue(cacheKey, result);
        }
        return result;
    }

    public static void storeProjectInfo(FeatureProjectInfo info) {
        ProjectHelper.store(info.project, RAW_FEATURE_JSON, info.features);
        ProjectHelper.store(info.project, RAW_TEST_FEATURE_JSON, info.testFeatures);
        ProjectHelper.store(info.project, ASSEMBLED_FEATURE_JSON, info.assembledFeatures);
        ProjectHelper.store(info.project, ASSEMBLED_TEST_FEATURE_JSON, info.assembledTestFeatures);
        info.project.setContextValue(Preprocessor.class.getName(), (Object)Boolean.TRUE);
    }

    public static String checkPreprocessorRun(MavenProject project) {
        if (project.getContextValue(Preprocessor.class.getName()) == null) {
            return "The slingfeature preprocessor did not run. Please make sure to set <extensions>true</extensions> for the slingfeature plugin in your pom.";
        }
        return null;
    }

    public static Map<String, Feature> getAssembledFeatures(MavenProject project) {
        return ProjectHelper.getFeatures(project, ASSEMBLED_FEATURE_JSON);
    }

    public static Map<String, Feature> getFeatures(MavenProject project) {
        return ProjectHelper.getFeatures(project, RAW_FEATURE_JSON);
    }

    public static Map<String, Feature> getAssembledTestFeatures(MavenProject project) {
        return ProjectHelper.getFeatures(project, ASSEMBLED_TEST_FEATURE_JSON);
    }

    public static Map<String, Feature> getTestFeatures(MavenProject project) {
        return ProjectHelper.getFeatures(project, RAW_TEST_FEATURE_JSON);
    }

    public static String getConfigValue(Plugin plugin, String name, String defaultValue) {
        Xpp3Dom globalNode;
        HashSet<String> values = new HashSet<String>();
        Xpp3Dom config = plugin == null ? null : (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom xpp3Dom = globalNode = config == null ? null : config.getChild(name);
        if (globalNode != null) {
            values.add(globalNode.getValue());
        }
        for (PluginExecution exec : plugin.getExecutions()) {
            Xpp3Dom cfg = (Xpp3Dom)exec.getConfiguration();
            Xpp3Dom pluginNode = cfg == null ? null : cfg.getChild(name);
            if (pluginNode == null || pluginNode.getValue() == null || pluginNode.getValue().isEmpty()) continue;
            values.add(pluginNode.getValue());
        }
        if (values.size() > 1) {
            throw new RuntimeException("More than one value configured in plugin (executions) of " + plugin.getKey() + " for " + name + " : " + values);
        }
        return values.isEmpty() ? defaultValue : (String)values.iterator().next();
    }

    public static Xpp3Dom getConfig(Plugin plugin, String name) {
        Xpp3Dom globalNode;
        HashSet<Xpp3Dom> values = new HashSet<Xpp3Dom>();
        Xpp3Dom config = plugin == null ? null : (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom xpp3Dom = globalNode = config == null ? null : config.getChild(name);
        if (globalNode != null && globalNode.getChildCount() > 0) {
            values.add(globalNode);
        }
        for (PluginExecution exec : plugin.getExecutions()) {
            Xpp3Dom cfg = (Xpp3Dom)exec.getConfiguration();
            Xpp3Dom pluginNode = cfg == null ? null : cfg.getChild(name);
            if (pluginNode == null || pluginNode.getChildCount() <= 0) continue;
            values.add(pluginNode);
        }
        if (values.size() > 1) {
            throw new RuntimeException("More than one value configured in plugin (executions) of " + plugin.getKey() + " for " + name + " : " + values);
        }
        return values.isEmpty() ? null : (Xpp3Dom)values.iterator().next();
    }

    private static Artifact findArtifact(ArtifactId id, Collection<Artifact> artifacts) {
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getGroupId().equals(id.getGroupId()) || !artifact.getArtifactId().equals(id.getArtifactId()) || !artifact.getVersion().equals(id.getVersion()) || !artifact.getType().equals(id.getType()) || (id.getClassifier() != null || artifact.getClassifier() != null) && (id.getClassifier() == null || !id.getClassifier().equals(artifact.getClassifier()))) continue;
                return artifact.getFile() == null ? null : artifact;
            }
        }
        return null;
    }

    public static File getTmpDir(MavenProject project) {
        File dir = new File(project.getBuild().getDirectory(), "slingfeature-tmp");
        dir.mkdirs();
        return dir;
    }

    public static File createTmpFeatureFile(MavenProject project, Feature feature) {
        return ProjectHelper.createTmpFeatureFile(project, feature, false);
    }

    public static File createTmpFeatureFile(MavenProject project, Feature feature, boolean overwrite) {
        String classifier = feature.getId().getClassifier();
        File outputFile = new File(ProjectHelper.getTmpDir(project), classifier == null ? "feature.json" : "feature-" + classifier + ".json");
        if (overwrite || !outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(outputFile);){
                FeatureJSONWriter.write((Writer)writer, (Feature)feature);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write feature " + feature.getId().toMvnId() + " to " + outputFile, e);
            }
        }
        return outputFile;
    }

    public static Artifact getOrResolveArtifact(MavenProject project, MavenSession session, ArtifactHandlerManager artifactHandlerManager, ArtifactResolver resolver, ArtifactId id) {
        Artifact result;
        ConcurrentHashMap<String, Artifact> cache = (ConcurrentHashMap<String, Artifact>)project.getContextValue(ARTIFACT_CACHE);
        if (cache == null) {
            cache = new ConcurrentHashMap<String, Artifact>();
            project.setContextValue(ARTIFACT_CACHE, cache);
        }
        if ((result = (Artifact)cache.get(id.toMvnId())) == null) {
            result = ProjectHelper.findArtifact(id, project.getAttachedArtifacts());
            if (result == null && (result = ProjectHelper.findArtifact(id, project.getDependencyArtifacts())) == null) {
                if (ProjectHelper.isLocalProjectArtifact(project, id)) {
                    for (Map.Entry<String, Feature> entry : ProjectHelper.getFeatures(project).entrySet()) {
                        if (!entry.getValue().getId().equals((Object)id)) continue;
                        DefaultArtifact artifact = new DefaultArtifact(id.getGroupId(), id.getArtifactId(), id.getVersion(), "provided", id.getType(), id.getClassifier(), null);
                        artifact.setFile(ProjectHelper.createTmpFeatureFile(project, entry.getValue()));
                        result = artifact;
                        break;
                    }
                }
                if (result == null) {
                    DefaultArtifact prjArtifact = new DefaultArtifact(id.getGroupId(), id.getArtifactId(), VersionRange.createFromVersion((String)id.getVersion()), "provided", id.getType(), id.getClassifier(), artifactHandlerManager.getArtifactHandler(id.getType()));
                    try {
                        resolver.resolve((Artifact)prjArtifact, project.getRemoteArtifactRepositories(), session.getLocalRepository());
                    }
                    catch (ArtifactNotFoundException | ArtifactResolutionException e) {
                        throw new RuntimeException("Unable to get artifact for " + id.toMvnId(), e);
                    }
                    result = prjArtifact;
                }
            }
            cache.put(id.toMvnId(), result);
        }
        return result;
    }

    public static Feature getOrResolveFeature(MavenProject project, MavenSession session, ArtifactHandlerManager artifactHandlerManager, ArtifactResolver resolver, ArtifactId id) {
        Feature feature;
        File artFile = ProjectHelper.getOrResolveArtifact(project, session, artifactHandlerManager, resolver, id).getFile();
        FileReader reader = new FileReader(artFile);
        try {
            feature = FeatureJSONReader.read((Reader)reader, (String)artFile.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to read feature file " + artFile + " for " + id.toMvnId(), ioe);
            }
        }
        ((Reader)reader).close();
        return feature;
    }

    public static String toString(Dependency d) {
        if (d == null) {
            return "null";
        }
        return "Dependency {groupId=" + d.getGroupId() + ", artifactId=" + d.getArtifactId() + ", version=" + d.getVersion() + (d.getClassifier() != null ? ", classifier=" + d.getClassifier() : "") + ", type=" + d.getType() + "}";
    }

    public static Dependency toDependency(ArtifactId id, String scope) {
        Dependency dep = new Dependency();
        dep.setGroupId(id.getGroupId());
        dep.setArtifactId(id.getArtifactId());
        dep.setVersion(id.getVersion());
        dep.setType(id.getType());
        dep.setClassifier(id.getClassifier());
        dep.setScope(scope);
        return dep;
    }

    public static ArtifactId toArtifactId(Dependency dep) {
        if (dep == null) {
            return null;
        }
        return new ArtifactId(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getClassifier(), dep.getType());
    }

    public static void setFeatureInfo(MavenProject project, Feature feature) {
        if (feature.getTitle() == null) {
            feature.setTitle(project.getName());
        }
        if (feature.getDescription() == null) {
            feature.setDescription(project.getDescription());
        }
        if (feature.getVendor() == null && project.getOrganization() != null) {
            feature.setVendor(project.getOrganization().getName());
        }
        if (feature.getLicense() == null && project.getLicenses() != null && !project.getLicenses().isEmpty()) {
            String license = project.getLicenses().stream().filter(l -> l.getName() != null).map(l -> l.getName()).collect(Collectors.joining(", "));
            feature.setLicense(license);
        }
    }

    private static String toString(List<String> featureKeys) {
        StringBuilder sb = new StringBuilder();
        if (featureKeys.size() > 1) {
            sb.append('[');
        }
        boolean first = true;
        for (String key : featureKeys) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (key.startsWith(AGGREGATE_PREFIX)) {
                key = key.substring(0, key.length() - 2);
                sb.append("aggregate ");
                if (key.length() == AGGREGATE_PREFIX.length()) {
                    sb.append("main artifact (no classifier)");
                    continue;
                }
                sb.append(key.substring(AGGREGATE_PREFIX.length()));
                continue;
            }
            sb.append(key);
        }
        if (featureKeys.size() > 1) {
            sb.append(']');
        }
        return sb.toString();
    }

    public static boolean isAggregate(String featureKey) {
        return featureKey.startsWith(AGGREGATE_PREFIX);
    }

    public static boolean isAttachAggregate(String featureKey) {
        return ProjectHelper.isAggregate(featureKey) && featureKey.endsWith(":T");
    }

    public static String generateAggregateFeatureKey(String classifier, boolean attach) {
        return (classifier != null ? AGGREGATE_PREFIX.concat(classifier) : AGGREGATE_PREFIX).concat(NULL_KEY).concat(attach ? "T" : "F");
    }

    private static void addClassifier(Map<String, List<String>> classifiers, String classifier, String featureKey) {
        String key = classifier == null ? NULL_KEY : classifier;
        List<String> list = classifiers.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            classifiers.put(key, list);
        }
        list.add(featureKey);
    }

    public static void validateFeatureClassifiers(MavenProject project) {
        ProjectHelper.validateFeatureClassifiers(project, false, null, false);
    }

    public static void validateFeatureClassifiers(MavenProject project, String additionalClassifier, boolean attachFeature) {
        ProjectHelper.validateFeatureClassifiers(project, true, additionalClassifier, attachFeature);
    }

    private static void validateFeatureClassifiers(MavenProject project, boolean classifierProvided, String additionalClassifier, boolean attachFeature) {
        HashMap<String, List<String>> classifiers = new HashMap<String, List<String>>();
        for (Map.Entry<String, Feature> entry : ProjectHelper.getFeatures(project).entrySet()) {
            ProjectHelper.addClassifier(classifiers, entry.getValue().getId().getClassifier(), entry.getKey());
        }
        for (Map.Entry<String, Feature> entry : ProjectHelper.getTestFeatures(project).entrySet()) {
            if (entry.getValue().getId().getClassifier() == null) {
                throw new RuntimeException("Found test feature without classifier in project " + project.getId() + " : " + entry.getKey());
            }
            ProjectHelper.addClassifier(classifiers, entry.getValue().getId().getClassifier(), entry.getKey());
        }
        if (classifierProvided) {
            String key = ProjectHelper.generateAggregateFeatureKey(additionalClassifier, attachFeature);
            ProjectHelper.addClassifier(classifiers, additionalClassifier, key);
        }
        for (Map.Entry<String, Object> entry : classifiers.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            if (entry.getKey().equals(NULL_KEY)) {
                throw new RuntimeException("More than one feature file without classifier in project " + project.getId() + " : " + ProjectHelper.toString((List)entry.getValue()));
            }
            throw new RuntimeException("More than one feature file for classifier " + entry.getKey() + " in project " + project.getId() + " : " + ProjectHelper.toString((List)entry.getValue()));
        }
    }

    public static boolean isLocalProjectArtifact(MavenProject project, ArtifactId id) {
        return id.getGroupId().equals(project.getGroupId()) && id.getArtifactId().equals(project.getArtifactId()) && id.getVersion().equals(project.getVersion());
    }

    public static Map<String, String> propertiesToMap(Properties value) {
        Properties m = value;
        return m;
    }

    public static void scan(List<File> files, File dir, String includes, String excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir);
        if (includes != null) {
            scanner.setIncludes(includes.split(","));
        }
        if (excludes != null) {
            scanner.setExcludes(excludes.split(","));
        }
        scanner.scan();
        for (String f : scanner.getIncludedFiles()) {
            files.add(new File(dir, f));
        }
    }

    public static String readFeatureFile(MavenProject project, File file, String suggestedClassifier, boolean legacyReplace, boolean enableProjectVars, String[] additionalVars) {
        String string;
        ArtifactId fileId = new ArtifactId(project.getGroupId(), project.getArtifactId(), project.getVersion(), suggestedClassifier, "slingosgifeature");
        FileReader reader = new FileReader(file);
        try {
            string = Substitution.replaceMavenVars(project, legacyReplace, enableProjectVars, additionalVars, JSONFeatures.read(reader, fileId, file.getAbsolutePath()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read feature file " + file.getAbsolutePath(), e);
            }
        }
        ((Reader)reader).close();
        return string;
    }

    public static void checkFeatureId(MavenProject project, Feature feature) {
        if (!project.getGroupId().equals(feature.getId().getGroupId())) {
            throw new RuntimeException("Wrong group id for feature. It should be " + project.getGroupId() + " but is " + feature.getId().getGroupId());
        }
        if (!project.getArtifactId().equals(feature.getId().getArtifactId())) {
            throw new RuntimeException("Wrong artifact id for feature. It should be " + project.getArtifactId() + " but is " + feature.getId().getArtifactId());
        }
        if (!project.getVersion().equals(feature.getId().getVersion())) {
            throw new RuntimeException("Wrong version for feature. It should be " + project.getVersion() + " but is " + feature.getId().getVersion());
        }
    }

    public static void setDefaultMetadata(MavenProject project, Map<String, Map<String, String>> data) {
        project.setContextValue(METADATA_KEY, data);
    }

    public static final Map<String, Map<String, String>> getDefaultMetadata(MavenProject project) {
        Map<String, Map<String, String>> map = (Map<String, Map<String, String>>)project.getContextValue(METADATA_KEY);
        if (map == null) {
            map = Collections.emptyMap();
        }
        return map;
    }
}

