/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.commons.io.FileUtils;
import org.apache.felix.cm.json.Configurations;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Artifacts;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONWriter;

public class JSONFeatures {
    public static final ArtifactId PLACEHOLDER_ID = new ArtifactId("_", "_", "1.0", null, null);
    private static final String FILE_PREFIX = "@file";
    private static final String FEATURE_BUNDLES = "bundles";

    public static String read(Reader reader, ArtifactId optionalId, String location) throws IOException {
        JsonObject featureObj;
        try (JsonReader jsonReader = Json.createReader((Reader)Configurations.jsonCommentAwareReader((Reader)reader));){
            featureObj = jsonReader.readObject();
            if (!featureObj.containsKey((Object)"id")) {
                JsonObjectBuilder job = Json.createObjectBuilder();
                job.add("id", optionalId.toMvnId());
                for (Map.Entry prop : featureObj.entrySet()) {
                    job.add((String)prop.getKey(), (JsonValue)prop.getValue());
                }
                featureObj = job.build();
            }
        }
        catch (JsonException je) {
            throw new IOException(location.concat(" : ").concat(je.getMessage()), je);
        }
        try (StringWriter writer = new StringWriter();){
            try (JsonWriter jsonWriter = Json.createWriter((Writer)writer);){
                jsonWriter.writeObject(featureObj);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static void write(Writer writer, Feature feature) throws IOException {
        block21: {
            if (feature.getId().equals((Object)PLACEHOLDER_ID)) {
                try (StringWriter stringWriter = new StringWriter();){
                    FeatureJSONWriter.write((Writer)stringWriter, (Feature)feature);
                    try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(stringWriter.toString()));){
                        JsonObject featureObj = jsonReader.readObject();
                        JsonGeneratorFactory factory = Json.createGeneratorFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
                        try (JsonGenerator generator = factory.createGenerator(writer);){
                            generator.writeStartObject();
                            for (Map.Entry entry : featureObj.entrySet()) {
                                if ("id".equals(entry.getKey())) continue;
                                generator.write((String)entry.getKey(), (JsonValue)entry.getValue());
                            }
                            generator.writeEnd();
                            break block21;
                        }
                    }
                    catch (JsonException je) {
                        throw new IOException(je.getMessage(), je);
                    }
                }
            }
            FeatureJSONWriter.write((Writer)writer, (Feature)feature);
        }
    }

    public static void handleExtensions(Feature feature, File file) throws IOException {
        for (Extension ext : feature.getExtensions()) {
            String fileName;
            String baseName;
            if (ext.getType() != ExtensionType.TEXT || !ext.getText().startsWith(FILE_PREFIX)) continue;
            int pos = file.getName().lastIndexOf(".");
            String string = baseName = pos == -1 ? file.getName() : file.getName().substring(0, pos);
            if (FILE_PREFIX.equals(ext.getText())) {
                fileName = baseName.concat("-").concat(ext.getName()).concat(".txt");
            } else {
                if (!ext.getText().substring(FILE_PREFIX.length()).startsWith(":")) {
                    throw new IOException("Invalid file reference: " + ext.getText());
                }
                fileName = baseName.concat("-").concat(ext.getText().substring(FILE_PREFIX.length() + 1));
            }
            File txtFile = new File(file.getParentFile(), fileName);
            if (!txtFile.exists() || !txtFile.isFile()) {
                throw new IOException("Extension text file " + txtFile.getAbsolutePath() + " not found.");
            }
            String contents = FileUtils.readFileToString((File)txtFile, (Charset)StandardCharsets.UTF_8);
            ext.setText(contents);
        }
    }

    public static void handleDefaultMetadata(Feature feature, Map<String, Map<String, String>> defaultMetadata) {
        for (Map.Entry<String, Map<String, String>> entry : defaultMetadata.entrySet()) {
            Bundles artifacts;
            String extensionName = entry.getKey();
            if (FEATURE_BUNDLES.equals(extensionName)) {
                artifacts = feature.getBundles();
            } else {
                Extension ext = feature.getExtensions().getByName(extensionName);
                Artifacts artifacts2 = artifacts = ext == null || ext.getType() != ExtensionType.ARTIFACTS ? null : ext.getArtifacts();
            }
            if (artifacts == null) continue;
            for (Map.Entry<String, String> propEntry : entry.getValue().entrySet()) {
                for (Artifact artifact : artifacts) {
                    if (artifact.getMetadata().containsKey(propEntry.getKey())) continue;
                    artifact.getMetadata().put(propEntry.getKey(), propEntry.getValue());
                }
            }
        }
    }
}

