/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationApi;
import org.apache.sling.feature.extension.apiregions.api.config.validation.FeatureValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.FeatureValidator;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractFeatureMojo;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;

@Mojo(name="apply-default-config", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class ApplyDefaultConfigMojo
extends AbstractIncludingFeatureMojo {
    @Parameter(name="selection", required=true)
    FeatureSelectionConfig selection;
    @Parameter(defaultValue="true")
    boolean failOnValidationError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkPreconditions();
        this.getLog().info((CharSequence)("Feature Selection: " + this.selection));
        Map<String, Feature> selFeat = this.getSelectedFeatures(this.selection);
        for (Map.Entry<String, Feature> entry : selFeat.entrySet()) {
            Feature f = entry.getValue();
            ConfigurationApi api = ConfigurationApi.getConfigurationApi((Feature)f);
            if (api == null) continue;
            FeatureValidator validator = new FeatureValidator();
            validator.setFeatureProvider((FeatureProvider)new AbstractFeatureMojo.BaseFeatureProvider());
            FeatureValidationResult result = validator.validate(f, api);
            if (!result.isValid() && this.failOnValidationError) {
                throw new MojoExecutionException("Unable to apply default configuration to invalid feature ".concat(f.getId().toMvnId()));
            }
            if (!validator.applyDefaultValues(f, result)) continue;
            this.getLog().info((CharSequence)"Applied default configurations to feature ".concat(f.getId().toMvnId()));
            ProjectHelper.createTmpFeatureFile(this.project, f, true);
        }
    }
}

