/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.utils.manifest.Clause;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.ExecutionEnvironmentExtension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.extension.apiregions.api.ApiExport;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.maven.mojos.AbstractFeatureMojo;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;
import org.apache.sling.feature.maven.mojos.apis.ApisJarContext;
import org.apache.sling.feature.maven.mojos.apis.ApisUtil;
import org.apache.sling.feature.maven.mojos.apis.ArtifactType;
import org.apache.sling.feature.maven.mojos.apis.DirectorySource;
import org.apache.sling.feature.maven.mojos.apis.FileSource;
import org.apache.sling.feature.maven.mojos.apis.JavadocExecutor;
import org.apache.sling.feature.maven.mojos.apis.JavadocLinks;
import org.apache.sling.feature.maven.mojos.apis.RegionSupport;
import org.apache.sling.feature.maven.mojos.apis.spi.Processor;
import org.apache.sling.feature.maven.mojos.apis.spi.ProcessorContext;
import org.apache.sling.feature.maven.mojos.apis.spi.Source;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

@Mojo(name="apis-jar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ApisJarMojo
extends AbstractIncludingFeatureMojo {
    @Parameter
    private FeatureSelectionConfig selection;
    @Parameter
    private String[] includeResources;
    @Parameter(defaultValue="*")
    private Set<String> includeRegions;
    @Parameter
    private Set<String> excludeRegions;
    @Parameter
    private String[] javadocLinks;
    @Parameter(defaultValue="false")
    private boolean ignoreJavadocErrors;
    @Parameter(defaultValue="true")
    private boolean incrementalApis;
    @Parameter(defaultValue="false")
    private boolean toggleApiOnly;
    @Parameter
    private List<File> apiResources;
    @Parameter
    private List<File> apiSourceResources;
    @Parameter
    private List<File> apiJavadocResources;
    @Parameter(defaultValue="true")
    private boolean attachApiJars;
    @Parameter
    private Map<String, String> apiRegionNameMappings;
    @Parameter
    private Map<String, String> apiClassifierMappings;
    @Parameter(defaultValue="true")
    private boolean generateApiJar;
    @Parameter(defaultValue="true")
    private boolean generateSourceJar;
    @Parameter(defaultValue="true")
    private boolean generateJavadocJar;
    @Parameter(defaultValue="8")
    private String javadocSourceLevel;
    @Parameter
    private String apiVersion;
    @Parameter(defaultValue="META-INF,SLING-INF")
    private String resourceFolders;
    @Parameter
    private String licenseReport;
    @Parameter
    private List<String> licenseDefaults;
    @Parameter(defaultValue="This archive contains files from the following artifacts:")
    private String licenseReportHeader;
    @Parameter
    private String licenseReportFooter;
    @Parameter(defaultValue="false")
    private boolean useApiDependencies;
    @Parameter
    private String apiRepositoryUrls;
    @Parameter(defaultValue="false")
    private boolean failOnError;
    @Parameter
    private final Properties manifestProperties = new Properties();
    @Parameter(defaultValue="false")
    private boolean failOnMissingSourcesForJavadoc;
    @Parameter(defaultValue="true")
    private boolean javadocIndex;
    @Parameter(defaultValue="true")
    private boolean javadocTree;
    @Parameter
    private List<String> javadocClasspathRemovals;
    @Parameter
    private List<String> javadocClasspathHighestVersions;
    @Parameter
    private List<String> javadocClasspathTops;
    @Parameter(property="enabled.toggles")
    private String enabledToggles;
    @Parameter
    private List<String> javadocAdditionalExtensions;
    @Parameter(defaultValue="${project.build.directory}/apis-jars", readonly=true)
    private File mainOutputDir;
    @Component(hint="default")
    private ModelBuilder modelBuilder;
    @Component
    private ScmManager scmManager;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private RepositorySystem repositorySystem;
    private final Pattern pomPropertiesPattern = Pattern.compile("META-INF/maven/[^/]+/[^/]+/pom.properties");
    private final ArtifactProvider artifactProvider = new AbstractFeatureMojo.BaseArtifactProvider();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkPreconditions();
        this.getLog().debug((CharSequence)"Retrieving feature files...");
        Collection<Feature> features = this.getSelectedFeatures(this.selection).values();
        if (features.isEmpty()) {
            this.getLog().info((CharSequence)"There are no associated feature files in the current project, plugin execution will be skipped");
        } else {
            this.getLog().debug((CharSequence)"Starting APIs JARs creation...");
            for (Feature feature : features) {
                this.onFeature(feature);
            }
        }
    }

    private void onFeature(Feature feature) throws MojoExecutionException {
        this.getLog().info((CharSequence)MessageUtils.buffer().a((CharSequence)"Creating API JARs for Feature ").strong((Object)feature.getId().toMvnId()).a((CharSequence)" ...").toString());
        RegionSupport regionSupport = new RegionSupport(this.getLog(), this.incrementalApis, this.toggleApiOnly, this.includeRegions, this.excludeRegions);
        ApiRegions regions = regionSupport.getApiRegions(feature);
        if (regions == null) {
            return;
        }
        File featureDir = new File(this.mainOutputDir, feature.getId().getArtifactId());
        ApisJarContext ctx = new ApisJarContext(this.mainOutputDir, feature);
        ctx.getConfig().setLicenseDefaults(this.licenseDefaults);
        ctx.getConfig().setLicenseReport(this.licenseReport);
        ctx.getConfig().setLicenseReportHeader(this.licenseReportHeader);
        ctx.getConfig().setLicenseReportFooter(this.licenseReportFooter);
        ctx.getConfig().setJavadocLinks(this.javadocLinks);
        ctx.getConfig().setJavadocClasspathRemovals(this.javadocClasspathRemovals);
        ctx.getConfig().setJavadocClasspathHighestVersions(this.javadocClasspathHighestVersions);
        ctx.getConfig().setJavadocClasspathTops(this.javadocClasspathTops);
        ctx.getConfig().setApiVersion(this.apiVersion);
        ctx.getConfig().setJavadocSourceLevel(this.javadocSourceLevel);
        ctx.getConfig().setBundleResourceFolders(this.resourceFolders);
        ctx.getConfig().setBundleResources(this.includeResources);
        ctx.getConfig().setClassifierMappings(this.apiClassifierMappings);
        ctx.getConfig().setRegionMappings(this.apiRegionNameMappings);
        ctx.getConfig().setManifestEntries(this.manifestProperties);
        ctx.getConfig().logConfiguration(this.getLog());
        ctx.getConfig().setEnabledToggles(this.enabledToggles);
        ctx.getConfig().setAdditionalJavadocExtensions(this.javadocAdditionalExtensions);
        ctx.setDependencyRepositories(this.apiRepositoryUrls);
        if (this.generateJavadocJar) {
            for (ApiRegion apiRegion : regions.listRegions()) {
                String regionName = apiRegion.getName();
                List<Artifact> artifacts = ApisUtil.getAdditionalJavadocArtifacts(ctx, regionName);
                for (Artifact artifact : artifacts) {
                    if (ctx.getFeature().getBundles().getExact(artifact.getId()) == null) continue;
                    throw new MojoExecutionException("Additional javadoc artifact is also listed as a bundle " + artifact.getId().toMvnId());
                }
            }
        }
        for (Artifact artifact : feature.getBundles()) {
            this.onArtifact(regions, ctx, regionSupport, artifact);
        }
        if (this.generateSourceJar || this.generateJavadocJar) {
            this.getLog().info((CharSequence)"--------------------------------------------------------");
            this.getLog().info((CharSequence)"Used sources:");
            for (ApisJarContext.ArtifactInfo info : ctx.getArtifactInfos()) {
                if (info.getSources().isEmpty()) {
                    this.getLog().info((CharSequence)"- ".concat(info.getId().toMvnId()).concat(" : NO SOURCES FOUND"));
                    continue;
                }
                this.getLog().info((CharSequence)"- ".concat(info.getId().toMvnId()).concat(" : ").concat(info.getSources().toString()));
            }
            this.getLog().info((CharSequence)"--------------------------------------------------------");
        }
        boolean hasErrors = false;
        for (ApiRegion apiRegion : regions.listRegions()) {
            Collection<ApisJarContext.ArtifactInfo> infos;
            String regionName = apiRegion.getName();
            ArrayList<String> report = new ArrayList<String>();
            File regionDir = new File(featureDir, regionName);
            if (this.generateApiJar) {
                infos = ctx.getArtifactInfos(regionName, this.useApiDependencies);
                this.runProcessor(ctx, apiRegion, ArtifactType.APIS, this.apiResources, infos);
                File apiJar = this.createArchive(ctx, apiRegion, ArtifactType.APIS, this.apiResources, infos, report);
                this.report(ctx, apiJar, ArtifactType.APIS, apiRegion, this.useApiDependencies, report, null);
            }
            if (this.generateSourceJar) {
                infos = ctx.getArtifactInfos(regionName, this.useApiDependencies);
                this.runProcessor(ctx, apiRegion, ArtifactType.SOURCES, this.apiResources, infos);
                File sourceJar = this.createArchive(ctx, apiRegion, ArtifactType.SOURCES, this.apiSourceResources, infos, report);
                this.report(ctx, sourceJar, ArtifactType.SOURCES, apiRegion, this.useApiDependencies, report, null);
            } else if (this.generateJavadocJar) {
                infos = ctx.getArtifactInfos(regionName, false);
                this.runProcessor(ctx, apiRegion, ArtifactType.SOURCES, this.apiResources, infos);
            }
            if (this.useApiDependencies && (this.generateApiJar || this.generateSourceJar)) {
                this.createDependenciesFile(ctx, apiRegion);
            }
            if (this.generateJavadocJar) {
                File javadocsDir = new File(regionDir, ArtifactType.JAVADOC.getId());
                ExecutionEnvironmentExtension ext = ExecutionEnvironmentExtension.getExecutionEnvironmentExtension((Feature)feature);
                JavadocLinks links = new JavadocLinks();
                links.calculateLinks(ctx.getConfig().getJavadocLinks(), ctx.getArtifactInfos(regionName, false), ext != null ? ext.getFramework() : null);
                Collection<ApisJarContext.ArtifactInfo> infos2 = this.generateJavadoc(ctx, regionName, links, javadocsDir, regionSupport);
                if (infos2 != null) {
                    ctx.setJavadocDir(javadocsDir);
                    File javadocJar = this.createArchive(ctx, apiRegion, ArtifactType.JAVADOC, this.apiJavadocResources, infos2, report);
                    this.report(ctx, javadocJar, ArtifactType.JAVADOC, apiRegion, false, report, links);
                } else {
                    this.getLog().warn((CharSequence)("Javadoc JAR will NOT be generated - sources directory " + ctx.getDeflatedSourcesDir() + " was empty or contained no Java files!"));
                }
            }
            ArtifactId reportId = this.buildArtifactId(ctx, apiRegion, ArtifactType.REPORT);
            File reportFile = new File(this.mainOutputDir, reportId.toMvnName());
            if (!report.isEmpty()) {
                report.stream().forEach(v -> this.getLog().info((CharSequence)v));
                try {
                    Files.write(reportFile.toPath(), report, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to write " + reportFile, (Exception)e);
                }
                hasErrors = true;
                continue;
            }
            if (!reportFile.exists()) continue;
            reportFile.delete();
        }
        if (hasErrors && this.failOnError) {
            throw new MojoExecutionException("API generation has errors, please see report files for more information");
        }
        this.getLog().info((CharSequence)MessageUtils.buffer().a((CharSequence)"APIs JARs for Feature ").project((Object)feature.getId().toMvnId()).a((CharSequence)" succesfully created").toString());
    }

    private void report(ApisJarContext ctx, File jarFile, ArtifactType artifactType, ApiRegion apiRegion, boolean omitDependencyArtifacts, List<String> report, JavadocLinks links) throws MojoExecutionException {
        Map.Entry<Set<String>, Set<String>> packageResult = ApisUtil.getPackages(ctx, jarFile, artifactType.getContentExtension());
        Set<String> apiPackages = packageResult.getKey();
        Set<String> otherPackages = packageResult.getValue();
        if (omitDependencyArtifacts) {
            for (ApisJarContext.ArtifactInfo artifactInfo : ctx.getArtifactInfos(apiRegion.getName(), false)) {
                if (!artifactInfo.isUseAsDependencyPerRegion(apiRegion.getName())) continue;
                for (Clause c : artifactInfo.getUsedExportedPackages(apiRegion.getName())) {
                    apiPackages.add(c.getName());
                }
            }
        }
        otherPackages.addAll(ctx.getPackagesWithoutJavaClasses());
        if (artifactType == ArtifactType.JAVADOC && !this.failOnMissingSourcesForJavadoc) {
            otherPackages.addAll(ctx.getPackagesWithoutSources());
        }
        if (links != null) {
            apiPackages.addAll(links.getLinkedPackages());
        }
        ArrayList<ApiExport> missing = new ArrayList<ApiExport>();
        for (ApiExport exp : apiRegion.listExports()) {
            String packageName = exp.getName();
            if (apiPackages.remove(packageName) || otherPackages.remove(packageName)) continue;
            missing.add(exp);
        }
        if (links != null) {
            apiPackages.removeAll(links.getLinkedPackages());
        }
        if (artifactType == ArtifactType.JAVADOC) {
            otherPackages.removeAll(ctx.getPackagesWithoutSources());
            for (Artifact artifact : ApisUtil.getAdditionalJavadocArtifacts(ctx, apiRegion.getName())) {
                ApisJarContext.ArtifactInfo info = ctx.getArtifactInfo(artifact.getId());
                if (info == null) continue;
                for (Clause clause : info.getUsedExportedPackages(apiRegion.getName())) {
                    if (apiPackages.remove(clause.getName())) continue;
                    ApiExport export = new ApiExport(clause.getName());
                    missing.add(export);
                }
            }
        }
        otherPackages.removeAll(ctx.getPackagesWithoutJavaClasses());
        apiPackages.addAll(otherPackages);
        if (artifactType == ArtifactType.JAVADOC) {
            List<String> list = Arrays.asList("jquery", "jquery.external.jquery", "jquery.images", "jquery.jszip-utils.dist", "jquery.jszip.dist", "resources");
            apiPackages.removeAll(list);
        }
        if (missing.isEmpty() && apiPackages.isEmpty()) {
            this.getLog().info((CharSequence)("Verified " + artifactType.getId() + " jar for region " + apiRegion.getName()));
        } else {
            Collections.sort(missing);
            report.add(artifactType.getId().concat(" jar for region ").concat(apiRegion.getName()).concat(" has ").concat(String.valueOf(missing.size() + apiPackages.size())).concat(" errors:"));
            for (ApiExport exp : missing) {
                ArrayList<String> candidates = new ArrayList<String>();
                block6: for (ApisJarContext.ArtifactInfo info : ctx.getArtifactInfos()) {
                    for (Clause clause : info.getUsedExportedPackages(apiRegion.getName())) {
                        if (!exp.getName().equals(clause.getName())) continue;
                        candidates.add(info.getId().toMvnName());
                        continue block6;
                    }
                }
                report.add("- Missing package ".concat(exp.getName()).concat(" from bundle(s) ").concat(String.join((CharSequence)",", candidates)));
            }
            for (String m : apiPackages) {
                report.add("- Unwanted package ".concat(m));
            }
        }
    }

    private File getArtifactFile(ArtifactId artifactId) throws MojoExecutionException {
        URL artifactURL = this.retrieve(artifactId);
        if (artifactURL == null) {
            throw new MojoExecutionException("Unable to find artifact " + artifactId.toMvnId());
        }
        File bundleFile = null;
        try {
            bundleFile = IOUtils.getFileFromURL((URL)artifactURL, (boolean)true, (File)this.getTmpDir());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        return bundleFile;
    }

    private boolean calculateOmitDependenciesFlag(ApiRegion region, Clause[] exportedPackageClauses, Set<Clause> usedExportedPackagesPerRegion) {
        boolean fullUsage = true;
        for (Clause c : exportedPackageClauses) {
            boolean found = false;
            for (Clause current : usedExportedPackagesPerRegion) {
                if (!current.getName().equals(c.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                fullUsage = false;
                break;
            }
            ApiExport exp = region.getAllExportByName(c.getName());
            if (exp == null || exp.getDeprecation() == null) continue;
            fullUsage = false;
            break;
        }
        return fullUsage;
    }

    private void onArtifact(ApiRegions apiRegions, ApisJarContext ctx, RegionSupport regionSupport, Artifact artifact) throws MojoExecutionException {
        Set<String> usedExportedPackages;
        File bundleFile = this.getArtifactFile(artifact.getId());
        Manifest manifest = regionSupport.getManifest(artifact.getId(), bundleFile);
        Clause[] exportedPackageClauses = regionSupport.getExportedPackages(manifest);
        if (exportedPackageClauses.length > 0 && !(usedExportedPackages = regionSupport.computeAllUsedExportPackages(apiRegions, ctx.getConfig().getEnabledToggles(), exportedPackageClauses, artifact)).isEmpty()) {
            String bundleClassPath;
            boolean skipSourceDeflate;
            ArtifactId previous = null;
            block0: for (String string : usedExportedPackages) {
                for (ApiRegion region : apiRegions.listRegions()) {
                    ApiExport exp = region.getExportByName(string);
                    if (exp == null) continue;
                    if (exp.getToggle() == null || ctx.getConfig().getEnabledToggles().contains(exp.getToggle()) || exp.getPrevious() == null) continue block0;
                    if (previous != null && previous.compareTo(exp.getPrevious()) != 0) {
                        throw new MojoExecutionException("More than one previous version artifact configured for " + artifact.getId().toMvnId() + " : " + previous.toMvnId() + ", " + exp.getPrevious().toMvnId());
                    }
                    previous = exp.getPrevious();
                    continue block0;
                }
            }
            if (previous != null) {
                Artifact previousArtifact = new Artifact(previous);
                previousArtifact.getMetadata().putAll(artifact.getMetadata());
                this.getLog().debug((CharSequence)("Using " + previous.toMvnId() + " instead of " + artifact.getId().toMvnId() + " due to disabled toggle(s)"));
                artifact = previousArtifact;
            }
            ApisJarContext.ArtifactInfo info = ctx.addArtifactInfo(artifact);
            info.setUsedExportedPackages(usedExportedPackages);
            for (ApiRegion region : apiRegions.listRegions()) {
                boolean useAsDependency;
                Set<Clause> usedExportedPackagesPerRegion = regionSupport.computeUsedExportPackagesPerRegion(region, exportedPackageClauses, usedExportedPackages);
                boolean bl = useAsDependency = this.useApiDependencies ? this.calculateOmitDependenciesFlag(region, exportedPackageClauses, usedExportedPackagesPerRegion) : false;
                if (useAsDependency && (useAsDependency = ctx.findDependencyArtifact(this.getLog(), info)) && artifact.getMetadata().get("scm-location") != null) {
                    throw new MojoExecutionException("Dependency artifact must not specify scm-location : " + artifact.getId().toMvnId());
                }
                info.setUsedExportedPackages(region.getName(), usedExportedPackagesPerRegion, useAsDependency);
            }
            info.setBinDirectory(new File(ctx.getDeflatedBinDir(), info.getId().toMvnName()));
            info.setSourceDirectory(new File(ctx.getDeflatedSourcesDir(), info.getId().toMvnName()));
            boolean bl = info.getBinDirectory().exists();
            if (bl) {
                this.getLog().debug((CharSequence)("Artifact " + info.getId().toMvnName() + " already deflated"));
            }
            if (skipSourceDeflate = info.getSourceDirectory().exists()) {
                this.getLog().debug((CharSequence)("Source for artifact " + info.getId().toMvnName() + " already deflated"));
            }
            String[] embeddedBundles = (bundleClassPath = manifest.getMainAttributes().getValue("Bundle-ClassPath")) != null && !bundleClassPath.isEmpty() ? bundleClassPath.split(",") : null;
            this.processBinary(ctx, info, bundleFile, artifact, embeddedBundles, bl, skipSourceDeflate);
            if (embeddedBundles != null) {
                this.computeWrappedBundles(ctx, info, embeddedBundles, bl, skipSourceDeflate);
            }
            this.postProcessArtifact(ctx, info, artifact);
            if (!info.getSourceDirectory().exists()) {
                info.setSourceDirectory(null);
            }
            if (this.generateJavadocJar) {
                ApisUtil.buildJavadocClasspath(this.getLog(), this.repositorySystem, this.mavenSession, artifact.getId()).forEach(ctx::addJavadocClasspath);
            }
        }
    }

    private void postProcessArtifact(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, Artifact artifact) throws MojoExecutionException {
        this.postProcessBinDirectory(ctx, info, info.getBinDirectory(), "");
        if (this.generateSourceJar || this.generateJavadocJar) {
            HashSet<String> foundPackages = new HashSet<String>();
            if (info.getSourceDirectory() != null && info.getSourceDirectory().exists()) {
                String encoding = artifact.getMetadata().getOrDefault("scm-encoding", "UTF-8");
                this.postProcessSourcesDirectory(ctx, info, foundPackages, info.getSourceDirectory(), "UTF-8".equals(encoding) ? null : encoding, "");
            }
            for (String pck : info.getUsedExportedPackages()) {
                if (foundPackages.contains(pck)) continue;
                this.getLog().debug((CharSequence)("No sources found in " + pck));
                ctx.getPackagesWithoutSources().add(pck);
            }
        }
    }

    private void postProcessBinDirectory(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, File dir, String pck) {
        boolean hasJavaFile = false;
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                this.postProcessBinDirectory(ctx, info, child, pck.isEmpty() ? child.getName() : pck.concat(".").concat(child.getName()));
                continue;
            }
            if (!child.getName().endsWith(ArtifactType.APIS.getContentExtension())) continue;
            hasJavaFile = true;
        }
        if (dir.listFiles().length == 0 && !pck.isEmpty()) {
            dir.delete();
        } else if (!hasJavaFile && info.getUsedExportedPackages().contains(pck)) {
            this.getLog().debug((CharSequence)("No classes found in " + pck));
            ctx.getPackagesWithoutJavaClasses().add(pck);
        }
    }

    private void processBinary(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, File binFile, Artifact binArtifact, String[] embeddedBundles, boolean skipBinDeflate, boolean skipSourceDeflate) throws MojoExecutionException {
        if (!skipBinDeflate) {
            ArrayList<String> deflateIncludes = new ArrayList<String>();
            deflateIncludes.addAll(Arrays.asList(info.getUsedExportedPackageIncludes()));
            if (embeddedBundles != null) {
                for (String jarName : embeddedBundles) {
                    if (".".equals(jarName)) continue;
                    deflateIncludes.add(jarName);
                }
            }
            deflateIncludes.addAll(this.getIncludeResourcePatterns(ctx, info.getId()));
            this.deflate(info.getBinDirectory(), binFile, deflateIncludes.toArray(new String[deflateIncludes.size()]));
        }
        this.renameResources(ctx, info, binArtifact.getId());
        if (this.generateSourceJar || this.generateJavadocJar) {
            if (!skipSourceDeflate) {
                this.downloadSources(ctx, info, binArtifact);
            } else {
                info.addSourceInfo("USE CACHE FROM PREVIOUS BUILD");
            }
        }
    }

    private List<String> getIncludeResourcePatterns(ApisJarContext ctx, ArtifactId id) {
        String licenseDefault;
        ArrayList<String> pattern = new ArrayList<String>();
        for (String folder : ctx.getConfig().getBundleResourceFolders()) {
            for (String inc : ctx.getConfig().getBundleResources()) {
                pattern.add(folder.concat("/").concat(inc));
            }
        }
        if (!(ctx.getConfig().getLicenseReport() == null || (licenseDefault = ctx.getConfig().getLicenseDefault(id)) != null && licenseDefault.isEmpty())) {
            pattern.add("META-INF/NOTICE");
            pattern.add("META-INF/LICENSE");
        }
        return pattern;
    }

    private void postProcessSourcesDirectory(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, Set<String> foundPackages, File dir, String readEncoding, String pck) throws MojoExecutionException {
        boolean hasSourceFile = false;
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                this.postProcessSourcesDirectory(ctx, info, foundPackages, child, readEncoding, pck.isEmpty() ? child.getName() : pck.concat(".").concat(child.getName()));
                continue;
            }
            if (!child.getName().endsWith(ArtifactType.SOURCES.getContentExtension())) continue;
            hasSourceFile = true;
            if (readEncoding == null) continue;
            try {
                String javaSource = FileUtils.fileRead((File)child, (String)readEncoding);
                FileUtils.fileWrite((File)child, (String)StandardCharsets.UTF_8.name(), (String)javaSource);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to clean up java source " + child, (Exception)ioe);
            }
        }
        if (dir.listFiles().length == 0 && !pck.isEmpty()) {
            dir.delete();
        } else if (hasSourceFile) {
            foundPackages.add(pck);
        }
    }

    private void computeWrappedBundles(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, String[] embeddedBundles, boolean skipBinDeflate, boolean skipSourceDeflate) throws MojoExecutionException {
        for (String jarName : embeddedBundles) {
            if (".".equals(jarName)) continue;
            File wrappedJar = new File(info.getBinDirectory(), jarName);
            this.getLog().debug((CharSequence)("Processing wrapped bundle " + wrappedJar));
            Properties properties = new Properties();
            try (JarInputStream jis = new JarInputStream(new FileInputStream(wrappedJar));){
                JarEntry jarEntry = null;
                while ((jarEntry = jis.getNextJarEntry()) != null) {
                    if (!jarEntry.isDirectory() && this.pomPropertiesPattern.matcher(jarEntry.getName()).matches()) {
                        this.getLog().debug((CharSequence)("Loading Maven GAV from " + wrappedJar + '!' + jarEntry.getName()));
                        properties.load(jis);
                        break;
                    }
                    jis.closeEntry();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while processing wrapped bundle " + wrappedJar, (Exception)e);
            }
            if (properties.isEmpty()) {
                this.getLog().warn((CharSequence)("No Maven GAV info attached to wrapped bundle " + wrappedJar + ", it will be ignored"));
                continue;
            }
            this.getLog().debug((CharSequence)("Handling synthetic artifacts from Maven GAV: " + properties));
            String groupId = properties.getProperty("groupId");
            String artifactId = properties.getProperty("artifactId");
            String version = properties.getProperty("version");
            String classifier = properties.getProperty("classifier");
            if (classifier == null) {
                classifier = this.inferClassifier(jarName, artifactId, version);
            }
            Artifact syntheticArtifact = new Artifact(new ArtifactId(groupId, artifactId, version, classifier, null));
            File bundleFile = this.getArtifactFile(syntheticArtifact.getId());
            this.processBinary(ctx, info, bundleFile, syntheticArtifact, null, skipBinDeflate, skipSourceDeflate);
        }
    }

    String inferClassifier(String bundleName, String artifactId, String version) {
        String suffix;
        String synthesized;
        int edx;
        if (bundleName == null || artifactId == null || version == null) {
            return null;
        }
        int idx = bundleName.lastIndexOf(47);
        if (idx >= 0) {
            bundleName = bundleName.substring(idx + 1);
        }
        if ((edx = bundleName.lastIndexOf(46)) > 0) {
            bundleName = bundleName.substring(0, edx);
        }
        if ((synthesized = artifactId + "-" + version).length() < bundleName.length() && bundleName.startsWith(synthesized) && (suffix = bundleName.substring(synthesized.length())).length() > 1 && suffix.startsWith("-")) {
            String classifier = suffix.substring(1);
            this.getLog().debug((CharSequence)("Inferred classifier of '" + artifactId + ":" + version + "' to be '" + classifier + "'"));
            return classifier;
        }
        return null;
    }

    private URL retrieve(ArtifactId artifactId) {
        this.getLog().debug((CharSequence)("Retrieving artifact " + artifactId + "..."));
        URL sourceFile = this.artifactProvider.provide(artifactId);
        if (sourceFile != null) {
            this.getLog().debug((CharSequence)("Artifact " + artifactId + " successfully retrieved : " + sourceFile));
        }
        return sourceFile;
    }

    private void deflate(File destDirectory, File artifact, String ... includes) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Deflating artifact " + artifact.getName() + "..."));
        destDirectory.mkdirs();
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(artifact);
            unArchiver.setSourceFile(artifact);
            unArchiver.setDestDirectory(destDirectory);
            IncludeExcludeFileSelector selector = new IncludeExcludeFileSelector();
            selector.setIncludes(includes);
            unArchiver.setFileSelectors(new FileSelector[]{selector});
            unArchiver.setOverwrite(false);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("An error occurred while deflating file " + artifact + " to directory " + destDirectory, (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)("Artifact " + artifact + " successfully deflated"));
    }

    private void renameResources(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, ArtifactId artifactId) throws MojoExecutionException {
        List<String> patterns = this.getIncludeResourcePatterns(ctx, info.getId());
        if (patterns.isEmpty()) {
            this.getLog().debug((CharSequence)("No configured resources to rename in " + info.getBinDirectory()));
        }
        this.getLog().debug((CharSequence)("Renaming " + patterns + " files in " + info.getBinDirectory() + "..."));
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(info.getBinDirectory());
        directoryScanner.setIncludes(patterns.toArray(new String[patterns.size()]));
        directoryScanner.scan();
        if (directoryScanner.getIncludedFiles().length == 0) {
            this.getLog().debug((CharSequence)("No " + patterns + " resources in " + info.getBinDirectory() + " to be renamed found."));
            return;
        }
        for (String resourceName : directoryScanner.getIncludedFiles()) {
            File resource = new File(info.getBinDirectory(), resourceName);
            String includedName = resourceName.replace(File.separatorChar, '/');
            if (!info.getIncludedResources().contains(resource)) {
                String prefix = artifactId.toMvnName().concat("-");
                if (resource.getName().startsWith(prefix)) {
                    this.getLog().debug((CharSequence)("No need to rename " + resource));
                    info.getIncludedResources().add(resource);
                } else {
                    File renamed = new File(resource.getParentFile(), prefix.concat(resource.getName()));
                    this.getLog().debug((CharSequence)("Renaming resource " + resource + " to " + renamed + "..."));
                    if (!resource.renameTo(renamed)) {
                        throw new MojoExecutionException("Impossible to rename resource " + resource + " to " + renamed + ", please check the current user has enough rights on the File System");
                    }
                    this.getLog().debug((CharSequence)("Resource renamed to " + renamed));
                    info.getIncludedResources().add(renamed);
                    int lastSlash = includedName.lastIndexOf(47);
                    includedName = lastSlash == -1 ? renamed.getName() : includedName.substring(0, lastSlash + 1).concat(renamed.getName());
                }
            }
            if (!includedName.endsWith(ArtifactType.CND.getContentExtension())) continue;
            info.getNodeTypes().add(includedName);
        }
        this.getLog().debug((CharSequence)(patterns + " resources in " + info.getBinDirectory() + " successfully renamed"));
    }

    private boolean downloadSourceAndDeflate(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, ArtifactId sourcesArtifactId, boolean allowFallback) throws MojoExecutionException {
        boolean failed = false;
        try {
            URL url = this.retrieve(sourcesArtifactId);
            if (url != null) {
                File sourcesBundle = IOUtils.getFileFromURL((URL)url, (boolean)true, null);
                this.deflate(info.getSourceDirectory(), sourcesBundle, info.getUsedExportedPackageIncludes());
            } else {
                if (!allowFallback) {
                    throw new MojoExecutionException("Unable to download sources for " + info.getId().toMvnId() + " due to missing artifact " + sourcesArtifactId.toMvnId());
                }
                this.getLog().warn((CharSequence)("Unable to download sources for " + info.getId().toMvnId() + " due to missing artifact " + sourcesArtifactId.toMvnId() + ", trying source checkout next..."));
                failed = true;
            }
        }
        catch (MojoExecutionException mee) {
            throw mee;
        }
        catch (Throwable t) {
            if (!allowFallback) {
                throw new MojoExecutionException("Unable to download sources for " + info.getId().toMvnId() + " due to missing artifact " + sourcesArtifactId.toMvnId());
            }
            this.getLog().warn((CharSequence)("Unable to download sources for " + info.getId().toMvnId() + " from " + sourcesArtifactId.toMvnId() + " due to " + t.getMessage() + ", trying source checkout next..."));
            failed = true;
        }
        return failed;
    }

    private void downloadSources(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, Artifact artifact) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Downloading sources for " + artifact.getId().toMvnId() + "..."));
        ApisUtil.validateSourceInfo(artifact);
        List<ArtifactId> scmIds = ApisUtil.getSourceIds(artifact);
        String scmLocation = (String)artifact.getMetadata().get("scm-location");
        if (scmIds != null) {
            for (ArtifactId sourcesArtifactId : scmIds) {
                this.downloadSourceAndDeflate(ctx, info, sourcesArtifactId, false);
                info.addSourceInfo(sourcesArtifactId);
            }
        } else if (scmLocation != null) {
            String connection = this.checkoutSourcesFromSCM(ctx, info, artifact);
            info.addSourceInfo(connection);
        } else {
            ArtifactId sourcesArtifactId;
            String sourceClassifier = (String)artifact.getMetadata().get("source-classifier");
            if (sourceClassifier == null) {
                sourceClassifier = "sources";
            }
            if (this.downloadSourceAndDeflate(ctx, info, sourcesArtifactId = artifact.getId().changeClassifier(sourceClassifier).changeType("jar"), artifact.getMetadata().get("source-classifier") == null)) {
                String connection = this.checkoutSourcesFromSCM(ctx, info, artifact);
                info.addSourceInfo(connection);
            } else {
                info.addSourceInfo(sourcesArtifactId);
            }
        }
    }

    private Model getArtifactPom(ApisJarContext ctx, ArtifactId artifactId) throws MojoExecutionException {
        ArtifactId pomArtifactId = artifactId.changeClassifier(null).changeType("pom");
        Model model = ctx.getModelCache().get(pomArtifactId);
        if (model == null) {
            this.getLog().debug((CharSequence)("Retrieving POM " + pomArtifactId.toMvnId() + "..."));
            URL pomURL = this.retrieve(pomArtifactId);
            if (pomURL == null) {
                throw new MojoExecutionException("Unable to find artifact " + pomArtifactId.toMvnId());
            }
            File pomFile = null;
            try {
                pomFile = IOUtils.getFileFromURL((URL)pomURL, (boolean)true, null);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage());
            }
            this.getLog().debug((CharSequence)("POM " + pomArtifactId.toMvnId() + " successfully retrieved, reading the model..."));
            model = (Model)this.modelBuilder.buildRawModel(pomFile, 0, false).get();
            this.getLog().debug((CharSequence)("POM model " + pomArtifactId.toMvnId() + " successfully read"));
            ctx.getModelCache().put(pomArtifactId, model);
        }
        return model;
    }

    /*
     * WARNING - void declaration
     */
    private String checkoutSourcesFromSCM(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, Artifact sourceArtifact) throws MojoExecutionException {
        String connection = (String)sourceArtifact.getMetadata().get("scm-location");
        String tag = (String)sourceArtifact.getMetadata().get("scm-tag");
        this.getLog().debug((CharSequence)"Falling back to SCM checkout...");
        Model pomModel = this.getArtifactPom(ctx, sourceArtifact.getId());
        this.getLog().debug((CharSequence)"Processing SCM info from pom...");
        Scm scm = pomModel.getScm();
        if (scm != null) {
            if (connection == null) {
                connection = scm.getConnection();
            }
            if (tag == null && "HEAD".equals(tag = scm.getTag())) {
                tag = null;
            }
        }
        if (connection == null) {
            this.getLog().warn((CharSequence)("Ignoring sources for artifact " + sourceArtifact.getId().toMvnId() + " : SCM not defined in " + sourceArtifact.getId().toMvnId() + " bundle neither in " + pomModel.getId() + " POM file."));
            return null;
        }
        try {
            void var12_21;
            File file;
            File file2;
            File basedir;
            ScmRepository repository = this.scmManager.makeScmRepository(connection);
            ScmTag scmVersion = null;
            if (tag != null) {
                scmVersion = new ScmTag(tag);
            }
            if ((basedir = new File(ctx.getCheckedOutSourcesDir(), sourceArtifact.getId().toMvnName())).exists()) {
                this.getLog().debug((CharSequence)("Source checkout directory " + basedir + " already exists"));
            } else {
                void var12_17;
                this.getLog().debug((CharSequence)("Checking out source to directory " + basedir));
                basedir.mkdirs();
                ScmFileSet fileSet = new ScmFileSet(basedir);
                Object var12_14 = null;
                try {
                    if (scmVersion == null) {
                        CheckOutScmResult checkOutScmResult = this.scmManager.checkOut(repository, fileSet, true);
                    } else {
                        CheckOutScmResult checkOutScmResult = this.scmManager.checkOut(repository, fileSet, (ScmVersion)scmVersion, true);
                    }
                }
                catch (ScmException se) {
                    throw new MojoExecutionException("An error occurred while checking sources from " + repository + " for artifact " + sourceArtifact.getId().toMvnId() + " model", (Exception)((Object)se));
                }
                if (!var12_17.isSuccess()) {
                    this.getLog().warn((CharSequence)("Ignoring sources for artifact " + sourceArtifact.getId().toMvnId() + " : An error occurred while checking out sources from " + connection + ": " + var12_17.getProviderMessage()));
                    return null;
                }
            }
            DirectoryScanner pomScanner = new DirectoryScanner();
            pomScanner.setBasedir(basedir);
            pomScanner.setIncludes(new String[]{"**/pom.xml"});
            pomScanner.scan();
            for (String pomFileLocation : pomScanner.getIncludedFiles()) {
                File pomFile = new File(basedir, pomFileLocation);
                Model model = (Model)this.modelBuilder.buildRawModel(pomFile, 0, false).get();
                if (!sourceArtifact.getId().getArtifactId().equals(model.getArtifactId())) continue;
                basedir = pomFile.getParentFile();
                break;
            }
            if (!(file2 = new File(basedir, "src/main/java")).exists() && !(file = new File(basedir, "src/java")).exists()) {
                this.getLog().warn((CharSequence)("Ignoring sources for artifact " + sourceArtifact.getId().toMvnId() + " : SCM checkout for " + sourceArtifact.getId().toMvnId() + " does not contain any source."));
                return null;
            }
            File sourceDirectory = new File(ctx.getDeflatedSourcesDir(), info.getId().toMvnName());
            info.setSourceDirectory(sourceDirectory);
            sourceDirectory.mkdir();
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir((File)var12_21);
            directoryScanner.setIncludes(info.getUsedExportedPackageIncludes());
            directoryScanner.scan();
            for (String file3 : directoryScanner.getIncludedFiles()) {
                File source = new File((File)var12_21, file3);
                File destination = new File(sourceDirectory, file3);
                destination.getParentFile().mkdirs();
                try {
                    FileUtils.copyFile((File)source, (File)destination);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("An error occurred while copying sources from " + source + " to " + destination, (Exception)e);
                }
            }
            return tag == null ? connection : connection.concat("@").concat(tag);
        }
        catch (ScmRepositoryException se) {
            throw new MojoExecutionException("An error occurred while reading SCM from " + connection + " connection for bundle " + sourceArtifact.getId(), (Exception)((Object)se));
        }
        catch (NoSuchScmProviderException nsspe) {
            this.getLog().warn((CharSequence)("Ignoring sources for artifact " + sourceArtifact.getId().toMvnId() + " : bundle points to an SCM connection " + connection + " which does not specify a valid or supported SCM provider"), (Throwable)nsspe);
            return null;
        }
    }

    private String getApiExportClause(ApiRegion region, Collection<ApisJarContext.ArtifactInfo> infos) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ApisJarContext.ArtifactInfo info : infos) {
            for (Clause clause : info.getUsedExportedPackages(region.getName())) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(clause.toString());
            }
        }
        return sb.toString();
    }

    private void addFileSets(ApiRegion apiRegion, ArtifactType archiveType, Collection<ApisJarContext.ArtifactInfo> infos, JarArchiver jarArchiver, List<Source> sources) {
        for (ApisJarContext.ArtifactInfo info : infos) {
            File dir = archiveType == ArtifactType.APIS ? info.getBinDirectory() : info.getSourceDirectory();
            if (dir == null) continue;
            Object[] usedExportedPackageIncludes = info.getUsedExportedPackageIncludes(apiRegion.getName());
            this.getLog().debug((CharSequence)("Adding directory " + dir.getName() + " with " + Arrays.toString(usedExportedPackageIncludes)));
            DefaultFileSet fileSet = new DefaultFileSet(dir);
            fileSet.setIncludingEmptyDirectories(false);
            fileSet.setIncludes((String[])usedExportedPackageIncludes);
            if (jarArchiver != null) {
                jarArchiver.addFileSet((FileSet)fileSet);
            }
            if (sources == null) continue;
            sources.add(new DirectorySource(fileSet));
        }
    }

    private void addResources(Collection<ApisJarContext.ArtifactInfo> infos, List<File> resources, JarArchiver jarArchiver, List<Source> sources) {
        for (ApisJarContext.ArtifactInfo info : infos) {
            if (info.getBinDirectory() == null) continue;
            int prefixLength = info.getBinDirectory().getAbsolutePath().length() + 1;
            for (File resource : info.getIncludedResources()) {
                String name = resource.getAbsolutePath().substring(prefixLength);
                this.getLog().debug((CharSequence)("Adding resource " + name));
                if (jarArchiver != null) {
                    jarArchiver.addFile(resource, name);
                }
                if (sources == null) continue;
                sources.add(new FileSource(info.getBinDirectory(), resource));
            }
        }
        if (resources != null) {
            for (File rsrc : resources) {
                this.getLog().debug((CharSequence)("Adding resource " + rsrc));
                if (rsrc.isDirectory()) {
                    DirectoryScanner ds = new DirectoryScanner();
                    ds.setBasedir(rsrc);
                    ds.setIncludes(new String[]{"**/*.*"});
                    ds.scan();
                    if (jarArchiver != null) {
                        for (String includedFile : ds.getIncludedFiles()) {
                            jarArchiver.addFile(new File(rsrc, includedFile), includedFile);
                        }
                    }
                    if (sources == null) continue;
                    DefaultFileSet fileSet = new DefaultFileSet(rsrc);
                    fileSet.setIncludingEmptyDirectories(false);
                    fileSet.setIncludes(new String[]{"**/*.*"});
                    sources.add(new DirectorySource(fileSet));
                    continue;
                }
                if (jarArchiver != null) {
                    jarArchiver.addFile(rsrc, rsrc.getName());
                }
                if (sources == null) continue;
                sources.add(new FileSource(rsrc.getParentFile(), rsrc));
            }
        }
    }

    private void runProcessor(final ApisJarContext ctx, final ApiRegion apiRegion, ArtifactType archiveType, List<File> resources, Collection<ApisJarContext.ArtifactInfo> infos) {
        List<Processor> processors = ApisUtil.getProcessors();
        if (!processors.isEmpty()) {
            ArrayList<Source> sources = new ArrayList<Source>();
            this.addFileSets(apiRegion, archiveType, infos, null, sources);
            this.addResources(infos, resources, null, sources);
            for (Processor p : processors) {
                ProcessorContext pc = new ProcessorContext(){

                    @Override
                    public MavenSession getSession() {
                        return ApisJarMojo.this.mavenSession;
                    }

                    @Override
                    public MavenProject getProject() {
                        return ApisJarMojo.this.project;
                    }

                    @Override
                    public Feature getFeature() {
                        return ctx.getFeature();
                    }

                    @Override
                    public ApiRegion getApiRegion() {
                        return apiRegion;
                    }

                    @Override
                    public Log getLog() {
                        return ApisJarMojo.this.getLog();
                    }
                };
                if (archiveType == ArtifactType.APIS) {
                    p.processBinaries(pc, sources);
                    continue;
                }
                p.processSources(pc, sources);
            }
        }
    }

    private File createArchive(ApisJarContext ctx, ApiRegion apiRegion, ArtifactType archiveType, List<File> resources, Collection<ApisJarContext.ArtifactInfo> infos, List<String> report) throws MojoExecutionException {
        JarArchiver jarArchiver = new JarArchiver();
        if (archiveType == ArtifactType.APIS || archiveType == ArtifactType.SOURCES) {
            this.addFileSets(apiRegion, archiveType, infos, jarArchiver, null);
        } else {
            DefaultFileSet fileSet = new DefaultFileSet(ctx.getJavadocDir());
            jarArchiver.addFileSet((FileSet)fileSet);
        }
        this.addResources(infos, resources, jarArchiver, null);
        if (ctx.getConfig().getLicenseReport() != null) {
            File out = this.createLicenseReport(ctx, apiRegion, infos, report);
            jarArchiver.addFile(out, ctx.getConfig().getLicenseReport());
        }
        ArtifactId targetId = this.buildArtifactId(ctx, apiRegion, archiveType);
        String artifactName = String.format("%s-%s", targetId.getArtifactId(), targetId.getClassifier());
        MavenArchiveConfiguration archiveConfiguration = new MavenArchiveConfiguration();
        archiveConfiguration.setAddMavenDescriptor(false);
        if (archiveType == ArtifactType.APIS) {
            String symbolicName = artifactName.replace('-', '.');
            archiveConfiguration.addManifestEntry("Export-Package", this.getApiExportClause(apiRegion, infos));
            archiveConfiguration.addManifestEntry("Bundle-Description", this.project.getDescription());
            archiveConfiguration.addManifestEntry("Bundle-Version", targetId.getOSGiVersion().toString());
            archiveConfiguration.addManifestEntry("Bundle-ManifestVersion", "2");
            archiveConfiguration.addManifestEntry("Bundle-SymbolicName", symbolicName);
            archiveConfiguration.addManifestEntry("Bundle-Name", artifactName);
            HashSet<String> nodeTypes = new HashSet<String>();
            for (ApisJarContext.ArtifactInfo info : infos) {
                nodeTypes.addAll(info.getNodeTypes());
            }
            if (!nodeTypes.isEmpty()) {
                archiveConfiguration.addManifestEntry("Sling-Nodetypes", String.join((CharSequence)",", nodeTypes));
            }
            if (this.project.getOrganization() != null) {
                archiveConfiguration.addManifestEntry("Bundle-Vendor", this.project.getOrganization().getName());
            }
            archiveConfiguration.addManifestEntry("Provide-Capability", "osgi.unresolvable");
            archiveConfiguration.addManifestEntry("Require-Capability", "osgi.unresolvable;filter:=\"(&(must.not.resolve=*)(!(must.not.resolve=*)))\",osgi.ee;filter:=\"(&(osgi.ee=JavaSE/compact2)(version=1.8))\"");
        }
        archiveConfiguration.addManifestEntry("Implementation-Version", targetId.getVersion());
        archiveConfiguration.addManifestEntry("Specification-Version", targetId.getVersion());
        archiveConfiguration.addManifestEntry("Implementation-Title", artifactName);
        archiveConfiguration.addManifestEntry("Specification-Title", artifactName);
        if (this.project.getOrganization() != null) {
            archiveConfiguration.addManifestEntry("Implementation-Vendor", this.project.getOrganization().getName());
            archiveConfiguration.addManifestEntry("Specification-Vendor", this.project.getOrganization().getName());
        }
        archiveConfiguration.addManifestEntries(ctx.getConfig().getManifestEntries());
        File target = new File(this.mainOutputDir, targetId.toMvnName());
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(jarArchiver);
        archiver.setOutputFile(target);
        try {
            archiver.createArchive(this.mavenSession, this.project, archiveConfiguration);
            if (this.attachApiJars) {
                this.projectHelper.attachArtifact(this.project, targetId.getType(), targetId.getClassifier(), target);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("An error occurred while creating APIs " + target + " archive", e);
        }
        return target;
    }

    private ArtifactId buildArtifactId(ApisJarContext ctx, ApiRegion apiRegion, ArtifactType artifactType) {
        StringBuilder classifierBuilder = new StringBuilder();
        if (ctx.getFeatureId().getClassifier() != null) {
            classifierBuilder.append(ctx.getConfig().mapApiClassifier(ctx.getFeatureId().getClassifier())).append('-');
        }
        String finalClassifier = classifierBuilder.append(ctx.getConfig().mapApiRegionName(apiRegion.getName())).append('-').append(artifactType.getId()).toString();
        return new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), ctx.getConfig().getApiVersion() != null ? ctx.getConfig().getApiVersion() : this.project.getVersion(), finalClassifier, artifactType.getExtension());
    }

    private void createDependenciesFile(ApisJarContext ctx, ApiRegion apiRegion) throws MojoExecutionException {
        Collection<ApisJarContext.ArtifactInfo> infos = ctx.getArtifactInfos(apiRegion.getName(), false);
        ArrayList<ArtifactId> dependencies = new ArrayList<ArtifactId>();
        for (ApisJarContext.ArtifactInfo info : infos) {
            if (!info.isUseAsDependencyPerRegion(apiRegion.getName())) continue;
            dependencies.addAll(info.getDependencyArtifacts());
        }
        Collections.sort(dependencies);
        ArtifactId targetId = this.buildArtifactId(ctx, apiRegion, ArtifactType.DEPENDENCIES);
        File target = new File(this.mainOutputDir, targetId.toMvnName());
        if (!dependencies.isEmpty()) {
            this.getLog().info((CharSequence)"Writing dependencies file ".concat(target.getAbsolutePath()));
            try (FileWriter w = new FileWriter(target);){
                for (ArtifactId id : dependencies) {
                    w.write(id.toMvnId());
                    w.write(System.lineSeparator());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write dependencies file", (Exception)e);
            }
            if (this.attachApiJars) {
                this.projectHelper.attachArtifact(this.project, targetId.getType(), targetId.getClassifier(), target);
            }
        } else {
            this.getLog().info((CharSequence)"No dependencies found");
            if (target.exists()) {
                target.delete();
            }
        }
    }

    private Collection<ApisJarContext.ArtifactInfo> generateJavadoc(ApisJarContext ctx, String regionName, JavadocLinks links, File javadocDir, RegionSupport regionSupport) throws MojoExecutionException {
        Collection<String> classpath;
        String versionSuffix;
        ArrayList<ApisJarContext.ArtifactInfo> usedInfos = new ArrayList<ApisJarContext.ArtifactInfo>();
        ArrayList<String> sourceDirectories = new ArrayList<String>();
        HashSet<String> javadocPackages = new HashSet<String>();
        for (ApisJarContext.ArtifactInfo info : ctx.getArtifactInfos(regionName, false)) {
            boolean addDirectory = false;
            for (Clause clause : info.getUsedExportedPackages(regionName)) {
                if (ctx.getPackagesWithoutSources().contains(clause.getName()) || links.getLinkedPackages().contains(clause.getName())) continue;
                addDirectory = true;
                javadocPackages.add(clause.getName());
            }
            if (!addDirectory || info.getSourceDirectory() == null) continue;
            usedInfos.add(info);
            sourceDirectories.add(info.getSourceDirectory().getAbsolutePath());
        }
        if (javadocPackages.isEmpty()) {
            return null;
        }
        for (Artifact artifact : ApisUtil.getAdditionalJavadocArtifacts(ctx, regionName)) {
            boolean infoExists = ctx.getArtifactInfo(artifact.getId()) != null;
            ApisJarContext.ArtifactInfo info = infoExists ? ctx.getArtifactInfo(artifact.getId()) : ctx.addArtifactInfo(artifact);
            Set<Clause> exportedPackages = regionSupport.getAllPublicPackages(ctx, artifact, this.getArtifactFile(artifact.getId()));
            Iterator<Clause> iter = exportedPackages.iterator();
            LinkedHashSet<String> exportedPackageNames = new LinkedHashSet<String>();
            while (iter.hasNext()) {
                Clause c = iter.next();
                if (javadocPackages.contains(c.getName())) {
                    iter.remove();
                    continue;
                }
                javadocPackages.add(c.getName());
                exportedPackageNames.add(c.getName());
            }
            if (exportedPackages.isEmpty()) continue;
            info.setUsedExportedPackages(regionName, exportedPackages, false);
            if (!infoExists) {
                info.setUsedExportedPackages(exportedPackageNames);
                info.setSourceDirectory(new File(ctx.getDeflatedSourcesDir(), info.getId().toMvnName()));
                boolean skipSourceDeflate = info.getSourceDirectory().exists();
                if (skipSourceDeflate) {
                    this.getLog().debug((CharSequence)("Source for artifact " + info.getId().toMvnName() + " already deflated"));
                } else {
                    this.downloadSources(ctx, info, artifact);
                }
            }
            usedInfos.add(info);
            sourceDirectories.add(info.getSourceDirectory().getAbsolutePath());
        }
        javadocDir.mkdirs();
        JavadocExecutor javadocExecutor = new JavadocExecutor(javadocDir.getParentFile()).addArgument("-public").addArgument("-encoding", false).addArgument("UTF-8").addArgument("-charset", false).addArgument("UTF-8").addArgument("-docencoding", false).addArgument("UTF-8").addArgument("-d", false).addArgument(javadocDir.getAbsolutePath()).addArgument("-sourcepath", false).addArgument(String.join((CharSequence)File.pathSeparator, sourceDirectories));
        javadocExecutor.addArgument("-source", false).addArgument(ctx.getConfig().getJavadocSourceLevel());
        String string = versionSuffix = ctx.getConfig().getApiVersion() != null ? ctx.getConfig().getApiVersion() : ctx.getFeatureId().getVersion();
        if (!StringUtils.isBlank((CharSequence)this.project.getName())) {
            javadocExecutor.addArgument("-doctitle", false).addQuotedArgument(this.project.getName().trim().concat(" ").concat(versionSuffix));
        }
        if (!StringUtils.isBlank((CharSequence)this.project.getDescription())) {
            javadocExecutor.addArgument("-windowtitle", false).addQuotedArgument(this.project.getDescription().trim().concat(" ").concat(versionSuffix));
        }
        if (!StringUtils.isBlank((CharSequence)this.project.getInceptionYear()) && this.project.getOrganization() != null && !StringUtils.isBlank((CharSequence)this.project.getOrganization().getName())) {
            javadocExecutor.addArgument("-bottom", false).addQuotedArgument(String.format("Copyright &copy; %s - %s %s. All Rights Reserved", this.project.getInceptionYear().trim(), Calendar.getInstance().get(1), this.project.getOrganization().getName().trim()));
        }
        if (!links.getJavadocLinks().isEmpty()) {
            javadocExecutor.addArguments("-link", links.getJavadocLinks());
        }
        if (!(classpath = ApisUtil.getJavadocClassPath(this.getLog(), this.repositorySystem, this.mavenSession, ctx, regionName)).isEmpty()) {
            javadocExecutor.addArgument("-classpath", false).addArgument(classpath, File.pathSeparator);
        }
        javadocExecutor.addArgument("-Xdoclint:none");
        javadocExecutor.addArgument("--allow-script-in-comments");
        if (!this.javadocIndex) {
            javadocExecutor.addArgument("-noindex");
        }
        if (!this.javadocTree) {
            javadocExecutor.addArgument("-notree");
        }
        javadocExecutor.addArguments(javadocPackages);
        javadocExecutor.execute(javadocDir, this.getLog(), this.ignoreJavadocErrors);
        return usedInfos;
    }

    private File createLicenseReport(ApisJarContext ctx, ApiRegion region, Collection<ApisJarContext.ArtifactInfo> infos, List<String> report) throws MojoExecutionException {
        File out = new File(this.getTmpDir(), region.getName() + "-license-report.txt");
        if (!out.exists()) {
            ArrayList<String> output = new ArrayList<String>();
            output.add(ctx.getConfig().getLicenseReportHeader());
            output.add("");
            for (ApisJarContext.ArtifactInfo info : infos) {
                String licenseDefault = ctx.getConfig().getLicenseDefault(info.getId());
                StringBuilder sb = new StringBuilder(info.getId().toMvnId());
                boolean exclude = false;
                if (licenseDefault != null) {
                    if (licenseDefault.isEmpty()) {
                        exclude = true;
                        this.getLog().debug((CharSequence)("Excluding from license report " + info.getId().toMvnId()));
                    } else {
                        sb.append(" - License(s) : ");
                        sb.append(licenseDefault);
                    }
                } else {
                    List<License> licenses = this.getLicenses(ctx, info);
                    if (!licenses.isEmpty()) {
                        sb.append(" - License(s) : ");
                        sb.append(String.join((CharSequence)", ", licenses.stream().map(l -> l.getName().concat(" (").concat(l.getUrl()).concat(")")).collect(Collectors.toList())));
                    } else {
                        report.add("No license info found for ".concat(info.getId().toMvnId()));
                    }
                }
                if (exclude) continue;
                output.add(sb.toString());
            }
            if (ctx.getConfig().getLicenseReportFooter() != null) {
                output.add("");
                output.add(ctx.getConfig().getLicenseReportFooter());
            }
            try {
                Files.write(out.toPath(), output, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write license report: " + e.getMessage(), (Exception)e);
            }
        }
        return out;
    }

    private List<License> getLicenses(ApisJarContext ctx, ApisJarContext.ArtifactInfo info) {
        this.getLog().debug((CharSequence)("Getting license for " + info.getId().toMvnId()));
        List result = info.getLicenses();
        if (result == null) {
            try {
                ArtifactId id = info.getId();
                do {
                    ArtifactId newId;
                    Model model;
                    List ll;
                    if ((ll = (model = this.getArtifactPom(ctx, id)).getLicenses()) != null && !ll.isEmpty()) {
                        this.getLog().debug((CharSequence)("Found license for " + id.toMvnId()));
                        result = ll;
                        continue;
                    }
                    if (model.getParent() == null || (newId = new ArtifactId(model.getParent().getGroupId(), model.getParent().getArtifactId(), model.getParent().getVersion(), null, "pom")).equals((Object)id)) break;
                    id = newId;
                } while (result == null);
            }
            catch (MojoExecutionException mojoExecutionException) {
                // empty catch block
            }
            if (result == null) {
                result = Collections.emptyList();
            }
            info.setLicenses(result);
        }
        this.getLog().debug((CharSequence)("License for " + info.getId().toMvnId() + " = " + result));
        return result;
    }
}

