/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.FeatureBuilder;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.maven.JSONFeatures;
import org.apache.sling.feature.maven.ProjectHelper;

public abstract class AbstractFeatureMojo
extends AbstractMojo {
    private static final String PROPERTY_HANDLED_GENERATED_FEATURES = Feature.class.getName() + "/generated";
    @Parameter(name="features", required=true, defaultValue="src/main/features")
    protected File features;
    @Parameter(name="featuresIncludes", defaultValue="**/*.json")
    private String featuresIncludes;
    @Parameter(name="featuresExcludes")
    private String featuresExcludes;
    @Parameter(name="testFeatures", required=true, defaultValue="src/test/features")
    private File testFeatures;
    @Parameter(name="testFeaturesIncludes", defaultValue="**/*.json")
    private String testFeaturesIncludes;
    @Parameter(name="testFeaturesExcludes")
    private String testFeaturesExcludes;
    @Parameter(name="validateFeatures", defaultValue="true")
    private boolean validateFeatures;
    @Parameter(name="skipAddFeatureDependencies", defaultValue="false")
    private boolean skipAddFeatureDependencies;
    @Parameter(name="skipAddTestFeatureDependencies", defaultValue="true")
    private boolean skipAddTestFeatureDependencies;
    @Parameter(name="skipAddJarToFeature", defaultValue="false")
    private boolean skipAddJarToFeature;
    @Parameter(name="skipAddJarToTestFeature", defaultValue="false")
    private boolean skipAddJarToTestFeature;
    @Parameter
    private File generatedFeatures;
    @Parameter(defaultValue="**/*.json")
    private String generatedFeaturesIncludes;
    @Parameter
    private String generatedFeaturesExcludes;
    @Parameter(name="jarStartOrder")
    protected int jarStartOrder;
    @Parameter(defaultValue="true")
    private boolean enableProjectVariableReplacement;
    @Parameter
    private String replacePropertyVariables;
    @Parameter(defaultValue="false")
    private boolean enableLegacyVariableReplacement;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    ArtifactHandlerManager artifactHandlerManager;
    @Component
    ArtifactResolver artifactResolver;

    protected File getTmpDir() {
        File dir = new File(this.project.getBuild().getDirectory(), "slingfeature-tmp");
        dir.mkdirs();
        return dir;
    }

    protected void checkPreconditions() throws MojoExecutionException {
        String errorMessage = ProjectHelper.checkPreprocessorRun(this.project);
        if (errorMessage != null) {
            throw new MojoExecutionException(errorMessage);
        }
        if (this.project.getContextValue(PROPERTY_HANDLED_GENERATED_FEATURES) == null) {
            this.handleGeneratedFeatures();
            this.project.setContextValue(PROPERTY_HANDLED_GENERATED_FEATURES, (Object)Boolean.TRUE);
        }
        if ("slingosgifeature".equals(this.project.getPackaging()) && ProjectHelper.getFeatures(this.project).isEmpty()) {
            throw new MojoExecutionException("Feature project has no features defined");
        }
    }

    private void handleGeneratedFeatures() throws MojoExecutionException {
        File targetDir;
        File genDir;
        File dir = this.generatedFeatures == null ? ((genDir = new File(targetDir = new File(this.project.getBasedir(), this.project.getBuild().getDirectory()), "generated-features")).exists() ? genDir : null) : this.generatedFeatures;
        if (dir != null) {
            if (!dir.exists()) {
                throw new MojoExecutionException("Directory does not exists: " + dir);
            }
            if (!dir.isDirectory()) {
                throw new MojoExecutionException("Generated features configuration is not a directory: " + dir);
            }
            ArrayList<File> files = new ArrayList<File>();
            ProjectHelper.scan(files, dir, this.generatedFeaturesIncludes, this.generatedFeaturesExcludes);
            for (File file : files) {
                this.getLog().debug((CharSequence)("Reading feature file " + file));
                try {
                    String json = ProjectHelper.readFeatureFile(this.project, file, null, this.enableLegacyVariableReplacement, this.enableProjectVariableReplacement, this.replacePropertyVariables != null ? this.replacePropertyVariables.split(",") : null);
                    try (StringReader reader = new StringReader(json);){
                        Feature feature = FeatureJSONReader.read((Reader)reader, (String)file.getAbsolutePath());
                        ProjectHelper.checkFeatureId(this.project, feature);
                        JSONFeatures.handleExtensions(feature, file);
                        JSONFeatures.handleDefaultMetadata(feature, ProjectHelper.getDefaultMetadata(this.project));
                        ProjectHelper.setFeatureInfo(this.project, feature);
                        String key = file.toPath().normalize().toFile().getAbsolutePath();
                        ProjectHelper.getFeatures(this.project).put(key, feature);
                        Feature assembledFeature = FeatureBuilder.assemble((Feature)feature, (BuilderContext)this.getBuilderContext());
                        ProjectHelper.getAssembledFeatures(this.project).put(key, assembledFeature);
                        ProjectHelper.validateFeatureClassifiers(this.project);
                    }
                    catch (IOException io) {
                        throw new MojoExecutionException("Unable to read feature " + file.getAbsolutePath(), (Exception)io);
                    }
                }
                catch (RuntimeException re) {
                    throw new MojoExecutionException(re.getMessage(), re.getCause() != null ? re.getCause() : re);
                }
            }
        }
    }

    private BuilderContext getBuilderContext() {
        BuilderContext builderContext = new BuilderContext((FeatureProvider)new BaseFeatureProvider()).setArtifactProvider((ArtifactProvider)new BaseArtifactProvider());
        return builderContext;
    }

    protected class BaseArtifactProvider
    implements ArtifactProvider {
        protected BaseArtifactProvider() {
        }

        public URL provide(ArtifactId id) {
            try {
                return ProjectHelper.getOrResolveArtifact(AbstractFeatureMojo.this.project, AbstractFeatureMojo.this.mavenSession, AbstractFeatureMojo.this.artifactHandlerManager, AbstractFeatureMojo.this.artifactResolver, id).getFile().toURI().toURL();
            }
            catch (Exception e) {
                AbstractFeatureMojo.this.getLog().debug((CharSequence)("Artifact " + id.toMvnId() + " not found"));
                return null;
            }
        }
    }

    protected class BaseFeatureProvider
    implements FeatureProvider {
        protected BaseFeatureProvider() {
        }

        public Feature provide(ArtifactId id) {
            for (Feature feat : ProjectHelper.getAssembledFeatures(AbstractFeatureMojo.this.project).values()) {
                if (!feat.getId().equals((Object)id)) continue;
                return feat;
            }
            if (ProjectHelper.isLocalProjectArtifact(AbstractFeatureMojo.this.project, id)) {
                throw new RuntimeException("Unable to resolve local artifact " + id.toMvnId());
            }
            return ProjectHelper.getOrResolveFeature(AbstractFeatureMojo.this.project, AbstractFeatureMojo.this.mavenSession, AbstractFeatureMojo.this.artifactHandlerManager, AbstractFeatureMojo.this.artifactResolver, id);
        }
    }
}

