/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.reports;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.maven.mojos.reports.ReportContext;
import org.apache.sling.feature.maven.mojos.reports.Reporter;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.FeatureDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;

public class ExportPackagesReporter
implements Reporter {
    @Override
    public String getName() {
        return "exported-packages";
    }

    @Override
    public void generateReport(ReportContext ctx) throws MojoExecutionException {
        for (Feature feature : ctx.getFeatures()) {
            FeatureDescriptor fd;
            try {
                fd = ctx.getScanner().scan(feature);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to scan feature " + e.getMessage(), (Exception)e);
            }
            List<String> exportedPackages = this.getExportedPackages(fd);
            if (exportedPackages.isEmpty()) continue;
            ctx.addReport(fd.getFeature().getId().changeType("packages.txt").toMvnName(), exportedPackages);
        }
    }

    private List<String> getExportedPackages(FeatureDescriptor fd) {
        ArrayList<String> packages = new ArrayList<String>();
        for (BundleDescriptor bd : fd.getBundleDescriptors()) {
            for (PackageInfo p : bd.getExportedPackages()) {
                packages.add(p.getName());
            }
        }
        Collections.sort(packages);
        return packages;
    }
}

