/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;

public class Aggregate
extends FeatureSelectionConfig {
    public String classifier;
    public boolean attach = true;
    public boolean markAsFinal = false;
    public boolean markAsComplete = false;
    public String title;
    public String description;
    public String vendor;
    public List<String> artifactsOverrides;
    public List<String> configurationOverrides;
    public Map<String, String> variablesOverrides;
    public Map<String, String> frameworkPropertiesOverrides;

    @Override
    public String toString() {
        return "Aggregate [selection=" + this.getSelections() + ", filesExcludes=" + this.getFilesExcludes() + ", classifier=" + this.classifier + ", attach=" + this.attach + ", markAsFinal=" + this.markAsFinal + ", markAsComplete=" + this.markAsComplete + ", title=" + this.title + ", description=" + this.description + ", vendor=" + this.vendor + ", artifactsOverrides=" + this.artifactsOverrides + ", variablesOverrides=" + this.variablesOverrides + ", frameworkPropertiesOverrides=" + this.frameworkPropertiesOverrides + "]";
    }

    public List<ArtifactId> getArtifactOverrideRules() {
        if (this.artifactsOverrides == null) {
            return Collections.emptyList();
        }
        return this.artifactsOverrides.stream().map(r -> ArtifactId.parse((String)r)).collect(Collectors.toList());
    }

    public Map<String, String> getConfigurationOverrideRules() {
        if (this.configurationOverrides == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String entry : this.configurationOverrides) {
            int idx = entry.lastIndexOf("=");
            if (idx == -1) continue;
            result.put(entry.substring(0, idx), entry.substring(idx + 1));
        }
        return result;
    }
}

