/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.apis;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.feature.maven.mojos.apis.ApisJarContext;
import org.apache.sling.feature.maven.mojos.apis.ApisUtil;

public class JavadocLinks {
    private final Set<String> linkedGlobalPackages = new HashSet<String>();
    private final Set<String> docLinks = new HashSet<String>();

    public void calculateLinks(String[] globalJavaDocLinks, Collection<ApisJarContext.ArtifactInfo> infos) throws MojoExecutionException {
        HashMap<String, Set<String>> linkedPackagesMap = new HashMap<String, Set<String>>();
        this.docLinks.clear();
        this.linkedGlobalPackages.clear();
        if (globalJavaDocLinks != null) {
            for (String val : globalJavaDocLinks) {
                this.docLinks.add(val);
                ApisUtil.getPackageList(val, this.linkedGlobalPackages, linkedPackagesMap);
            }
        }
        for (ApisJarContext.ArtifactInfo info : infos) {
            List<String> links = ApisUtil.getJavadocLinks(info.getArtifact());
            if (links == null) continue;
            for (String v : links) {
                ApisUtil.getPackageList(v, this.linkedGlobalPackages, linkedPackagesMap);
                this.docLinks.add(v);
            }
        }
    }

    public Set<String> getJavadocLinks() {
        return this.docLinks;
    }

    public Set<String> getLinkedPackages() {
        return this.linkedGlobalPackages;
    }
}

