/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;
import org.apache.sling.feature.maven.mojos.reports.ContentsReporter;
import org.apache.sling.feature.maven.mojos.reports.DuplicatesReporter;
import org.apache.sling.feature.maven.mojos.reports.ExportPackagesReporter;
import org.apache.sling.feature.maven.mojos.reports.ReportContext;
import org.apache.sling.feature.maven.mojos.reports.Reporter;
import org.apache.sling.feature.maven.mojos.selection.IncludeExcludeMatcher;
import org.apache.sling.feature.scanner.Scanner;

@Mojo(requiresProject=false, name="info", threadSafe=true)
public class InfoMojo
extends AbstractIncludingFeatureMojo {
    @Parameter
    private FeatureSelectionConfig infoFeatures;
    @Parameter(property="infoFeatureFiles")
    private String infoFeatureFiles;
    @Parameter(property="reports", defaultValue="exported-packages")
    private String reports;
    @Parameter(property="outputFormat", defaultValue="file")
    private String outputFormat;
    @Parameter(property="outputDirectory")
    private File outputDirectory;
    @Parameter(property="includes")
    private String artifactIncludesList;
    @Parameter(property="excludes")
    private String artifactExcludesList;
    @Deprecated
    @Parameter(property="featureFile")
    private File featureFile;
    @Deprecated
    @Parameter(property="outputExportedPackages")
    private String outputExportedPackages;
    @Parameter(readonly=true, defaultValue="${project.build.directory}/feature-reports")
    private File buildDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean isStandalone = "standalone-pom".equals(this.project.getArtifactId());
        if (this.outputExportedPackages != null) {
            this.getLog().warn((CharSequence)"Deprecated configuration 'outputExportedPackages' is used. Please use 'reports' instead.");
        }
        if (this.featureFile != null) {
            this.getLog().warn((CharSequence)"Deprecated configuration 'featureFile' is used. Change to 'infoFeatureFiles'");
            this.infoFeatureFiles = this.infoFeatureFiles == null ? this.featureFile.getAbsolutePath() : this.infoFeatureFiles.concat(",").concat(this.featureFile.getAbsolutePath());
        }
        if (isStandalone && this.infoFeatureFiles == null) {
            throw new MojoExecutionException("Required configuration for standalone execution is missing. Please specify 'infoFeatureFiles'.");
        }
        boolean outputFile = "file".equals(this.outputFormat);
        if (!outputFile && !"log".equals(this.outputFormat)) {
            throw new MojoExecutionException("Invalid value for 'outputFormat', allowed values are file or log, configured : ".concat(this.outputFormat));
        }
        List<Reporter> reporters = this.getReporters(this.reports);
        if (reporters.isEmpty()) {
            this.getLog().warn((CharSequence)"No reporters specified.");
            return;
        }
        final List<Feature> selection = this.selectFeatures(this.infoFeatureFiles);
        final Scanner scanner = this.setupScanner();
        final IncludeExcludeMatcher matcher = this.artifactIncludesList != null && !this.artifactIncludesList.isEmpty() ? new IncludeExcludeMatcher(Stream.of(this.artifactIncludesList.split(",")).map(v -> v.trim()).collect(Collectors.toList()), this.artifactExcludesList == null ? null : Stream.of(this.artifactExcludesList.split(",")).map(v -> v.trim()).collect(Collectors.toList()), null, false) : null;
        final LinkedHashMap reports = new LinkedHashMap();
        ReportContext ctx = new ReportContext(){

            @Override
            public Scanner getScanner() {
                return scanner;
            }

            @Override
            public List<Feature> getFeatures() {
                return selection;
            }

            @Override
            public void addReport(String key, List<String> output) {
                reports.put(key, output);
            }

            @Override
            public boolean matches(ArtifactId id) {
                return matcher == null || matcher.matches(id) != null;
            }
        };
        for (Reporter reporter : reporters) {
            this.getLog().info((CharSequence)"Generating report ".concat(reporter.getName().concat("...")));
            reporter.generateReport(ctx);
        }
        File directory = this.outputDirectory != null ? this.outputDirectory : (isStandalone ? Paths.get(".", new String[0]).toAbsolutePath().getParent().toFile() : this.buildDirectory);
        if (outputFile) {
            directory.mkdirs();
        }
        for (Map.Entry entry : reports.entrySet()) {
            if (outputFile) {
                try {
                    File out = new File(directory, (String)entry.getKey());
                    this.getLog().info((CharSequence)("Writing " + out + "..."));
                    Files.write(out.toPath(), (Iterable<? extends CharSequence>)((Iterable)entry.getValue()), new OpenOption[0]);
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to write file: " + e.getMessage(), (Exception)e);
                }
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Report ".concat((String)entry.getKey()));
            this.getLog().info((CharSequence)"================================================================");
            ((List)entry.getValue()).stream().forEach(l -> this.getLog().info((CharSequence)l));
            this.getLog().info((CharSequence)"");
        }
    }

    private List<Reporter> getReporters(String reports) throws MojoExecutionException {
        if (reports == null) {
            throw new MojoExecutionException("No reports configured.");
        }
        ArrayList<Reporter> available = new ArrayList<Reporter>();
        available.add(new ExportPackagesReporter());
        available.add(new DuplicatesReporter());
        available.add(new ContentsReporter());
        ArrayList<Reporter> result = new ArrayList<Reporter>();
        block0: for (String r : reports.split(",")) {
            for (Reporter current : available) {
                if (!current.getName().equals(r.trim())) continue;
                result.add(current);
                continue block0;
            }
        }
        return result;
    }

    private List<Feature> selectFeatures(String infoFeatureFiles) throws MojoExecutionException {
        ArrayList<Feature> result = new ArrayList<Feature>();
        if (infoFeatureFiles != null) {
            for (String file : infoFeatureFiles.split(",")) {
                File f = new File(file.trim());
                result.add(this.readFeature(f));
            }
        } else {
            this.checkPreconditions();
            Map<String, Feature> features = this.infoFeatures == null ? this.selectAllFeatureFiles() : this.getSelectedFeatures(this.infoFeatures);
            for (Feature f : features.values()) {
                result.add(f);
            }
        }
        return result;
    }

    private Scanner setupScanner() throws MojoExecutionException {
        ArtifactProvider am = new ArtifactProvider(){

            public URL provide(ArtifactId id) {
                InfoMojo.this.getLog().info((CharSequence)("Searching " + id.toMvnId()));
                try {
                    return ProjectHelper.getOrResolveArtifact(InfoMojo.this.project, InfoMojo.this.mavenSession, InfoMojo.this.artifactHandlerManager, InfoMojo.this.artifactResolver, id).getFile().toURI().toURL();
                }
                catch (MalformedURLException e) {
                    InfoMojo.this.getLog().debug((CharSequence)("Malformed url " + e.getMessage()), (Throwable)e);
                    return null;
                }
            }
        };
        try {
            return new Scanner(am);
        }
        catch (IOException e) {
            throw new MojoExecutionException("A fatal error occurred while setting up the Scanner, see error cause:", (Exception)e);
        }
    }

    private Feature readFeature(File file) throws MojoExecutionException {
        Feature feature;
        FileReader reader = new FileReader(file);
        try {
            Feature f;
            feature = f = FeatureJSONReader.read((Reader)reader, (String)this.featureFile.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to read feature file " + ioe.getMessage(), (Exception)ioe);
            }
        }
        ((Reader)reader).close();
        return feature;
    }
}

