/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.JarDecompressor;

public abstract class AbstractRepositoryMojo
extends AbstractIncludingFeatureMojo {
    @Parameter(defaultValue="artifacts", property="repositoryDir")
    String repositoryDir;
    boolean decompress;

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    protected void doExecute(File artifactDir, Map<String, Feature> features, List<Dependency> embed) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Creating repository in '" + artifactDir.getPath() + "'..."));
        for (Feature feature : features.values()) {
            this.processFeature(artifactDir, feature);
        }
        if (embed != null) {
            for (Dependency include : embed) {
                this.copyArtifactToRepository(ProjectHelper.toArtifactId(include), artifactDir);
            }
        }
    }

    protected Feature getLocalFeature(ArtifactId id) {
        Map<String, Feature> features = ProjectHelper.getAssembledFeatures(this.project);
        for (Feature f : features.values()) {
            if (!f.getId().equals((Object)id)) continue;
            return f;
        }
        return null;
    }

    protected void processFeature(File artifactDir, Feature f) throws MojoExecutionException {
        for (Artifact artifact : f.getBundles()) {
            this.copyArtifactToRepository(artifact.getId(), artifactDir);
        }
        for (Extension ext : f.getExtensions()) {
            if (ext.getType() != ExtensionType.ARTIFACTS) continue;
            for (Artifact artifact : ext.getArtifacts()) {
                this.copyArtifactToRepository(artifact.getId(), artifactDir);
            }
        }
        File featureFile = this.getRepositoryFile(artifactDir, f.getId());
        featureFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(featureFile);){
            FeatureJSONWriter.write((Writer)writer, (Feature)f);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write feature file  :" + f.getId().toMvnId(), (Exception)e);
        }
        if (f.getPrototype() != null) {
            Feature prototype;
            if (ProjectHelper.isLocalProjectArtifact(this.project, f.getPrototype().getId())) {
                prototype = this.getLocalFeature(f.getPrototype().getId());
                if (prototype == null) {
                    throw new MojoExecutionException("Unable to find project feature " + f.getPrototype().getId().toMvnId());
                }
                this.processFeature(artifactDir, prototype);
            } else {
                prototype = ProjectHelper.getOrResolveFeature(this.project, this.mavenSession, this.artifactHandlerManager, this.artifactResolver, f.getPrototype().getId());
                this.processFeature(artifactDir, prototype);
            }
        }
    }

    private File getRepositoryFile(File artifactDir, ArtifactId artifact) {
        StringBuilder artifactNameBuilder = new StringBuilder();
        artifactNameBuilder.append(artifact.getArtifactId());
        artifactNameBuilder.append('-');
        artifactNameBuilder.append(artifact.getVersion());
        if (artifact.getClassifier() != null) {
            artifactNameBuilder.append('-');
            artifactNameBuilder.append(artifact.getClassifier());
        }
        artifactNameBuilder.append('.');
        artifactNameBuilder.append(artifact.getType());
        String artifactName = artifactNameBuilder.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId().replace('.', File.separatorChar));
        sb.append(File.separatorChar);
        sb.append(artifact.getArtifactId());
        sb.append(File.separatorChar);
        sb.append(artifact.getVersion());
        sb.append(File.separatorChar);
        sb.append(artifactName);
        String destPath = sb.toString();
        File artifactFile = new File(artifactDir, destPath);
        artifactFile.getParentFile().mkdirs();
        return artifactFile;
    }

    private void copyArtifactToRepository(ArtifactId artifactId, File artifactDir) throws MojoExecutionException {
        File artifactFile = this.getRepositoryFile(artifactDir, artifactId);
        if (artifactFile.exists()) {
            return;
        }
        org.apache.maven.artifact.Artifact source = ProjectHelper.getOrResolveArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.artifactResolver, artifactId);
        try {
            if (this.decompress) {
                this.copyAndDecompressArtifact(source.getFile(), artifactFile);
            } else {
                this.copyArtifact(source.getFile(), artifactFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy artifact from " + source.getFile(), (Exception)e);
        }
    }

    void copyAndDecompressArtifact(File sourceFile, File artifactFile) throws IOException {
        this.getLog().info((CharSequence)("Decompressing " + artifactFile));
        JarDecompressor.copyDecompress(sourceFile, artifactFile);
    }

    void copyArtifact(File sourceFile, File artifactFile) throws IOException {
        FileUtils.copyFile((File)sourceFile, (File)artifactFile);
    }
}

